/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.selectable.ProductionOrderStatusSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderStatus
 * ProductionOrderStatus} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ProductionOrderStatusByKeyFluentHelper
    extends
    FluentHelperByKey<ProductionOrderStatusByKeyFluentHelper, ProductionOrderStatus, ProductionOrderStatusSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderStatus
     * ProductionOrderStatus} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProductionOrderStatus}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProductionOrderStatus}
     * @param manufacturingOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param statusCode
     *            Object status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public ProductionOrderStatusByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String manufacturingOrder,
        final String statusCode )
    {
        super(servicePath, entityCollection);
        this.key.put("ManufacturingOrder", manufacturingOrder);
        this.key.put("StatusCode", statusCode);
    }

    @Override
    @Nonnull
    protected Class<ProductionOrderStatus> getEntityClass()
    {
        return ProductionOrderStatus.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
