/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.field.ProductionRsceToolsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.selectable.ProductionRsceToolsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * API Production Resource/Tools
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductionRsceToolsType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductionRsceTools extends VdmEntity<ProductionRsceTools>
{

    /**
     * Selector for all available fields of ProductionRsceTools.
     *
     */
    public final static ProductionRsceToolsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @return Order Internal ID
     */
    @Key
    @SerializedName( "OrderInternalBillOfOperations" )
    @JsonProperty( "OrderInternalBillOfOperations" )
    @Nullable
    @ODataField( odataName = "OrderInternalBillOfOperations" )
    private String orderInternalBillOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalBillOfOperations</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<String> ORDER_INTERNAL_BILL_OF_OPERATIONS =
        new ProductionRsceToolsField<String>("OrderInternalBillOfOperations");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderOpProdnRsceToolIntID</b>
     * </p>
     *
     * @return Item Counter for Production Resources/Tools
     */
    @Key
    @SerializedName( "MfgOrderOpProdnRsceToolIntID" )
    @JsonProperty( "MfgOrderOpProdnRsceToolIntID" )
    @Nullable
    @ODataField( odataName = "MfgOrderOpProdnRsceToolIntID" )
    private String mfgOrderOpProdnRsceToolIntID;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderOpProdnRsceToolIntID</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<String> MFG_ORDER_OP_PRODN_RSCE_TOOL_INT_ID =
        new ProductionRsceToolsField<String>("MfgOrderOpProdnRsceToolIntID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Manufacturing Order ID
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<String> MANUFACTURING_ORDER =
        new ProductionRsceToolsField<String>("ManufacturingOrder");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategory</b>
     * </p>
     *
     * @return Production Resources/Tools Category
     */
    @SerializedName( "ProdnRsceToolCategory" )
    @JsonProperty( "ProdnRsceToolCategory" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolCategory" )
    private String prodnRsceToolCategory;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolCategory</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<String> PRODN_RSCE_TOOL_CATEGORY =
        new ProductionRsceToolsField<String>("ProdnRsceToolCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategoryName</b>
     * </p>
     *
     * @return Language-dependent description of the PRT category
     */
    @SerializedName( "ProdnRsceToolCategoryName" )
    @JsonProperty( "ProdnRsceToolCategoryName" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolCategoryName" )
    private String prodnRsceToolCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolCategoryName</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<String> PRODN_RSCE_TOOL_CATEGORY_NAME =
        new ProductionRsceToolsField<String>("ProdnRsceToolCategoryName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedProdnRsceToolQtyUnit</b>
     * </p>
     *
     * @return Unit for Total Planned Quantity of Production Resource/Tool
     */
    @SerializedName( "PlannedProdnRsceToolQtyUnit" )
    @JsonProperty( "PlannedProdnRsceToolQtyUnit" )
    @Nullable
    @ODataField( odataName = "PlannedProdnRsceToolQtyUnit" )
    private String plannedProdnRsceToolQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>PlannedProdnRsceToolQtyUnit</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<String> PLANNED_PRODN_RSCE_TOOL_QTY_UNIT =
        new ProductionRsceToolsField<String>("PlannedProdnRsceToolQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedTotalProdnRsceToolQty</b>
     * </p>
     *
     * @return Total Planned Quantity of Production Resource/Tool
     */
    @SerializedName( "PlannedTotalProdnRsceToolQty" )
    @JsonProperty( "PlannedTotalProdnRsceToolQty" )
    @Nullable
    @ODataField( odataName = "PlannedTotalProdnRsceToolQty" )
    private BigDecimal plannedTotalProdnRsceToolQty;
    /**
     * Use with available fluent helpers to apply the <b>PlannedTotalProdnRsceToolQty</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<BigDecimal> PLANNED_TOTAL_PRODN_RSCE_TOOL_QTY =
        new ProductionRsceToolsField<BigDecimal>("PlannedTotalProdnRsceToolQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProdnRsceToolQtyUnit</b>
     * </p>
     *
     * @return Unit for Actual Quantity of Production Resource/Tool
     */
    @SerializedName( "ConfirmedProdnRsceToolQtyUnit" )
    @JsonProperty( "ConfirmedProdnRsceToolQtyUnit" )
    @Nullable
    @ODataField( odataName = "ConfirmedProdnRsceToolQtyUnit" )
    private String confirmedProdnRsceToolQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedProdnRsceToolQtyUnit</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<String> CONFIRMED_PRODN_RSCE_TOOL_QTY_UNIT =
        new ProductionRsceToolsField<String>("ConfirmedProdnRsceToolQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProdnRsceToolQty</b>
     * </p>
     *
     * @return Actual Quantity of Production Resource/Tool
     */
    @SerializedName( "ConfirmedProdnRsceToolQty" )
    @JsonProperty( "ConfirmedProdnRsceToolQty" )
    @Nullable
    @ODataField( odataName = "ConfirmedProdnRsceToolQty" )
    private BigDecimal confirmedProdnRsceToolQty;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedProdnRsceToolQty</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<BigDecimal> CONFIRMED_PRODN_RSCE_TOOL_QTY =
        new ProductionRsceToolsField<BigDecimal>("ConfirmedProdnRsceToolQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantityUnit</b>
     * </p>
     *
     * @return Usage Value Unit of the Production Resource/Tool
     */
    @SerializedName( "ProdnRsceToolUsageQuantityUnit" )
    @JsonProperty( "ProdnRsceToolUsageQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageQuantityUnit" )
    private String prodnRsceToolUsageQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageQuantityUnit</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<String> PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT =
        new ProductionRsceToolsField<String>("ProdnRsceToolUsageQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantity</b>
     * </p>
     *
     * @return Standard Usage Value for Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolUsageQuantity" )
    @JsonProperty( "ProdnRsceToolUsageQuantity" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageQuantity" )
    private BigDecimal prodnRsceToolUsageQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageQuantity</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<BigDecimal> PRODN_RSCE_TOOL_USAGE_QUANTITY =
        new ProductionRsceToolsField<BigDecimal>("ProdnRsceToolUsageQuantity");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageStartDate</b>
     * </p>
     *
     * @return Earliest Scheduled Start Date for PRT Usage
     */
    @SerializedName( "EarliestSchedldUsageStartDate" )
    @JsonProperty( "EarliestSchedldUsageStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EarliestSchedldUsageStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime earliestSchedldUsageStartDate;
    /**
     * Use with available fluent helpers to apply the <b>EarliestSchedldUsageStartDate</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<LocalDateTime> EARLIEST_SCHEDLD_USAGE_START_DATE =
        new ProductionRsceToolsField<LocalDateTime>("EarliestSchedldUsageStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageStartTime</b>
     * </p>
     *
     * @return Earliest Scheduled Start Time for PRT Usage
     */
    @SerializedName( "EarliestSchedldUsageStartTime" )
    @JsonProperty( "EarliestSchedldUsageStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "EarliestSchedldUsageStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime earliestSchedldUsageStartTime;
    /**
     * Use with available fluent helpers to apply the <b>EarliestSchedldUsageStartTime</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<LocalTime> EARLIEST_SCHEDLD_USAGE_START_TIME =
        new ProductionRsceToolsField<LocalTime>("EarliestSchedldUsageStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageEndDate</b>
     * </p>
     *
     * @return Earliest Scheduled End Date of PRT Usage
     */
    @SerializedName( "EarliestSchedldUsageEndDate" )
    @JsonProperty( "EarliestSchedldUsageEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EarliestSchedldUsageEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime earliestSchedldUsageEndDate;
    /**
     * Use with available fluent helpers to apply the <b>EarliestSchedldUsageEndDate</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<LocalDateTime> EARLIEST_SCHEDLD_USAGE_END_DATE =
        new ProductionRsceToolsField<LocalDateTime>("EarliestSchedldUsageEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageEndTime</b>
     * </p>
     *
     * @return Earliest Scheduled End Time of PRT Usage
     */
    @SerializedName( "EarliestSchedldUsageEndTime" )
    @JsonProperty( "EarliestSchedldUsageEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "EarliestSchedldUsageEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime earliestSchedldUsageEndTime;
    /**
     * Use with available fluent helpers to apply the <b>EarliestSchedldUsageEndTime</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<LocalTime> EARLIEST_SCHEDLD_USAGE_END_TIME =
        new ProductionRsceToolsField<LocalTime>("EarliestSchedldUsageEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageStartDate</b>
     * </p>
     *
     * @return Latest Scheduled Start Date for PRT Usage
     */
    @SerializedName( "LatestSchedldUsageStartDate" )
    @JsonProperty( "LatestSchedldUsageStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LatestSchedldUsageStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime latestSchedldUsageStartDate;
    /**
     * Use with available fluent helpers to apply the <b>LatestSchedldUsageStartDate</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<LocalDateTime> LATEST_SCHEDLD_USAGE_START_DATE =
        new ProductionRsceToolsField<LocalDateTime>("LatestSchedldUsageStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageStartTime</b>
     * </p>
     *
     * @return Latest Scheduled Start Time for PRT Usage
     */
    @SerializedName( "LatestSchedldUsageStartTime" )
    @JsonProperty( "LatestSchedldUsageStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LatestSchedldUsageStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime latestSchedldUsageStartTime;
    /**
     * Use with available fluent helpers to apply the <b>LatestSchedldUsageStartTime</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<LocalTime> LATEST_SCHEDLD_USAGE_START_TIME =
        new ProductionRsceToolsField<LocalTime>("LatestSchedldUsageStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageEndDate</b>
     * </p>
     *
     * @return Latest Scheduled End Date for PRT Usage
     */
    @SerializedName( "LatestSchedldUsageEndDate" )
    @JsonProperty( "LatestSchedldUsageEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LatestSchedldUsageEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime latestSchedldUsageEndDate;
    /**
     * Use with available fluent helpers to apply the <b>LatestSchedldUsageEndDate</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<LocalDateTime> LATEST_SCHEDLD_USAGE_END_DATE =
        new ProductionRsceToolsField<LocalDateTime>("LatestSchedldUsageEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageEndTime</b>
     * </p>
     *
     * @return Latest Scheduled End Time for PRT Usage
     */
    @SerializedName( "LatestSchedldUsageEndTime" )
    @JsonProperty( "LatestSchedldUsageEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LatestSchedldUsageEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime latestSchedldUsageEndTime;
    /**
     * Use with available fluent helpers to apply the <b>LatestSchedldUsageEndTime</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<LocalTime> LATEST_SCHEDLD_USAGE_END_TIME =
        new ProductionRsceToolsField<LocalTime>("LatestSchedldUsageEndTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @return Manufacturing Order Type
     */
    @SerializedName( "ManufacturingOrderType" )
    @JsonProperty( "ManufacturingOrderType" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderType" )
    private String manufacturingOrderType;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderType</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<String> MANUFACTURING_ORDER_TYPE =
        new ProductionRsceToolsField<String>("ManufacturingOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @return Manufacturing Order Category
     */
    @SerializedName( "ManufacturingOrderCategory" )
    @JsonProperty( "ManufacturingOrderCategory" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderCategory" )
    private String manufacturingOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderCategory</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<String> MANUFACTURING_ORDER_CATEGORY =
        new ProductionRsceToolsField<String>("ManufacturingOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @return Production Plant
     */
    @SerializedName( "ProductionPlant" )
    @JsonProperty( "ProductionPlant" )
    @Nullable
    @ODataField( odataName = "ProductionPlant" )
    private String productionPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPlant</b> field to query operations.
     *
     */
    public final static ProductionRsceToolsField<String> PRODUCTION_PLANT =
        new ProductionRsceToolsField<String>("ProductionPlant");

    @Nonnull
    @Override
    public Class<ProductionRsceTools> getType()
    {
        return ProductionRsceTools.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     */
    public void setOrderInternalBillOfOperations( @Nullable final String orderInternalBillOfOperations )
    {
        rememberChangedField("OrderInternalBillOfOperations", this.orderInternalBillOfOperations);
        this.orderInternalBillOfOperations = orderInternalBillOfOperations;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderOpProdnRsceToolIntID</b>
     * </p>
     *
     * @param mfgOrderOpProdnRsceToolIntID
     *            Item Counter for Production Resources/Tools
     */
    public void setMfgOrderOpProdnRsceToolIntID( @Nullable final String mfgOrderOpProdnRsceToolIntID )
    {
        rememberChangedField("MfgOrderOpProdnRsceToolIntID", this.mfgOrderOpProdnRsceToolIntID);
        this.mfgOrderOpProdnRsceToolIntID = mfgOrderOpProdnRsceToolIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Manufacturing Order ID
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategory</b>
     * </p>
     *
     * @param prodnRsceToolCategory
     *            Production Resources/Tools Category
     */
    public void setProdnRsceToolCategory( @Nullable final String prodnRsceToolCategory )
    {
        rememberChangedField("ProdnRsceToolCategory", this.prodnRsceToolCategory);
        this.prodnRsceToolCategory = prodnRsceToolCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategoryName</b>
     * </p>
     *
     * @param prodnRsceToolCategoryName
     *            Language-dependent description of the PRT category
     */
    public void setProdnRsceToolCategoryName( @Nullable final String prodnRsceToolCategoryName )
    {
        rememberChangedField("ProdnRsceToolCategoryName", this.prodnRsceToolCategoryName);
        this.prodnRsceToolCategoryName = prodnRsceToolCategoryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedProdnRsceToolQtyUnit</b>
     * </p>
     *
     * @param plannedProdnRsceToolQtyUnit
     *            Unit for Total Planned Quantity of Production Resource/Tool
     */
    public void setPlannedProdnRsceToolQtyUnit( @Nullable final String plannedProdnRsceToolQtyUnit )
    {
        rememberChangedField("PlannedProdnRsceToolQtyUnit", this.plannedProdnRsceToolQtyUnit);
        this.plannedProdnRsceToolQtyUnit = plannedProdnRsceToolQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedTotalProdnRsceToolQty</b>
     * </p>
     *
     * @param plannedTotalProdnRsceToolQty
     *            Total Planned Quantity of Production Resource/Tool
     */
    public void setPlannedTotalProdnRsceToolQty( @Nullable final BigDecimal plannedTotalProdnRsceToolQty )
    {
        rememberChangedField("PlannedTotalProdnRsceToolQty", this.plannedTotalProdnRsceToolQty);
        this.plannedTotalProdnRsceToolQty = plannedTotalProdnRsceToolQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProdnRsceToolQtyUnit</b>
     * </p>
     *
     * @param confirmedProdnRsceToolQtyUnit
     *            Unit for Actual Quantity of Production Resource/Tool
     */
    public void setConfirmedProdnRsceToolQtyUnit( @Nullable final String confirmedProdnRsceToolQtyUnit )
    {
        rememberChangedField("ConfirmedProdnRsceToolQtyUnit", this.confirmedProdnRsceToolQtyUnit);
        this.confirmedProdnRsceToolQtyUnit = confirmedProdnRsceToolQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProdnRsceToolQty</b>
     * </p>
     *
     * @param confirmedProdnRsceToolQty
     *            Actual Quantity of Production Resource/Tool
     */
    public void setConfirmedProdnRsceToolQty( @Nullable final BigDecimal confirmedProdnRsceToolQty )
    {
        rememberChangedField("ConfirmedProdnRsceToolQty", this.confirmedProdnRsceToolQty);
        this.confirmedProdnRsceToolQty = confirmedProdnRsceToolQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantityUnit</b>
     * </p>
     *
     * @param prodnRsceToolUsageQuantityUnit
     *            Usage Value Unit of the Production Resource/Tool
     */
    public void setProdnRsceToolUsageQuantityUnit( @Nullable final String prodnRsceToolUsageQuantityUnit )
    {
        rememberChangedField("ProdnRsceToolUsageQuantityUnit", this.prodnRsceToolUsageQuantityUnit);
        this.prodnRsceToolUsageQuantityUnit = prodnRsceToolUsageQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantity</b>
     * </p>
     *
     * @param prodnRsceToolUsageQuantity
     *            Standard Usage Value for Production Resources/Tools
     */
    public void setProdnRsceToolUsageQuantity( @Nullable final BigDecimal prodnRsceToolUsageQuantity )
    {
        rememberChangedField("ProdnRsceToolUsageQuantity", this.prodnRsceToolUsageQuantity);
        this.prodnRsceToolUsageQuantity = prodnRsceToolUsageQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageStartDate</b>
     * </p>
     *
     * @param earliestSchedldUsageStartDate
     *            Earliest Scheduled Start Date for PRT Usage
     */
    public void setEarliestSchedldUsageStartDate( @Nullable final LocalDateTime earliestSchedldUsageStartDate )
    {
        rememberChangedField("EarliestSchedldUsageStartDate", this.earliestSchedldUsageStartDate);
        this.earliestSchedldUsageStartDate = earliestSchedldUsageStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageStartTime</b>
     * </p>
     *
     * @param earliestSchedldUsageStartTime
     *            Earliest Scheduled Start Time for PRT Usage
     */
    public void setEarliestSchedldUsageStartTime( @Nullable final LocalTime earliestSchedldUsageStartTime )
    {
        rememberChangedField("EarliestSchedldUsageStartTime", this.earliestSchedldUsageStartTime);
        this.earliestSchedldUsageStartTime = earliestSchedldUsageStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageEndDate</b>
     * </p>
     *
     * @param earliestSchedldUsageEndDate
     *            Earliest Scheduled End Date of PRT Usage
     */
    public void setEarliestSchedldUsageEndDate( @Nullable final LocalDateTime earliestSchedldUsageEndDate )
    {
        rememberChangedField("EarliestSchedldUsageEndDate", this.earliestSchedldUsageEndDate);
        this.earliestSchedldUsageEndDate = earliestSchedldUsageEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageEndTime</b>
     * </p>
     *
     * @param earliestSchedldUsageEndTime
     *            Earliest Scheduled End Time of PRT Usage
     */
    public void setEarliestSchedldUsageEndTime( @Nullable final LocalTime earliestSchedldUsageEndTime )
    {
        rememberChangedField("EarliestSchedldUsageEndTime", this.earliestSchedldUsageEndTime);
        this.earliestSchedldUsageEndTime = earliestSchedldUsageEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageStartDate</b>
     * </p>
     *
     * @param latestSchedldUsageStartDate
     *            Latest Scheduled Start Date for PRT Usage
     */
    public void setLatestSchedldUsageStartDate( @Nullable final LocalDateTime latestSchedldUsageStartDate )
    {
        rememberChangedField("LatestSchedldUsageStartDate", this.latestSchedldUsageStartDate);
        this.latestSchedldUsageStartDate = latestSchedldUsageStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageStartTime</b>
     * </p>
     *
     * @param latestSchedldUsageStartTime
     *            Latest Scheduled Start Time for PRT Usage
     */
    public void setLatestSchedldUsageStartTime( @Nullable final LocalTime latestSchedldUsageStartTime )
    {
        rememberChangedField("LatestSchedldUsageStartTime", this.latestSchedldUsageStartTime);
        this.latestSchedldUsageStartTime = latestSchedldUsageStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageEndDate</b>
     * </p>
     *
     * @param latestSchedldUsageEndDate
     *            Latest Scheduled End Date for PRT Usage
     */
    public void setLatestSchedldUsageEndDate( @Nullable final LocalDateTime latestSchedldUsageEndDate )
    {
        rememberChangedField("LatestSchedldUsageEndDate", this.latestSchedldUsageEndDate);
        this.latestSchedldUsageEndDate = latestSchedldUsageEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageEndTime</b>
     * </p>
     *
     * @param latestSchedldUsageEndTime
     *            Latest Scheduled End Time for PRT Usage
     */
    public void setLatestSchedldUsageEndTime( @Nullable final LocalTime latestSchedldUsageEndTime )
    {
        rememberChangedField("LatestSchedldUsageEndTime", this.latestSchedldUsageEndTime);
        this.latestSchedldUsageEndTime = latestSchedldUsageEndTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @param manufacturingOrderType
     *            Manufacturing Order Type
     */
    public void setManufacturingOrderType( @Nullable final String manufacturingOrderType )
    {
        rememberChangedField("ManufacturingOrderType", this.manufacturingOrderType);
        this.manufacturingOrderType = manufacturingOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     */
    public void setManufacturingOrderCategory( @Nullable final String manufacturingOrderCategory )
    {
        rememberChangedField("ManufacturingOrderCategory", this.manufacturingOrderCategory);
        this.manufacturingOrderCategory = manufacturingOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @param productionPlant
     *            Production Plant
     */
    public void setProductionPlant( @Nullable final String productionPlant )
    {
        rememberChangedField("ProductionPlant", this.productionPlant);
        this.productionPlant = productionPlant;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductionRsceTools";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        result.put("MfgOrderOpProdnRsceToolIntID", getMfgOrderOpProdnRsceToolIntID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        values.put("MfgOrderOpProdnRsceToolIntID", getMfgOrderOpProdnRsceToolIntID());
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("ProdnRsceToolCategory", getProdnRsceToolCategory());
        values.put("ProdnRsceToolCategoryName", getProdnRsceToolCategoryName());
        values.put("PlannedProdnRsceToolQtyUnit", getPlannedProdnRsceToolQtyUnit());
        values.put("PlannedTotalProdnRsceToolQty", getPlannedTotalProdnRsceToolQty());
        values.put("ConfirmedProdnRsceToolQtyUnit", getConfirmedProdnRsceToolQtyUnit());
        values.put("ConfirmedProdnRsceToolQty", getConfirmedProdnRsceToolQty());
        values.put("ProdnRsceToolUsageQuantityUnit", getProdnRsceToolUsageQuantityUnit());
        values.put("ProdnRsceToolUsageQuantity", getProdnRsceToolUsageQuantity());
        values.put("EarliestSchedldUsageStartDate", getEarliestSchedldUsageStartDate());
        values.put("EarliestSchedldUsageStartTime", getEarliestSchedldUsageStartTime());
        values.put("EarliestSchedldUsageEndDate", getEarliestSchedldUsageEndDate());
        values.put("EarliestSchedldUsageEndTime", getEarliestSchedldUsageEndTime());
        values.put("LatestSchedldUsageStartDate", getLatestSchedldUsageStartDate());
        values.put("LatestSchedldUsageStartTime", getLatestSchedldUsageStartTime());
        values.put("LatestSchedldUsageEndDate", getLatestSchedldUsageEndDate());
        values.put("LatestSchedldUsageEndTime", getLatestSchedldUsageEndTime());
        values.put("ManufacturingOrderType", getManufacturingOrderType());
        values.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        values.put("ProductionPlant", getProductionPlant());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OrderInternalBillOfOperations") ) {
                final Object value = values.remove("OrderInternalBillOfOperations");
                if( (value == null) || (!value.equals(getOrderInternalBillOfOperations())) ) {
                    setOrderInternalBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("MfgOrderOpProdnRsceToolIntID") ) {
                final Object value = values.remove("MfgOrderOpProdnRsceToolIntID");
                if( (value == null) || (!value.equals(getMfgOrderOpProdnRsceToolIntID())) ) {
                    setMfgOrderOpProdnRsceToolIntID(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolCategory") ) {
                final Object value = values.remove("ProdnRsceToolCategory");
                if( (value == null) || (!value.equals(getProdnRsceToolCategory())) ) {
                    setProdnRsceToolCategory(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolCategoryName") ) {
                final Object value = values.remove("ProdnRsceToolCategoryName");
                if( (value == null) || (!value.equals(getProdnRsceToolCategoryName())) ) {
                    setProdnRsceToolCategoryName(((String) value));
                }
            }
            if( values.containsKey("PlannedProdnRsceToolQtyUnit") ) {
                final Object value = values.remove("PlannedProdnRsceToolQtyUnit");
                if( (value == null) || (!value.equals(getPlannedProdnRsceToolQtyUnit())) ) {
                    setPlannedProdnRsceToolQtyUnit(((String) value));
                }
            }
            if( values.containsKey("PlannedTotalProdnRsceToolQty") ) {
                final Object value = values.remove("PlannedTotalProdnRsceToolQty");
                if( (value == null) || (!value.equals(getPlannedTotalProdnRsceToolQty())) ) {
                    setPlannedTotalProdnRsceToolQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConfirmedProdnRsceToolQtyUnit") ) {
                final Object value = values.remove("ConfirmedProdnRsceToolQtyUnit");
                if( (value == null) || (!value.equals(getConfirmedProdnRsceToolQtyUnit())) ) {
                    setConfirmedProdnRsceToolQtyUnit(((String) value));
                }
            }
            if( values.containsKey("ConfirmedProdnRsceToolQty") ) {
                final Object value = values.remove("ConfirmedProdnRsceToolQty");
                if( (value == null) || (!value.equals(getConfirmedProdnRsceToolQty())) ) {
                    setConfirmedProdnRsceToolQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageQuantityUnit") ) {
                final Object value = values.remove("ProdnRsceToolUsageQuantityUnit");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageQuantityUnit())) ) {
                    setProdnRsceToolUsageQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageQuantity") ) {
                final Object value = values.remove("ProdnRsceToolUsageQuantity");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageQuantity())) ) {
                    setProdnRsceToolUsageQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("EarliestSchedldUsageStartDate") ) {
                final Object value = values.remove("EarliestSchedldUsageStartDate");
                if( (value == null) || (!value.equals(getEarliestSchedldUsageStartDate())) ) {
                    setEarliestSchedldUsageStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EarliestSchedldUsageStartTime") ) {
                final Object value = values.remove("EarliestSchedldUsageStartTime");
                if( (value == null) || (!value.equals(getEarliestSchedldUsageStartTime())) ) {
                    setEarliestSchedldUsageStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("EarliestSchedldUsageEndDate") ) {
                final Object value = values.remove("EarliestSchedldUsageEndDate");
                if( (value == null) || (!value.equals(getEarliestSchedldUsageEndDate())) ) {
                    setEarliestSchedldUsageEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EarliestSchedldUsageEndTime") ) {
                final Object value = values.remove("EarliestSchedldUsageEndTime");
                if( (value == null) || (!value.equals(getEarliestSchedldUsageEndTime())) ) {
                    setEarliestSchedldUsageEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LatestSchedldUsageStartDate") ) {
                final Object value = values.remove("LatestSchedldUsageStartDate");
                if( (value == null) || (!value.equals(getLatestSchedldUsageStartDate())) ) {
                    setLatestSchedldUsageStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LatestSchedldUsageStartTime") ) {
                final Object value = values.remove("LatestSchedldUsageStartTime");
                if( (value == null) || (!value.equals(getLatestSchedldUsageStartTime())) ) {
                    setLatestSchedldUsageStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LatestSchedldUsageEndDate") ) {
                final Object value = values.remove("LatestSchedldUsageEndDate");
                if( (value == null) || (!value.equals(getLatestSchedldUsageEndDate())) ) {
                    setLatestSchedldUsageEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LatestSchedldUsageEndTime") ) {
                final Object value = values.remove("LatestSchedldUsageEndTime");
                if( (value == null) || (!value.equals(getLatestSchedldUsageEndTime())) ) {
                    setLatestSchedldUsageEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ManufacturingOrderType") ) {
                final Object value = values.remove("ManufacturingOrderType");
                if( (value == null) || (!value.equals(getManufacturingOrderType())) ) {
                    setManufacturingOrderType(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderCategory") ) {
                final Object value = values.remove("ManufacturingOrderCategory");
                if( (value == null) || (!value.equals(getManufacturingOrderCategory())) ) {
                    setManufacturingOrderCategory(((String) value));
                }
            }
            if( values.containsKey("ProductionPlant") ) {
                final Object value = values.remove("ProductionPlant");
                if( (value == null) || (!value.equals(getProductionPlant())) ) {
                    setProductionPlant(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductionRsceToolsField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductionRsceToolsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductionRsceToolsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductionRsceToolsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderService.DEFAULT_SERVICE_PATH);
    }

}
