/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder;

/**
 * Implementation of the {@link ProductionOrderServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderService ProductionOrderService}.
 *
 */
public class DefaultProductionOrderServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProductionOrderServiceBatch, ProductionOrderServiceBatchChangeSet>
    implements
    ProductionOrderServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderService service;

    @SuppressWarnings( "deprecation" )
    DefaultProductionOrderServiceBatchChangeSet(
        @Nonnull final DefaultProductionOrderServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProductionOrderServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductionOrderServiceBatchChangeSet createProductionOrder( @Nonnull final ProductionOrder productionOrder )
    {
        return addRequestCreate(service::createProductionOrder, productionOrder);
    }

    @Nonnull
    @Override
    public ProductionOrderServiceBatchChangeSet updateProductionOrder( @Nonnull final ProductionOrder productionOrder )
    {
        return addRequestUpdate(service::updateProductionOrder, productionOrder);
    }

}
