/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderService ProductionOrderService}.
 *
 */
public interface ProductionOrderServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ProductionOrderServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ProductionOrderServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     * ProductionOrder} entity and save it to the S/4HANA system.
     *
     * @param productionOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     *            ProductionOrder} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionOrderServiceBatchChangeSet createProductionOrder( @Nonnull final ProductionOrder productionOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     * ProductionOrder} entity and save it to the S/4HANA system.
     *
     * @param productionOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     *            ProductionOrder} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionOrderServiceBatchChangeSet updateProductionOrder( @Nonnull final ProductionOrder productionOrder );

}
