/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.datamodel.odata.helper.OneToOneLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ReleaseMessage;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ReleaseMessage ReleaseMessage} to other
 * entities, where the cardinality of the related entity is at most 1. This class extends
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.link.ReleaseMessageLink
 * ReleaseMessageLink} and provides an additional filter function.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ReleaseMessageOneToOneLink<ObjectT extends VdmObject<?>> extends ReleaseMessageLink<ObjectT>
    implements
    OneToOneLink<ReleaseMessage, ObjectT>
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ReleaseMessageOneToOneLink( final String fieldName )
    {
        super(fieldName);
    }

    /**
     * Query modifier to restrict the result set to entities for which this expression (formulated over a property of a
     * <b>related</b> entity) evaluates to true. Note that filtering on a related entity does not expand the selection
     * of the respective query to that entity.
     *
     * @param filterExpression
     *            A filter expression on the related entity.
     * @return A filter expression over a related entity, scoped to the parent entity.
     */
    @Nonnull
    @Override
    public ExpressionFluentHelper<ReleaseMessage> filter(
        @Nonnull final ExpressionFluentHelper<ObjectT> filterExpression )
    {
        return super.filterOnOneToOneLink(filterExpression);
    }

}
