/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent
 * ProductionOrderComponent}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.field.ProductionOrderComponentField
 * ProductionOrderComponentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.link.ProductionOrderComponentLink
 * ProductionOrderComponentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#RESERVATION
 * RESERVATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#RESERVATION_ITEM
 * RESERVATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#BILL_OF_MATERIAL_ITEM_NUMBER
 * BILL_OF_MATERIAL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#BOM_ITEM_DESCRIPTION
 * BOM_ITEM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#PRODUCTION_PLANT
 * PRODUCTION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#MATL_COMP_REQUIREMENT_DATE
 * MATL_COMP_REQUIREMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#REQUIRED_QUANTITY
 * REQUIRED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#WITHDRAWN_QUANTITY
 * WITHDRAWN_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#BOM_ITEM
 * BOM_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#SUPPLY_AREA
 * SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#MANUFACTURING_ORDER_SEQUENCE
 * MANUFACTURING_ORDER_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#MANUFACTURING_ORDER_OPERATION
 * MANUFACTURING_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#MANUFACTURING_ORDER_CATEGORY
 * MANUFACTURING_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#MANUFACTURING_ORDER_TYPE
 * MANUFACTURING_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#ORDER_INTERNAL_BILL_OF_OPERATIONS
 * ORDER_INTERNAL_BILL_OF_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#BOM_ITEM_TEXT2
 * BOM_ITEM_TEXT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#BOM_ITEM_CATEGORY
 * BOM_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#BILL_OF_MATERIAL_CATEGORY
 * BILL_OF_MATERIAL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#SORT_FIELD
 * SORT_FIELD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#GOODS_RECIPIENT_NAME
 * GOODS_RECIPIENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent#BATCH_SPLIT_TYPE
 * BATCH_SPLIT_TYPE}</li>
 * </ul>
 *
 */
public interface ProductionOrderComponentSelectable extends EntitySelectable<ProductionOrderComponent>
{

}
