/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem ProductionOrderItem}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.field.ProductionOrderItemField
 * ProductionOrderItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.link.ProductionOrderItemLink
 * ProductionOrderItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MANUFACTURING_ORDER_ITEM
 * MANUFACTURING_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MANUFACTURING_ORDER_CATEGORY
 * MANUFACTURING_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MANUFACTURING_ORDER_TYPE
 * MANUFACTURING_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#PRODUCTION_PLANT
 * PRODUCTION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MRP_PLANT
 * MRP_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MFG_ORDER_ITEM_ACTUAL_DELIVERY_DATE
 * MFG_ORDER_ITEM_ACTUAL_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MFG_ORDER_ITEM_PLANNED_TOTAL_QTY
 * MFG_ORDER_ITEM_PLANNED_TOTAL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MFG_ORDER_ITEM_PLANNED_SCRAP_QTY
 * MFG_ORDER_ITEM_PLANNED_SCRAP_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MFG_ORDER_ITEM_GOODS_RECEIPT_QTY
 * MFG_ORDER_ITEM_GOODS_RECEIPT_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MFG_ORDER_ITEM_ACTUAL_DEVIATION_QTY
 * MFG_ORDER_ITEM_ACTUAL_DEVIATION_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#PRODUCTION_UNIT
 * PRODUCTION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MRP_AREA
 * MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MFG_ORDER_ITEM_PLND_DELIVERY_DATE
 * MFG_ORDER_ITEM_PLND_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#GOODS_RECIPIENT_NAME
 * GOODS_RECIPIENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#MATERIAL_GOODS_RECEIPT_DURATION
 * MATERIAL_GOODS_RECEIPT_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#INVENTORY_USABILITY_CODE
 * INVENTORY_USABILITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#QUANTITY_DISTRIBUTION_KEY
 * QUANTITY_DISTRIBUTION_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#STOCK_SEGMENT
 * STOCK_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem#BATCH BATCH}</li>
 * </ul>
 *
 */
public interface ProductionOrderItemSelectable extends EntitySelectable<ProductionOrderItem>
{

}
