/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation
 * ProductionOrderOperation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.field.ProductionOrderOperationField
 * ProductionOrderOperationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.link.ProductionOrderOperationLink
 * ProductionOrderOperationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#ORDER_INTERNAL_BILL_OF_OPERATIONS
 * ORDER_INTERNAL_BILL_OF_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#ORDER_INT_BILL_OF_OPERATIONS_ITEM
 * ORDER_INT_BILL_OF_OPERATIONS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#MANUFACTURING_ORDER_OPERATION
 * MANUFACTURING_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#MFG_ORDER_OPERATION_IS_PHASE
 * MFG_ORDER_OPERATION_IS_PHASE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#MANUFACTURING_ORDER_SEQUENCE
 * MANUFACTURING_ORDER_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#MFG_ORDER_SEQUENCE_TEXT
 * MFG_ORDER_SEQUENCE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#MFG_ORDER_OPERATION_TEXT
 * MFG_ORDER_OPERATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#MANUFACTURING_ORDER_TYPE
 * MANUFACTURING_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#BUSINESS_PROCESS_ENTRY_UNIT
 * BUSINESS_PROCESS_ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#MANUFACTURING_ORDER_CATEGORY
 * MANUFACTURING_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#WORK_CENTER_TYPE_CODE
 * WORK_CENTER_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#OP_ERLST_SCHEDLD_EXEC_STRT_DTE
 * OP_ERLST_SCHEDLD_EXEC_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#OP_ERLST_SCHEDLD_EXEC_STRT_TME
 * OP_ERLST_SCHEDLD_EXEC_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#OP_ERLST_SCHEDLD_EXEC_END_DTE
 * OP_ERLST_SCHEDLD_EXEC_END_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#OP_ERLST_SCHEDLD_EXEC_END_TME
 * OP_ERLST_SCHEDLD_EXEC_END_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#OP_ACTUAL_EXECUTION_START_DATE
 * OP_ACTUAL_EXECUTION_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#OP_ACTUAL_EXECUTION_START_TIME
 * OP_ACTUAL_EXECUTION_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#OP_ACTUAL_EXECUTION_END_DATE
 * OP_ACTUAL_EXECUTION_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#OP_ACTUAL_EXECUTION_END_TIME
 * OP_ACTUAL_EXECUTION_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#OPERATION_UNIT
 * OPERATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#OP_PLANNED_TOTAL_QUANTITY
 * OP_PLANNED_TOTAL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS
 * ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#OP_ACTUAL_EXECUTION_DAYS
 * OP_ACTUAL_EXECUTION_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#OP_TOTAL_CONFIRMED_YIELD_QTY
 * OP_TOTAL_CONFIRMED_YIELD_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * </ul>
 *
 */
public interface ProductionOrderOperationSelectable extends EntitySelectable<ProductionOrderOperation>
{

}
