/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder ProductionOrder}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.field.ProductionOrderField
 * ProductionOrderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.link.ProductionOrderLink
 * ProductionOrderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#PRODUCTION_ORDER
 * PRODUCTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#PRODUCTION_PLANT
 * PRODUCTION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_INTERNAL_BILL_OF_OPERATIONS
 * ORDER_INTERNAL_BILL_OF_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_CREATED
 * ORDER_IS_CREATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_RELEASED
 * ORDER_IS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_PRINTED
 * ORDER_IS_PRINTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_CONFIRMED
 * ORDER_IS_CONFIRMED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_PARTIALLY_CONFIRMED
 * ORDER_IS_PARTIALLY_CONFIRMED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_DELIVERED
 * ORDER_IS_DELIVERED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_DELETED
 * ORDER_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_PRE_COSTED
 * ORDER_IS_PRE_COSTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#SETTLEMENT_RULE_IS_CREATED
 * SETTLEMENT_RULE_IS_CREATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_PARTIALLY_RELEASED
 * ORDER_IS_PARTIALLY_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_LOCKED
 * ORDER_IS_LOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_TECHNICALLY_COMPLETED
 * ORDER_IS_TECHNICALLY_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_CLOSED
 * ORDER_IS_CLOSED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_PARTIALLY_DELIVERED
 * ORDER_IS_PARTIALLY_DELIVERED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_MARKED_FOR_DELETION
 * ORDER_IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#SETTLEMENT_RULE_IS_CRTED_MANUALLY
 * SETTLEMENT_RULE_IS_CRTED_MANUALLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_SCHEDULED
 * ORDER_IS_SCHEDULED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_HAS_GENERATED_OPERATIONS
 * ORDER_HAS_GENERATED_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_IS_TO_BE_HANDLED_IN_BATCHES
 * ORDER_IS_TO_BE_HANDLED_IN_BATCHES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MATERIAL_AVAILY_IS_NOT_CHECKED
 * MATERIAL_AVAILY_IS_NOT_CHECKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MATERIAL_NAME
 * MATERIAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#PRODUCTION_UNIT
 * PRODUCTION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#TOTAL_QUANTITY
 * TOTAL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MANUFACTURING_ORDER_TYPE
 * MANUFACTURING_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MRP_AREA
 * MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MANUFACTURING_OBJECT
 * MANUFACTURING_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_CONFIRMED_YIELD_QTY
 * MFG_ORDER_CONFIRMED_YIELD_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_PLANNED_START_DATE
 * MFG_ORDER_PLANNED_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_PLANNED_START_TIME
 * MFG_ORDER_PLANNED_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_PLANNED_END_DATE
 * MFG_ORDER_PLANNED_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_PLANNED_END_TIME
 * MFG_ORDER_PLANNED_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_SCHEDULED_START_DATE
 * MFG_ORDER_SCHEDULED_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_SCHEDULED_START_TIME
 * MFG_ORDER_SCHEDULED_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_SCHEDULED_END_DATE
 * MFG_ORDER_SCHEDULED_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_SCHEDULED_END_TIME
 * MFG_ORDER_SCHEDULED_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#PLANNED_ORDER
 * PLANNED_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#CUSTOMER_NAME
 * CUSTOMER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#WBS_DESCRIPTION
 * WBS_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#PLANNED_COSTS_COSTING_VARIANT
 * PLANNED_COSTS_COSTING_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ACTUAL_COSTS_COSTING_VARIANT
 * ACTUAL_COSTS_COSTING_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#USER_ID USER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#PRODUCTION_VERSION
 * PRODUCTION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MRP_CONTROLLER
 * MRP_CONTROLLER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#PRODUCTION_SUPERVISOR
 * PRODUCTION_SUPERVISOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MANUFACTURING_ORDER_CATEGORY
 * MANUFACTURING_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_PLANNED_SCRAP_QTY
 * MFG_ORDER_PLANNED_SCRAP_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MANUFACTURING_ORDER_IMPORTANCE
 * MANUFACTURING_ORDER_IMPORTANCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#ORDER_SEQUENCE_NUMBER
 * ORDER_SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_CREATION_DATE
 * MFG_ORDER_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_CREATION_TIME
 * MFG_ORDER_CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MFG_ORDER_ACTUAL_RELEASE_DATE
 * MFG_ORDER_ACTUAL_RELEASE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#GOODS_RECIPIENT_NAME
 * GOODS_RECIPIENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#MATERIAL_GOODS_RECEIPT_DURATION
 * MATERIAL_GOODS_RECEIPT_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#INVENTORY_USABILITY_CODE
 * INVENTORY_USABILITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#QUANTITY_DISTRIBUTION_KEY
 * QUANTITY_DISTRIBUTION_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#STOCK_SEGMENT
 * STOCK_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#BASIC_SCHEDULING_TYPE
 * BASIC_SCHEDULING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#TO_PRODUCTION_ORDER_COMPONENT
 * TO_PRODUCTION_ORDER_COMPONENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#TO_PRODUCTION_ORDER_ITEM
 * TO_PRODUCTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#TO_PRODUCTION_ORDER_OPERATION
 * TO_PRODUCTION_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#TO_PRODUCTION_ORDER_STATUS
 * TO_PRODUCTION_ORDER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder#TO_PRODUCTION_RSCE_TOOLS
 * TO_PRODUCTION_RSCE_TOOLS}</li>
 * </ul>
 *
 */
public interface ProductionOrderSelectable extends EntitySelectable<ProductionOrder>
{

}
