/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools ProductionRsceTools}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.field.ProductionRsceToolsField
 * ProductionRsceToolsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.link.ProductionRsceToolsLink
 * ProductionRsceToolsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#ORDER_INTERNAL_BILL_OF_OPERATIONS
 * ORDER_INTERNAL_BILL_OF_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#MFG_ORDER_OP_PRODN_RSCE_TOOL_INT_ID
 * MFG_ORDER_OP_PRODN_RSCE_TOOL_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#PRODN_RSCE_TOOL_CATEGORY
 * PRODN_RSCE_TOOL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#PRODN_RSCE_TOOL_CATEGORY_NAME
 * PRODN_RSCE_TOOL_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#PLANNED_PRODN_RSCE_TOOL_QTY_UNIT
 * PLANNED_PRODN_RSCE_TOOL_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#PLANNED_TOTAL_PRODN_RSCE_TOOL_QTY
 * PLANNED_TOTAL_PRODN_RSCE_TOOL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#CONFIRMED_PRODN_RSCE_TOOL_QTY_UNIT
 * CONFIRMED_PRODN_RSCE_TOOL_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#CONFIRMED_PRODN_RSCE_TOOL_QTY
 * CONFIRMED_PRODN_RSCE_TOOL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT
 * PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#PRODN_RSCE_TOOL_USAGE_QUANTITY
 * PRODN_RSCE_TOOL_USAGE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#EARLIEST_SCHEDLD_USAGE_START_DATE
 * EARLIEST_SCHEDLD_USAGE_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#EARLIEST_SCHEDLD_USAGE_START_TIME
 * EARLIEST_SCHEDLD_USAGE_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#EARLIEST_SCHEDLD_USAGE_END_DATE
 * EARLIEST_SCHEDLD_USAGE_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#EARLIEST_SCHEDLD_USAGE_END_TIME
 * EARLIEST_SCHEDLD_USAGE_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#LATEST_SCHEDLD_USAGE_START_DATE
 * LATEST_SCHEDLD_USAGE_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#LATEST_SCHEDLD_USAGE_START_TIME
 * LATEST_SCHEDLD_USAGE_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#LATEST_SCHEDLD_USAGE_END_DATE
 * LATEST_SCHEDLD_USAGE_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#LATEST_SCHEDLD_USAGE_END_TIME
 * LATEST_SCHEDLD_USAGE_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#MANUFACTURING_ORDER_TYPE
 * MANUFACTURING_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#MANUFACTURING_ORDER_CATEGORY
 * MANUFACTURING_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools#PRODUCTION_PLANT
 * PRODUCTION_PLANT}</li>
 * </ul>
 *
 */
public interface ProductionRsceToolsSelectable extends EntitySelectable<ProductionRsceTools>
{

}
