/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ReleaseMessage;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ReleaseMessage ReleaseMessage}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.field.ReleaseMessageField
 * ReleaseMessageField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.link.ReleaseMessageLink
 * ReleaseMessageLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ReleaseMessage#MESSAGE MESSAGE}</li>
 * </ul>
 *
 */
public interface ReleaseMessageSelectable extends EntitySelectable<ReleaseMessage>
{

}
