/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>AProdnordconfmatldocitem</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AProdnordconfmatldocitem extends VdmComplex<AProdnordconfmatldocitem>
{

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *
     * @return Batch
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationCount</b>
     * </p>
     *
     * @param confirmationCount
     *
     * @return Order Confirmation
     */
    @SerializedName( "ConfirmationCount" )
    @JsonProperty( "ConfirmationCount" )
    @Nullable
    @ODataField( odataName = "ConfirmationCount" )
    private String confirmationCount;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationGroup</b>
     * </p>
     *
     * @param confirmationGroup
     *
     * @return Confirmation Group
     */
    @SerializedName( "ConfirmationGroup" )
    @JsonProperty( "ConfirmationGroup" )
    @Nullable
    @ODataField( odataName = "ConfirmationGroup" )
    private String confirmationGroup;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *
     * @return Customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @param entryUnit
     *
     * @return Unit of Entry
     */
    @SerializedName( "EntryUnit" )
    @JsonProperty( "EntryUnit" )
    @Nullable
    @ODataField( odataName = "EntryUnit" )
    private String entryUnit;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>EntryUnitISOCode</b>
     * </p>
     *
     * @param entryUnitISOCode
     *
     * @return ISO Code
     */
    @SerializedName( "EntryUnitISOCode" )
    @JsonProperty( "EntryUnitISOCode" )
    @Nullable
    @ODataField( odataName = "EntryUnitISOCode" )
    private String entryUnitISOCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>EntryUnitSAPCode</b>
     * </p>
     *
     * @param entryUnitSAPCode
     *
     * @return Internal SAP Code
     */
    @SerializedName( "EntryUnitSAPCode" )
    @JsonProperty( "EntryUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "EntryUnitSAPCode" )
    private String entryUnitSAPCode;
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>EWMStorageBin</b>
     * </p>
     *
     * @param eWMStorageBin
     *
     * @return Storage Bin
     */
    @SerializedName( "EWMStorageBin" )
    @JsonProperty( "EWMStorageBin" )
    @Nullable
    @ODataField( odataName = "EWMStorageBin" )
    private String eWMStorageBin;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>EWMWarehouse</b>
     * </p>
     *
     * @param eWMWarehouse
     *
     * @return Warehouse Number
     */
    @SerializedName( "EWMWarehouse" )
    @JsonProperty( "EWMWarehouse" )
    @Nullable
    @ODataField( odataName = "EWMWarehouse" )
    private String eWMWarehouse;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>GoodsMovementReasonCode</b>
     * </p>
     *
     * @param goodsMovementReasonCode
     *
     * @return Reason for Movement
     */
    @SerializedName( "GoodsMovementReasonCode" )
    @JsonProperty( "GoodsMovementReasonCode" )
    @Nullable
    @ODataField( odataName = "GoodsMovementReasonCode" )
    private String goodsMovementReasonCode;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>GoodsMovementRefDocType</b>
     * </p>
     *
     * @param goodsMovementRefDocType
     *
     * @return Reference Doc. Type
     */
    @SerializedName( "GoodsMovementRefDocType" )
    @JsonProperty( "GoodsMovementRefDocType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementRefDocType" )
    private String goodsMovementRefDocType;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @param goodsMovementType
     *
     * @return Goods Movement Type
     */
    @SerializedName( "GoodsMovementType" )
    @JsonProperty( "GoodsMovementType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementType" )
    private String goodsMovementType;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @param inventorySpecialStockType
     *
     * @return Special Stock Type
     */
    @SerializedName( "InventorySpecialStockType" )
    @JsonProperty( "InventorySpecialStockType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockType" )
    private String inventorySpecialStockType;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>InventoryUsabilityCode</b>
     * </p>
     *
     * @param inventoryUsabilityCode
     *
     * @return Inventory Usability
     */
    @SerializedName( "InventoryUsabilityCode" )
    @JsonProperty( "InventoryUsabilityCode" )
    @Nullable
    @ODataField( odataName = "InventoryUsabilityCode" )
    private String inventoryUsabilityCode;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @param inventoryValuationType
     *
     * @return Valuation Type
     */
    @SerializedName( "InventoryValuationType" )
    @JsonProperty( "InventoryValuationType" )
    @Nullable
    @ODataField( odataName = "InventoryValuationType" )
    private String inventoryValuationType;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsCompletelyDelivered</b>
     * </p>
     *
     * @param isCompletelyDelivered
     *
     * @return Delivery Completed
     */
    @SerializedName( "IsCompletelyDelivered" )
    @JsonProperty( "IsCompletelyDelivered" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCompletelyDelivered" )
    private Boolean isCompletelyDelivered;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ManufactureDate</b>
     * </p>
     *
     * @param manufactureDate
     *
     * @return Date of Manufacture
     */
    @SerializedName( "ManufactureDate" )
    @JsonProperty( "ManufactureDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ManufactureDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime manufactureDate;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *
     * @return Order Category
     */
    @SerializedName( "ManufacturingOrderCategory" )
    @JsonProperty( "ManufacturingOrderCategory" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderCategory" )
    private String manufacturingOrderCategory;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *
     * @return Material
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *
     * @return Material Document
     */
    @SerializedName( "MaterialDocument" )
    @JsonProperty( "MaterialDocument" )
    @Nullable
    @ODataField( odataName = "MaterialDocument" )
    private String materialDocument;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @param materialDocumentItem
     *
     * @return Material Document Item
     */
    @SerializedName( "MaterialDocumentItem" )
    @JsonProperty( "MaterialDocumentItem" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItem" )
    private String materialDocumentItem;
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocumentItemText</b>
     * </p>
     *
     * @param materialDocumentItemText
     *
     * @return Text
     */
    @SerializedName( "MaterialDocumentItemText" )
    @JsonProperty( "MaterialDocumentItemText" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItemText" )
    private String materialDocumentItemText;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *
     * @return Material Document Year
     */
    @SerializedName( "MaterialDocumentYear" )
    @JsonProperty( "MaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentYear" )
    private String materialDocumentYear;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *
     * @return Manufacturing Order
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>OrderItem</b>
     * </p>
     *
     * @param orderItem
     *
     * @return Order Item
     */
    @SerializedName( "OrderItem" )
    @JsonProperty( "OrderItem" )
    @Nullable
    @ODataField( odataName = "OrderItem" )
    private String orderItem;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @param orderType
     *
     * @return Order Type
     */
    @SerializedName( "OrderType" )
    @JsonProperty( "OrderType" )
    @Nullable
    @ODataField( odataName = "OrderType" )
    private String orderType;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *
     * @return Prodn Supply Area
     */
    @SerializedName( "ProductionSupplyArea" )
    @JsonProperty( "ProductionSupplyArea" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyArea" )
    private String productionSupplyArea;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>QuantityInEntryUnit</b>
     * </p>
     *
     * @param quantityInEntryUnit
     *
     * @return Quantity in Unit of Entry
     */
    @SerializedName( "QuantityInEntryUnit" )
    @JsonProperty( "QuantityInEntryUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInEntryUnit" )
    private BigDecimal quantityInEntryUnit;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *
     * @return Reservation
     */
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>ReservationIsFinallyIssued</b>
     * </p>
     *
     * @param reservationIsFinallyIssued
     *
     * @return Res Final Issue
     */
    @SerializedName( "ReservationIsFinallyIssued" )
    @JsonProperty( "ReservationIsFinallyIssued" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReservationIsFinallyIssued" )
    private Boolean reservationIsFinallyIssued;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *
     * @return Reservation Item
     */
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *
     * @return Sales Order
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *
     * @return Sales Order Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @param shelfLifeExpirationDate
     *
     * @return SLED/BBD
     */
    @SerializedName( "ShelfLifeExpirationDate" )
    @JsonProperty( "ShelfLifeExpirationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ShelfLifeExpirationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime shelfLifeExpirationDate;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @param storageBin
     *
     * @return Storage Bin
     */
    @SerializedName( "StorageBin" )
    @JsonProperty( "StorageBin" )
    @Nullable
    @ODataField( odataName = "StorageBin" )
    private String storageBin;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @param storageType
     *
     * @return Storage Type
     */
    @SerializedName( "StorageType" )
    @JsonProperty( "StorageType" )
    @Nullable
    @ODataField( odataName = "StorageType" )
    private String storageType;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;

    @Nonnull
    @Override
    public Class<AProdnordconfmatldocitem> getType()
    {
        return AProdnordconfmatldocitem.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Batch", getBatch());
        values.put("ConfirmationCount", getConfirmationCount());
        values.put("ConfirmationGroup", getConfirmationGroup());
        values.put("Customer", getCustomer());
        values.put("EntryUnit", getEntryUnit());
        values.put("EntryUnitISOCode", getEntryUnitISOCode());
        values.put("EntryUnitSAPCode", getEntryUnitSAPCode());
        values.put("EWMStorageBin", getEWMStorageBin());
        values.put("EWMWarehouse", getEWMWarehouse());
        values.put("GoodsMovementReasonCode", getGoodsMovementReasonCode());
        values.put("GoodsMovementRefDocType", getGoodsMovementRefDocType());
        values.put("GoodsMovementType", getGoodsMovementType());
        values.put("InventorySpecialStockType", getInventorySpecialStockType());
        values.put("InventoryUsabilityCode", getInventoryUsabilityCode());
        values.put("InventoryValuationType", getInventoryValuationType());
        values.put("IsCompletelyDelivered", getIsCompletelyDelivered());
        values.put("ManufactureDate", getManufactureDate());
        values.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        values.put("Material", getMaterial());
        values.put("MaterialDocument", getMaterialDocument());
        values.put("MaterialDocumentItem", getMaterialDocumentItem());
        values.put("MaterialDocumentItemText", getMaterialDocumentItemText());
        values.put("MaterialDocumentYear", getMaterialDocumentYear());
        values.put("OrderID", getOrderID());
        values.put("OrderItem", getOrderItem());
        values.put("OrderType", getOrderType());
        values.put("Plant", getPlant());
        values.put("ProductionSupplyArea", getProductionSupplyArea());
        values.put("QuantityInEntryUnit", getQuantityInEntryUnit());
        values.put("Reservation", getReservation());
        values.put("ReservationIsFinallyIssued", getReservationIsFinallyIssued());
        values.put("ReservationItem", getReservationItem());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("ShelfLifeExpirationDate", getShelfLifeExpirationDate());
        values.put("StorageBin", getStorageBin());
        values.put("StorageLocation", getStorageLocation());
        values.put("StorageType", getStorageType());
        values.put("Supplier", getSupplier());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("ConfirmationCount") ) {
                final Object value = values.remove("ConfirmationCount");
                if( (value == null) || (!value.equals(getConfirmationCount())) ) {
                    setConfirmationCount(((String) value));
                }
            }
            if( values.containsKey("ConfirmationGroup") ) {
                final Object value = values.remove("ConfirmationGroup");
                if( (value == null) || (!value.equals(getConfirmationGroup())) ) {
                    setConfirmationGroup(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("EntryUnit") ) {
                final Object value = values.remove("EntryUnit");
                if( (value == null) || (!value.equals(getEntryUnit())) ) {
                    setEntryUnit(((String) value));
                }
            }
            if( values.containsKey("EntryUnitISOCode") ) {
                final Object value = values.remove("EntryUnitISOCode");
                if( (value == null) || (!value.equals(getEntryUnitISOCode())) ) {
                    setEntryUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("EntryUnitSAPCode") ) {
                final Object value = values.remove("EntryUnitSAPCode");
                if( (value == null) || (!value.equals(getEntryUnitSAPCode())) ) {
                    setEntryUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("EWMStorageBin") ) {
                final Object value = values.remove("EWMStorageBin");
                if( (value == null) || (!value.equals(getEWMStorageBin())) ) {
                    setEWMStorageBin(((String) value));
                }
            }
            if( values.containsKey("EWMWarehouse") ) {
                final Object value = values.remove("EWMWarehouse");
                if( (value == null) || (!value.equals(getEWMWarehouse())) ) {
                    setEWMWarehouse(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementReasonCode") ) {
                final Object value = values.remove("GoodsMovementReasonCode");
                if( (value == null) || (!value.equals(getGoodsMovementReasonCode())) ) {
                    setGoodsMovementReasonCode(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementRefDocType") ) {
                final Object value = values.remove("GoodsMovementRefDocType");
                if( (value == null) || (!value.equals(getGoodsMovementRefDocType())) ) {
                    setGoodsMovementRefDocType(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementType") ) {
                final Object value = values.remove("GoodsMovementType");
                if( (value == null) || (!value.equals(getGoodsMovementType())) ) {
                    setGoodsMovementType(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockType") ) {
                final Object value = values.remove("InventorySpecialStockType");
                if( (value == null) || (!value.equals(getInventorySpecialStockType())) ) {
                    setInventorySpecialStockType(((String) value));
                }
            }
            if( values.containsKey("InventoryUsabilityCode") ) {
                final Object value = values.remove("InventoryUsabilityCode");
                if( (value == null) || (!value.equals(getInventoryUsabilityCode())) ) {
                    setInventoryUsabilityCode(((String) value));
                }
            }
            if( values.containsKey("InventoryValuationType") ) {
                final Object value = values.remove("InventoryValuationType");
                if( (value == null) || (!value.equals(getInventoryValuationType())) ) {
                    setInventoryValuationType(((String) value));
                }
            }
            if( values.containsKey("IsCompletelyDelivered") ) {
                final Object value = values.remove("IsCompletelyDelivered");
                if( (value == null) || (!value.equals(getIsCompletelyDelivered())) ) {
                    setIsCompletelyDelivered(((Boolean) value));
                }
            }
            if( values.containsKey("ManufactureDate") ) {
                final Object value = values.remove("ManufactureDate");
                if( (value == null) || (!value.equals(getManufactureDate())) ) {
                    setManufactureDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ManufacturingOrderCategory") ) {
                final Object value = values.remove("ManufacturingOrderCategory");
                if( (value == null) || (!value.equals(getManufacturingOrderCategory())) ) {
                    setManufacturingOrderCategory(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialDocument") ) {
                final Object value = values.remove("MaterialDocument");
                if( (value == null) || (!value.equals(getMaterialDocument())) ) {
                    setMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentItem") ) {
                final Object value = values.remove("MaterialDocumentItem");
                if( (value == null) || (!value.equals(getMaterialDocumentItem())) ) {
                    setMaterialDocumentItem(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentItemText") ) {
                final Object value = values.remove("MaterialDocumentItemText");
                if( (value == null) || (!value.equals(getMaterialDocumentItemText())) ) {
                    setMaterialDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentYear") ) {
                final Object value = values.remove("MaterialDocumentYear");
                if( (value == null) || (!value.equals(getMaterialDocumentYear())) ) {
                    setMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("OrderItem") ) {
                final Object value = values.remove("OrderItem");
                if( (value == null) || (!value.equals(getOrderItem())) ) {
                    setOrderItem(((String) value));
                }
            }
            if( values.containsKey("OrderType") ) {
                final Object value = values.remove("OrderType");
                if( (value == null) || (!value.equals(getOrderType())) ) {
                    setOrderType(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ProductionSupplyArea") ) {
                final Object value = values.remove("ProductionSupplyArea");
                if( (value == null) || (!value.equals(getProductionSupplyArea())) ) {
                    setProductionSupplyArea(((String) value));
                }
            }
            if( values.containsKey("QuantityInEntryUnit") ) {
                final Object value = values.remove("QuantityInEntryUnit");
                if( (value == null) || (!value.equals(getQuantityInEntryUnit())) ) {
                    setQuantityInEntryUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ReservationIsFinallyIssued") ) {
                final Object value = values.remove("ReservationIsFinallyIssued");
                if( (value == null) || (!value.equals(getReservationIsFinallyIssued())) ) {
                    setReservationIsFinallyIssued(((Boolean) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("ShelfLifeExpirationDate") ) {
                final Object value = values.remove("ShelfLifeExpirationDate");
                if( (value == null) || (!value.equals(getShelfLifeExpirationDate())) ) {
                    setShelfLifeExpirationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("StorageBin") ) {
                final Object value = values.remove("StorageBin");
                if( (value == null) || (!value.equals(getStorageBin())) ) {
                    setStorageBin(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("StorageType") ) {
                final Object value = values.remove("StorageType");
                if( (value == null) || (!value.equals(getStorageType())) ) {
                    setStorageType(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationCount</b>
     * </p>
     *
     * @param confirmationCount
     *            Order Confirmation
     */
    public void setConfirmationCount( @Nullable final String confirmationCount )
    {
        rememberChangedField("ConfirmationCount", this.confirmationCount);
        this.confirmationCount = confirmationCount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationGroup</b>
     * </p>
     *
     * @param confirmationGroup
     *            Confirmation Group
     */
    public void setConfirmationGroup( @Nullable final String confirmationGroup )
    {
        rememberChangedField("ConfirmationGroup", this.confirmationGroup);
        this.confirmationGroup = confirmationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @param entryUnit
     *            Unit of Entry
     */
    public void setEntryUnit( @Nullable final String entryUnit )
    {
        rememberChangedField("EntryUnit", this.entryUnit);
        this.entryUnit = entryUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>EntryUnitISOCode</b>
     * </p>
     *
     * @param entryUnitISOCode
     *            ISO Code
     */
    public void setEntryUnitISOCode( @Nullable final String entryUnitISOCode )
    {
        rememberChangedField("EntryUnitISOCode", this.entryUnitISOCode);
        this.entryUnitISOCode = entryUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>EntryUnitSAPCode</b>
     * </p>
     *
     * @param entryUnitSAPCode
     *            Internal SAP Code
     */
    public void setEntryUnitSAPCode( @Nullable final String entryUnitSAPCode )
    {
        rememberChangedField("EntryUnitSAPCode", this.entryUnitSAPCode);
        this.entryUnitSAPCode = entryUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>EWMStorageBin</b>
     * </p>
     *
     * @param eWMStorageBin
     *            Storage Bin
     */
    public void setEWMStorageBin( @Nullable final String eWMStorageBin )
    {
        rememberChangedField("EWMStorageBin", this.eWMStorageBin);
        this.eWMStorageBin = eWMStorageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>EWMWarehouse</b>
     * </p>
     *
     * @param eWMWarehouse
     *            Warehouse Number
     */
    public void setEWMWarehouse( @Nullable final String eWMWarehouse )
    {
        rememberChangedField("EWMWarehouse", this.eWMWarehouse);
        this.eWMWarehouse = eWMWarehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>GoodsMovementReasonCode</b>
     * </p>
     *
     * @param goodsMovementReasonCode
     *            Reason for Movement
     */
    public void setGoodsMovementReasonCode( @Nullable final String goodsMovementReasonCode )
    {
        rememberChangedField("GoodsMovementReasonCode", this.goodsMovementReasonCode);
        this.goodsMovementReasonCode = goodsMovementReasonCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>GoodsMovementRefDocType</b>
     * </p>
     *
     * @param goodsMovementRefDocType
     *            Reference Doc. Type
     */
    public void setGoodsMovementRefDocType( @Nullable final String goodsMovementRefDocType )
    {
        rememberChangedField("GoodsMovementRefDocType", this.goodsMovementRefDocType);
        this.goodsMovementRefDocType = goodsMovementRefDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @param goodsMovementType
     *            Goods Movement Type
     */
    public void setGoodsMovementType( @Nullable final String goodsMovementType )
    {
        rememberChangedField("GoodsMovementType", this.goodsMovementType);
        this.goodsMovementType = goodsMovementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @param inventorySpecialStockType
     *            Special Stock Type
     */
    public void setInventorySpecialStockType( @Nullable final String inventorySpecialStockType )
    {
        rememberChangedField("InventorySpecialStockType", this.inventorySpecialStockType);
        this.inventorySpecialStockType = inventorySpecialStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>InventoryUsabilityCode</b>
     * </p>
     *
     * @param inventoryUsabilityCode
     *            Inventory Usability
     */
    public void setInventoryUsabilityCode( @Nullable final String inventoryUsabilityCode )
    {
        rememberChangedField("InventoryUsabilityCode", this.inventoryUsabilityCode);
        this.inventoryUsabilityCode = inventoryUsabilityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @param inventoryValuationType
     *            Valuation Type
     */
    public void setInventoryValuationType( @Nullable final String inventoryValuationType )
    {
        rememberChangedField("InventoryValuationType", this.inventoryValuationType);
        this.inventoryValuationType = inventoryValuationType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsCompletelyDelivered</b>
     * </p>
     *
     * @param isCompletelyDelivered
     *            Delivery Completed
     */
    public void setIsCompletelyDelivered( @Nullable final Boolean isCompletelyDelivered )
    {
        rememberChangedField("IsCompletelyDelivered", this.isCompletelyDelivered);
        this.isCompletelyDelivered = isCompletelyDelivered;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ManufactureDate</b>
     * </p>
     *
     * @param manufactureDate
     *            Date of Manufacture
     */
    public void setManufactureDate( @Nullable final LocalDateTime manufactureDate )
    {
        rememberChangedField("ManufactureDate", this.manufactureDate);
        this.manufactureDate = manufactureDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *            Order Category
     */
    public void setManufacturingOrderCategory( @Nullable final String manufacturingOrderCategory )
    {
        rememberChangedField("ManufacturingOrderCategory", this.manufacturingOrderCategory);
        this.manufacturingOrderCategory = manufacturingOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *            Material Document
     */
    public void setMaterialDocument( @Nullable final String materialDocument )
    {
        rememberChangedField("MaterialDocument", this.materialDocument);
        this.materialDocument = materialDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @param materialDocumentItem
     *            Material Document Item
     */
    public void setMaterialDocumentItem( @Nullable final String materialDocumentItem )
    {
        rememberChangedField("MaterialDocumentItem", this.materialDocumentItem);
        this.materialDocumentItem = materialDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocumentItemText</b>
     * </p>
     *
     * @param materialDocumentItemText
     *            Text
     */
    public void setMaterialDocumentItemText( @Nullable final String materialDocumentItemText )
    {
        rememberChangedField("MaterialDocumentItemText", this.materialDocumentItemText);
        this.materialDocumentItemText = materialDocumentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *            Material Document Year
     */
    public void setMaterialDocumentYear( @Nullable final String materialDocumentYear )
    {
        rememberChangedField("MaterialDocumentYear", this.materialDocumentYear);
        this.materialDocumentYear = materialDocumentYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Manufacturing Order
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>OrderItem</b>
     * </p>
     *
     * @param orderItem
     *            Order Item
     */
    public void setOrderItem( @Nullable final String orderItem )
    {
        rememberChangedField("OrderItem", this.orderItem);
        this.orderItem = orderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @param orderType
     *            Order Type
     */
    public void setOrderType( @Nullable final String orderType )
    {
        rememberChangedField("OrderType", this.orderType);
        this.orderType = orderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *            Prodn Supply Area
     */
    public void setProductionSupplyArea( @Nullable final String productionSupplyArea )
    {
        rememberChangedField("ProductionSupplyArea", this.productionSupplyArea);
        this.productionSupplyArea = productionSupplyArea;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>QuantityInEntryUnit</b>
     * </p>
     *
     * @param quantityInEntryUnit
     *            Quantity in Unit of Entry
     */
    public void setQuantityInEntryUnit( @Nullable final BigDecimal quantityInEntryUnit )
    {
        rememberChangedField("QuantityInEntryUnit", this.quantityInEntryUnit);
        this.quantityInEntryUnit = quantityInEntryUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Reservation
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>ReservationIsFinallyIssued</b>
     * </p>
     *
     * @param reservationIsFinallyIssued
     *            Res Final Issue
     */
    public void setReservationIsFinallyIssued( @Nullable final Boolean reservationIsFinallyIssued )
    {
        rememberChangedField("ReservationIsFinallyIssued", this.reservationIsFinallyIssued);
        this.reservationIsFinallyIssued = reservationIsFinallyIssued;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Reservation Item
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @param shelfLifeExpirationDate
     *            SLED/BBD
     */
    public void setShelfLifeExpirationDate( @Nullable final LocalDateTime shelfLifeExpirationDate )
    {
        rememberChangedField("ShelfLifeExpirationDate", this.shelfLifeExpirationDate);
        this.shelfLifeExpirationDate = shelfLifeExpirationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @param storageBin
     *            Storage Bin
     */
    public void setStorageBin( @Nullable final String storageBin )
    {
        rememberChangedField("StorageBin", this.storageBin);
        this.storageBin = storageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @param storageType
     *            Storage Type
     */
    public void setStorageType( @Nullable final String storageType )
    {
        rememberChangedField("StorageType", this.storageType);
        this.storageType = storageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            WBS Element
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

}
