/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.field.ProdnOrdConfMatlDocItmField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.link.ProdnOrdConfMatlDocItmLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.selectable.ProdnOrdConfMatlDocItmSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Material Movements for Confirmation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProdnOrdConfMatlDocItmType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProdnOrdConfMatlDocItm extends VdmEntity<ProdnOrdConfMatlDocItm>
{

    /**
     * Selector for all available fields of ProdnOrdConfMatlDocItm.
     *
     */
    public final static ProdnOrdConfMatlDocItmSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationGroup</b>
     * </p>
     *
     * @return Collective ID of Order Confirmations
     */
    @Key
    @SerializedName( "ConfirmationGroup" )
    @JsonProperty( "ConfirmationGroup" )
    @Nullable
    @ODataField( odataName = "ConfirmationGroup" )
    private String confirmationGroup;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationGroup</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> CONFIRMATION_GROUP =
        new ProdnOrdConfMatlDocItmField<String>("ConfirmationGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationCount</b>
     * </p>
     *
     * @return Identifier of Single Order Confirmation
     */
    @Key
    @SerializedName( "ConfirmationCount" )
    @JsonProperty( "ConfirmationCount" )
    @Nullable
    @ODataField( odataName = "ConfirmationCount" )
    private String confirmationCount;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationCount</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> CONFIRMATION_COUNT =
        new ProdnOrdConfMatlDocItmField<String>("ConfirmationCount");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @return Number of Material Document
     */
    @Key
    @SerializedName( "MaterialDocument" )
    @JsonProperty( "MaterialDocument" )
    @Nullable
    @ODataField( odataName = "MaterialDocument" )
    private String materialDocument;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocument</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> MATERIAL_DOCUMENT =
        new ProdnOrdConfMatlDocItmField<String>("MaterialDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @return Material Document Item
     */
    @Key
    @SerializedName( "MaterialDocumentItem" )
    @JsonProperty( "MaterialDocumentItem" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItem" )
    private String materialDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentItem</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> MATERIAL_DOCUMENT_ITEM =
        new ProdnOrdConfMatlDocItmField<String>("MaterialDocumentItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @return Material Document Year
     */
    @Key
    @SerializedName( "MaterialDocumentYear" )
    @JsonProperty( "MaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentYear" )
    private String materialDocumentYear;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentYear</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> MATERIAL_DOCUMENT_YEAR =
        new ProdnOrdConfMatlDocItmField<String>("MaterialDocumentYear");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @return Manufacturing Order Type
     */
    @SerializedName( "OrderType" )
    @JsonProperty( "OrderType" )
    @Nullable
    @ODataField( odataName = "OrderType" )
    private String orderType;
    /**
     * Use with available fluent helpers to apply the <b>OrderType</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> ORDER_TYPE =
        new ProdnOrdConfMatlDocItmField<String>("OrderType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Manufacturing Order ID
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> ORDER_ID =
        new ProdnOrdConfMatlDocItmField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderItem</b>
     * </p>
     *
     * @return Order Item
     */
    @SerializedName( "OrderItem" )
    @JsonProperty( "OrderItem" )
    @Nullable
    @ODataField( odataName = "OrderItem" )
    private String orderItem;
    /**
     * Use with available fluent helpers to apply the <b>OrderItem</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> ORDER_ITEM =
        new ProdnOrdConfMatlDocItmField<String>("OrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @return Manufacturing Order Category
     */
    @SerializedName( "ManufacturingOrderCategory" )
    @JsonProperty( "ManufacturingOrderCategory" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderCategory" )
    private String manufacturingOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderCategory</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> MANUFACTURING_ORDER_CATEGORY =
        new ProdnOrdConfMatlDocItmField<String>("ManufacturingOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number for Order
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> MATERIAL =
        new ProdnOrdConfMatlDocItmField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> PLANT = new ProdnOrdConfMatlDocItmField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> RESERVATION =
        new ProdnOrdConfMatlDocItmField<String>("Reservation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Item Number of Reservation / Dependent Requirements
     */
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> RESERVATION_ITEM =
        new ProdnOrdConfMatlDocItmField<String>("ReservationItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> STORAGE_LOCATION =
        new ProdnOrdConfMatlDocItmField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @return Production Supply Area
     */
    @SerializedName( "ProductionSupplyArea" )
    @JsonProperty( "ProductionSupplyArea" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyArea" )
    private String productionSupplyArea;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupplyArea</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> PRODUCTION_SUPPLY_AREA =
        new ProdnOrdConfMatlDocItmField<String>("ProductionSupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> BATCH = new ProdnOrdConfMatlDocItmField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @return Inventory Valuation Type
     */
    @SerializedName( "InventoryValuationType" )
    @JsonProperty( "InventoryValuationType" )
    @Nullable
    @ODataField( odataName = "InventoryValuationType" )
    private String inventoryValuationType;
    /**
     * Use with available fluent helpers to apply the <b>InventoryValuationType</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> INVENTORY_VALUATION_TYPE =
        new ProdnOrdConfMatlDocItmField<String>("InventoryValuationType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @return Goods Movement Type
     */
    @SerializedName( "GoodsMovementType" )
    @JsonProperty( "GoodsMovementType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementType" )
    private String goodsMovementType;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementType</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> GOODS_MOVEMENT_TYPE =
        new ProdnOrdConfMatlDocItmField<String>("GoodsMovementType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementReasonCode</b>
     * </p>
     *
     * @return Reason for Movement
     */
    @SerializedName( "GoodsMovementReasonCode" )
    @JsonProperty( "GoodsMovementReasonCode" )
    @Nullable
    @ODataField( odataName = "GoodsMovementReasonCode" )
    private String goodsMovementReasonCode;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementReasonCode</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> GOODS_MOVEMENT_REASON_CODE =
        new ProdnOrdConfMatlDocItmField<String>("GoodsMovementReasonCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementRefDocType</b>
     * </p>
     *
     * @return Goods movement ref doc type
     */
    @SerializedName( "GoodsMovementRefDocType" )
    @JsonProperty( "GoodsMovementRefDocType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementRefDocType" )
    private String goodsMovementRefDocType;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementRefDocType</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> GOODS_MOVEMENT_REF_DOC_TYPE =
        new ProdnOrdConfMatlDocItmField<String>("GoodsMovementRefDocType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventoryUsabilityCode</b>
     * </p>
     *
     * @return Inventory Usability Code
     */
    @SerializedName( "InventoryUsabilityCode" )
    @JsonProperty( "InventoryUsabilityCode" )
    @Nullable
    @ODataField( odataName = "InventoryUsabilityCode" )
    private String inventoryUsabilityCode;
    /**
     * Use with available fluent helpers to apply the <b>InventoryUsabilityCode</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> INVENTORY_USABILITY_CODE =
        new ProdnOrdConfMatlDocItmField<String>("InventoryUsabilityCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @return Inventory Special Stock Type
     */
    @SerializedName( "InventorySpecialStockType" )
    @JsonProperty( "InventorySpecialStockType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockType" )
    private String inventorySpecialStockType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockType</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> INVENTORY_SPECIAL_STOCK_TYPE =
        new ProdnOrdConfMatlDocItmField<String>("InventorySpecialStockType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> SALES_ORDER =
        new ProdnOrdConfMatlDocItmField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> SALES_ORDER_ITEM =
        new ProdnOrdConfMatlDocItmField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> WBS_ELEMENT_EXTERNAL_ID =
        new ProdnOrdConfMatlDocItmField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> SUPPLIER =
        new ProdnOrdConfMatlDocItmField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Account number of customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> CUSTOMER =
        new ProdnOrdConfMatlDocItmField<String>("Customer");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationIsFinallyIssued</b>
     * </p>
     *
     * @return Final Issue for Reservation
     */
    @SerializedName( "ReservationIsFinallyIssued" )
    @JsonProperty( "ReservationIsFinallyIssued" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReservationIsFinallyIssued" )
    private Boolean reservationIsFinallyIssued;
    /**
     * Use with available fluent helpers to apply the <b>ReservationIsFinallyIssued</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<Boolean> RESERVATION_IS_FINALLY_ISSUED =
        new ProdnOrdConfMatlDocItmField<Boolean>("ReservationIsFinallyIssued");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCompletelyDelivered</b>
     * </p>
     *
     * @return "Delivery Completed" Indicator
     */
    @SerializedName( "IsCompletelyDelivered" )
    @JsonProperty( "IsCompletelyDelivered" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCompletelyDelivered" )
    private Boolean isCompletelyDelivered;
    /**
     * Use with available fluent helpers to apply the <b>IsCompletelyDelivered</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<Boolean> IS_COMPLETELY_DELIVERED =
        new ProdnOrdConfMatlDocItmField<Boolean>("IsCompletelyDelivered");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @return Shelf Life Expiration or Best-Before Date
     */
    @SerializedName( "ShelfLifeExpirationDate" )
    @JsonProperty( "ShelfLifeExpirationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ShelfLifeExpirationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime shelfLifeExpirationDate;
    /**
     * Use with available fluent helpers to apply the <b>ShelfLifeExpirationDate</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<LocalDateTime> SHELF_LIFE_EXPIRATION_DATE =
        new ProdnOrdConfMatlDocItmField<LocalDateTime>("ShelfLifeExpirationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ManufactureDate</b>
     * </p>
     *
     * @return Date of Manufacture
     */
    @SerializedName( "ManufactureDate" )
    @JsonProperty( "ManufactureDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ManufactureDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime manufactureDate;
    /**
     * Use with available fluent helpers to apply the <b>ManufactureDate</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<LocalDateTime> MANUFACTURE_DATE =
        new ProdnOrdConfMatlDocItmField<LocalDateTime>("ManufactureDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @return Storage Type
     */
    @SerializedName( "StorageType" )
    @JsonProperty( "StorageType" )
    @Nullable
    @ODataField( odataName = "StorageType" )
    private String storageType;
    /**
     * Use with available fluent helpers to apply the <b>StorageType</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> STORAGE_TYPE =
        new ProdnOrdConfMatlDocItmField<String>("StorageType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @return Storage Bin
     */
    @SerializedName( "StorageBin" )
    @JsonProperty( "StorageBin" )
    @Nullable
    @ODataField( odataName = "StorageBin" )
    private String storageBin;
    /**
     * Use with available fluent helpers to apply the <b>StorageBin</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> STORAGE_BIN =
        new ProdnOrdConfMatlDocItmField<String>("StorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EWMWarehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @SerializedName( "EWMWarehouse" )
    @JsonProperty( "EWMWarehouse" )
    @Nullable
    @ODataField( odataName = "EWMWarehouse" )
    private String eWMWarehouse;
    /**
     * Use with available fluent helpers to apply the <b>EWMWarehouse</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> EWM_WAREHOUSE =
        new ProdnOrdConfMatlDocItmField<String>("EWMWarehouse");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBin</b>
     * </p>
     *
     * @return Storage Bin
     */
    @SerializedName( "EWMStorageBin" )
    @JsonProperty( "EWMStorageBin" )
    @Nullable
    @ODataField( odataName = "EWMStorageBin" )
    private String eWMStorageBin;
    /**
     * Use with available fluent helpers to apply the <b>EWMStorageBin</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> EWM_STORAGE_BIN =
        new ProdnOrdConfMatlDocItmField<String>("EWMStorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "MaterialDocumentItemText" )
    @JsonProperty( "MaterialDocumentItemText" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItemText" )
    private String materialDocumentItemText;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentItemText</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> MATERIAL_DOCUMENT_ITEM_TEXT =
        new ProdnOrdConfMatlDocItmField<String>("MaterialDocumentItemText");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @return Unit of entry
     */
    @SerializedName( "EntryUnit" )
    @JsonProperty( "EntryUnit" )
    @Nullable
    @ODataField( odataName = "EntryUnit" )
    private String entryUnit;
    /**
     * Use with available fluent helpers to apply the <b>EntryUnit</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> ENTRY_UNIT =
        new ProdnOrdConfMatlDocItmField<String>("EntryUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "EntryUnitISOCode" )
    @JsonProperty( "EntryUnitISOCode" )
    @Nullable
    @ODataField( odataName = "EntryUnitISOCode" )
    private String entryUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>EntryUnitISOCode</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> ENTRY_UNIT_ISO_CODE =
        new ProdnOrdConfMatlDocItmField<String>("EntryUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "EntryUnitSAPCode" )
    @JsonProperty( "EntryUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "EntryUnitSAPCode" )
    private String entryUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>EntryUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<String> ENTRY_UNIT_SAP_CODE =
        new ProdnOrdConfMatlDocItmField<String>("EntryUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInEntryUnit</b>
     * </p>
     *
     * @return Quantity in Unit of Entry
     */
    @SerializedName( "QuantityInEntryUnit" )
    @JsonProperty( "QuantityInEntryUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInEntryUnit" )
    private BigDecimal quantityInEntryUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInEntryUnit</b> field to query operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmField<BigDecimal> QUANTITY_IN_ENTRY_UNIT =
        new ProdnOrdConfMatlDocItmField<BigDecimal>("QuantityInEntryUnit");
    /**
     * Navigation property <b>to_ProdnOrderConfBatchCharc</b> for <b>ProdnOrdConfMatlDocItm</b> to multiple
     * <b>ProdnOrderConfBatchCharc</b>.
     *
     */
    @SerializedName( "to_ProdnOrderConfBatchCharc" )
    @JsonProperty( "to_ProdnOrderConfBatchCharc" )
    @ODataField( odataName = "to_ProdnOrderConfBatchCharc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProdnOrderConfBatchCharc> toProdnOrderConfBatchCharc;
    /**
     * Use with available fluent helpers to apply the <b>to_ProdnOrderConfBatchCharc</b> navigation property to query
     * operations.
     *
     */
    public final static ProdnOrdConfMatlDocItmLink<ProdnOrderConfBatchCharc> TO_PRODN_ORDER_CONF_BATCH_CHARC =
        new ProdnOrdConfMatlDocItmLink<ProdnOrderConfBatchCharc>("to_ProdnOrderConfBatchCharc");

    @Nonnull
    @Override
    public Class<ProdnOrdConfMatlDocItm> getType()
    {
        return ProdnOrdConfMatlDocItm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationGroup</b>
     * </p>
     *
     * @param confirmationGroup
     *            Collective ID of Order Confirmations
     */
    public void setConfirmationGroup( @Nullable final String confirmationGroup )
    {
        rememberChangedField("ConfirmationGroup", this.confirmationGroup);
        this.confirmationGroup = confirmationGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationCount</b>
     * </p>
     *
     * @param confirmationCount
     *            Identifier of Single Order Confirmation
     */
    public void setConfirmationCount( @Nullable final String confirmationCount )
    {
        rememberChangedField("ConfirmationCount", this.confirmationCount);
        this.confirmationCount = confirmationCount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *            Number of Material Document
     */
    public void setMaterialDocument( @Nullable final String materialDocument )
    {
        rememberChangedField("MaterialDocument", this.materialDocument);
        this.materialDocument = materialDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @param materialDocumentItem
     *            Material Document Item
     */
    public void setMaterialDocumentItem( @Nullable final String materialDocumentItem )
    {
        rememberChangedField("MaterialDocumentItem", this.materialDocumentItem);
        this.materialDocumentItem = materialDocumentItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *            Material Document Year
     */
    public void setMaterialDocumentYear( @Nullable final String materialDocumentYear )
    {
        rememberChangedField("MaterialDocumentYear", this.materialDocumentYear);
        this.materialDocumentYear = materialDocumentYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @param orderType
     *            Manufacturing Order Type
     */
    public void setOrderType( @Nullable final String orderType )
    {
        rememberChangedField("OrderType", this.orderType);
        this.orderType = orderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Manufacturing Order ID
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderItem</b>
     * </p>
     *
     * @param orderItem
     *            Order Item
     */
    public void setOrderItem( @Nullable final String orderItem )
    {
        rememberChangedField("OrderItem", this.orderItem);
        this.orderItem = orderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     */
    public void setManufacturingOrderCategory( @Nullable final String manufacturingOrderCategory )
    {
        rememberChangedField("ManufacturingOrderCategory", this.manufacturingOrderCategory);
        this.manufacturingOrderCategory = manufacturingOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number for Order
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Item Number of Reservation / Dependent Requirements
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *            Production Supply Area
     */
    public void setProductionSupplyArea( @Nullable final String productionSupplyArea )
    {
        rememberChangedField("ProductionSupplyArea", this.productionSupplyArea);
        this.productionSupplyArea = productionSupplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @param inventoryValuationType
     *            Inventory Valuation Type
     */
    public void setInventoryValuationType( @Nullable final String inventoryValuationType )
    {
        rememberChangedField("InventoryValuationType", this.inventoryValuationType);
        this.inventoryValuationType = inventoryValuationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @param goodsMovementType
     *            Goods Movement Type
     */
    public void setGoodsMovementType( @Nullable final String goodsMovementType )
    {
        rememberChangedField("GoodsMovementType", this.goodsMovementType);
        this.goodsMovementType = goodsMovementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementReasonCode</b>
     * </p>
     *
     * @param goodsMovementReasonCode
     *            Reason for Movement
     */
    public void setGoodsMovementReasonCode( @Nullable final String goodsMovementReasonCode )
    {
        rememberChangedField("GoodsMovementReasonCode", this.goodsMovementReasonCode);
        this.goodsMovementReasonCode = goodsMovementReasonCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementRefDocType</b>
     * </p>
     *
     * @param goodsMovementRefDocType
     *            Goods movement ref doc type
     */
    public void setGoodsMovementRefDocType( @Nullable final String goodsMovementRefDocType )
    {
        rememberChangedField("GoodsMovementRefDocType", this.goodsMovementRefDocType);
        this.goodsMovementRefDocType = goodsMovementRefDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventoryUsabilityCode</b>
     * </p>
     *
     * @param inventoryUsabilityCode
     *            Inventory Usability Code
     */
    public void setInventoryUsabilityCode( @Nullable final String inventoryUsabilityCode )
    {
        rememberChangedField("InventoryUsabilityCode", this.inventoryUsabilityCode);
        this.inventoryUsabilityCode = inventoryUsabilityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @param inventorySpecialStockType
     *            Inventory Special Stock Type
     */
    public void setInventorySpecialStockType( @Nullable final String inventorySpecialStockType )
    {
        rememberChangedField("InventorySpecialStockType", this.inventorySpecialStockType);
        this.inventorySpecialStockType = inventorySpecialStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Account number of customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationIsFinallyIssued</b>
     * </p>
     *
     * @param reservationIsFinallyIssued
     *            Final Issue for Reservation
     */
    public void setReservationIsFinallyIssued( @Nullable final Boolean reservationIsFinallyIssued )
    {
        rememberChangedField("ReservationIsFinallyIssued", this.reservationIsFinallyIssued);
        this.reservationIsFinallyIssued = reservationIsFinallyIssued;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCompletelyDelivered</b>
     * </p>
     *
     * @param isCompletelyDelivered
     *            "Delivery Completed" Indicator
     */
    public void setIsCompletelyDelivered( @Nullable final Boolean isCompletelyDelivered )
    {
        rememberChangedField("IsCompletelyDelivered", this.isCompletelyDelivered);
        this.isCompletelyDelivered = isCompletelyDelivered;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @param shelfLifeExpirationDate
     *            Shelf Life Expiration or Best-Before Date
     */
    public void setShelfLifeExpirationDate( @Nullable final LocalDateTime shelfLifeExpirationDate )
    {
        rememberChangedField("ShelfLifeExpirationDate", this.shelfLifeExpirationDate);
        this.shelfLifeExpirationDate = shelfLifeExpirationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ManufactureDate</b>
     * </p>
     *
     * @param manufactureDate
     *            Date of Manufacture
     */
    public void setManufactureDate( @Nullable final LocalDateTime manufactureDate )
    {
        rememberChangedField("ManufactureDate", this.manufactureDate);
        this.manufactureDate = manufactureDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @param storageType
     *            Storage Type
     */
    public void setStorageType( @Nullable final String storageType )
    {
        rememberChangedField("StorageType", this.storageType);
        this.storageType = storageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @param storageBin
     *            Storage Bin
     */
    public void setStorageBin( @Nullable final String storageBin )
    {
        rememberChangedField("StorageBin", this.storageBin);
        this.storageBin = storageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EWMWarehouse</b>
     * </p>
     *
     * @param eWMWarehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setEWMWarehouse( @Nullable final String eWMWarehouse )
    {
        rememberChangedField("EWMWarehouse", this.eWMWarehouse);
        this.eWMWarehouse = eWMWarehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBin</b>
     * </p>
     *
     * @param eWMStorageBin
     *            Storage Bin
     */
    public void setEWMStorageBin( @Nullable final String eWMStorageBin )
    {
        rememberChangedField("EWMStorageBin", this.eWMStorageBin);
        this.eWMStorageBin = eWMStorageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItemText</b>
     * </p>
     *
     * @param materialDocumentItemText
     *            Item Text
     */
    public void setMaterialDocumentItemText( @Nullable final String materialDocumentItemText )
    {
        rememberChangedField("MaterialDocumentItemText", this.materialDocumentItemText);
        this.materialDocumentItemText = materialDocumentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @param entryUnit
     *            Unit of entry
     */
    public void setEntryUnit( @Nullable final String entryUnit )
    {
        rememberChangedField("EntryUnit", this.entryUnit);
        this.entryUnit = entryUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnitISOCode</b>
     * </p>
     *
     * @param entryUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setEntryUnitISOCode( @Nullable final String entryUnitISOCode )
    {
        rememberChangedField("EntryUnitISOCode", this.entryUnitISOCode);
        this.entryUnitISOCode = entryUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnitSAPCode</b>
     * </p>
     *
     * @param entryUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setEntryUnitSAPCode( @Nullable final String entryUnitSAPCode )
    {
        rememberChangedField("EntryUnitSAPCode", this.entryUnitSAPCode);
        this.entryUnitSAPCode = entryUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInEntryUnit</b>
     * </p>
     *
     * @param quantityInEntryUnit
     *            Quantity in Unit of Entry
     */
    public void setQuantityInEntryUnit( @Nullable final BigDecimal quantityInEntryUnit )
    {
        rememberChangedField("QuantityInEntryUnit", this.quantityInEntryUnit);
        this.quantityInEntryUnit = quantityInEntryUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProdnOrdConfMatlDocItm";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConfirmationGroup", getConfirmationGroup());
        result.put("ConfirmationCount", getConfirmationCount());
        result.put("MaterialDocument", getMaterialDocument());
        result.put("MaterialDocumentItem", getMaterialDocumentItem());
        result.put("MaterialDocumentYear", getMaterialDocumentYear());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConfirmationGroup", getConfirmationGroup());
        values.put("ConfirmationCount", getConfirmationCount());
        values.put("MaterialDocument", getMaterialDocument());
        values.put("MaterialDocumentItem", getMaterialDocumentItem());
        values.put("MaterialDocumentYear", getMaterialDocumentYear());
        values.put("OrderType", getOrderType());
        values.put("OrderID", getOrderID());
        values.put("OrderItem", getOrderItem());
        values.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("Reservation", getReservation());
        values.put("ReservationItem", getReservationItem());
        values.put("StorageLocation", getStorageLocation());
        values.put("ProductionSupplyArea", getProductionSupplyArea());
        values.put("Batch", getBatch());
        values.put("InventoryValuationType", getInventoryValuationType());
        values.put("GoodsMovementType", getGoodsMovementType());
        values.put("GoodsMovementReasonCode", getGoodsMovementReasonCode());
        values.put("GoodsMovementRefDocType", getGoodsMovementRefDocType());
        values.put("InventoryUsabilityCode", getInventoryUsabilityCode());
        values.put("InventorySpecialStockType", getInventorySpecialStockType());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("Supplier", getSupplier());
        values.put("Customer", getCustomer());
        values.put("ReservationIsFinallyIssued", getReservationIsFinallyIssued());
        values.put("IsCompletelyDelivered", getIsCompletelyDelivered());
        values.put("ShelfLifeExpirationDate", getShelfLifeExpirationDate());
        values.put("ManufactureDate", getManufactureDate());
        values.put("StorageType", getStorageType());
        values.put("StorageBin", getStorageBin());
        values.put("EWMWarehouse", getEWMWarehouse());
        values.put("EWMStorageBin", getEWMStorageBin());
        values.put("MaterialDocumentItemText", getMaterialDocumentItemText());
        values.put("EntryUnit", getEntryUnit());
        values.put("EntryUnitISOCode", getEntryUnitISOCode());
        values.put("EntryUnitSAPCode", getEntryUnitSAPCode());
        values.put("QuantityInEntryUnit", getQuantityInEntryUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConfirmationGroup") ) {
                final Object value = values.remove("ConfirmationGroup");
                if( (value == null) || (!value.equals(getConfirmationGroup())) ) {
                    setConfirmationGroup(((String) value));
                }
            }
            if( values.containsKey("ConfirmationCount") ) {
                final Object value = values.remove("ConfirmationCount");
                if( (value == null) || (!value.equals(getConfirmationCount())) ) {
                    setConfirmationCount(((String) value));
                }
            }
            if( values.containsKey("MaterialDocument") ) {
                final Object value = values.remove("MaterialDocument");
                if( (value == null) || (!value.equals(getMaterialDocument())) ) {
                    setMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentItem") ) {
                final Object value = values.remove("MaterialDocumentItem");
                if( (value == null) || (!value.equals(getMaterialDocumentItem())) ) {
                    setMaterialDocumentItem(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentYear") ) {
                final Object value = values.remove("MaterialDocumentYear");
                if( (value == null) || (!value.equals(getMaterialDocumentYear())) ) {
                    setMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("OrderType") ) {
                final Object value = values.remove("OrderType");
                if( (value == null) || (!value.equals(getOrderType())) ) {
                    setOrderType(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("OrderItem") ) {
                final Object value = values.remove("OrderItem");
                if( (value == null) || (!value.equals(getOrderItem())) ) {
                    setOrderItem(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderCategory") ) {
                final Object value = values.remove("ManufacturingOrderCategory");
                if( (value == null) || (!value.equals(getManufacturingOrderCategory())) ) {
                    setManufacturingOrderCategory(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("ProductionSupplyArea") ) {
                final Object value = values.remove("ProductionSupplyArea");
                if( (value == null) || (!value.equals(getProductionSupplyArea())) ) {
                    setProductionSupplyArea(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("InventoryValuationType") ) {
                final Object value = values.remove("InventoryValuationType");
                if( (value == null) || (!value.equals(getInventoryValuationType())) ) {
                    setInventoryValuationType(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementType") ) {
                final Object value = values.remove("GoodsMovementType");
                if( (value == null) || (!value.equals(getGoodsMovementType())) ) {
                    setGoodsMovementType(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementReasonCode") ) {
                final Object value = values.remove("GoodsMovementReasonCode");
                if( (value == null) || (!value.equals(getGoodsMovementReasonCode())) ) {
                    setGoodsMovementReasonCode(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementRefDocType") ) {
                final Object value = values.remove("GoodsMovementRefDocType");
                if( (value == null) || (!value.equals(getGoodsMovementRefDocType())) ) {
                    setGoodsMovementRefDocType(((String) value));
                }
            }
            if( values.containsKey("InventoryUsabilityCode") ) {
                final Object value = values.remove("InventoryUsabilityCode");
                if( (value == null) || (!value.equals(getInventoryUsabilityCode())) ) {
                    setInventoryUsabilityCode(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockType") ) {
                final Object value = values.remove("InventorySpecialStockType");
                if( (value == null) || (!value.equals(getInventorySpecialStockType())) ) {
                    setInventorySpecialStockType(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("ReservationIsFinallyIssued") ) {
                final Object value = values.remove("ReservationIsFinallyIssued");
                if( (value == null) || (!value.equals(getReservationIsFinallyIssued())) ) {
                    setReservationIsFinallyIssued(((Boolean) value));
                }
            }
            if( values.containsKey("IsCompletelyDelivered") ) {
                final Object value = values.remove("IsCompletelyDelivered");
                if( (value == null) || (!value.equals(getIsCompletelyDelivered())) ) {
                    setIsCompletelyDelivered(((Boolean) value));
                }
            }
            if( values.containsKey("ShelfLifeExpirationDate") ) {
                final Object value = values.remove("ShelfLifeExpirationDate");
                if( (value == null) || (!value.equals(getShelfLifeExpirationDate())) ) {
                    setShelfLifeExpirationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ManufactureDate") ) {
                final Object value = values.remove("ManufactureDate");
                if( (value == null) || (!value.equals(getManufactureDate())) ) {
                    setManufactureDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("StorageType") ) {
                final Object value = values.remove("StorageType");
                if( (value == null) || (!value.equals(getStorageType())) ) {
                    setStorageType(((String) value));
                }
            }
            if( values.containsKey("StorageBin") ) {
                final Object value = values.remove("StorageBin");
                if( (value == null) || (!value.equals(getStorageBin())) ) {
                    setStorageBin(((String) value));
                }
            }
            if( values.containsKey("EWMWarehouse") ) {
                final Object value = values.remove("EWMWarehouse");
                if( (value == null) || (!value.equals(getEWMWarehouse())) ) {
                    setEWMWarehouse(((String) value));
                }
            }
            if( values.containsKey("EWMStorageBin") ) {
                final Object value = values.remove("EWMStorageBin");
                if( (value == null) || (!value.equals(getEWMStorageBin())) ) {
                    setEWMStorageBin(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentItemText") ) {
                final Object value = values.remove("MaterialDocumentItemText");
                if( (value == null) || (!value.equals(getMaterialDocumentItemText())) ) {
                    setMaterialDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("EntryUnit") ) {
                final Object value = values.remove("EntryUnit");
                if( (value == null) || (!value.equals(getEntryUnit())) ) {
                    setEntryUnit(((String) value));
                }
            }
            if( values.containsKey("EntryUnitISOCode") ) {
                final Object value = values.remove("EntryUnitISOCode");
                if( (value == null) || (!value.equals(getEntryUnitISOCode())) ) {
                    setEntryUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("EntryUnitSAPCode") ) {
                final Object value = values.remove("EntryUnitSAPCode");
                if( (value == null) || (!value.equals(getEntryUnitSAPCode())) ) {
                    setEntryUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("QuantityInEntryUnit") ) {
                final Object value = values.remove("QuantityInEntryUnit");
                if( (value == null) || (!value.equals(getQuantityInEntryUnit())) ) {
                    setQuantityInEntryUnit(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProdnOrderConfBatchCharc") ) {
                final Object value = (values).remove("to_ProdnOrderConfBatchCharc");
                if( value instanceof Iterable ) {
                    if( toProdnOrderConfBatchCharc == null ) {
                        toProdnOrderConfBatchCharc = Lists.newArrayList();
                    } else {
                        toProdnOrderConfBatchCharc = Lists.newArrayList(toProdnOrderConfBatchCharc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProdnOrderConfBatchCharc entity;
                        if( toProdnOrderConfBatchCharc.size() > i ) {
                            entity = toProdnOrderConfBatchCharc.get(i);
                        } else {
                            entity = new ProdnOrderConfBatchCharc();
                            toProdnOrderConfBatchCharc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProdnOrdConfMatlDocItmField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProdnOrdConfMatlDocItmField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProdnOrdConfMatlDocItmField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProdnOrdConfMatlDocItmField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderConfirmationV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProdnOrderConfBatchCharc != null ) {
            (values).put("to_ProdnOrderConfBatchCharc", toProdnOrderConfBatchCharc);
        }
        return values;
    }

    /**
     * Fetches the <b>ProdnOrderConfBatchCharc</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ProdnOrderConfBatchCharc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProdnOrderConfBatchCharc</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdnOrderConfBatchCharc> fetchProdnOrderConfBatchCharc()
    {
        return fetchFieldAsList("to_ProdnOrderConfBatchCharc", ProdnOrderConfBatchCharc.class);
    }

    /**
     * Retrieval of associated <b>ProdnOrderConfBatchCharc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdnOrderConfBatchCharc</b>.
     * <p>
     * If the navigation property <b>to_ProdnOrderConfBatchCharc</b> of a queried <b>ProdnOrdConfMatlDocItm</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdnOrderConfBatchCharc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdnOrderConfBatchCharc> getProdnOrderConfBatchCharcOrFetch()
    {
        if( toProdnOrderConfBatchCharc == null ) {
            toProdnOrderConfBatchCharc = fetchProdnOrderConfBatchCharc();
        }
        return toProdnOrderConfBatchCharc;
    }

    /**
     * Retrieval of associated <b>ProdnOrderConfBatchCharc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdnOrderConfBatchCharc</b>.
     * <p>
     * If the navigation property for an entity <b>ProdnOrdConfMatlDocItm</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdnOrderConfBatchCharc</b> is already loaded, the
     *         result will contain the <b>ProdnOrderConfBatchCharc</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProdnOrderConfBatchCharc>> getProdnOrderConfBatchCharcIfPresent()
    {
        return Option.of(toProdnOrderConfBatchCharc);
    }

    /**
     * Overwrites the list of associated <b>ProdnOrderConfBatchCharc</b> entities for the loaded navigation property
     * <b>to_ProdnOrderConfBatchCharc</b>.
     * <p>
     * If the navigation property <b>to_ProdnOrderConfBatchCharc</b> of a queried <b>ProdnOrdConfMatlDocItm</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProdnOrderConfBatchCharc</b> entities.
     */
    public void setProdnOrderConfBatchCharc( @Nonnull final List<ProdnOrderConfBatchCharc> value )
    {
        if( toProdnOrderConfBatchCharc == null ) {
            toProdnOrderConfBatchCharc = Lists.newArrayList();
        }
        toProdnOrderConfBatchCharc.clear();
        toProdnOrderConfBatchCharc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProdnOrderConfBatchCharc</b> entities. This corresponds to the OData
     * navigation property <b>to_ProdnOrderConfBatchCharc</b>.
     * <p>
     * If the navigation property <b>to_ProdnOrderConfBatchCharc</b> of a queried <b>ProdnOrdConfMatlDocItm</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProdnOrderConfBatchCharc</b> entities.
     */
    public void addProdnOrderConfBatchCharc( ProdnOrderConfBatchCharc... entity )
    {
        if( toProdnOrderConfBatchCharc == null ) {
            toProdnOrderConfBatchCharc = Lists.newArrayList();
        }
        toProdnOrderConfBatchCharc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProdnOrdConfMatlDocItm instances.
     *
     */
    public final static class ProdnOrdConfMatlDocItmBuilder
    {

        private List<ProdnOrderConfBatchCharc> toProdnOrderConfBatchCharc = Lists.newArrayList();

        private ProdnOrdConfMatlDocItm.ProdnOrdConfMatlDocItmBuilder toProdnOrderConfBatchCharc(
            final List<ProdnOrderConfBatchCharc> value )
        {
            toProdnOrderConfBatchCharc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProdnOrderConfBatchCharc</b> for <b>ProdnOrdConfMatlDocItm</b> to multiple
         * <b>ProdnOrderConfBatchCharc</b>.
         *
         * @param value
         *            The ProdnOrderConfBatchCharcs to build this ProdnOrdConfMatlDocItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdnOrdConfMatlDocItm.ProdnOrdConfMatlDocItmBuilder prodnOrderConfBatchCharc(
            ProdnOrderConfBatchCharc... value )
        {
            return toProdnOrderConfBatchCharc(Lists.newArrayList(value));
        }

    }

}
