/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.selectable.ProdnOrdConfMatlDocItmSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm
 * ProdnOrdConfMatlDocItm} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ProdnOrdConfMatlDocItmByKeyFluentHelper
    extends
    FluentHelperByKey<ProdnOrdConfMatlDocItmByKeyFluentHelper, ProdnOrdConfMatlDocItm, ProdnOrdConfMatlDocItmSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm
     * ProdnOrdConfMatlDocItm} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param materialDocument
     *            Number of Material Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProdnOrdConfMatlDocItm}
     * @param confirmationCount
     *            Identifier of Single Order Confirmation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param materialDocumentItem
     *            Material Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProdnOrdConfMatlDocItm}
     * @param materialDocumentYear
     *            Material Document Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param confirmationGroup
     *            Collective ID of Order Confirmations
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public ProdnOrdConfMatlDocItmByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String confirmationGroup,
        final String confirmationCount,
        final String materialDocument,
        final String materialDocumentItem,
        final String materialDocumentYear )
    {
        super(servicePath, entityCollection);
        this.key.put("ConfirmationGroup", confirmationGroup);
        this.key.put("ConfirmationCount", confirmationCount);
        this.key.put("MaterialDocument", materialDocument);
        this.key.put("MaterialDocumentItem", materialDocumentItem);
        this.key.put("MaterialDocumentYear", materialDocumentYear);
    }

    @Override
    @Nonnull
    protected Class<ProdnOrdConfMatlDocItm> getEntityClass()
    {
        return ProdnOrdConfMatlDocItm.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
