/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.field.ProdnOrderConfBatchCharcField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.selectable.ProdnOrderConfBatchCharcSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Batch Characteristics for Material Movements
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProdnOrderConfBatchCharcType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProdnOrderConfBatchCharc extends VdmEntity<ProdnOrderConfBatchCharc>
{

    /**
     * Selector for all available fields of ProdnOrderConfBatchCharc.
     *
     */
    public final static ProdnOrderConfBatchCharcSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationGroup</b>
     * </p>
     *
     * @return Collective ID of Order Confirmations
     */
    @Key
    @SerializedName( "ConfirmationGroup" )
    @JsonProperty( "ConfirmationGroup" )
    @Nullable
    @ODataField( odataName = "ConfirmationGroup" )
    private String confirmationGroup;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationGroup</b> field to query operations.
     *
     */
    public final static ProdnOrderConfBatchCharcField<String> CONFIRMATION_GROUP =
        new ProdnOrderConfBatchCharcField<String>("ConfirmationGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationCount</b>
     * </p>
     *
     * @return Identifier of Single Order Confirmation
     */
    @Key
    @SerializedName( "ConfirmationCount" )
    @JsonProperty( "ConfirmationCount" )
    @Nullable
    @ODataField( odataName = "ConfirmationCount" )
    private String confirmationCount;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationCount</b> field to query operations.
     *
     */
    public final static ProdnOrderConfBatchCharcField<String> CONFIRMATION_COUNT =
        new ProdnOrderConfBatchCharcField<String>("ConfirmationCount");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @return Number of Material Document
     */
    @Key
    @SerializedName( "MaterialDocument" )
    @JsonProperty( "MaterialDocument" )
    @Nullable
    @ODataField( odataName = "MaterialDocument" )
    private String materialDocument;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocument</b> field to query operations.
     *
     */
    public final static ProdnOrderConfBatchCharcField<String> MATERIAL_DOCUMENT =
        new ProdnOrderConfBatchCharcField<String>("MaterialDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @return Material Document Item
     */
    @Key
    @SerializedName( "MaterialDocumentItem" )
    @JsonProperty( "MaterialDocumentItem" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItem" )
    private String materialDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentItem</b> field to query operations.
     *
     */
    public final static ProdnOrderConfBatchCharcField<String> MATERIAL_DOCUMENT_ITEM =
        new ProdnOrderConfBatchCharcField<String>("MaterialDocumentItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @return Material Document Year
     */
    @Key
    @SerializedName( "MaterialDocumentYear" )
    @JsonProperty( "MaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentYear" )
    private String materialDocumentYear;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentYear</b> field to query operations.
     *
     */
    public final static ProdnOrderConfBatchCharcField<String> MATERIAL_DOCUMENT_YEAR =
        new ProdnOrderConfBatchCharcField<String>("MaterialDocumentYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant of a Batch
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProdnOrderConfBatchCharcField<String> PLANT =
        new ProdnOrderConfBatchCharcField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ProdnOrderConfBatchCharcField<String> MATERIAL =
        new ProdnOrderConfBatchCharcField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @Key
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static ProdnOrderConfBatchCharcField<String> BATCH =
        new ProdnOrderConfBatchCharcField<String>("Batch");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharcInternalID" )
    @JsonProperty( "CharcInternalID" )
    @Nullable
    @ODataField( odataName = "CharcInternalID" )
    private String charcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharcInternalID</b> field to query operations.
     *
     */
    public final static ProdnOrderConfBatchCharcField<String> CHARC_INTERNAL_ID =
        new ProdnOrderConfBatchCharcField<String>("CharcInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @SerializedName( "Characteristic" )
    @JsonProperty( "Characteristic" )
    @Nullable
    @ODataField( odataName = "Characteristic" )
    private String characteristic;
    /**
     * Use with available fluent helpers to apply the <b>Characteristic</b> field to query operations.
     *
     */
    public final static ProdnOrderConfBatchCharcField<String> CHARACTERISTIC =
        new ProdnOrderConfBatchCharcField<String>("Characteristic");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValue</b>
     * </p>
     *
     * @return Characteristic Value
     */
    @SerializedName( "CharcValue" )
    @JsonProperty( "CharcValue" )
    @Nullable
    @ODataField( odataName = "CharcValue" )
    private String charcValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcValue</b> field to query operations.
     *
     */
    public final static ProdnOrderConfBatchCharcField<String> CHARC_VALUE =
        new ProdnOrderConfBatchCharcField<String>("CharcValue");

    @Nonnull
    @Override
    public Class<ProdnOrderConfBatchCharc> getType()
    {
        return ProdnOrderConfBatchCharc.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationGroup</b>
     * </p>
     *
     * @param confirmationGroup
     *            Collective ID of Order Confirmations
     */
    public void setConfirmationGroup( @Nullable final String confirmationGroup )
    {
        rememberChangedField("ConfirmationGroup", this.confirmationGroup);
        this.confirmationGroup = confirmationGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationCount</b>
     * </p>
     *
     * @param confirmationCount
     *            Identifier of Single Order Confirmation
     */
    public void setConfirmationCount( @Nullable final String confirmationCount )
    {
        rememberChangedField("ConfirmationCount", this.confirmationCount);
        this.confirmationCount = confirmationCount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *            Number of Material Document
     */
    public void setMaterialDocument( @Nullable final String materialDocument )
    {
        rememberChangedField("MaterialDocument", this.materialDocument);
        this.materialDocument = materialDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @param materialDocumentItem
     *            Material Document Item
     */
    public void setMaterialDocumentItem( @Nullable final String materialDocumentItem )
    {
        rememberChangedField("MaterialDocumentItem", this.materialDocumentItem);
        this.materialDocumentItem = materialDocumentItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *            Material Document Year
     */
    public void setMaterialDocumentYear( @Nullable final String materialDocumentYear )
    {
        rememberChangedField("MaterialDocumentYear", this.materialDocumentYear);
        this.materialDocumentYear = materialDocumentYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant of a Batch
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     */
    public void setCharcInternalID( @Nullable final String charcInternalID )
    {
        rememberChangedField("CharcInternalID", this.charcInternalID);
        this.charcInternalID = charcInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @param characteristic
     *            Characteristic Name
     */
    public void setCharacteristic( @Nullable final String characteristic )
    {
        rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValue</b>
     * </p>
     *
     * @param charcValue
     *            Characteristic Value
     */
    public void setCharcValue( @Nullable final String charcValue )
    {
        rememberChangedField("CharcValue", this.charcValue);
        this.charcValue = charcValue;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProdnOrderConfBatchCharc";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConfirmationGroup", getConfirmationGroup());
        result.put("ConfirmationCount", getConfirmationCount());
        result.put("MaterialDocument", getMaterialDocument());
        result.put("MaterialDocumentItem", getMaterialDocumentItem());
        result.put("MaterialDocumentYear", getMaterialDocumentYear());
        result.put("Plant", getPlant());
        result.put("Material", getMaterial());
        result.put("Batch", getBatch());
        result.put("CharcInternalID", getCharcInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConfirmationGroup", getConfirmationGroup());
        values.put("ConfirmationCount", getConfirmationCount());
        values.put("MaterialDocument", getMaterialDocument());
        values.put("MaterialDocumentItem", getMaterialDocumentItem());
        values.put("MaterialDocumentYear", getMaterialDocumentYear());
        values.put("Plant", getPlant());
        values.put("Material", getMaterial());
        values.put("Batch", getBatch());
        values.put("CharcInternalID", getCharcInternalID());
        values.put("Characteristic", getCharacteristic());
        values.put("CharcValue", getCharcValue());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConfirmationGroup") ) {
                final Object value = values.remove("ConfirmationGroup");
                if( (value == null) || (!value.equals(getConfirmationGroup())) ) {
                    setConfirmationGroup(((String) value));
                }
            }
            if( values.containsKey("ConfirmationCount") ) {
                final Object value = values.remove("ConfirmationCount");
                if( (value == null) || (!value.equals(getConfirmationCount())) ) {
                    setConfirmationCount(((String) value));
                }
            }
            if( values.containsKey("MaterialDocument") ) {
                final Object value = values.remove("MaterialDocument");
                if( (value == null) || (!value.equals(getMaterialDocument())) ) {
                    setMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentItem") ) {
                final Object value = values.remove("MaterialDocumentItem");
                if( (value == null) || (!value.equals(getMaterialDocumentItem())) ) {
                    setMaterialDocumentItem(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentYear") ) {
                final Object value = values.remove("MaterialDocumentYear");
                if( (value == null) || (!value.equals(getMaterialDocumentYear())) ) {
                    setMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("CharcInternalID") ) {
                final Object value = values.remove("CharcInternalID");
                if( (value == null) || (!value.equals(getCharcInternalID())) ) {
                    setCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("Characteristic") ) {
                final Object value = values.remove("Characteristic");
                if( (value == null) || (!value.equals(getCharacteristic())) ) {
                    setCharacteristic(((String) value));
                }
            }
            if( values.containsKey("CharcValue") ) {
                final Object value = values.remove("CharcValue");
                if( (value == null) || (!value.equals(getCharcValue())) ) {
                    setCharcValue(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProdnOrderConfBatchCharcField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProdnOrderConfBatchCharcField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProdnOrderConfBatchCharcField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProdnOrderConfBatchCharcField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderConfirmationV2Service.DEFAULT_SERVICE_PATH);
    }

}
