/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConf2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm;

/**
 * Implementation of the {@link ProductionOrderConfirmationV2ServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderConfirmationV2Service
 * ProductionOrderConfirmationV2Service}.
 *
 */
public class DefaultProductionOrderConfirmationV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProductionOrderConfirmationV2ServiceBatch, ProductionOrderConfirmationV2ServiceBatchChangeSet>
    implements
    ProductionOrderConfirmationV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderConfirmationV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultProductionOrderConfirmationV2ServiceBatchChangeSet(
        @Nonnull final DefaultProductionOrderConfirmationV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderConfirmationV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProductionOrderConfirmationV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductionOrderConfirmationV2ServiceBatchChangeSet createProdnOrdConfMatlDocItm(
        @Nonnull final ProdnOrdConfMatlDocItm prodnOrdConfMatlDocItm )
    {
        return addRequestCreate(service::createProdnOrdConfMatlDocItm, prodnOrdConfMatlDocItm);
    }

    @Nonnull
    @Override
    public ProductionOrderConfirmationV2ServiceBatchChangeSet createProdnOrdConf2(
        @Nonnull final ProdnOrdConf2 prodnOrdConf2 )
    {
        return addRequestCreate(service::createProdnOrdConf2, prodnOrdConf2);
    }

}
