/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConf2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderConfirmationV2Service
 * ProductionOrderConfirmationV2Service}.
 *
 */
public interface ProductionOrderConfirmationV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ProductionOrderConfirmationV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ProductionOrderConfirmationV2ServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm
     * ProdnOrdConfMatlDocItm} entity and save it to the S/4HANA system.
     *
     * @param prodnOrdConfMatlDocItm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm
     *            ProdnOrdConfMatlDocItm} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionOrderConfirmationV2ServiceBatchChangeSet
        createProdnOrdConfMatlDocItm( @Nonnull final ProdnOrdConfMatlDocItm prodnOrdConfMatlDocItm );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConf2
     * ProdnOrdConf2} entity and save it to the S/4HANA system.
     *
     * @param prodnOrdConf2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConf2
     *            ProdnOrdConf2} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionOrderConfirmationV2ServiceBatchChangeSet
        createProdnOrdConf2( @Nonnull final ProdnOrdConf2 prodnOrdConf2 );

}
