/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm
 * ProdnOrdConfMatlDocItm}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.field.ProdnOrdConfMatlDocItmField
 * ProdnOrdConfMatlDocItmField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.link.ProdnOrdConfMatlDocItmLink
 * ProdnOrdConfMatlDocItmLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#CONFIRMATION_GROUP
 * CONFIRMATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#CONFIRMATION_COUNT
 * CONFIRMATION_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#MATERIAL_DOCUMENT
 * MATERIAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#MATERIAL_DOCUMENT_ITEM
 * MATERIAL_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#MATERIAL_DOCUMENT_YEAR
 * MATERIAL_DOCUMENT_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#ORDER_TYPE
 * ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#ORDER_ITEM
 * ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#MANUFACTURING_ORDER_CATEGORY
 * MANUFACTURING_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#RESERVATION
 * RESERVATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#RESERVATION_ITEM
 * RESERVATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#PRODUCTION_SUPPLY_AREA
 * PRODUCTION_SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#INVENTORY_VALUATION_TYPE
 * INVENTORY_VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#GOODS_MOVEMENT_TYPE
 * GOODS_MOVEMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#GOODS_MOVEMENT_REASON_CODE
 * GOODS_MOVEMENT_REASON_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#GOODS_MOVEMENT_REF_DOC_TYPE
 * GOODS_MOVEMENT_REF_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#INVENTORY_USABILITY_CODE
 * INVENTORY_USABILITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#INVENTORY_SPECIAL_STOCK_TYPE
 * INVENTORY_SPECIAL_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#RESERVATION_IS_FINALLY_ISSUED
 * RESERVATION_IS_FINALLY_ISSUED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#IS_COMPLETELY_DELIVERED
 * IS_COMPLETELY_DELIVERED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#SHELF_LIFE_EXPIRATION_DATE
 * SHELF_LIFE_EXPIRATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#MANUFACTURE_DATE
 * MANUFACTURE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#STORAGE_TYPE
 * STORAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#STORAGE_BIN
 * STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#EWM_WAREHOUSE
 * EWM_WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#EWM_STORAGE_BIN
 * EWM_STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#MATERIAL_DOCUMENT_ITEM_TEXT
 * MATERIAL_DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#ENTRY_UNIT
 * ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#ENTRY_UNIT_ISO_CODE
 * ENTRY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#ENTRY_UNIT_SAP_CODE
 * ENTRY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#QUANTITY_IN_ENTRY_UNIT
 * QUANTITY_IN_ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm#TO_PRODN_ORDER_CONF_BATCH_CHARC
 * TO_PRODN_ORDER_CONF_BATCH_CHARC}</li>
 * </ul>
 *
 */
public interface ProdnOrdConfMatlDocItmSelectable extends EntitySelectable<ProdnOrdConfMatlDocItm>
{

}
