/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.selectable.ProductionOrderComponent_3Selectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3
 * ProductionOrderComponent_3} entities. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class ProductionOrderComponent_3FluentHelper
    extends
    FluentHelperRead<ProductionOrderComponent_3FluentHelper, ProductionOrderComponent_3, ProductionOrderComponent_3Selectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public ProductionOrderComponent_3FluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<ProductionOrderComponent_3> getEntityClass()
    {
        return ProductionOrderComponent_3.class;
    }

}
