/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.field.ProductionOrderComponent_4Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.selectable.ProductionOrderComponent_4Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Production Order Components Using RAP BO
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductionOrderComponent_4Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductionOrderComponent_4 extends VdmEntity<ProductionOrderComponent_4>
{

    /**
     * Selector for all available fields of ProductionOrderComponent_4.
     *
     */
    public final static ProductionOrderComponent_4Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @Key
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> RESERVATION =
        new ProductionOrderComponent_4Field<String>("Reservation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Reservation Item
     */
    @Key
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> RESERVATION_ITEM =
        new ProductionOrderComponent_4Field<String>("ReservationItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReservationRecordType</b>
     * </p>
     *
     * @return Reservation Record Type
     */
    @Key
    @SerializedName( "ReservationRecordType" )
    @JsonProperty( "ReservationRecordType" )
    @Nullable
    @ODataField( odataName = "ReservationRecordType" )
    private String reservationRecordType;
    /**
     * Use with available fluent helpers to apply the <b>ReservationRecordType</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> RESERVATION_RECORD_TYPE =
        new ProductionOrderComponent_4Field<String>("ReservationRecordType");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> MATERIAL_GROUP =
        new ProductionOrderComponent_4Field<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> MATERIAL =
        new ProductionOrderComponent_4Field<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> PLANT =
        new ProductionOrderComponent_4Field<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @return Manufacturing Order Category
     */
    @SerializedName( "ManufacturingOrderCategory" )
    @JsonProperty( "ManufacturingOrderCategory" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderCategory" )
    private String manufacturingOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderCategory</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> MANUFACTURING_ORDER_CATEGORY =
        new ProductionOrderComponent_4Field<String>("ManufacturingOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @return Manufacturing Order Type
     */
    @SerializedName( "ManufacturingOrderType" )
    @JsonProperty( "ManufacturingOrderType" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderType" )
    private String manufacturingOrderType;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderType</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> MANUFACTURING_ORDER_TYPE =
        new ProductionOrderComponent_4Field<String>("ManufacturingOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Production Order
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> MANUFACTURING_ORDER =
        new ProductionOrderComponent_4Field<String>("ManufacturingOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @return Sequence
     */
    @SerializedName( "ManufacturingOrderSequence" )
    @JsonProperty( "ManufacturingOrderSequence" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderSequence" )
    private String manufacturingOrderSequence;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderSequence</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> MANUFACTURING_ORDER_SEQUENCE =
        new ProductionOrderComponent_4Field<String>("ManufacturingOrderSequence");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @return Operation or Phase Number
     */
    @SerializedName( "ManufacturingOrderOperation" )
    @JsonProperty( "ManufacturingOrderOperation" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderOperation" )
    private String manufacturingOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderOperation</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> MANUFACTURING_ORDER_OPERATION =
        new ProductionOrderComponent_4Field<String>("ManufacturingOrderOperation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @return Production Plant
     */
    @SerializedName( "ProductionPlant" )
    @JsonProperty( "ProductionPlant" )
    @Nullable
    @ODataField( odataName = "ProductionPlant" )
    private String productionPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPlant</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> PRODUCTION_PLANT =
        new ProductionOrderComponent_4Field<String>("ProductionPlant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @return Order Internal ID
     */
    @SerializedName( "OrderInternalBillOfOperations" )
    @JsonProperty( "OrderInternalBillOfOperations" )
    @Nullable
    @ODataField( odataName = "OrderInternalBillOfOperations" )
    private String orderInternalBillOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalBillOfOperations</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> ORDER_INTERNAL_BILL_OF_OPERATIONS =
        new ProductionOrderComponent_4Field<String>("OrderInternalBillOfOperations");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementDate</b>
     * </p>
     *
     * @return Material Component Requirement Date
     */
    @SerializedName( "MatlCompRequirementDate" )
    @JsonProperty( "MatlCompRequirementDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MatlCompRequirementDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime matlCompRequirementDate;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompRequirementDate</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<LocalDateTime> MATL_COMP_REQUIREMENT_DATE =
        new ProductionOrderComponent_4Field<LocalDateTime>("MatlCompRequirementDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementTime</b>
     * </p>
     *
     * @return Material Component Requirement Time
     */
    @SerializedName( "MatlCompRequirementTime" )
    @JsonProperty( "MatlCompRequirementTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MatlCompRequirementTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime matlCompRequirementTime;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompRequirementTime</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<LocalTime> MATL_COMP_REQUIREMENT_TIME =
        new ProductionOrderComponent_4Field<LocalTime>("MatlCompRequirementTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationIsFinallyIssued</b>
     * </p>
     *
     * @return Final Issue for Reservation
     */
    @SerializedName( "ReservationIsFinallyIssued" )
    @JsonProperty( "ReservationIsFinallyIssued" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReservationIsFinallyIssued" )
    private Boolean reservationIsFinallyIssued;
    /**
     * Use with available fluent helpers to apply the <b>ReservationIsFinallyIssued</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<Boolean> RESERVATION_IS_FINALLY_ISSUED =
        new ProductionOrderComponent_4Field<Boolean>("ReservationIsFinallyIssued");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForDeletion</b>
     * </p>
     *
     * @return Marked for Deletion
     */
    @SerializedName( "MatlCompIsMarkedForDeletion" )
    @JsonProperty( "MatlCompIsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MatlCompIsMarkedForDeletion" )
    private Boolean matlCompIsMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompIsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<Boolean> MATL_COMP_IS_MARKED_FOR_DELETION =
        new ProductionOrderComponent_4Field<Boolean>("MatlCompIsMarkedForDeletion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBulkMaterialComponent</b>
     * </p>
     *
     * @return Indicator: Bulk Material
     */
    @SerializedName( "IsBulkMaterialComponent" )
    @JsonProperty( "IsBulkMaterialComponent" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBulkMaterialComponent" )
    private Boolean isBulkMaterialComponent;
    /**
     * Use with available fluent helpers to apply the <b>IsBulkMaterialComponent</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<Boolean> IS_BULK_MATERIAL_COMPONENT =
        new ProductionOrderComponent_4Field<Boolean>("IsBulkMaterialComponent");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @return Indicator: Backflush
     */
    @SerializedName( "MatlCompIsMarkedForBackflush" )
    @JsonProperty( "MatlCompIsMarkedForBackflush" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MatlCompIsMarkedForBackflush" )
    private Boolean matlCompIsMarkedForBackflush;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompIsMarkedForBackflush</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<Boolean> MATL_COMP_IS_MARKED_FOR_BACKFLUSH =
        new ProductionOrderComponent_4Field<Boolean>("MatlCompIsMarkedForBackflush");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCompIsCostRelevant</b>
     * </p>
     *
     * @return Indicator for Relevancy to Costing
     */
    @SerializedName( "MaterialCompIsCostRelevant" )
    @JsonProperty( "MaterialCompIsCostRelevant" )
    @Nullable
    @ODataField( odataName = "MaterialCompIsCostRelevant" )
    private String materialCompIsCostRelevant;
    /**
     * Use with available fluent helpers to apply the <b>MaterialCompIsCostRelevant</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> MATERIAL_COMP_IS_COST_RELEVANT =
        new ProductionOrderComponent_4Field<String>("MaterialCompIsCostRelevant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderComponentLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "OrderComponentLongText" )
    @JsonProperty( "OrderComponentLongText" )
    @Nullable
    @ODataField( odataName = "OrderComponentLongText" )
    private String orderComponentLongText;
    /**
     * Use with available fluent helpers to apply the <b>OrderComponentLongText</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> ORDER_COMPONENT_LONG_TEXT =
        new ProductionOrderComponent_4Field<String>("OrderComponentLongText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> SALES_ORDER =
        new ProductionOrderComponent_4Field<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> SALES_ORDER_ITEM =
        new ProductionOrderComponent_4Field<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompFreeDefinedAttribute</b>
     * </p>
     *
     * @return Sort String
     */
    @SerializedName( "MatlCompFreeDefinedAttribute" )
    @JsonProperty( "MatlCompFreeDefinedAttribute" )
    @Nullable
    @ODataField( odataName = "MatlCompFreeDefinedAttribute" )
    private String matlCompFreeDefinedAttribute;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompFreeDefinedAttribute</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> MATL_COMP_FREE_DEFINED_ATTRIBUTE =
        new ProductionOrderComponent_4Field<String>("MatlCompFreeDefinedAttribute");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return Bill of Material Category Code
     */
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> BILL_OF_MATERIAL_CATEGORY =
        new ProductionOrderComponent_4Field<String>("BillOfMaterialCategory");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMItem</b>
     * </p>
     *
     * @return Bill of Material Item
     */
    @SerializedName( "BOMItem" )
    @JsonProperty( "BOMItem" )
    @Nullable
    @ODataField( odataName = "BOMItem" )
    private String bOMItem;
    /**
     * Use with available fluent helpers to apply the <b>BOMItem</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> BOM_ITEM =
        new ProductionOrderComponent_4Field<String>("BOMItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCategory</b>
     * </p>
     *
     * @return Bill of Material Item Category
     */
    @SerializedName( "BOMItemCategory" )
    @JsonProperty( "BOMItemCategory" )
    @Nullable
    @ODataField( odataName = "BOMItemCategory" )
    private String bOMItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemCategory</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> BOM_ITEM_CATEGORY =
        new ProductionOrderComponent_4Field<String>("BOMItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @return Bill Of Material Item Number
     */
    @SerializedName( "BillOfMaterialItemNumber" )
    @JsonProperty( "BillOfMaterialItemNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNumber" )
    private String billOfMaterialItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemNumber</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> BILL_OF_MATERIAL_ITEM_NUMBER =
        new ProductionOrderComponent_4Field<String>("BillOfMaterialItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @return BOM Item Text (Line 1)
     */
    @SerializedName( "BOMItemDescription" )
    @JsonProperty( "BOMItemDescription" )
    @Nullable
    @ODataField( odataName = "BOMItemDescription" )
    private String bOMItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemDescription</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> BOM_ITEM_DESCRIPTION =
        new ProductionOrderComponent_4Field<String>("BOMItemDescription");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> STORAGE_LOCATION =
        new ProductionOrderComponent_4Field<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> BATCH =
        new ProductionOrderComponent_4Field<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BatchSplitType</b>
     * </p>
     *
     * @return The batchSplitType contained in this entity.
     */
    @SerializedName( "BatchSplitType" )
    @JsonProperty( "BatchSplitType" )
    @Nullable
    @ODataField( odataName = "BatchSplitType" )
    private String batchSplitType;
    /**
     * Use with available fluent helpers to apply the <b>BatchSplitType</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> BATCH_SPLIT_TYPE =
        new ProductionOrderComponent_4Field<String>("BatchSplitType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @return Movement Type (Inventory Management)
     */
    @SerializedName( "GoodsMovementType" )
    @JsonProperty( "GoodsMovementType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementType" )
    private String goodsMovementType;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementType</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> GOODS_MOVEMENT_TYPE =
        new ProductionOrderComponent_4Field<String>("GoodsMovementType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyArea</b>
     * </p>
     *
     * @return Production Supply Area
     */
    @SerializedName( "SupplyArea" )
    @JsonProperty( "SupplyArea" )
    @Nullable
    @ODataField( odataName = "SupplyArea" )
    private String supplyArea;
    /**
     * Use with available fluent helpers to apply the <b>SupplyArea</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> SUPPLY_AREA =
        new ProductionOrderComponent_4Field<String>("SupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @return Goods Recipient
     */
    @SerializedName( "GoodsRecipientName" )
    @JsonProperty( "GoodsRecipientName" )
    @Nullable
    @ODataField( odataName = "GoodsRecipientName" )
    private String goodsRecipientName;
    /**
     * Use with available fluent helpers to apply the <b>GoodsRecipientName</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> GOODS_RECIPIENT_NAME =
        new ProductionOrderComponent_4Field<String>("GoodsRecipientName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> UNLOADING_POINT_NAME =
        new ProductionOrderComponent_4Field<String>("UnloadingPointName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCompIsAlternativeItem</b>
     * </p>
     *
     * @return Alternative Item Indicator
     */
    @SerializedName( "MaterialCompIsAlternativeItem" )
    @JsonProperty( "MaterialCompIsAlternativeItem" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaterialCompIsAlternativeItem" )
    private Boolean materialCompIsAlternativeItem;
    /**
     * Use with available fluent helpers to apply the <b>MaterialCompIsAlternativeItem</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<Boolean> MATERIAL_COMP_IS_ALTERNATIVE_ITEM =
        new ProductionOrderComponent_4Field<Boolean>("MaterialCompIsAlternativeItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeItemGroup</b>
     * </p>
     *
     * @return Alternative Item Group
     */
    @SerializedName( "AlternativeItemGroup" )
    @JsonProperty( "AlternativeItemGroup" )
    @Nullable
    @ODataField( odataName = "AlternativeItemGroup" )
    private String alternativeItemGroup;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeItemGroup</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> ALTERNATIVE_ITEM_GROUP =
        new ProductionOrderComponent_4Field<String>("AlternativeItemGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeItemStrategy</b>
     * </p>
     *
     * @return Alternative Item Strategy
     */
    @SerializedName( "AlternativeItemStrategy" )
    @JsonProperty( "AlternativeItemStrategy" )
    @Nullable
    @ODataField( odataName = "AlternativeItemStrategy" )
    private String alternativeItemStrategy;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeItemStrategy</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> ALTERNATIVE_ITEM_STRATEGY =
        new ProductionOrderComponent_4Field<String>("AlternativeItemStrategy");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeItemPriority</b>
     * </p>
     *
     * @return Alternative Item Priority
     */
    @SerializedName( "AlternativeItemPriority" )
    @JsonProperty( "AlternativeItemPriority" )
    @Nullable
    @ODataField( odataName = "AlternativeItemPriority" )
    private String alternativeItemPriority;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeItemPriority</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> ALTERNATIVE_ITEM_PRIORITY =
        new ProductionOrderComponent_4Field<String>("AlternativeItemPriority");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>UsageProbabilityPercent</b>
     * </p>
     *
     * @return Usage Probability in % (Alternative Item)
     */
    @SerializedName( "UsageProbabilityPercent" )
    @JsonProperty( "UsageProbabilityPercent" )
    @Nullable
    @ODataField( odataName = "UsageProbabilityPercent" )
    private BigDecimal usageProbabilityPercent;
    /**
     * Use with available fluent helpers to apply the <b>UsageProbabilityPercent</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<BigDecimal> USAGE_PROBABILITY_PERCENT =
        new ProductionOrderComponent_4Field<BigDecimal>("UsageProbabilityPercent");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialComponentIsPhantomItem</b>
     * </p>
     *
     * @return Phantom Item Indicator
     */
    @SerializedName( "MaterialComponentIsPhantomItem" )
    @JsonProperty( "MaterialComponentIsPhantomItem" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaterialComponentIsPhantomItem" )
    private Boolean materialComponentIsPhantomItem;
    /**
     * Use with available fluent helpers to apply the <b>MaterialComponentIsPhantomItem</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<Boolean> MATERIAL_COMPONENT_IS_PHANTOM_ITEM =
        new ProductionOrderComponent_4Field<Boolean>("MaterialComponentIsPhantomItem");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeOffset</b>
     * </p>
     *
     * @return Lead-Time Offset
     */
    @SerializedName( "LeadTimeOffset" )
    @JsonProperty( "LeadTimeOffset" )
    @Nullable
    @ODataField( odataName = "LeadTimeOffset" )
    private BigDecimal leadTimeOffset;
    /**
     * Use with available fluent helpers to apply the <b>LeadTimeOffset</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<BigDecimal> LEAD_TIME_OFFSET =
        new ProductionOrderComponent_4Field<BigDecimal>("LeadTimeOffset");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsFixed</b>
     * </p>
     *
     * @return Quantity is fixed
     */
    @SerializedName( "QuantityIsFixed" )
    @JsonProperty( "QuantityIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "QuantityIsFixed" )
    private Boolean quantityIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>QuantityIsFixed</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<Boolean> QUANTITY_IS_FIXED =
        new ProductionOrderComponent_4Field<Boolean>("QuantityIsFixed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNetScrap</b>
     * </p>
     *
     * @return Net Scrap Indicator
     */
    @SerializedName( "IsNetScrap" )
    @JsonProperty( "IsNetScrap" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsNetScrap" )
    private Boolean isNetScrap;
    /**
     * Use with available fluent helpers to apply the <b>IsNetScrap</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<Boolean> IS_NET_SCRAP =
        new ProductionOrderComponent_4Field<Boolean>("IsNetScrap");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ComponentScrapInPercent</b>
     * </p>
     *
     * @return Component Scrap in Percent
     */
    @SerializedName( "ComponentScrapInPercent" )
    @JsonProperty( "ComponentScrapInPercent" )
    @Nullable
    @ODataField( odataName = "ComponentScrapInPercent" )
    private BigDecimal componentScrapInPercent;
    /**
     * Use with available fluent helpers to apply the <b>ComponentScrapInPercent</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<BigDecimal> COMPONENT_SCRAP_IN_PERCENT =
        new ProductionOrderComponent_4Field<BigDecimal>("ComponentScrapInPercent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>OperationScrapInPercent</b>
     * </p>
     *
     * @return Operation Scrap
     */
    @SerializedName( "OperationScrapInPercent" )
    @JsonProperty( "OperationScrapInPercent" )
    @Nullable
    @ODataField( odataName = "OperationScrapInPercent" )
    private BigDecimal operationScrapInPercent;
    /**
     * Use with available fluent helpers to apply the <b>OperationScrapInPercent</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<BigDecimal> OPERATION_SCRAP_IN_PERCENT =
        new ProductionOrderComponent_4Field<BigDecimal>("OperationScrapInPercent");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> BASE_UNIT =
        new ProductionOrderComponent_4Field<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "BaseUnitISOCode" )
    @JsonProperty( "BaseUnitISOCode" )
    @Nullable
    @ODataField( odataName = "BaseUnitISOCode" )
    private String baseUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnitISOCode</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> BASE_UNIT_ISO_CODE =
        new ProductionOrderComponent_4Field<String>("BaseUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "BaseUnitSAPCode" )
    @JsonProperty( "BaseUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "BaseUnitSAPCode" )
    private String baseUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> BASE_UNIT_SAP_CODE =
        new ProductionOrderComponent_4Field<String>("BaseUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequiredQuantity</b>
     * </p>
     *
     * @return Requirement Quantity
     */
    @SerializedName( "RequiredQuantity" )
    @JsonProperty( "RequiredQuantity" )
    @Nullable
    @ODataField( odataName = "RequiredQuantity" )
    private BigDecimal requiredQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequiredQuantity</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<BigDecimal> REQUIRED_QUANTITY =
        new ProductionOrderComponent_4Field<BigDecimal>("RequiredQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantity</b>
     * </p>
     *
     * @return Withdrawn Quantity
     */
    @SerializedName( "WithdrawnQuantity" )
    @JsonProperty( "WithdrawnQuantity" )
    @Nullable
    @ODataField( odataName = "WithdrawnQuantity" )
    private BigDecimal withdrawnQuantity;
    /**
     * Use with available fluent helpers to apply the <b>WithdrawnQuantity</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<BigDecimal> WITHDRAWN_QUANTITY =
        new ProductionOrderComponent_4Field<BigDecimal>("WithdrawnQuantity");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedAvailableQuantity</b>
     * </p>
     *
     * @return Available Quantity
     */
    @SerializedName( "ConfirmedAvailableQuantity" )
    @JsonProperty( "ConfirmedAvailableQuantity" )
    @Nullable
    @ODataField( odataName = "ConfirmedAvailableQuantity" )
    private BigDecimal confirmedAvailableQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedAvailableQuantity</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<BigDecimal> CONFIRMED_AVAILABLE_QUANTITY =
        new ProductionOrderComponent_4Field<BigDecimal>("ConfirmedAvailableQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCompOriginalQuantity</b>
     * </p>
     *
     * @return Original Quantity of a Material Component
     */
    @SerializedName( "MaterialCompOriginalQuantity" )
    @JsonProperty( "MaterialCompOriginalQuantity" )
    @Nullable
    @ODataField( odataName = "MaterialCompOriginalQuantity" )
    private BigDecimal materialCompOriginalQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaterialCompOriginalQuantity</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<BigDecimal> MATERIAL_COMP_ORIGINAL_QUANTITY =
        new ProductionOrderComponent_4Field<BigDecimal>("MaterialCompOriginalQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @return Unit of entry
     */
    @SerializedName( "EntryUnit" )
    @JsonProperty( "EntryUnit" )
    @Nullable
    @ODataField( odataName = "EntryUnit" )
    private String entryUnit;
    /**
     * Use with available fluent helpers to apply the <b>EntryUnit</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> ENTRY_UNIT =
        new ProductionOrderComponent_4Field<String>("EntryUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "EntryUnitISOCode" )
    @JsonProperty( "EntryUnitISOCode" )
    @Nullable
    @ODataField( odataName = "EntryUnitISOCode" )
    private String entryUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>EntryUnitISOCode</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> ENTRY_UNIT_ISO_CODE =
        new ProductionOrderComponent_4Field<String>("EntryUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "EntryUnitSAPCode" )
    @JsonProperty( "EntryUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "EntryUnitSAPCode" )
    private String entryUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>EntryUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> ENTRY_UNIT_SAP_CODE =
        new ProductionOrderComponent_4Field<String>("EntryUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementEntryQty</b>
     * </p>
     *
     * @return Quantity in Unit of Entry
     */
    @SerializedName( "GoodsMovementEntryQty" )
    @JsonProperty( "GoodsMovementEntryQty" )
    @Nullable
    @ODataField( odataName = "GoodsMovementEntryQty" )
    private BigDecimal goodsMovementEntryQty;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementEntryQty</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<BigDecimal> GOODS_MOVEMENT_ENTRY_QTY =
        new ProductionOrderComponent_4Field<BigDecimal>("GoodsMovementEntryQty");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> CURRENCY =
        new ProductionOrderComponent_4Field<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantityAmount</b>
     * </p>
     *
     * @return Value Withdrawn
     */
    @SerializedName( "WithdrawnQuantityAmount" )
    @JsonProperty( "WithdrawnQuantityAmount" )
    @Nullable
    @ODataField( odataName = "WithdrawnQuantityAmount" )
    private BigDecimal withdrawnQuantityAmount;
    /**
     * Use with available fluent helpers to apply the <b>WithdrawnQuantityAmount</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<BigDecimal> WITHDRAWN_QUANTITY_AMOUNT =
        new ProductionOrderComponent_4Field<BigDecimal>("WithdrawnQuantityAmount");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return The lastChangeDateTime contained in this entity.
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @ODataField( odataName = "LastChangeDateTime" )
    private String lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProductionOrderComponent_4Field<String> LAST_CHANGE_DATE_TIME =
        new ProductionOrderComponent_4Field<String>("LastChangeDateTime");

    @Nonnull
    @Override
    public Class<ProductionOrderComponent_4> getType()
    {
        return ProductionOrderComponent_4.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Reservation Item
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReservationRecordType</b>
     * </p>
     *
     * @param reservationRecordType
     *            Reservation Record Type
     */
    public void setReservationRecordType( @Nullable final String reservationRecordType )
    {
        rememberChangedField("ReservationRecordType", this.reservationRecordType);
        this.reservationRecordType = reservationRecordType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     */
    public void setManufacturingOrderCategory( @Nullable final String manufacturingOrderCategory )
    {
        rememberChangedField("ManufacturingOrderCategory", this.manufacturingOrderCategory);
        this.manufacturingOrderCategory = manufacturingOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @param manufacturingOrderType
     *            Manufacturing Order Type
     */
    public void setManufacturingOrderType( @Nullable final String manufacturingOrderType )
    {
        rememberChangedField("ManufacturingOrderType", this.manufacturingOrderType);
        this.manufacturingOrderType = manufacturingOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Production Order
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @param manufacturingOrderSequence
     *            Sequence
     */
    public void setManufacturingOrderSequence( @Nullable final String manufacturingOrderSequence )
    {
        rememberChangedField("ManufacturingOrderSequence", this.manufacturingOrderSequence);
        this.manufacturingOrderSequence = manufacturingOrderSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Operation or Phase Number
     */
    public void setManufacturingOrderOperation( @Nullable final String manufacturingOrderOperation )
    {
        rememberChangedField("ManufacturingOrderOperation", this.manufacturingOrderOperation);
        this.manufacturingOrderOperation = manufacturingOrderOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @param productionPlant
     *            Production Plant
     */
    public void setProductionPlant( @Nullable final String productionPlant )
    {
        rememberChangedField("ProductionPlant", this.productionPlant);
        this.productionPlant = productionPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     */
    public void setOrderInternalBillOfOperations( @Nullable final String orderInternalBillOfOperations )
    {
        rememberChangedField("OrderInternalBillOfOperations", this.orderInternalBillOfOperations);
        this.orderInternalBillOfOperations = orderInternalBillOfOperations;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementDate</b>
     * </p>
     *
     * @param matlCompRequirementDate
     *            Material Component Requirement Date
     */
    public void setMatlCompRequirementDate( @Nullable final LocalDateTime matlCompRequirementDate )
    {
        rememberChangedField("MatlCompRequirementDate", this.matlCompRequirementDate);
        this.matlCompRequirementDate = matlCompRequirementDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementTime</b>
     * </p>
     *
     * @param matlCompRequirementTime
     *            Material Component Requirement Time
     */
    public void setMatlCompRequirementTime( @Nullable final LocalTime matlCompRequirementTime )
    {
        rememberChangedField("MatlCompRequirementTime", this.matlCompRequirementTime);
        this.matlCompRequirementTime = matlCompRequirementTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationIsFinallyIssued</b>
     * </p>
     *
     * @param reservationIsFinallyIssued
     *            Final Issue for Reservation
     */
    public void setReservationIsFinallyIssued( @Nullable final Boolean reservationIsFinallyIssued )
    {
        rememberChangedField("ReservationIsFinallyIssued", this.reservationIsFinallyIssued);
        this.reservationIsFinallyIssued = reservationIsFinallyIssued;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForDeletion</b>
     * </p>
     *
     * @param matlCompIsMarkedForDeletion
     *            Marked for Deletion
     */
    public void setMatlCompIsMarkedForDeletion( @Nullable final Boolean matlCompIsMarkedForDeletion )
    {
        rememberChangedField("MatlCompIsMarkedForDeletion", this.matlCompIsMarkedForDeletion);
        this.matlCompIsMarkedForDeletion = matlCompIsMarkedForDeletion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBulkMaterialComponent</b>
     * </p>
     *
     * @param isBulkMaterialComponent
     *            Indicator: Bulk Material
     */
    public void setIsBulkMaterialComponent( @Nullable final Boolean isBulkMaterialComponent )
    {
        rememberChangedField("IsBulkMaterialComponent", this.isBulkMaterialComponent);
        this.isBulkMaterialComponent = isBulkMaterialComponent;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @param matlCompIsMarkedForBackflush
     *            Indicator: Backflush
     */
    public void setMatlCompIsMarkedForBackflush( @Nullable final Boolean matlCompIsMarkedForBackflush )
    {
        rememberChangedField("MatlCompIsMarkedForBackflush", this.matlCompIsMarkedForBackflush);
        this.matlCompIsMarkedForBackflush = matlCompIsMarkedForBackflush;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCompIsCostRelevant</b>
     * </p>
     *
     * @param materialCompIsCostRelevant
     *            Indicator for Relevancy to Costing
     */
    public void setMaterialCompIsCostRelevant( @Nullable final String materialCompIsCostRelevant )
    {
        rememberChangedField("MaterialCompIsCostRelevant", this.materialCompIsCostRelevant);
        this.materialCompIsCostRelevant = materialCompIsCostRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderComponentLongText</b>
     * </p>
     *
     * @param orderComponentLongText
     *            Long Text
     */
    public void setOrderComponentLongText( @Nullable final String orderComponentLongText )
    {
        rememberChangedField("OrderComponentLongText", this.orderComponentLongText);
        this.orderComponentLongText = orderComponentLongText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompFreeDefinedAttribute</b>
     * </p>
     *
     * @param matlCompFreeDefinedAttribute
     *            Sort String
     */
    public void setMatlCompFreeDefinedAttribute( @Nullable final String matlCompFreeDefinedAttribute )
    {
        rememberChangedField("MatlCompFreeDefinedAttribute", this.matlCompFreeDefinedAttribute);
        this.matlCompFreeDefinedAttribute = matlCompFreeDefinedAttribute;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            Bill of Material Category Code
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMItem</b>
     * </p>
     *
     * @param bOMItem
     *            Bill of Material Item
     */
    public void setBOMItem( @Nullable final String bOMItem )
    {
        rememberChangedField("BOMItem", this.bOMItem);
        this.bOMItem = bOMItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCategory</b>
     * </p>
     *
     * @param bOMItemCategory
     *            Bill of Material Item Category
     */
    public void setBOMItemCategory( @Nullable final String bOMItemCategory )
    {
        rememberChangedField("BOMItemCategory", this.bOMItemCategory);
        this.bOMItemCategory = bOMItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNumber
     *            Bill Of Material Item Number
     */
    public void setBillOfMaterialItemNumber( @Nullable final String billOfMaterialItemNumber )
    {
        rememberChangedField("BillOfMaterialItemNumber", this.billOfMaterialItemNumber);
        this.billOfMaterialItemNumber = billOfMaterialItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @param bOMItemDescription
     *            BOM Item Text (Line 1)
     */
    public void setBOMItemDescription( @Nullable final String bOMItemDescription )
    {
        rememberChangedField("BOMItemDescription", this.bOMItemDescription);
        this.bOMItemDescription = bOMItemDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BatchSplitType</b>
     * </p>
     *
     * @param batchSplitType
     *            The batchSplitType to set.
     */
    public void setBatchSplitType( @Nullable final String batchSplitType )
    {
        rememberChangedField("BatchSplitType", this.batchSplitType);
        this.batchSplitType = batchSplitType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @param goodsMovementType
     *            Movement Type (Inventory Management)
     */
    public void setGoodsMovementType( @Nullable final String goodsMovementType )
    {
        rememberChangedField("GoodsMovementType", this.goodsMovementType);
        this.goodsMovementType = goodsMovementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyArea</b>
     * </p>
     *
     * @param supplyArea
     *            Production Supply Area
     */
    public void setSupplyArea( @Nullable final String supplyArea )
    {
        rememberChangedField("SupplyArea", this.supplyArea);
        this.supplyArea = supplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @param goodsRecipientName
     *            Goods Recipient
     */
    public void setGoodsRecipientName( @Nullable final String goodsRecipientName )
    {
        rememberChangedField("GoodsRecipientName", this.goodsRecipientName);
        this.goodsRecipientName = goodsRecipientName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCompIsAlternativeItem</b>
     * </p>
     *
     * @param materialCompIsAlternativeItem
     *            Alternative Item Indicator
     */
    public void setMaterialCompIsAlternativeItem( @Nullable final Boolean materialCompIsAlternativeItem )
    {
        rememberChangedField("MaterialCompIsAlternativeItem", this.materialCompIsAlternativeItem);
        this.materialCompIsAlternativeItem = materialCompIsAlternativeItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeItemGroup</b>
     * </p>
     *
     * @param alternativeItemGroup
     *            Alternative Item Group
     */
    public void setAlternativeItemGroup( @Nullable final String alternativeItemGroup )
    {
        rememberChangedField("AlternativeItemGroup", this.alternativeItemGroup);
        this.alternativeItemGroup = alternativeItemGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeItemStrategy</b>
     * </p>
     *
     * @param alternativeItemStrategy
     *            Alternative Item Strategy
     */
    public void setAlternativeItemStrategy( @Nullable final String alternativeItemStrategy )
    {
        rememberChangedField("AlternativeItemStrategy", this.alternativeItemStrategy);
        this.alternativeItemStrategy = alternativeItemStrategy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeItemPriority</b>
     * </p>
     *
     * @param alternativeItemPriority
     *            Alternative Item Priority
     */
    public void setAlternativeItemPriority( @Nullable final String alternativeItemPriority )
    {
        rememberChangedField("AlternativeItemPriority", this.alternativeItemPriority);
        this.alternativeItemPriority = alternativeItemPriority;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>UsageProbabilityPercent</b>
     * </p>
     *
     * @param usageProbabilityPercent
     *            Usage Probability in % (Alternative Item)
     */
    public void setUsageProbabilityPercent( @Nullable final BigDecimal usageProbabilityPercent )
    {
        rememberChangedField("UsageProbabilityPercent", this.usageProbabilityPercent);
        this.usageProbabilityPercent = usageProbabilityPercent;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialComponentIsPhantomItem</b>
     * </p>
     *
     * @param materialComponentIsPhantomItem
     *            Phantom Item Indicator
     */
    public void setMaterialComponentIsPhantomItem( @Nullable final Boolean materialComponentIsPhantomItem )
    {
        rememberChangedField("MaterialComponentIsPhantomItem", this.materialComponentIsPhantomItem);
        this.materialComponentIsPhantomItem = materialComponentIsPhantomItem;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeOffset</b>
     * </p>
     *
     * @param leadTimeOffset
     *            Lead-Time Offset
     */
    public void setLeadTimeOffset( @Nullable final BigDecimal leadTimeOffset )
    {
        rememberChangedField("LeadTimeOffset", this.leadTimeOffset);
        this.leadTimeOffset = leadTimeOffset;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsFixed</b>
     * </p>
     *
     * @param quantityIsFixed
     *            Quantity is fixed
     */
    public void setQuantityIsFixed( @Nullable final Boolean quantityIsFixed )
    {
        rememberChangedField("QuantityIsFixed", this.quantityIsFixed);
        this.quantityIsFixed = quantityIsFixed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNetScrap</b>
     * </p>
     *
     * @param isNetScrap
     *            Net Scrap Indicator
     */
    public void setIsNetScrap( @Nullable final Boolean isNetScrap )
    {
        rememberChangedField("IsNetScrap", this.isNetScrap);
        this.isNetScrap = isNetScrap;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ComponentScrapInPercent</b>
     * </p>
     *
     * @param componentScrapInPercent
     *            Component Scrap in Percent
     */
    public void setComponentScrapInPercent( @Nullable final BigDecimal componentScrapInPercent )
    {
        rememberChangedField("ComponentScrapInPercent", this.componentScrapInPercent);
        this.componentScrapInPercent = componentScrapInPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>OperationScrapInPercent</b>
     * </p>
     *
     * @param operationScrapInPercent
     *            Operation Scrap
     */
    public void setOperationScrapInPercent( @Nullable final BigDecimal operationScrapInPercent )
    {
        rememberChangedField("OperationScrapInPercent", this.operationScrapInPercent);
        this.operationScrapInPercent = operationScrapInPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnitISOCode</b>
     * </p>
     *
     * @param baseUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setBaseUnitISOCode( @Nullable final String baseUnitISOCode )
    {
        rememberChangedField("BaseUnitISOCode", this.baseUnitISOCode);
        this.baseUnitISOCode = baseUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnitSAPCode</b>
     * </p>
     *
     * @param baseUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setBaseUnitSAPCode( @Nullable final String baseUnitSAPCode )
    {
        rememberChangedField("BaseUnitSAPCode", this.baseUnitSAPCode);
        this.baseUnitSAPCode = baseUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequiredQuantity</b>
     * </p>
     *
     * @param requiredQuantity
     *            Requirement Quantity
     */
    public void setRequiredQuantity( @Nullable final BigDecimal requiredQuantity )
    {
        rememberChangedField("RequiredQuantity", this.requiredQuantity);
        this.requiredQuantity = requiredQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantity</b>
     * </p>
     *
     * @param withdrawnQuantity
     *            Withdrawn Quantity
     */
    public void setWithdrawnQuantity( @Nullable final BigDecimal withdrawnQuantity )
    {
        rememberChangedField("WithdrawnQuantity", this.withdrawnQuantity);
        this.withdrawnQuantity = withdrawnQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedAvailableQuantity</b>
     * </p>
     *
     * @param confirmedAvailableQuantity
     *            Available Quantity
     */
    public void setConfirmedAvailableQuantity( @Nullable final BigDecimal confirmedAvailableQuantity )
    {
        rememberChangedField("ConfirmedAvailableQuantity", this.confirmedAvailableQuantity);
        this.confirmedAvailableQuantity = confirmedAvailableQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCompOriginalQuantity</b>
     * </p>
     *
     * @param materialCompOriginalQuantity
     *            Original Quantity of a Material Component
     */
    public void setMaterialCompOriginalQuantity( @Nullable final BigDecimal materialCompOriginalQuantity )
    {
        rememberChangedField("MaterialCompOriginalQuantity", this.materialCompOriginalQuantity);
        this.materialCompOriginalQuantity = materialCompOriginalQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @param entryUnit
     *            Unit of entry
     */
    public void setEntryUnit( @Nullable final String entryUnit )
    {
        rememberChangedField("EntryUnit", this.entryUnit);
        this.entryUnit = entryUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnitISOCode</b>
     * </p>
     *
     * @param entryUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setEntryUnitISOCode( @Nullable final String entryUnitISOCode )
    {
        rememberChangedField("EntryUnitISOCode", this.entryUnitISOCode);
        this.entryUnitISOCode = entryUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnitSAPCode</b>
     * </p>
     *
     * @param entryUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setEntryUnitSAPCode( @Nullable final String entryUnitSAPCode )
    {
        rememberChangedField("EntryUnitSAPCode", this.entryUnitSAPCode);
        this.entryUnitSAPCode = entryUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementEntryQty</b>
     * </p>
     *
     * @param goodsMovementEntryQty
     *            Quantity in Unit of Entry
     */
    public void setGoodsMovementEntryQty( @Nullable final BigDecimal goodsMovementEntryQty )
    {
        rememberChangedField("GoodsMovementEntryQty", this.goodsMovementEntryQty);
        this.goodsMovementEntryQty = goodsMovementEntryQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantityAmount</b>
     * </p>
     *
     * @param withdrawnQuantityAmount
     *            Value Withdrawn
     */
    public void setWithdrawnQuantityAmount( @Nullable final BigDecimal withdrawnQuantityAmount )
    {
        rememberChangedField("WithdrawnQuantityAmount", this.withdrawnQuantityAmount);
        this.withdrawnQuantityAmount = withdrawnQuantityAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            The lastChangeDateTime to set.
     */
    public void setLastChangeDateTime( @Nullable final String lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductionOrderComponent_4";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Reservation", getReservation());
        result.put("ReservationItem", getReservationItem());
        result.put("ReservationRecordType", getReservationRecordType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Reservation", getReservation());
        values.put("ReservationItem", getReservationItem());
        values.put("ReservationRecordType", getReservationRecordType());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        values.put("ManufacturingOrderType", getManufacturingOrderType());
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("ManufacturingOrderSequence", getManufacturingOrderSequence());
        values.put("ManufacturingOrderOperation", getManufacturingOrderOperation());
        values.put("ProductionPlant", getProductionPlant());
        values.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        values.put("MatlCompRequirementDate", getMatlCompRequirementDate());
        values.put("MatlCompRequirementTime", getMatlCompRequirementTime());
        values.put("ReservationIsFinallyIssued", getReservationIsFinallyIssued());
        values.put("MatlCompIsMarkedForDeletion", getMatlCompIsMarkedForDeletion());
        values.put("IsBulkMaterialComponent", getIsBulkMaterialComponent());
        values.put("MatlCompIsMarkedForBackflush", getMatlCompIsMarkedForBackflush());
        values.put("MaterialCompIsCostRelevant", getMaterialCompIsCostRelevant());
        values.put("OrderComponentLongText", getOrderComponentLongText());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("MatlCompFreeDefinedAttribute", getMatlCompFreeDefinedAttribute());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("BOMItem", getBOMItem());
        values.put("BOMItemCategory", getBOMItemCategory());
        values.put("BillOfMaterialItemNumber", getBillOfMaterialItemNumber());
        values.put("BOMItemDescription", getBOMItemDescription());
        values.put("StorageLocation", getStorageLocation());
        values.put("Batch", getBatch());
        values.put("BatchSplitType", getBatchSplitType());
        values.put("GoodsMovementType", getGoodsMovementType());
        values.put("SupplyArea", getSupplyArea());
        values.put("GoodsRecipientName", getGoodsRecipientName());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("MaterialCompIsAlternativeItem", getMaterialCompIsAlternativeItem());
        values.put("AlternativeItemGroup", getAlternativeItemGroup());
        values.put("AlternativeItemStrategy", getAlternativeItemStrategy());
        values.put("AlternativeItemPriority", getAlternativeItemPriority());
        values.put("UsageProbabilityPercent", getUsageProbabilityPercent());
        values.put("MaterialComponentIsPhantomItem", getMaterialComponentIsPhantomItem());
        values.put("LeadTimeOffset", getLeadTimeOffset());
        values.put("QuantityIsFixed", getQuantityIsFixed());
        values.put("IsNetScrap", getIsNetScrap());
        values.put("ComponentScrapInPercent", getComponentScrapInPercent());
        values.put("OperationScrapInPercent", getOperationScrapInPercent());
        values.put("BaseUnit", getBaseUnit());
        values.put("BaseUnitISOCode", getBaseUnitISOCode());
        values.put("BaseUnitSAPCode", getBaseUnitSAPCode());
        values.put("RequiredQuantity", getRequiredQuantity());
        values.put("WithdrawnQuantity", getWithdrawnQuantity());
        values.put("ConfirmedAvailableQuantity", getConfirmedAvailableQuantity());
        values.put("MaterialCompOriginalQuantity", getMaterialCompOriginalQuantity());
        values.put("EntryUnit", getEntryUnit());
        values.put("EntryUnitISOCode", getEntryUnitISOCode());
        values.put("EntryUnitSAPCode", getEntryUnitSAPCode());
        values.put("GoodsMovementEntryQty", getGoodsMovementEntryQty());
        values.put("Currency", getCurrency());
        values.put("WithdrawnQuantityAmount", getWithdrawnQuantityAmount());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("ReservationRecordType") ) {
                final Object value = values.remove("ReservationRecordType");
                if( (value == null) || (!value.equals(getReservationRecordType())) ) {
                    setReservationRecordType(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderCategory") ) {
                final Object value = values.remove("ManufacturingOrderCategory");
                if( (value == null) || (!value.equals(getManufacturingOrderCategory())) ) {
                    setManufacturingOrderCategory(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderType") ) {
                final Object value = values.remove("ManufacturingOrderType");
                if( (value == null) || (!value.equals(getManufacturingOrderType())) ) {
                    setManufacturingOrderType(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderSequence") ) {
                final Object value = values.remove("ManufacturingOrderSequence");
                if( (value == null) || (!value.equals(getManufacturingOrderSequence())) ) {
                    setManufacturingOrderSequence(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderOperation") ) {
                final Object value = values.remove("ManufacturingOrderOperation");
                if( (value == null) || (!value.equals(getManufacturingOrderOperation())) ) {
                    setManufacturingOrderOperation(((String) value));
                }
            }
            if( values.containsKey("ProductionPlant") ) {
                final Object value = values.remove("ProductionPlant");
                if( (value == null) || (!value.equals(getProductionPlant())) ) {
                    setProductionPlant(((String) value));
                }
            }
            if( values.containsKey("OrderInternalBillOfOperations") ) {
                final Object value = values.remove("OrderInternalBillOfOperations");
                if( (value == null) || (!value.equals(getOrderInternalBillOfOperations())) ) {
                    setOrderInternalBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("MatlCompRequirementDate") ) {
                final Object value = values.remove("MatlCompRequirementDate");
                if( (value == null) || (!value.equals(getMatlCompRequirementDate())) ) {
                    setMatlCompRequirementDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MatlCompRequirementTime") ) {
                final Object value = values.remove("MatlCompRequirementTime");
                if( (value == null) || (!value.equals(getMatlCompRequirementTime())) ) {
                    setMatlCompRequirementTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ReservationIsFinallyIssued") ) {
                final Object value = values.remove("ReservationIsFinallyIssued");
                if( (value == null) || (!value.equals(getReservationIsFinallyIssued())) ) {
                    setReservationIsFinallyIssued(((Boolean) value));
                }
            }
            if( values.containsKey("MatlCompIsMarkedForDeletion") ) {
                final Object value = values.remove("MatlCompIsMarkedForDeletion");
                if( (value == null) || (!value.equals(getMatlCompIsMarkedForDeletion())) ) {
                    setMatlCompIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("IsBulkMaterialComponent") ) {
                final Object value = values.remove("IsBulkMaterialComponent");
                if( (value == null) || (!value.equals(getIsBulkMaterialComponent())) ) {
                    setIsBulkMaterialComponent(((Boolean) value));
                }
            }
            if( values.containsKey("MatlCompIsMarkedForBackflush") ) {
                final Object value = values.remove("MatlCompIsMarkedForBackflush");
                if( (value == null) || (!value.equals(getMatlCompIsMarkedForBackflush())) ) {
                    setMatlCompIsMarkedForBackflush(((Boolean) value));
                }
            }
            if( values.containsKey("MaterialCompIsCostRelevant") ) {
                final Object value = values.remove("MaterialCompIsCostRelevant");
                if( (value == null) || (!value.equals(getMaterialCompIsCostRelevant())) ) {
                    setMaterialCompIsCostRelevant(((String) value));
                }
            }
            if( values.containsKey("OrderComponentLongText") ) {
                final Object value = values.remove("OrderComponentLongText");
                if( (value == null) || (!value.equals(getOrderComponentLongText())) ) {
                    setOrderComponentLongText(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("MatlCompFreeDefinedAttribute") ) {
                final Object value = values.remove("MatlCompFreeDefinedAttribute");
                if( (value == null) || (!value.equals(getMatlCompFreeDefinedAttribute())) ) {
                    setMatlCompFreeDefinedAttribute(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("BOMItem") ) {
                final Object value = values.remove("BOMItem");
                if( (value == null) || (!value.equals(getBOMItem())) ) {
                    setBOMItem(((String) value));
                }
            }
            if( values.containsKey("BOMItemCategory") ) {
                final Object value = values.remove("BOMItemCategory");
                if( (value == null) || (!value.equals(getBOMItemCategory())) ) {
                    setBOMItemCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNumber())) ) {
                    setBillOfMaterialItemNumber(((String) value));
                }
            }
            if( values.containsKey("BOMItemDescription") ) {
                final Object value = values.remove("BOMItemDescription");
                if( (value == null) || (!value.equals(getBOMItemDescription())) ) {
                    setBOMItemDescription(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("BatchSplitType") ) {
                final Object value = values.remove("BatchSplitType");
                if( (value == null) || (!value.equals(getBatchSplitType())) ) {
                    setBatchSplitType(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementType") ) {
                final Object value = values.remove("GoodsMovementType");
                if( (value == null) || (!value.equals(getGoodsMovementType())) ) {
                    setGoodsMovementType(((String) value));
                }
            }
            if( values.containsKey("SupplyArea") ) {
                final Object value = values.remove("SupplyArea");
                if( (value == null) || (!value.equals(getSupplyArea())) ) {
                    setSupplyArea(((String) value));
                }
            }
            if( values.containsKey("GoodsRecipientName") ) {
                final Object value = values.remove("GoodsRecipientName");
                if( (value == null) || (!value.equals(getGoodsRecipientName())) ) {
                    setGoodsRecipientName(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("MaterialCompIsAlternativeItem") ) {
                final Object value = values.remove("MaterialCompIsAlternativeItem");
                if( (value == null) || (!value.equals(getMaterialCompIsAlternativeItem())) ) {
                    setMaterialCompIsAlternativeItem(((Boolean) value));
                }
            }
            if( values.containsKey("AlternativeItemGroup") ) {
                final Object value = values.remove("AlternativeItemGroup");
                if( (value == null) || (!value.equals(getAlternativeItemGroup())) ) {
                    setAlternativeItemGroup(((String) value));
                }
            }
            if( values.containsKey("AlternativeItemStrategy") ) {
                final Object value = values.remove("AlternativeItemStrategy");
                if( (value == null) || (!value.equals(getAlternativeItemStrategy())) ) {
                    setAlternativeItemStrategy(((String) value));
                }
            }
            if( values.containsKey("AlternativeItemPriority") ) {
                final Object value = values.remove("AlternativeItemPriority");
                if( (value == null) || (!value.equals(getAlternativeItemPriority())) ) {
                    setAlternativeItemPriority(((String) value));
                }
            }
            if( values.containsKey("UsageProbabilityPercent") ) {
                final Object value = values.remove("UsageProbabilityPercent");
                if( (value == null) || (!value.equals(getUsageProbabilityPercent())) ) {
                    setUsageProbabilityPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialComponentIsPhantomItem") ) {
                final Object value = values.remove("MaterialComponentIsPhantomItem");
                if( (value == null) || (!value.equals(getMaterialComponentIsPhantomItem())) ) {
                    setMaterialComponentIsPhantomItem(((Boolean) value));
                }
            }
            if( values.containsKey("LeadTimeOffset") ) {
                final Object value = values.remove("LeadTimeOffset");
                if( (value == null) || (!value.equals(getLeadTimeOffset())) ) {
                    setLeadTimeOffset(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityIsFixed") ) {
                final Object value = values.remove("QuantityIsFixed");
                if( (value == null) || (!value.equals(getQuantityIsFixed())) ) {
                    setQuantityIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("IsNetScrap") ) {
                final Object value = values.remove("IsNetScrap");
                if( (value == null) || (!value.equals(getIsNetScrap())) ) {
                    setIsNetScrap(((Boolean) value));
                }
            }
            if( values.containsKey("ComponentScrapInPercent") ) {
                final Object value = values.remove("ComponentScrapInPercent");
                if( (value == null) || (!value.equals(getComponentScrapInPercent())) ) {
                    setComponentScrapInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("OperationScrapInPercent") ) {
                final Object value = values.remove("OperationScrapInPercent");
                if( (value == null) || (!value.equals(getOperationScrapInPercent())) ) {
                    setOperationScrapInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("BaseUnitISOCode") ) {
                final Object value = values.remove("BaseUnitISOCode");
                if( (value == null) || (!value.equals(getBaseUnitISOCode())) ) {
                    setBaseUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("BaseUnitSAPCode") ) {
                final Object value = values.remove("BaseUnitSAPCode");
                if( (value == null) || (!value.equals(getBaseUnitSAPCode())) ) {
                    setBaseUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("RequiredQuantity") ) {
                final Object value = values.remove("RequiredQuantity");
                if( (value == null) || (!value.equals(getRequiredQuantity())) ) {
                    setRequiredQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("WithdrawnQuantity") ) {
                final Object value = values.remove("WithdrawnQuantity");
                if( (value == null) || (!value.equals(getWithdrawnQuantity())) ) {
                    setWithdrawnQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConfirmedAvailableQuantity") ) {
                final Object value = values.remove("ConfirmedAvailableQuantity");
                if( (value == null) || (!value.equals(getConfirmedAvailableQuantity())) ) {
                    setConfirmedAvailableQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialCompOriginalQuantity") ) {
                final Object value = values.remove("MaterialCompOriginalQuantity");
                if( (value == null) || (!value.equals(getMaterialCompOriginalQuantity())) ) {
                    setMaterialCompOriginalQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("EntryUnit") ) {
                final Object value = values.remove("EntryUnit");
                if( (value == null) || (!value.equals(getEntryUnit())) ) {
                    setEntryUnit(((String) value));
                }
            }
            if( values.containsKey("EntryUnitISOCode") ) {
                final Object value = values.remove("EntryUnitISOCode");
                if( (value == null) || (!value.equals(getEntryUnitISOCode())) ) {
                    setEntryUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("EntryUnitSAPCode") ) {
                final Object value = values.remove("EntryUnitSAPCode");
                if( (value == null) || (!value.equals(getEntryUnitSAPCode())) ) {
                    setEntryUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementEntryQty") ) {
                final Object value = values.remove("GoodsMovementEntryQty");
                if( (value == null) || (!value.equals(getGoodsMovementEntryQty())) ) {
                    setGoodsMovementEntryQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("WithdrawnQuantityAmount") ) {
                final Object value = values.remove("WithdrawnQuantityAmount");
                if( (value == null) || (!value.equals(getWithdrawnQuantityAmount())) ) {
                    setWithdrawnQuantityAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProductionOrderComponent_4Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ProductionOrderComponent_4Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductionOrderComponent_4Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductionOrderComponent_4Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderV2Service.DEFAULT_SERVICE_PATH);
    }

}
