/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.selectable.ProductionOrderComponent_4Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
 * ProductionOrderComponent_4} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ProductionOrderComponent_4ByKeyFluentHelper
    extends
    FluentHelperByKey<ProductionOrderComponent_4ByKeyFluentHelper, ProductionOrderComponent_4, ProductionOrderComponent_4Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
     * ProductionOrderComponent_4} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProductionOrderComponent_4}
     * @param reservationItem
     *            Reservation Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProductionOrderComponent_4}
     * @param reservation
     *            Number of reservation/dependent requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param reservationRecordType
     *            Reservation Record Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public ProductionOrderComponent_4ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String reservation,
        final String reservationItem,
        final String reservationRecordType )
    {
        super(servicePath, entityCollection);
        this.key.put("Reservation", reservation);
        this.key.put("ReservationItem", reservationItem);
        this.key.put("ReservationRecordType", reservationRecordType);
    }

    @Override
    @Nonnull
    protected Class<ProductionOrderComponent_4> getEntityClass()
    {
        return ProductionOrderComponent_4.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
