/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
 * ProductionOrderComponent_4} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ProductionOrderComponent_4UpdateFluentHelper
    extends
    FluentHelperUpdate<ProductionOrderComponent_4UpdateFluentHelper, ProductionOrderComponent_4>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
     * ProductionOrderComponent_4} entity object that will be updated in the S/4HANA system.
     *
     */
    private final ProductionOrderComponent_4 entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
     * ProductionOrderComponent_4} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The ProductionOrderComponent_4 to take the updated values from.
     */
    public ProductionOrderComponent_4UpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ProductionOrderComponent_4 entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ProductionOrderComponent_4 getEntity()
    {
        return entity;
    }

}
