/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.field.ProductionOrderOperation_2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.selectable.ProductionOrderOperation_2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Production Order Operations
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductionOrderOperation_2Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductionOrderOperation_2 extends VdmEntity<ProductionOrderOperation_2>
{

    /**
     * Selector for all available fields of ProductionOrderOperation_2.
     *
     */
    public final static ProductionOrderOperation_2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @return Order Internal ID
     */
    @Key
    @SerializedName( "OrderInternalBillOfOperations" )
    @JsonProperty( "OrderInternalBillOfOperations" )
    @Nullable
    @ODataField( odataName = "OrderInternalBillOfOperations" )
    private String orderInternalBillOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalBillOfOperations</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> ORDER_INTERNAL_BILL_OF_OPERATIONS =
        new ProductionOrderOperation_2Field<String>("OrderInternalBillOfOperations");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     * </p>
     *
     * @return Internal Identifier of an Operation or Activity
     */
    @Key
    @SerializedName( "OrderIntBillOfOperationsItem" )
    @JsonProperty( "OrderIntBillOfOperationsItem" )
    @Nullable
    @ODataField( odataName = "OrderIntBillOfOperationsItem" )
    private String orderIntBillOfOperationsItem;
    /**
     * Use with available fluent helpers to apply the <b>OrderIntBillOfOperationsItem</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> ORDER_INT_BILL_OF_OPERATIONS_ITEM =
        new ProductionOrderOperation_2Field<String>("OrderIntBillOfOperationsItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Production Order
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> MANUFACTURING_ORDER =
        new ProductionOrderOperation_2Field<String>("ManufacturingOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @return Manufacturing Order Sequence
     */
    @SerializedName( "ManufacturingOrderSequence" )
    @JsonProperty( "ManufacturingOrderSequence" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderSequence" )
    private String manufacturingOrderSequence;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderSequence</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> MANUFACTURING_ORDER_SEQUENCE =
        new ProductionOrderOperation_2Field<String>("ManufacturingOrderSequence");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderSequenceText</b>
     * </p>
     *
     * @return Manufacturing Order Sequence Text
     */
    @SerializedName( "MfgOrderSequenceText" )
    @JsonProperty( "MfgOrderSequenceText" )
    @Nullable
    @ODataField( odataName = "MfgOrderSequenceText" )
    private String mfgOrderSequenceText;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderSequenceText</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> MFG_ORDER_SEQUENCE_TEXT =
        new ProductionOrderOperation_2Field<String>("MfgOrderSequenceText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @return Manufacturing Order Operation
     */
    @SerializedName( "ManufacturingOrderOperation" )
    @JsonProperty( "ManufacturingOrderOperation" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderOperation" )
    private String manufacturingOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderOperation</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> MANUFACTURING_ORDER_OPERATION =
        new ProductionOrderOperation_2Field<String>("ManufacturingOrderOperation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSubOperation</b>
     * </p>
     *
     * @return Manufacturing Order Suboperation
     */
    @SerializedName( "ManufacturingOrderSubOperation" )
    @JsonProperty( "ManufacturingOrderSubOperation" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderSubOperation" )
    private String manufacturingOrderSubOperation;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderSubOperation</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> MANUFACTURING_ORDER_SUB_OPERATION =
        new ProductionOrderOperation_2Field<String>("ManufacturingOrderSubOperation");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @return Manufacturing Order Category
     */
    @SerializedName( "ManufacturingOrderCategory" )
    @JsonProperty( "ManufacturingOrderCategory" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderCategory" )
    private String manufacturingOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderCategory</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> MANUFACTURING_ORDER_CATEGORY =
        new ProductionOrderOperation_2Field<String>("ManufacturingOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @return Manufacturing Order Type
     */
    @SerializedName( "ManufacturingOrderType" )
    @JsonProperty( "ManufacturingOrderType" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderType" )
    private String manufacturingOrderType;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderType</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> MANUFACTURING_ORDER_TYPE =
        new ProductionOrderOperation_2Field<String>("ManufacturingOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderOperationText</b>
     * </p>
     *
     * @return Manufacturing Order Operation Text
     */
    @SerializedName( "MfgOrderOperationText" )
    @JsonProperty( "MfgOrderOperationText" )
    @Nullable
    @ODataField( odataName = "MfgOrderOperationText" )
    private String mfgOrderOperationText;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderOperationText</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> MFG_ORDER_OPERATION_TEXT =
        new ProductionOrderOperation_2Field<String>("MfgOrderOperationText");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderOperationLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "OrderOperationLongText" )
    @JsonProperty( "OrderOperationLongText" )
    @Nullable
    @ODataField( odataName = "OrderOperationLongText" )
    private String orderOperationLongText;
    /**
     * Use with available fluent helpers to apply the <b>OrderOperationLongText</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> ORDER_OPERATION_LONG_TEXT =
        new ProductionOrderOperation_2Field<String>("OrderOperationLongText");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderSequenceLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "OrderSequenceLongText" )
    @JsonProperty( "OrderSequenceLongText" )
    @Nullable
    @ODataField( odataName = "OrderSequenceLongText" )
    private String orderSequenceLongText;
    /**
     * Use with available fluent helpers to apply the <b>OrderSequenceLongText</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> ORDER_SEQUENCE_LONG_TEXT =
        new ProductionOrderOperation_2Field<String>("OrderSequenceLongText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsCreated</b>
     * </p>
     *
     * @return The operationIsCreated contained in this entity.
     */
    @SerializedName( "OperationIsCreated" )
    @JsonProperty( "OperationIsCreated" )
    @Nullable
    @ODataField( odataName = "OperationIsCreated" )
    private String operationIsCreated;
    /**
     * Use with available fluent helpers to apply the <b>OperationIsCreated</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_IS_CREATED =
        new ProductionOrderOperation_2Field<String>("OperationIsCreated");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsReleased</b>
     * </p>
     *
     * @return The operationIsReleased contained in this entity.
     */
    @SerializedName( "OperationIsReleased" )
    @JsonProperty( "OperationIsReleased" )
    @Nullable
    @ODataField( odataName = "OperationIsReleased" )
    private String operationIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>OperationIsReleased</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_IS_RELEASED =
        new ProductionOrderOperation_2Field<String>("OperationIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsPrinted</b>
     * </p>
     *
     * @return The operationIsPrinted contained in this entity.
     */
    @SerializedName( "OperationIsPrinted" )
    @JsonProperty( "OperationIsPrinted" )
    @Nullable
    @ODataField( odataName = "OperationIsPrinted" )
    private String operationIsPrinted;
    /**
     * Use with available fluent helpers to apply the <b>OperationIsPrinted</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_IS_PRINTED =
        new ProductionOrderOperation_2Field<String>("OperationIsPrinted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsConfirmed</b>
     * </p>
     *
     * @return The operationIsConfirmed contained in this entity.
     */
    @SerializedName( "OperationIsConfirmed" )
    @JsonProperty( "OperationIsConfirmed" )
    @Nullable
    @ODataField( odataName = "OperationIsConfirmed" )
    private String operationIsConfirmed;
    /**
     * Use with available fluent helpers to apply the <b>OperationIsConfirmed</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_IS_CONFIRMED =
        new ProductionOrderOperation_2Field<String>("OperationIsConfirmed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsPartiallyConfirmed</b>
     * </p>
     *
     * @return The operationIsPartiallyConfirmed contained in this entity.
     */
    @SerializedName( "OperationIsPartiallyConfirmed" )
    @JsonProperty( "OperationIsPartiallyConfirmed" )
    @Nullable
    @ODataField( odataName = "OperationIsPartiallyConfirmed" )
    private String operationIsPartiallyConfirmed;
    /**
     * Use with available fluent helpers to apply the <b>OperationIsPartiallyConfirmed</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_IS_PARTIALLY_CONFIRMED =
        new ProductionOrderOperation_2Field<String>("OperationIsPartiallyConfirmed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsDeleted</b>
     * </p>
     *
     * @return The operationIsDeleted contained in this entity.
     */
    @SerializedName( "OperationIsDeleted" )
    @JsonProperty( "OperationIsDeleted" )
    @Nullable
    @ODataField( odataName = "OperationIsDeleted" )
    private String operationIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>OperationIsDeleted</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_IS_DELETED =
        new ProductionOrderOperation_2Field<String>("OperationIsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsTechlyCompleted</b>
     * </p>
     *
     * @return The operationIsTechlyCompleted contained in this entity.
     */
    @SerializedName( "OperationIsTechlyCompleted" )
    @JsonProperty( "OperationIsTechlyCompleted" )
    @Nullable
    @ODataField( odataName = "OperationIsTechlyCompleted" )
    private String operationIsTechlyCompleted;
    /**
     * Use with available fluent helpers to apply the <b>OperationIsTechlyCompleted</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_IS_TECHLY_COMPLETED =
        new ProductionOrderOperation_2Field<String>("OperationIsTechlyCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsClosed</b>
     * </p>
     *
     * @return The operationIsClosed contained in this entity.
     */
    @SerializedName( "OperationIsClosed" )
    @JsonProperty( "OperationIsClosed" )
    @Nullable
    @ODataField( odataName = "OperationIsClosed" )
    private String operationIsClosed;
    /**
     * Use with available fluent helpers to apply the <b>OperationIsClosed</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_IS_CLOSED =
        new ProductionOrderOperation_2Field<String>("OperationIsClosed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsScheduled</b>
     * </p>
     *
     * @return The operationIsScheduled contained in this entity.
     */
    @SerializedName( "OperationIsScheduled" )
    @JsonProperty( "OperationIsScheduled" )
    @Nullable
    @ODataField( odataName = "OperationIsScheduled" )
    private String operationIsScheduled;
    /**
     * Use with available fluent helpers to apply the <b>OperationIsScheduled</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_IS_SCHEDULED =
        new ProductionOrderOperation_2Field<String>("OperationIsScheduled");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsPartiallyDelivered</b>
     * </p>
     *
     * @return The operationIsPartiallyDelivered contained in this entity.
     */
    @SerializedName( "OperationIsPartiallyDelivered" )
    @JsonProperty( "OperationIsPartiallyDelivered" )
    @Nullable
    @ODataField( odataName = "OperationIsPartiallyDelivered" )
    private String operationIsPartiallyDelivered;
    /**
     * Use with available fluent helpers to apply the <b>OperationIsPartiallyDelivered</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_IS_PARTIALLY_DELIVERED =
        new ProductionOrderOperation_2Field<String>("OperationIsPartiallyDelivered");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsDelivered</b>
     * </p>
     *
     * @return The operationIsDelivered contained in this entity.
     */
    @SerializedName( "OperationIsDelivered" )
    @JsonProperty( "OperationIsDelivered" )
    @Nullable
    @ODataField( odataName = "OperationIsDelivered" )
    private String operationIsDelivered;
    /**
     * Use with available fluent helpers to apply the <b>OperationIsDelivered</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_IS_DELIVERED =
        new ProductionOrderOperation_2Field<String>("OperationIsDelivered");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @return Production Plant
     */
    @SerializedName( "ProductionPlant" )
    @JsonProperty( "ProductionPlant" )
    @Nullable
    @ODataField( odataName = "ProductionPlant" )
    private String productionPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPlant</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> PRODUCTION_PLANT =
        new ProductionOrderOperation_2Field<String>("ProductionPlant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Work Center Internal ID
     */
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> WORK_CENTER_INTERNAL_ID =
        new ProductionOrderOperation_2Field<String>("WorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Work Center Type Code
     */
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> WORK_CENTER_TYPE_CODE =
        new ProductionOrderOperation_2Field<String>("WorkCenterTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> WORK_CENTER =
        new ProductionOrderOperation_2Field<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @return Operation Control Profile
     */
    @SerializedName( "OperationControlProfile" )
    @JsonProperty( "OperationControlProfile" )
    @Nullable
    @ODataField( odataName = "OperationControlProfile" )
    private String operationControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>OperationControlProfile</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_CONTROL_PROFILE =
        new ProductionOrderOperation_2Field<String>("OperationControlProfile");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtDte</b>
     * </p>
     *
     * @return Earliest Scheduled Execution Start Date
     */
    @SerializedName( "OpErlstSchedldExecStrtDte" )
    @JsonProperty( "OpErlstSchedldExecStrtDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecStrtDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opErlstSchedldExecStrtDte;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecStrtDte</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<LocalDateTime> OP_ERLST_SCHEDLD_EXEC_STRT_DTE =
        new ProductionOrderOperation_2Field<LocalDateTime>("OpErlstSchedldExecStrtDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtTme</b>
     * </p>
     *
     * @return Earliest Scheduled Execution Start Time
     */
    @SerializedName( "OpErlstSchedldExecStrtTme" )
    @JsonProperty( "OpErlstSchedldExecStrtTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecStrtTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opErlstSchedldExecStrtTme;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecStrtTme</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<LocalTime> OP_ERLST_SCHEDLD_EXEC_STRT_TME =
        new ProductionOrderOperation_2Field<LocalTime>("OpErlstSchedldExecStrtTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndDte</b>
     * </p>
     *
     * @return Earliest Scheduled Execution End Date
     */
    @SerializedName( "OpErlstSchedldExecEndDte" )
    @JsonProperty( "OpErlstSchedldExecEndDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecEndDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opErlstSchedldExecEndDte;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecEndDte</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<LocalDateTime> OP_ERLST_SCHEDLD_EXEC_END_DTE =
        new ProductionOrderOperation_2Field<LocalDateTime>("OpErlstSchedldExecEndDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndTme</b>
     * </p>
     *
     * @return Earliest Scheduled Execution End Time
     */
    @SerializedName( "OpErlstSchedldExecEndTme" )
    @JsonProperty( "OpErlstSchedldExecEndTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecEndTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opErlstSchedldExecEndTme;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecEndTme</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<LocalTime> OP_ERLST_SCHEDLD_EXEC_END_TME =
        new ProductionOrderOperation_2Field<LocalTime>("OpErlstSchedldExecEndTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionStartDate</b>
     * </p>
     *
     * @return Confirmed Start Date of Execution
     */
    @SerializedName( "OpActualExecutionStartDate" )
    @JsonProperty( "OpActualExecutionStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpActualExecutionStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opActualExecutionStartDate;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionStartDate</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<LocalDateTime> OP_ACTUAL_EXECUTION_START_DATE =
        new ProductionOrderOperation_2Field<LocalDateTime>("OpActualExecutionStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionStartTime</b>
     * </p>
     *
     * @return Confirmed Start Time of Execution
     */
    @SerializedName( "OpActualExecutionStartTime" )
    @JsonProperty( "OpActualExecutionStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpActualExecutionStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opActualExecutionStartTime;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionStartTime</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<LocalTime> OP_ACTUAL_EXECUTION_START_TIME =
        new ProductionOrderOperation_2Field<LocalTime>("OpActualExecutionStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionEndDate</b>
     * </p>
     *
     * @return Confirmed End Date of Execution
     */
    @SerializedName( "OpActualExecutionEndDate" )
    @JsonProperty( "OpActualExecutionEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpActualExecutionEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opActualExecutionEndDate;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionEndDate</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<LocalDateTime> OP_ACTUAL_EXECUTION_END_DATE =
        new ProductionOrderOperation_2Field<LocalDateTime>("OpActualExecutionEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionEndTime</b>
     * </p>
     *
     * @return Confirmed End Time of Execution
     */
    @SerializedName( "OpActualExecutionEndTime" )
    @JsonProperty( "OpActualExecutionEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpActualExecutionEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opActualExecutionEndTime;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionEndTime</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<LocalTime> OP_ACTUAL_EXECUTION_END_TIME =
        new ProductionOrderOperation_2Field<LocalTime>("OpActualExecutionEndTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ErlstSchedldExecDurnInWorkdays</b>
     * </p>
     *
     * @return Earliest Scheduled Execution Duration in Workdays
     */
    @SerializedName( "ErlstSchedldExecDurnInWorkdays" )
    @JsonProperty( "ErlstSchedldExecDurnInWorkdays" )
    @Nullable
    @ODataField( odataName = "ErlstSchedldExecDurnInWorkdays" )
    private Integer erlstSchedldExecDurnInWorkdays;
    /**
     * Use with available fluent helpers to apply the <b>ErlstSchedldExecDurnInWorkdays</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<Integer> ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS =
        new ProductionOrderOperation_2Field<Integer>("ErlstSchedldExecDurnInWorkdays");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionDays</b>
     * </p>
     *
     * @return Actual Execution Duration in Workdays
     */
    @SerializedName( "OpActualExecutionDays" )
    @JsonProperty( "OpActualExecutionDays" )
    @Nullable
    @ODataField( odataName = "OpActualExecutionDays" )
    private Integer opActualExecutionDays;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionDays</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<Integer> OP_ACTUAL_EXECUTION_DAYS =
        new ProductionOrderOperation_2Field<Integer>("OpActualExecutionDays");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @return Operation Unit of Measure
     */
    @SerializedName( "OperationUnit" )
    @JsonProperty( "OperationUnit" )
    @Nullable
    @ODataField( odataName = "OperationUnit" )
    private String operationUnit;
    /**
     * Use with available fluent helpers to apply the <b>OperationUnit</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_UNIT =
        new ProductionOrderOperation_2Field<String>("OperationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "OperationUnitISOCode" )
    @JsonProperty( "OperationUnitISOCode" )
    @Nullable
    @ODataField( odataName = "OperationUnitISOCode" )
    private String operationUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>OperationUnitISOCode</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_UNIT_ISO_CODE =
        new ProductionOrderOperation_2Field<String>("OperationUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "OperationUnitSAPCode" )
    @JsonProperty( "OperationUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "OperationUnitSAPCode" )
    private String operationUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>OperationUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> OPERATION_UNIT_SAP_CODE =
        new ProductionOrderOperation_2Field<String>("OperationUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpPlannedTotalQuantity</b>
     * </p>
     *
     * @return Operation Total Quantity
     */
    @SerializedName( "OpPlannedTotalQuantity" )
    @JsonProperty( "OpPlannedTotalQuantity" )
    @Nullable
    @ODataField( odataName = "OpPlannedTotalQuantity" )
    private BigDecimal opPlannedTotalQuantity;
    /**
     * Use with available fluent helpers to apply the <b>OpPlannedTotalQuantity</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<BigDecimal> OP_PLANNED_TOTAL_QUANTITY =
        new ProductionOrderOperation_2Field<BigDecimal>("OpPlannedTotalQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpTotalConfirmedYieldQty</b>
     * </p>
     *
     * @return Total Confirmed Yield
     */
    @SerializedName( "OpTotalConfirmedYieldQty" )
    @JsonProperty( "OpTotalConfirmedYieldQty" )
    @Nullable
    @ODataField( odataName = "OpTotalConfirmedYieldQty" )
    private BigDecimal opTotalConfirmedYieldQty;
    /**
     * Use with available fluent helpers to apply the <b>OpTotalConfirmedYieldQty</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<BigDecimal> OP_TOTAL_CONFIRMED_YIELD_QTY =
        new ProductionOrderOperation_2Field<BigDecimal>("OpTotalConfirmedYieldQty");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return The lastChangeDateTime contained in this entity.
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @ODataField( odataName = "LastChangeDateTime" )
    private String lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProductionOrderOperation_2Field<String> LAST_CHANGE_DATE_TIME =
        new ProductionOrderOperation_2Field<String>("LastChangeDateTime");

    @Nonnull
    @Override
    public Class<ProductionOrderOperation_2> getType()
    {
        return ProductionOrderOperation_2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     */
    public void setOrderInternalBillOfOperations( @Nullable final String orderInternalBillOfOperations )
    {
        rememberChangedField("OrderInternalBillOfOperations", this.orderInternalBillOfOperations);
        this.orderInternalBillOfOperations = orderInternalBillOfOperations;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     * </p>
     *
     * @param orderIntBillOfOperationsItem
     *            Internal Identifier of an Operation or Activity
     */
    public void setOrderIntBillOfOperationsItem( @Nullable final String orderIntBillOfOperationsItem )
    {
        rememberChangedField("OrderIntBillOfOperationsItem", this.orderIntBillOfOperationsItem);
        this.orderIntBillOfOperationsItem = orderIntBillOfOperationsItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Production Order
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @param manufacturingOrderSequence
     *            Manufacturing Order Sequence
     */
    public void setManufacturingOrderSequence( @Nullable final String manufacturingOrderSequence )
    {
        rememberChangedField("ManufacturingOrderSequence", this.manufacturingOrderSequence);
        this.manufacturingOrderSequence = manufacturingOrderSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderSequenceText</b>
     * </p>
     *
     * @param mfgOrderSequenceText
     *            Manufacturing Order Sequence Text
     */
    public void setMfgOrderSequenceText( @Nullable final String mfgOrderSequenceText )
    {
        rememberChangedField("MfgOrderSequenceText", this.mfgOrderSequenceText);
        this.mfgOrderSequenceText = mfgOrderSequenceText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Manufacturing Order Operation
     */
    public void setManufacturingOrderOperation( @Nullable final String manufacturingOrderOperation )
    {
        rememberChangedField("ManufacturingOrderOperation", this.manufacturingOrderOperation);
        this.manufacturingOrderOperation = manufacturingOrderOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSubOperation</b>
     * </p>
     *
     * @param manufacturingOrderSubOperation
     *            Manufacturing Order Suboperation
     */
    public void setManufacturingOrderSubOperation( @Nullable final String manufacturingOrderSubOperation )
    {
        rememberChangedField("ManufacturingOrderSubOperation", this.manufacturingOrderSubOperation);
        this.manufacturingOrderSubOperation = manufacturingOrderSubOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     */
    public void setManufacturingOrderCategory( @Nullable final String manufacturingOrderCategory )
    {
        rememberChangedField("ManufacturingOrderCategory", this.manufacturingOrderCategory);
        this.manufacturingOrderCategory = manufacturingOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @param manufacturingOrderType
     *            Manufacturing Order Type
     */
    public void setManufacturingOrderType( @Nullable final String manufacturingOrderType )
    {
        rememberChangedField("ManufacturingOrderType", this.manufacturingOrderType);
        this.manufacturingOrderType = manufacturingOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderOperationText</b>
     * </p>
     *
     * @param mfgOrderOperationText
     *            Manufacturing Order Operation Text
     */
    public void setMfgOrderOperationText( @Nullable final String mfgOrderOperationText )
    {
        rememberChangedField("MfgOrderOperationText", this.mfgOrderOperationText);
        this.mfgOrderOperationText = mfgOrderOperationText;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderOperationLongText</b>
     * </p>
     *
     * @param orderOperationLongText
     *            Long Text
     */
    public void setOrderOperationLongText( @Nullable final String orderOperationLongText )
    {
        rememberChangedField("OrderOperationLongText", this.orderOperationLongText);
        this.orderOperationLongText = orderOperationLongText;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderSequenceLongText</b>
     * </p>
     *
     * @param orderSequenceLongText
     *            Long Text
     */
    public void setOrderSequenceLongText( @Nullable final String orderSequenceLongText )
    {
        rememberChangedField("OrderSequenceLongText", this.orderSequenceLongText);
        this.orderSequenceLongText = orderSequenceLongText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsCreated</b>
     * </p>
     *
     * @param operationIsCreated
     *            The operationIsCreated to set.
     */
    public void setOperationIsCreated( @Nullable final String operationIsCreated )
    {
        rememberChangedField("OperationIsCreated", this.operationIsCreated);
        this.operationIsCreated = operationIsCreated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsReleased</b>
     * </p>
     *
     * @param operationIsReleased
     *            The operationIsReleased to set.
     */
    public void setOperationIsReleased( @Nullable final String operationIsReleased )
    {
        rememberChangedField("OperationIsReleased", this.operationIsReleased);
        this.operationIsReleased = operationIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsPrinted</b>
     * </p>
     *
     * @param operationIsPrinted
     *            The operationIsPrinted to set.
     */
    public void setOperationIsPrinted( @Nullable final String operationIsPrinted )
    {
        rememberChangedField("OperationIsPrinted", this.operationIsPrinted);
        this.operationIsPrinted = operationIsPrinted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsConfirmed</b>
     * </p>
     *
     * @param operationIsConfirmed
     *            The operationIsConfirmed to set.
     */
    public void setOperationIsConfirmed( @Nullable final String operationIsConfirmed )
    {
        rememberChangedField("OperationIsConfirmed", this.operationIsConfirmed);
        this.operationIsConfirmed = operationIsConfirmed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsPartiallyConfirmed</b>
     * </p>
     *
     * @param operationIsPartiallyConfirmed
     *            The operationIsPartiallyConfirmed to set.
     */
    public void setOperationIsPartiallyConfirmed( @Nullable final String operationIsPartiallyConfirmed )
    {
        rememberChangedField("OperationIsPartiallyConfirmed", this.operationIsPartiallyConfirmed);
        this.operationIsPartiallyConfirmed = operationIsPartiallyConfirmed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsDeleted</b>
     * </p>
     *
     * @param operationIsDeleted
     *            The operationIsDeleted to set.
     */
    public void setOperationIsDeleted( @Nullable final String operationIsDeleted )
    {
        rememberChangedField("OperationIsDeleted", this.operationIsDeleted);
        this.operationIsDeleted = operationIsDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsTechlyCompleted</b>
     * </p>
     *
     * @param operationIsTechlyCompleted
     *            The operationIsTechlyCompleted to set.
     */
    public void setOperationIsTechlyCompleted( @Nullable final String operationIsTechlyCompleted )
    {
        rememberChangedField("OperationIsTechlyCompleted", this.operationIsTechlyCompleted);
        this.operationIsTechlyCompleted = operationIsTechlyCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsClosed</b>
     * </p>
     *
     * @param operationIsClosed
     *            The operationIsClosed to set.
     */
    public void setOperationIsClosed( @Nullable final String operationIsClosed )
    {
        rememberChangedField("OperationIsClosed", this.operationIsClosed);
        this.operationIsClosed = operationIsClosed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsScheduled</b>
     * </p>
     *
     * @param operationIsScheduled
     *            The operationIsScheduled to set.
     */
    public void setOperationIsScheduled( @Nullable final String operationIsScheduled )
    {
        rememberChangedField("OperationIsScheduled", this.operationIsScheduled);
        this.operationIsScheduled = operationIsScheduled;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsPartiallyDelivered</b>
     * </p>
     *
     * @param operationIsPartiallyDelivered
     *            The operationIsPartiallyDelivered to set.
     */
    public void setOperationIsPartiallyDelivered( @Nullable final String operationIsPartiallyDelivered )
    {
        rememberChangedField("OperationIsPartiallyDelivered", this.operationIsPartiallyDelivered);
        this.operationIsPartiallyDelivered = operationIsPartiallyDelivered;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsDelivered</b>
     * </p>
     *
     * @param operationIsDelivered
     *            The operationIsDelivered to set.
     */
    public void setOperationIsDelivered( @Nullable final String operationIsDelivered )
    {
        rememberChangedField("OperationIsDelivered", this.operationIsDelivered);
        this.operationIsDelivered = operationIsDelivered;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @param productionPlant
     *            Production Plant
     */
    public void setProductionPlant( @Nullable final String productionPlant )
    {
        rememberChangedField("ProductionPlant", this.productionPlant);
        this.productionPlant = productionPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Work Center Internal ID
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Work Center Type Code
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @param operationControlProfile
     *            Operation Control Profile
     */
    public void setOperationControlProfile( @Nullable final String operationControlProfile )
    {
        rememberChangedField("OperationControlProfile", this.operationControlProfile);
        this.operationControlProfile = operationControlProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtDte</b>
     * </p>
     *
     * @param opErlstSchedldExecStrtDte
     *            Earliest Scheduled Execution Start Date
     */
    public void setOpErlstSchedldExecStrtDte( @Nullable final LocalDateTime opErlstSchedldExecStrtDte )
    {
        rememberChangedField("OpErlstSchedldExecStrtDte", this.opErlstSchedldExecStrtDte);
        this.opErlstSchedldExecStrtDte = opErlstSchedldExecStrtDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtTme</b>
     * </p>
     *
     * @param opErlstSchedldExecStrtTme
     *            Earliest Scheduled Execution Start Time
     */
    public void setOpErlstSchedldExecStrtTme( @Nullable final LocalTime opErlstSchedldExecStrtTme )
    {
        rememberChangedField("OpErlstSchedldExecStrtTme", this.opErlstSchedldExecStrtTme);
        this.opErlstSchedldExecStrtTme = opErlstSchedldExecStrtTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndDte</b>
     * </p>
     *
     * @param opErlstSchedldExecEndDte
     *            Earliest Scheduled Execution End Date
     */
    public void setOpErlstSchedldExecEndDte( @Nullable final LocalDateTime opErlstSchedldExecEndDte )
    {
        rememberChangedField("OpErlstSchedldExecEndDte", this.opErlstSchedldExecEndDte);
        this.opErlstSchedldExecEndDte = opErlstSchedldExecEndDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndTme</b>
     * </p>
     *
     * @param opErlstSchedldExecEndTme
     *            Earliest Scheduled Execution End Time
     */
    public void setOpErlstSchedldExecEndTme( @Nullable final LocalTime opErlstSchedldExecEndTme )
    {
        rememberChangedField("OpErlstSchedldExecEndTme", this.opErlstSchedldExecEndTme);
        this.opErlstSchedldExecEndTme = opErlstSchedldExecEndTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionStartDate</b>
     * </p>
     *
     * @param opActualExecutionStartDate
     *            Confirmed Start Date of Execution
     */
    public void setOpActualExecutionStartDate( @Nullable final LocalDateTime opActualExecutionStartDate )
    {
        rememberChangedField("OpActualExecutionStartDate", this.opActualExecutionStartDate);
        this.opActualExecutionStartDate = opActualExecutionStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionStartTime</b>
     * </p>
     *
     * @param opActualExecutionStartTime
     *            Confirmed Start Time of Execution
     */
    public void setOpActualExecutionStartTime( @Nullable final LocalTime opActualExecutionStartTime )
    {
        rememberChangedField("OpActualExecutionStartTime", this.opActualExecutionStartTime);
        this.opActualExecutionStartTime = opActualExecutionStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionEndDate</b>
     * </p>
     *
     * @param opActualExecutionEndDate
     *            Confirmed End Date of Execution
     */
    public void setOpActualExecutionEndDate( @Nullable final LocalDateTime opActualExecutionEndDate )
    {
        rememberChangedField("OpActualExecutionEndDate", this.opActualExecutionEndDate);
        this.opActualExecutionEndDate = opActualExecutionEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionEndTime</b>
     * </p>
     *
     * @param opActualExecutionEndTime
     *            Confirmed End Time of Execution
     */
    public void setOpActualExecutionEndTime( @Nullable final LocalTime opActualExecutionEndTime )
    {
        rememberChangedField("OpActualExecutionEndTime", this.opActualExecutionEndTime);
        this.opActualExecutionEndTime = opActualExecutionEndTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ErlstSchedldExecDurnInWorkdays</b>
     * </p>
     *
     * @param erlstSchedldExecDurnInWorkdays
     *            Earliest Scheduled Execution Duration in Workdays
     */
    public void setErlstSchedldExecDurnInWorkdays( @Nullable final Integer erlstSchedldExecDurnInWorkdays )
    {
        rememberChangedField("ErlstSchedldExecDurnInWorkdays", this.erlstSchedldExecDurnInWorkdays);
        this.erlstSchedldExecDurnInWorkdays = erlstSchedldExecDurnInWorkdays;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionDays</b>
     * </p>
     *
     * @param opActualExecutionDays
     *            Actual Execution Duration in Workdays
     */
    public void setOpActualExecutionDays( @Nullable final Integer opActualExecutionDays )
    {
        rememberChangedField("OpActualExecutionDays", this.opActualExecutionDays);
        this.opActualExecutionDays = opActualExecutionDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @param operationUnit
     *            Operation Unit of Measure
     */
    public void setOperationUnit( @Nullable final String operationUnit )
    {
        rememberChangedField("OperationUnit", this.operationUnit);
        this.operationUnit = operationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnitISOCode</b>
     * </p>
     *
     * @param operationUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setOperationUnitISOCode( @Nullable final String operationUnitISOCode )
    {
        rememberChangedField("OperationUnitISOCode", this.operationUnitISOCode);
        this.operationUnitISOCode = operationUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnitSAPCode</b>
     * </p>
     *
     * @param operationUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setOperationUnitSAPCode( @Nullable final String operationUnitSAPCode )
    {
        rememberChangedField("OperationUnitSAPCode", this.operationUnitSAPCode);
        this.operationUnitSAPCode = operationUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpPlannedTotalQuantity</b>
     * </p>
     *
     * @param opPlannedTotalQuantity
     *            Operation Total Quantity
     */
    public void setOpPlannedTotalQuantity( @Nullable final BigDecimal opPlannedTotalQuantity )
    {
        rememberChangedField("OpPlannedTotalQuantity", this.opPlannedTotalQuantity);
        this.opPlannedTotalQuantity = opPlannedTotalQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpTotalConfirmedYieldQty</b>
     * </p>
     *
     * @param opTotalConfirmedYieldQty
     *            Total Confirmed Yield
     */
    public void setOpTotalConfirmedYieldQty( @Nullable final BigDecimal opTotalConfirmedYieldQty )
    {
        rememberChangedField("OpTotalConfirmedYieldQty", this.opTotalConfirmedYieldQty);
        this.opTotalConfirmedYieldQty = opTotalConfirmedYieldQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            The lastChangeDateTime to set.
     */
    public void setLastChangeDateTime( @Nullable final String lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductionOrderOperation_2";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        result.put("OrderIntBillOfOperationsItem", getOrderIntBillOfOperationsItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        values.put("OrderIntBillOfOperationsItem", getOrderIntBillOfOperationsItem());
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("ManufacturingOrderSequence", getManufacturingOrderSequence());
        values.put("MfgOrderSequenceText", getMfgOrderSequenceText());
        values.put("ManufacturingOrderOperation", getManufacturingOrderOperation());
        values.put("ManufacturingOrderSubOperation", getManufacturingOrderSubOperation());
        values.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        values.put("ManufacturingOrderType", getManufacturingOrderType());
        values.put("MfgOrderOperationText", getMfgOrderOperationText());
        values.put("OrderOperationLongText", getOrderOperationLongText());
        values.put("OrderSequenceLongText", getOrderSequenceLongText());
        values.put("OperationIsCreated", getOperationIsCreated());
        values.put("OperationIsReleased", getOperationIsReleased());
        values.put("OperationIsPrinted", getOperationIsPrinted());
        values.put("OperationIsConfirmed", getOperationIsConfirmed());
        values.put("OperationIsPartiallyConfirmed", getOperationIsPartiallyConfirmed());
        values.put("OperationIsDeleted", getOperationIsDeleted());
        values.put("OperationIsTechlyCompleted", getOperationIsTechlyCompleted());
        values.put("OperationIsClosed", getOperationIsClosed());
        values.put("OperationIsScheduled", getOperationIsScheduled());
        values.put("OperationIsPartiallyDelivered", getOperationIsPartiallyDelivered());
        values.put("OperationIsDelivered", getOperationIsDelivered());
        values.put("ProductionPlant", getProductionPlant());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("WorkCenter", getWorkCenter());
        values.put("OperationControlProfile", getOperationControlProfile());
        values.put("OpErlstSchedldExecStrtDte", getOpErlstSchedldExecStrtDte());
        values.put("OpErlstSchedldExecStrtTme", getOpErlstSchedldExecStrtTme());
        values.put("OpErlstSchedldExecEndDte", getOpErlstSchedldExecEndDte());
        values.put("OpErlstSchedldExecEndTme", getOpErlstSchedldExecEndTme());
        values.put("OpActualExecutionStartDate", getOpActualExecutionStartDate());
        values.put("OpActualExecutionStartTime", getOpActualExecutionStartTime());
        values.put("OpActualExecutionEndDate", getOpActualExecutionEndDate());
        values.put("OpActualExecutionEndTime", getOpActualExecutionEndTime());
        values.put("ErlstSchedldExecDurnInWorkdays", getErlstSchedldExecDurnInWorkdays());
        values.put("OpActualExecutionDays", getOpActualExecutionDays());
        values.put("OperationUnit", getOperationUnit());
        values.put("OperationUnitISOCode", getOperationUnitISOCode());
        values.put("OperationUnitSAPCode", getOperationUnitSAPCode());
        values.put("OpPlannedTotalQuantity", getOpPlannedTotalQuantity());
        values.put("OpTotalConfirmedYieldQty", getOpTotalConfirmedYieldQty());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OrderInternalBillOfOperations") ) {
                final Object value = values.remove("OrderInternalBillOfOperations");
                if( (value == null) || (!value.equals(getOrderInternalBillOfOperations())) ) {
                    setOrderInternalBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("OrderIntBillOfOperationsItem") ) {
                final Object value = values.remove("OrderIntBillOfOperationsItem");
                if( (value == null) || (!value.equals(getOrderIntBillOfOperationsItem())) ) {
                    setOrderIntBillOfOperationsItem(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderSequence") ) {
                final Object value = values.remove("ManufacturingOrderSequence");
                if( (value == null) || (!value.equals(getManufacturingOrderSequence())) ) {
                    setManufacturingOrderSequence(((String) value));
                }
            }
            if( values.containsKey("MfgOrderSequenceText") ) {
                final Object value = values.remove("MfgOrderSequenceText");
                if( (value == null) || (!value.equals(getMfgOrderSequenceText())) ) {
                    setMfgOrderSequenceText(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderOperation") ) {
                final Object value = values.remove("ManufacturingOrderOperation");
                if( (value == null) || (!value.equals(getManufacturingOrderOperation())) ) {
                    setManufacturingOrderOperation(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderSubOperation") ) {
                final Object value = values.remove("ManufacturingOrderSubOperation");
                if( (value == null) || (!value.equals(getManufacturingOrderSubOperation())) ) {
                    setManufacturingOrderSubOperation(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderCategory") ) {
                final Object value = values.remove("ManufacturingOrderCategory");
                if( (value == null) || (!value.equals(getManufacturingOrderCategory())) ) {
                    setManufacturingOrderCategory(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderType") ) {
                final Object value = values.remove("ManufacturingOrderType");
                if( (value == null) || (!value.equals(getManufacturingOrderType())) ) {
                    setManufacturingOrderType(((String) value));
                }
            }
            if( values.containsKey("MfgOrderOperationText") ) {
                final Object value = values.remove("MfgOrderOperationText");
                if( (value == null) || (!value.equals(getMfgOrderOperationText())) ) {
                    setMfgOrderOperationText(((String) value));
                }
            }
            if( values.containsKey("OrderOperationLongText") ) {
                final Object value = values.remove("OrderOperationLongText");
                if( (value == null) || (!value.equals(getOrderOperationLongText())) ) {
                    setOrderOperationLongText(((String) value));
                }
            }
            if( values.containsKey("OrderSequenceLongText") ) {
                final Object value = values.remove("OrderSequenceLongText");
                if( (value == null) || (!value.equals(getOrderSequenceLongText())) ) {
                    setOrderSequenceLongText(((String) value));
                }
            }
            if( values.containsKey("OperationIsCreated") ) {
                final Object value = values.remove("OperationIsCreated");
                if( (value == null) || (!value.equals(getOperationIsCreated())) ) {
                    setOperationIsCreated(((String) value));
                }
            }
            if( values.containsKey("OperationIsReleased") ) {
                final Object value = values.remove("OperationIsReleased");
                if( (value == null) || (!value.equals(getOperationIsReleased())) ) {
                    setOperationIsReleased(((String) value));
                }
            }
            if( values.containsKey("OperationIsPrinted") ) {
                final Object value = values.remove("OperationIsPrinted");
                if( (value == null) || (!value.equals(getOperationIsPrinted())) ) {
                    setOperationIsPrinted(((String) value));
                }
            }
            if( values.containsKey("OperationIsConfirmed") ) {
                final Object value = values.remove("OperationIsConfirmed");
                if( (value == null) || (!value.equals(getOperationIsConfirmed())) ) {
                    setOperationIsConfirmed(((String) value));
                }
            }
            if( values.containsKey("OperationIsPartiallyConfirmed") ) {
                final Object value = values.remove("OperationIsPartiallyConfirmed");
                if( (value == null) || (!value.equals(getOperationIsPartiallyConfirmed())) ) {
                    setOperationIsPartiallyConfirmed(((String) value));
                }
            }
            if( values.containsKey("OperationIsDeleted") ) {
                final Object value = values.remove("OperationIsDeleted");
                if( (value == null) || (!value.equals(getOperationIsDeleted())) ) {
                    setOperationIsDeleted(((String) value));
                }
            }
            if( values.containsKey("OperationIsTechlyCompleted") ) {
                final Object value = values.remove("OperationIsTechlyCompleted");
                if( (value == null) || (!value.equals(getOperationIsTechlyCompleted())) ) {
                    setOperationIsTechlyCompleted(((String) value));
                }
            }
            if( values.containsKey("OperationIsClosed") ) {
                final Object value = values.remove("OperationIsClosed");
                if( (value == null) || (!value.equals(getOperationIsClosed())) ) {
                    setOperationIsClosed(((String) value));
                }
            }
            if( values.containsKey("OperationIsScheduled") ) {
                final Object value = values.remove("OperationIsScheduled");
                if( (value == null) || (!value.equals(getOperationIsScheduled())) ) {
                    setOperationIsScheduled(((String) value));
                }
            }
            if( values.containsKey("OperationIsPartiallyDelivered") ) {
                final Object value = values.remove("OperationIsPartiallyDelivered");
                if( (value == null) || (!value.equals(getOperationIsPartiallyDelivered())) ) {
                    setOperationIsPartiallyDelivered(((String) value));
                }
            }
            if( values.containsKey("OperationIsDelivered") ) {
                final Object value = values.remove("OperationIsDelivered");
                if( (value == null) || (!value.equals(getOperationIsDelivered())) ) {
                    setOperationIsDelivered(((String) value));
                }
            }
            if( values.containsKey("ProductionPlant") ) {
                final Object value = values.remove("ProductionPlant");
                if( (value == null) || (!value.equals(getProductionPlant())) ) {
                    setProductionPlant(((String) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("OperationControlProfile") ) {
                final Object value = values.remove("OperationControlProfile");
                if( (value == null) || (!value.equals(getOperationControlProfile())) ) {
                    setOperationControlProfile(((String) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecStrtDte") ) {
                final Object value = values.remove("OpErlstSchedldExecStrtDte");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecStrtDte())) ) {
                    setOpErlstSchedldExecStrtDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecStrtTme") ) {
                final Object value = values.remove("OpErlstSchedldExecStrtTme");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecStrtTme())) ) {
                    setOpErlstSchedldExecStrtTme(((LocalTime) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecEndDte") ) {
                final Object value = values.remove("OpErlstSchedldExecEndDte");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecEndDte())) ) {
                    setOpErlstSchedldExecEndDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecEndTme") ) {
                final Object value = values.remove("OpErlstSchedldExecEndTme");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecEndTme())) ) {
                    setOpErlstSchedldExecEndTme(((LocalTime) value));
                }
            }
            if( values.containsKey("OpActualExecutionStartDate") ) {
                final Object value = values.remove("OpActualExecutionStartDate");
                if( (value == null) || (!value.equals(getOpActualExecutionStartDate())) ) {
                    setOpActualExecutionStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpActualExecutionStartTime") ) {
                final Object value = values.remove("OpActualExecutionStartTime");
                if( (value == null) || (!value.equals(getOpActualExecutionStartTime())) ) {
                    setOpActualExecutionStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OpActualExecutionEndDate") ) {
                final Object value = values.remove("OpActualExecutionEndDate");
                if( (value == null) || (!value.equals(getOpActualExecutionEndDate())) ) {
                    setOpActualExecutionEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpActualExecutionEndTime") ) {
                final Object value = values.remove("OpActualExecutionEndTime");
                if( (value == null) || (!value.equals(getOpActualExecutionEndTime())) ) {
                    setOpActualExecutionEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ErlstSchedldExecDurnInWorkdays") ) {
                final Object value = values.remove("ErlstSchedldExecDurnInWorkdays");
                if( (value == null) || (!value.equals(getErlstSchedldExecDurnInWorkdays())) ) {
                    setErlstSchedldExecDurnInWorkdays(((Integer) value));
                }
            }
            if( values.containsKey("OpActualExecutionDays") ) {
                final Object value = values.remove("OpActualExecutionDays");
                if( (value == null) || (!value.equals(getOpActualExecutionDays())) ) {
                    setOpActualExecutionDays(((Integer) value));
                }
            }
            if( values.containsKey("OperationUnit") ) {
                final Object value = values.remove("OperationUnit");
                if( (value == null) || (!value.equals(getOperationUnit())) ) {
                    setOperationUnit(((String) value));
                }
            }
            if( values.containsKey("OperationUnitISOCode") ) {
                final Object value = values.remove("OperationUnitISOCode");
                if( (value == null) || (!value.equals(getOperationUnitISOCode())) ) {
                    setOperationUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("OperationUnitSAPCode") ) {
                final Object value = values.remove("OperationUnitSAPCode");
                if( (value == null) || (!value.equals(getOperationUnitSAPCode())) ) {
                    setOperationUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("OpPlannedTotalQuantity") ) {
                final Object value = values.remove("OpPlannedTotalQuantity");
                if( (value == null) || (!value.equals(getOpPlannedTotalQuantity())) ) {
                    setOpPlannedTotalQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpTotalConfirmedYieldQty") ) {
                final Object value = values.remove("OpTotalConfirmedYieldQty");
                if( (value == null) || (!value.equals(getOpTotalConfirmedYieldQty())) ) {
                    setOpTotalConfirmedYieldQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProductionOrderOperation_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ProductionOrderOperation_2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductionOrderOperation_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductionOrderOperation_2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderV2Service.DEFAULT_SERVICE_PATH);
    }

}
