/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperCreate;

/**
 * Fluent helper to create a new
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2 ProductionOrder_2}
 * entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ProductionOrder_2CreateFluentHelper
    extends
    FluentHelperCreate<ProductionOrder_2CreateFluentHelper, ProductionOrder_2>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2 ProductionOrder_2}
     * entity object that will be created in the S/4HANA system.
     *
     */
    private final ProductionOrder_2 entity;

    /**
     * Creates a fluent helper object that will create a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2 ProductionOrder_2}
     * entity on the OData endpoint. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to direct the create requests to.
     * @param servicePath
     *            The service path to direct the create requests to.
     * @param entity
     *            The ProductionOrder_2 to create.
     */
    public ProductionOrder_2CreateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ProductionOrder_2 entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ProductionOrder_2 getEntity()
    {
        return entity;
    }

}
