/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2 ProductionOrder_2}
 * entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ProductionOrder_2UpdateFluentHelper
    extends
    FluentHelperUpdate<ProductionOrder_2UpdateFluentHelper, ProductionOrder_2>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2 ProductionOrder_2}
     * entity object that will be updated in the S/4HANA system.
     *
     */
    private final ProductionOrder_2 entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2 ProductionOrder_2}
     * entity on the OData endpoint. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The ProductionOrder_2 to take the updated values from.
     */
    public ProductionOrder_2UpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ProductionOrder_2 entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ProductionOrder_2 getEntity()
    {
        return entity;
    }

}
