/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.selectable.ProductionRsceTools_2Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2
 * ProductionRsceTools_2} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ProductionRsceTools_2ByKeyFluentHelper
    extends
    FluentHelperByKey<ProductionRsceTools_2ByKeyFluentHelper, ProductionRsceTools_2, ProductionRsceTools_2Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2
     * ProductionRsceTools_2} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProductionRsceTools_2}
     * @param mfgOrderOpProdnRsceToolIntID
     *            Item Counter for Production Resources/Tools
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProductionRsceTools_2}
     */
    public ProductionRsceTools_2ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String orderInternalBillOfOperations,
        final String mfgOrderOpProdnRsceToolIntID )
    {
        super(servicePath, entityCollection);
        this.key.put("OrderInternalBillOfOperations", orderInternalBillOfOperations);
        this.key.put("MfgOrderOpProdnRsceToolIntID", mfgOrderOpProdnRsceToolIntID);
    }

    @Override
    @Nonnull
    protected Class<ProductionRsceTools_2> getEntityClass()
    {
        return ProductionRsceTools_2.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
