/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2;

import java.net.URI;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>ScheduleProductionOrderOperation</b> OData function import.
 *
 */
public class ScheduleProductionOrderOperationFluentHelper
    extends
    SingleValuedFluentHelperFunction<ScheduleProductionOrderOperationFluentHelper, SchedldProdOrdOpMessage, SchedldProdOrdOpMessage>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>ScheduleProductionOrderOperation</b> OData function
     * import with the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param orderIntBillOfOperationsItem
     *            Operation Internal ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     *            </p>
     * @param opSchedldStartDate
     *            Execution Start Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldStartDate</b>
     *            </p>
     * @param opSchedulingStrategy
     *            Component of the Version Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingStrategy</b>
     *            </p>
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param opSchedulingStatus
     *            Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingStatus</b>
     *            </p>
     * @param opSchedulingMode
     *            Scheduling type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingMode</b>
     *            </p>
     * @param manufacturingOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @param opSchedldStartTime
     *            Execution Start Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldStartTime</b>
     *            </p>
     * @param opSchedldEndDate
     *            Execution End Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldEndDate</b>
     *            </p>
     * @param opSchedldEndTime
     *            Execution End Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldEndTime</b>
     *            </p>
     */
    public ScheduleProductionOrderOperationFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String manufacturingOrder,
        @Nonnull final String orderInternalBillOfOperations,
        @Nonnull final String orderIntBillOfOperationsItem,
        @Nullable final LocalDateTime opSchedldStartDate,
        @Nullable final LocalTime opSchedldStartTime,
        @Nullable final LocalDateTime opSchedldEndDate,
        @Nullable final LocalTime opSchedldEndTime,
        @Nonnull final String opSchedulingMode,
        @Nullable final String opSchedulingStatus,
        @Nonnull final String opSchedulingStrategy )
    {
        super(servicePath);
        values.put("ManufacturingOrder", manufacturingOrder);
        values.put("OrderInternalBillOfOperations", orderInternalBillOfOperations);
        values.put("OrderIntBillOfOperationsItem", orderIntBillOfOperationsItem);
        if( opSchedldStartDate != null ) {
            values.put("OpSchedldStartDate", opSchedldStartDate);
        }
        if( opSchedldStartTime != null ) {
            values.put("OpSchedldStartTime", opSchedldStartTime);
        }
        if( opSchedldEndDate != null ) {
            values.put("OpSchedldEndDate", opSchedldEndDate);
        }
        if( opSchedldEndTime != null ) {
            values.put("OpSchedldEndTime", opSchedldEndTime);
        }
        values.put("OpSchedulingMode", opSchedulingMode);
        if( opSchedulingStatus != null ) {
            values.put("OpSchedulingStatus", opSchedulingStatus);
        }
        values.put("OpSchedulingStrategy", opSchedulingStrategy);
    }

    @Override
    @Nonnull
    protected Class<SchedldProdOrdOpMessage> getEntityClass()
    {
        return SchedldProdOrdOpMessage.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "ScheduleProductionOrderOperation";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public SchedldProdOrdOpMessage executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
