/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProductionOrderV2ServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderV2Service ProductionOrderV2Service}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProductionOrderV2ServiceBatch
    extends
    BatchFluentHelperBasic<ProductionOrderV2ServiceBatch, ProductionOrderV2ServiceBatchChangeSet>
    implements
    ProductionOrderV2ServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderV2Service service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProductionOrderV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductionOrderV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderV2Service service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderV2Service.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProductionOrderV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductionOrderV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderV2Service service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProductionOrderV2ServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductionOrderV2ServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProductionOrderV2ServiceBatchChangeSet(this, service);
    }

}
