/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2;

/**
 * Implementation of the {@link ProductionOrderV2ServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderV2Service ProductionOrderV2Service}.
 *
 */
public class DefaultProductionOrderV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProductionOrderV2ServiceBatch, ProductionOrderV2ServiceBatchChangeSet>
    implements
    ProductionOrderV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultProductionOrderV2ServiceBatchChangeSet(
        @Nonnull final DefaultProductionOrderV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProductionOrderV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductionOrderV2ServiceBatchChangeSet updateProductionOrderComponent_3(
        @Nonnull final ProductionOrderComponent_3 productionOrderComponent_3 )
    {
        return addRequestUpdate(service::updateProductionOrderComponent_3, productionOrderComponent_3);
    }

    @Nonnull
    @Override
    public ProductionOrderV2ServiceBatchChangeSet updateProductionOrderComponent_4(
        @Nonnull final ProductionOrderComponent_4 productionOrderComponent_4 )
    {
        return addRequestUpdate(service::updateProductionOrderComponent_4, productionOrderComponent_4);
    }

    @Nonnull
    @Override
    public ProductionOrderV2ServiceBatchChangeSet createProductionOrder_2(
        @Nonnull final ProductionOrder_2 productionOrder_2 )
    {
        return addRequestCreate(service::createProductionOrder_2, productionOrder_2);
    }

    @Nonnull
    @Override
    public ProductionOrderV2ServiceBatchChangeSet updateProductionOrder_2(
        @Nonnull final ProductionOrder_2 productionOrder_2 )
    {
        return addRequestUpdate(service::updateProductionOrder_2, productionOrder_2);
    }

}
