/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderV2Service ProductionOrderV2Service}.
 *
 */
public interface ProductionOrderV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ProductionOrderV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ProductionOrderV2ServiceBatch>
{

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3
     * ProductionOrderComponent_3} entity and save it to the S/4HANA system.
     *
     * @param productionOrderComponent_3
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3
     *            ProductionOrderComponent_3} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionOrderV2ServiceBatchChangeSet
        updateProductionOrderComponent_3( @Nonnull final ProductionOrderComponent_3 productionOrderComponent_3 );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
     * ProductionOrderComponent_4} entity and save it to the S/4HANA system.
     *
     * @param productionOrderComponent_4
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
     *            ProductionOrderComponent_4} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionOrderV2ServiceBatchChangeSet
        updateProductionOrderComponent_4( @Nonnull final ProductionOrderComponent_4 productionOrderComponent_4 );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     * ProductionOrder_2} entity and save it to the S/4HANA system.
     *
     * @param productionOrder_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     *            ProductionOrder_2} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionOrderV2ServiceBatchChangeSet
        createProductionOrder_2( @Nonnull final ProductionOrder_2 productionOrder_2 );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     * ProductionOrder_2} entity and save it to the S/4HANA system.
     *
     * @param productionOrder_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     *            ProductionOrder_2} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionOrderV2ServiceBatchChangeSet
        updateProductionOrder_2( @Nonnull final ProductionOrder_2 productionOrder_2 );

}
