/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.selectable.ProductionOrderComponent_3Selectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3
 * ProductionOrderComponent_3} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ProductionOrderComponent_3Link<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ProductionOrderComponent_3Link<ObjectT>, ProductionOrderComponent_3, ObjectT>
    implements
    ProductionOrderComponent_3Selectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ProductionOrderComponent_3Link( final String fieldName )
    {
        super(fieldName);
    }

    private ProductionOrderComponent_3Link(
        final EntityLink<ProductionOrderComponent_3Link<ObjectT>, ProductionOrderComponent_3, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ProductionOrderComponent_3Link<ObjectT> translateLinkType(
        final EntityLink<ProductionOrderComponent_3Link<ObjectT>, ProductionOrderComponent_3, ObjectT> link )
    {
        return new ProductionOrderComponent_3Link<ObjectT>(link);
    }

}
