/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.selectable.ProductionOrderComponent_4Selectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
 * ProductionOrderComponent_4} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ProductionOrderComponent_4Link<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ProductionOrderComponent_4Link<ObjectT>, ProductionOrderComponent_4, ObjectT>
    implements
    ProductionOrderComponent_4Selectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ProductionOrderComponent_4Link( final String fieldName )
    {
        super(fieldName);
    }

    private ProductionOrderComponent_4Link(
        final EntityLink<ProductionOrderComponent_4Link<ObjectT>, ProductionOrderComponent_4, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ProductionOrderComponent_4Link<ObjectT> translateLinkType(
        final EntityLink<ProductionOrderComponent_4Link<ObjectT>, ProductionOrderComponent_4, ObjectT> link )
    {
        return new ProductionOrderComponent_4Link<ObjectT>(link);
    }

}
