/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2
 * ProductionOrderStatus_2}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.field.ProductionOrderStatus_2Field
 * ProductionOrderStatus_2Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.link.ProductionOrderStatus_2Link
 * ProductionOrderStatus_2Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2#STATUS_CODE
 * STATUS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2#IS_USER_STATUS
 * IS_USER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2#STATUS_SHORT_NAME
 * STATUS_SHORT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2#STATUS_NAME
 * STATUS_NAME}</li>
 * </ul>
 *
 */
public interface ProductionOrderStatus_2Selectable extends EntitySelectable<ProductionOrderStatus_2>
{

}
