/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2
 * ProductionRsceTools_2}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.field.ProductionRsceTools_2Field
 * ProductionRsceTools_2Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.link.ProductionRsceTools_2Link
 * ProductionRsceTools_2Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#ORDER_INTERNAL_BILL_OF_OPERATIONS
 * ORDER_INTERNAL_BILL_OF_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#MFG_ORDER_OP_PRODN_RSCE_TOOL_INT_ID
 * MFG_ORDER_OP_PRODN_RSCE_TOOL_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODUCTION_RESOURCE_TOOL
 * PRODUCTION_RESOURCE_TOOL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_CATEGORY
 * PRODN_RSCE_TOOL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_CATEGORY_NAME
 * PRODN_RSCE_TOOL_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_CONTROL_PROFILE
 * PRODN_RSCE_TOOL_CONTROL_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_PLANT
 * PRODN_RSCE_TOOL_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#ORDER_OPERATION_INTERNAL_ID
 * ORDER_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#MANUFACTURING_ORDER_OPERATION
 * MANUFACTURING_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#MANUFACTURING_ORDER_CATEGORY
 * MANUFACTURING_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#MANUFACTURING_ORDER_TYPE
 * MANUFACTURING_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODUCTION_PLANT
 * PRODUCTION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#BILL_OF_OPERATIONS_TYPE
 * BILL_OF_OPERATIONS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#BILL_OF_OPERATIONS_GROUP
 * BILL_OF_OPERATIONS_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#EARLIEST_SCHEDLD_USAGE_START_DATE
 * EARLIEST_SCHEDLD_USAGE_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#EARLIEST_SCHEDLD_USAGE_START_TIME
 * EARLIEST_SCHEDLD_USAGE_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#EARLIEST_SCHEDLD_USAGE_END_DATE
 * EARLIEST_SCHEDLD_USAGE_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#EARLIEST_SCHEDLD_USAGE_END_TIME
 * EARLIEST_SCHEDLD_USAGE_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#LATEST_SCHEDLD_USAGE_START_DATE
 * LATEST_SCHEDLD_USAGE_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#LATEST_SCHEDLD_USAGE_START_TIME
 * LATEST_SCHEDLD_USAGE_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#LATEST_SCHEDLD_USAGE_END_DATE
 * LATEST_SCHEDLD_USAGE_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#LATEST_SCHEDLD_USAGE_END_TIME
 * LATEST_SCHEDLD_USAGE_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#ACTUAL_USAGE_START_DATE
 * ACTUAL_USAGE_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#ACTUAL_USAGE_START_TIME
 * ACTUAL_USAGE_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#ACTUAL_USAGE_END_DATE
 * ACTUAL_USAGE_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#ACTUAL_USAGE_END_TIME
 * ACTUAL_USAGE_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_USAGE_DURN_UNIT
 * PRODN_RSCE_TOOL_USAGE_DURN_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_USAGE_DURATION
 * PRODN_RSCE_TOOL_USAGE_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRT_USAGE_DURATION_UNIT_ISO_CODE
 * PRT_USAGE_DURATION_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRT_USAGE_DURATION_UNIT_SAP_CODE
 * PRT_USAGE_DURATION_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_TOT_QTY_CALC_FORMULA
 * PRODN_RSCE_TOOL_TOT_QTY_CALC_FORMULA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_USAGE_QTY_CALC_FMLA
 * PRODN_RSCE_TOOL_USAGE_QTY_CALC_FMLA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT
 * PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_STANDARD_WORK_QTY
 * PRODN_RSCE_TOOL_STANDARD_WORK_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRT_STD_WORK_QTY_UNIT_ISO_CODE
 * PRT_STD_WORK_QTY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRT_STD_WORK_QTY_UNIT_SAP_CODE
 * PRT_STD_WORK_QTY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PLANNED_PRODN_RSCE_TOOL_QTY_UNIT
 * PLANNED_PRODN_RSCE_TOOL_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PLANNED_TOTAL_PRODN_RSCE_TOOL_QTY
 * PLANNED_TOTAL_PRODN_RSCE_TOOL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PLANNED_PRT_QTY_UNIT_ISO_CODE
 * PLANNED_PRT_QTY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PLANNED_PRT_QTY_UNIT_SAP_CODE
 * PLANNED_PRT_QTY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#CONFIRMED_PRODN_RSCE_TOOL_QTY_UNIT
 * CONFIRMED_PRODN_RSCE_TOOL_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#CONFIRMED_PRODN_RSCE_TOOL_QTY
 * CONFIRMED_PRODN_RSCE_TOOL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#CONFIRMED_PRT_QTY_UNIT_ISO_CODE
 * CONFIRMED_PRT_QTY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#CONFIRMED_PRT_QTY_UNIT_SAP_CODE
 * CONFIRMED_PRT_QTY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT
 * PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_USAGE_QUANTITY
 * PRODN_RSCE_TOOL_USAGE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRT_USAGE_QTY_UNIT_ISO_CODE
 * PRT_USAGE_QTY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRT_USAGE_QTY_UNIT_SAP_CODE
 * PRT_USAGE_QTY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PLND_PRODN_RSCE_TOOL_USAGE_QTY_UNIT
 * PLND_PRODN_RSCE_TOOL_USAGE_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PLANNED_PRODN_RSCE_TOOL_USAGE_QTY
 * PLANNED_PRODN_RSCE_TOOL_USAGE_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PLANNED_PRT_USAGE_QTY_UNIT_ISO_CODE
 * PLANNED_PRT_USAGE_QTY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PLANNED_PRT_USAGE_QTY_UNIT_SAP_CODE
 * PLANNED_PRT_USAGE_QTY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#CONFD_PRODN_RSCE_TOOL_USAGE_QTY_UNIT
 * CONFD_PRODN_RSCE_TOOL_USAGE_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#CONFIRMED_PRODN_RSCE_TOOL_USAGE_QTY
 * CONFIRMED_PRODN_RSCE_TOOL_USAGE_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#CONFD_PRT_USAGE_QTY_UNIT_ISO_CODE
 * CONFD_PRT_USAGE_QTY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#CONFD_PRT_USAGE_QTY_UNIT_SAP_CODE
 * CONFD_PRT_USAGE_QTY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_BASE_UNIT
 * PRODN_RSCE_TOOL_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_BASE_UNIT_ISO_CODE
 * PRODN_RSCE_TOOL_BASE_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2#PRODN_RSCE_TOOL_BASE_UNIT_SAP_CODE
 * PRODN_RSCE_TOOL_BASE_UNIT_SAP_CODE}</li>
 * </ul>
 *
 */
public interface ProductionRsceTools_2Selectable extends EntitySelectable<ProductionRsceTools_2>
{

}
