/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.field.OperationDocumentPRTAssignmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.selectable.OperationDocumentPRTAssignmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Operation Document PRT Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>OperationDocumentPRTAssignment_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OperationDocumentPRTAssignment extends VdmEntity<OperationDocumentPRTAssignment>
{

    /**
     * Selector for all available fields of OperationDocumentPRTAssignment.
     *
     */
    public final static OperationDocumentPRTAssignmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "ProductionRoutingGroup" )
    @JsonProperty( "ProductionRoutingGroup" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingGroup" )
    private String productionRoutingGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingGroup</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODUCTION_ROUTING_GROUP =
        new OperationDocumentPRTAssignmentField<String>("ProductionRoutingGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRouting</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "ProductionRouting" )
    @JsonProperty( "ProductionRouting" )
    @Nullable
    @ODataField( odataName = "ProductionRouting" )
    private String productionRouting;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRouting</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODUCTION_ROUTING =
        new OperationDocumentPRTAssignmentField<String>("ProductionRouting");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingSequence</b>
     * </p>
     *
     * @return Sequence
     */
    @Key
    @SerializedName( "ProductionRoutingSequence" )
    @JsonProperty( "ProductionRoutingSequence" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingSequence" )
    private String productionRoutingSequence;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingSequence</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODUCTION_ROUTING_SEQUENCE =
        new OperationDocumentPRTAssignmentField<String>("ProductionRoutingSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingOpIntID</b>
     * </p>
     *
     * @return Number of the Task List Node
     */
    @Key
    @SerializedName( "ProductionRoutingOpIntID" )
    @JsonProperty( "ProductionRoutingOpIntID" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingOpIntID" )
    private String productionRoutingOpIntID;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingOpIntID</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODUCTION_ROUTING_OP_INT_ID =
        new OperationDocumentPRTAssignmentField<String>("ProductionRoutingOpIntID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationPRTInternalID</b>
     * </p>
     *
     * @return Item Counter for Production Resources/Tools
     */
    @Key
    @SerializedName( "BOOOperationPRTInternalID" )
    @JsonProperty( "BOOOperationPRTInternalID" )
    @Nullable
    @ODataField( odataName = "BOOOperationPRTInternalID" )
    private String bOOOperationPRTInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BOOOperationPRTInternalID</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> BOO_OPERATION_PRT_INTERNAL_ID =
        new OperationDocumentPRTAssignmentField<String>("BOOOperationPRTInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationPRTIntVersCounter</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "BOOOperationPRTIntVersCounter" )
    @JsonProperty( "BOOOperationPRTIntVersCounter" )
    @Nullable
    @ODataField( odataName = "BOOOperationPRTIntVersCounter" )
    private String bOOOperationPRTIntVersCounter;
    /**
     * Use with available fluent helpers to apply the <b>BOOOperationPRTIntVersCounter</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> BOO_OPERATION_PRT_INT_VERS_COUNTER =
        new OperationDocumentPRTAssignmentField<String>("BOOOperationPRTIntVersCounter");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "DocumentType" )
    @JsonProperty( "DocumentType" )
    @Nullable
    @ODataField( odataName = "DocumentType" )
    private String documentType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentType</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> DOCUMENT_TYPE =
        new OperationDocumentPRTAssignmentField<String>("DocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecord</b>
     * </p>
     *
     * @return Document number
     */
    @SerializedName( "DocumentInfoRecord" )
    @JsonProperty( "DocumentInfoRecord" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecord" )
    private String documentInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecord</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> DOCUMENT_INFO_RECORD =
        new OperationDocumentPRTAssignmentField<String>("DocumentInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @return Document Version
     */
    @SerializedName( "DocumentVersion" )
    @JsonProperty( "DocumentVersion" )
    @Nullable
    @ODataField( odataName = "DocumentVersion" )
    private String documentVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentVersion</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> DOCUMENT_VERSION =
        new OperationDocumentPRTAssignmentField<String>("DocumentVersion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @return Document Part
     */
    @SerializedName( "DocumentPart" )
    @JsonProperty( "DocumentPart" )
    @Nullable
    @ODataField( odataName = "DocumentPart" )
    private String documentPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentPart</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> DOCUMENT_PART =
        new OperationDocumentPRTAssignmentField<String>("DocumentPart");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolItemNumber</b>
     * </p>
     *
     * @return Item Number for Production Resource/Tool
     */
    @SerializedName( "ProdnRsceToolItemNumber" )
    @JsonProperty( "ProdnRsceToolItemNumber" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolItemNumber" )
    private String prodnRsceToolItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolItemNumber</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODN_RSCE_TOOL_ITEM_NUMBER =
        new OperationDocumentPRTAssignmentField<String>("ProdnRsceToolItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceType</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @SerializedName( "ProductionResourceType" )
    @JsonProperty( "ProductionResourceType" )
    @Nullable
    @ODataField( odataName = "ProductionResourceType" )
    private String productionResourceType;
    /**
     * Use with available fluent helpers to apply the <b>ProductionResourceType</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODUCTION_RESOURCE_TYPE =
        new OperationDocumentPRTAssignmentField<String>("ProductionResourceType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @SerializedName( "ProductionResourceInternalID" )
    @JsonProperty( "ProductionResourceInternalID" )
    @Nullable
    @ODataField( odataName = "ProductionResourceInternalID" )
    private String productionResourceInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProductionResourceInternalID</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODUCTION_RESOURCE_INTERNAL_ID =
        new OperationDocumentPRTAssignmentField<String>("ProductionResourceInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStandardTextCode</b>
     * </p>
     *
     * @return Standard Text Key for Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolStandardTextCode" )
    @JsonProperty( "ProdnRsceToolStandardTextCode" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolStandardTextCode" )
    private String prodnRsceToolStandardTextCode;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolStandardTextCode</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODN_RSCE_TOOL_STANDARD_TEXT_CODE =
        new OperationDocumentPRTAssignmentField<String>("ProdnRsceToolStandardTextCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolText</b>
     * </p>
     *
     * @return First Line of Text for Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolText" )
    @JsonProperty( "ProdnRsceToolText" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolText" )
    private String prodnRsceToolText;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolText</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODN_RSCE_TOOL_TEXT =
        new OperationDocumentPRTAssignmentField<String>("ProdnRsceToolText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolControlProfile</b>
     * </p>
     *
     * @return Control Profile for Management of Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolControlProfile" )
    @JsonProperty( "ProdnRsceToolControlProfile" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolControlProfile" )
    private String prodnRsceToolControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolControlProfile</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODN_RSCE_TOOL_CONTROL_PROFILE =
        new OperationDocumentPRTAssignmentField<String>("ProdnRsceToolControlProfile");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStandardWorkQty</b>
     * </p>
     *
     * @return Standard Value for Quantity of Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolStandardWorkQty" )
    @JsonProperty( "ProdnRsceToolStandardWorkQty" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolStandardWorkQty" )
    private BigDecimal prodnRsceToolStandardWorkQty;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolStandardWorkQty</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<BigDecimal> PRODN_RSCE_TOOL_STANDARD_WORK_QTY =
        new OperationDocumentPRTAssignmentField<BigDecimal>("ProdnRsceToolStandardWorkQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStdWorkQtyUnit</b>
     * </p>
     *
     * @return Unit for Quantity of Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolStdWorkQtyUnit" )
    @JsonProperty( "ProdnRsceToolStdWorkQtyUnit" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolStdWorkQtyUnit" )
    private String prodnRsceToolStdWorkQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolStdWorkQtyUnit</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT =
        new OperationDocumentPRTAssignmentField<String>("ProdnRsceToolStdWorkQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolTotQtyCalcFormula</b>
     * </p>
     *
     * @return Formula for Calculating the Total Quantity of PRT
     */
    @SerializedName( "ProdnRsceToolTotQtyCalcFormula" )
    @JsonProperty( "ProdnRsceToolTotQtyCalcFormula" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolTotQtyCalcFormula" )
    private String prodnRsceToolTotQtyCalcFormula;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolTotQtyCalcFormula</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODN_RSCE_TOOL_TOT_QTY_CALC_FORMULA =
        new OperationDocumentPRTAssignmentField<String>("ProdnRsceToolTotQtyCalcFormula");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantity</b>
     * </p>
     *
     * @return Standard Usage Value for Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolUsageQuantity" )
    @JsonProperty( "ProdnRsceToolUsageQuantity" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageQuantity" )
    private BigDecimal prodnRsceToolUsageQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageQuantity</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<BigDecimal> PRODN_RSCE_TOOL_USAGE_QUANTITY =
        new OperationDocumentPRTAssignmentField<BigDecimal>("ProdnRsceToolUsageQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantityUnit</b>
     * </p>
     *
     * @return Usage Value Unit of the Production Resource/Tool
     */
    @SerializedName( "ProdnRsceToolUsageQuantityUnit" )
    @JsonProperty( "ProdnRsceToolUsageQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageQuantityUnit" )
    private String prodnRsceToolUsageQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageQuantityUnit</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT =
        new OperationDocumentPRTAssignmentField<String>("ProdnRsceToolUsageQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQtyCalcFmla</b>
     * </p>
     *
     * @return Formula for Calculating the Total Usage Value of PRT
     */
    @SerializedName( "ProdnRsceToolUsageQtyCalcFmla" )
    @JsonProperty( "ProdnRsceToolUsageQtyCalcFmla" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageQtyCalcFmla" )
    private String prodnRsceToolUsageQtyCalcFmla;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageQtyCalcFmla</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> PRODN_RSCE_TOOL_USAGE_QTY_CALC_FMLA =
        new OperationDocumentPRTAssignmentField<String>("ProdnRsceToolUsageQtyCalcFmla");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> CHANGE_NUMBER =
        new OperationDocumentPRTAssignmentField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<LocalDateTime> VALIDITY_START_DATE =
        new OperationDocumentPRTAssignmentField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<LocalDateTime> VALIDITY_END_DATE =
        new OperationDocumentPRTAssignmentField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<LocalDateTime> CREATION_DATE =
        new OperationDocumentPRTAssignmentField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> CREATED_BY_USER =
        new OperationDocumentPRTAssignmentField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<LocalDateTime> LAST_CHANGE_DATE =
        new OperationDocumentPRTAssignmentField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<String> LAST_CHANGED_BY_USER =
        new OperationDocumentPRTAssignmentField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static OperationDocumentPRTAssignmentField<ZonedDateTime> CHANGED_DATE_TIME =
        new OperationDocumentPRTAssignmentField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<OperationDocumentPRTAssignment> getType()
    {
        return OperationDocumentPRTAssignment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingGroup</b>
     * </p>
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     */
    public void setProductionRoutingGroup( @Nullable final String productionRoutingGroup )
    {
        rememberChangedField("ProductionRoutingGroup", this.productionRoutingGroup);
        this.productionRoutingGroup = productionRoutingGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRouting</b>
     * </p>
     *
     * @param productionRouting
     *            Group Counter
     */
    public void setProductionRouting( @Nullable final String productionRouting )
    {
        rememberChangedField("ProductionRouting", this.productionRouting);
        this.productionRouting = productionRouting;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingSequence</b>
     * </p>
     *
     * @param productionRoutingSequence
     *            Sequence
     */
    public void setProductionRoutingSequence( @Nullable final String productionRoutingSequence )
    {
        rememberChangedField("ProductionRoutingSequence", this.productionRoutingSequence);
        this.productionRoutingSequence = productionRoutingSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingOpIntID</b>
     * </p>
     *
     * @param productionRoutingOpIntID
     *            Number of the Task List Node
     */
    public void setProductionRoutingOpIntID( @Nullable final String productionRoutingOpIntID )
    {
        rememberChangedField("ProductionRoutingOpIntID", this.productionRoutingOpIntID);
        this.productionRoutingOpIntID = productionRoutingOpIntID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationPRTInternalID</b>
     * </p>
     *
     * @param bOOOperationPRTInternalID
     *            Item Counter for Production Resources/Tools
     */
    public void setBOOOperationPRTInternalID( @Nullable final String bOOOperationPRTInternalID )
    {
        rememberChangedField("BOOOperationPRTInternalID", this.bOOOperationPRTInternalID);
        this.bOOOperationPRTInternalID = bOOOperationPRTInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationPRTIntVersCounter</b>
     * </p>
     *
     * @param bOOOperationPRTIntVersCounter
     *            Internal counter
     */
    public void setBOOOperationPRTIntVersCounter( @Nullable final String bOOOperationPRTIntVersCounter )
    {
        rememberChangedField("BOOOperationPRTIntVersCounter", this.bOOOperationPRTIntVersCounter);
        this.bOOOperationPRTIntVersCounter = bOOOperationPRTIntVersCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @param documentType
     *            Document Type
     */
    public void setDocumentType( @Nullable final String documentType )
    {
        rememberChangedField("DocumentType", this.documentType);
        this.documentType = documentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecord</b>
     * </p>
     *
     * @param documentInfoRecord
     *            Document number
     */
    public void setDocumentInfoRecord( @Nullable final String documentInfoRecord )
    {
        rememberChangedField("DocumentInfoRecord", this.documentInfoRecord);
        this.documentInfoRecord = documentInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @param documentVersion
     *            Document Version
     */
    public void setDocumentVersion( @Nullable final String documentVersion )
    {
        rememberChangedField("DocumentVersion", this.documentVersion);
        this.documentVersion = documentVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @param documentPart
     *            Document Part
     */
    public void setDocumentPart( @Nullable final String documentPart )
    {
        rememberChangedField("DocumentPart", this.documentPart);
        this.documentPart = documentPart;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolItemNumber</b>
     * </p>
     *
     * @param prodnRsceToolItemNumber
     *            Item Number for Production Resource/Tool
     */
    public void setProdnRsceToolItemNumber( @Nullable final String prodnRsceToolItemNumber )
    {
        rememberChangedField("ProdnRsceToolItemNumber", this.prodnRsceToolItemNumber);
        this.prodnRsceToolItemNumber = prodnRsceToolItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceType</b>
     * </p>
     *
     * @param productionResourceType
     *            Object types of the CIM resource
     */
    public void setProductionResourceType( @Nullable final String productionResourceType )
    {
        rememberChangedField("ProductionResourceType", this.productionResourceType);
        this.productionResourceType = productionResourceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceInternalID</b>
     * </p>
     *
     * @param productionResourceInternalID
     *            Object ID of the resource
     */
    public void setProductionResourceInternalID( @Nullable final String productionResourceInternalID )
    {
        rememberChangedField("ProductionResourceInternalID", this.productionResourceInternalID);
        this.productionResourceInternalID = productionResourceInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStandardTextCode</b>
     * </p>
     *
     * @param prodnRsceToolStandardTextCode
     *            Standard Text Key for Production Resources/Tools
     */
    public void setProdnRsceToolStandardTextCode( @Nullable final String prodnRsceToolStandardTextCode )
    {
        rememberChangedField("ProdnRsceToolStandardTextCode", this.prodnRsceToolStandardTextCode);
        this.prodnRsceToolStandardTextCode = prodnRsceToolStandardTextCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolText</b>
     * </p>
     *
     * @param prodnRsceToolText
     *            First Line of Text for Production Resources/Tools
     */
    public void setProdnRsceToolText( @Nullable final String prodnRsceToolText )
    {
        rememberChangedField("ProdnRsceToolText", this.prodnRsceToolText);
        this.prodnRsceToolText = prodnRsceToolText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolControlProfile</b>
     * </p>
     *
     * @param prodnRsceToolControlProfile
     *            Control Profile for Management of Production Resources/Tools
     */
    public void setProdnRsceToolControlProfile( @Nullable final String prodnRsceToolControlProfile )
    {
        rememberChangedField("ProdnRsceToolControlProfile", this.prodnRsceToolControlProfile);
        this.prodnRsceToolControlProfile = prodnRsceToolControlProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStandardWorkQty</b>
     * </p>
     *
     * @param prodnRsceToolStandardWorkQty
     *            Standard Value for Quantity of Production Resources/Tools
     */
    public void setProdnRsceToolStandardWorkQty( @Nullable final BigDecimal prodnRsceToolStandardWorkQty )
    {
        rememberChangedField("ProdnRsceToolStandardWorkQty", this.prodnRsceToolStandardWorkQty);
        this.prodnRsceToolStandardWorkQty = prodnRsceToolStandardWorkQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStdWorkQtyUnit</b>
     * </p>
     *
     * @param prodnRsceToolStdWorkQtyUnit
     *            Unit for Quantity of Production Resources/Tools
     */
    public void setProdnRsceToolStdWorkQtyUnit( @Nullable final String prodnRsceToolStdWorkQtyUnit )
    {
        rememberChangedField("ProdnRsceToolStdWorkQtyUnit", this.prodnRsceToolStdWorkQtyUnit);
        this.prodnRsceToolStdWorkQtyUnit = prodnRsceToolStdWorkQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolTotQtyCalcFormula</b>
     * </p>
     *
     * @param prodnRsceToolTotQtyCalcFormula
     *            Formula for Calculating the Total Quantity of PRT
     */
    public void setProdnRsceToolTotQtyCalcFormula( @Nullable final String prodnRsceToolTotQtyCalcFormula )
    {
        rememberChangedField("ProdnRsceToolTotQtyCalcFormula", this.prodnRsceToolTotQtyCalcFormula);
        this.prodnRsceToolTotQtyCalcFormula = prodnRsceToolTotQtyCalcFormula;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantity</b>
     * </p>
     *
     * @param prodnRsceToolUsageQuantity
     *            Standard Usage Value for Production Resources/Tools
     */
    public void setProdnRsceToolUsageQuantity( @Nullable final BigDecimal prodnRsceToolUsageQuantity )
    {
        rememberChangedField("ProdnRsceToolUsageQuantity", this.prodnRsceToolUsageQuantity);
        this.prodnRsceToolUsageQuantity = prodnRsceToolUsageQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantityUnit</b>
     * </p>
     *
     * @param prodnRsceToolUsageQuantityUnit
     *            Usage Value Unit of the Production Resource/Tool
     */
    public void setProdnRsceToolUsageQuantityUnit( @Nullable final String prodnRsceToolUsageQuantityUnit )
    {
        rememberChangedField("ProdnRsceToolUsageQuantityUnit", this.prodnRsceToolUsageQuantityUnit);
        this.prodnRsceToolUsageQuantityUnit = prodnRsceToolUsageQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQtyCalcFmla</b>
     * </p>
     *
     * @param prodnRsceToolUsageQtyCalcFmla
     *            Formula for Calculating the Total Usage Value of PRT
     */
    public void setProdnRsceToolUsageQtyCalcFmla( @Nullable final String prodnRsceToolUsageQtyCalcFmla )
    {
        rememberChangedField("ProdnRsceToolUsageQtyCalcFmla", this.prodnRsceToolUsageQtyCalcFmla);
        this.prodnRsceToolUsageQtyCalcFmla = prodnRsceToolUsageQtyCalcFmla;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "OpDocumentPRTAssgmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductionRoutingGroup", getProductionRoutingGroup());
        result.put("ProductionRouting", getProductionRouting());
        result.put("ProductionRoutingSequence", getProductionRoutingSequence());
        result.put("ProductionRoutingOpIntID", getProductionRoutingOpIntID());
        result.put("BOOOperationPRTInternalID", getBOOOperationPRTInternalID());
        result.put("BOOOperationPRTIntVersCounter", getBOOOperationPRTIntVersCounter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProductionRoutingGroup", getProductionRoutingGroup());
        values.put("ProductionRouting", getProductionRouting());
        values.put("ProductionRoutingSequence", getProductionRoutingSequence());
        values.put("ProductionRoutingOpIntID", getProductionRoutingOpIntID());
        values.put("BOOOperationPRTInternalID", getBOOOperationPRTInternalID());
        values.put("BOOOperationPRTIntVersCounter", getBOOOperationPRTIntVersCounter());
        values.put("DocumentType", getDocumentType());
        values.put("DocumentInfoRecord", getDocumentInfoRecord());
        values.put("DocumentVersion", getDocumentVersion());
        values.put("DocumentPart", getDocumentPart());
        values.put("ProdnRsceToolItemNumber", getProdnRsceToolItemNumber());
        values.put("ProductionResourceType", getProductionResourceType());
        values.put("ProductionResourceInternalID", getProductionResourceInternalID());
        values.put("ProdnRsceToolStandardTextCode", getProdnRsceToolStandardTextCode());
        values.put("ProdnRsceToolText", getProdnRsceToolText());
        values.put("ProdnRsceToolControlProfile", getProdnRsceToolControlProfile());
        values.put("ProdnRsceToolStandardWorkQty", getProdnRsceToolStandardWorkQty());
        values.put("ProdnRsceToolStdWorkQtyUnit", getProdnRsceToolStdWorkQtyUnit());
        values.put("ProdnRsceToolTotQtyCalcFormula", getProdnRsceToolTotQtyCalcFormula());
        values.put("ProdnRsceToolUsageQuantity", getProdnRsceToolUsageQuantity());
        values.put("ProdnRsceToolUsageQuantityUnit", getProdnRsceToolUsageQuantityUnit());
        values.put("ProdnRsceToolUsageQtyCalcFmla", getProdnRsceToolUsageQtyCalcFmla());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductionRoutingGroup") ) {
                final Object value = values.remove("ProductionRoutingGroup");
                if( (value == null) || (!value.equals(getProductionRoutingGroup())) ) {
                    setProductionRoutingGroup(((String) value));
                }
            }
            if( values.containsKey("ProductionRouting") ) {
                final Object value = values.remove("ProductionRouting");
                if( (value == null) || (!value.equals(getProductionRouting())) ) {
                    setProductionRouting(((String) value));
                }
            }
            if( values.containsKey("ProductionRoutingSequence") ) {
                final Object value = values.remove("ProductionRoutingSequence");
                if( (value == null) || (!value.equals(getProductionRoutingSequence())) ) {
                    setProductionRoutingSequence(((String) value));
                }
            }
            if( values.containsKey("ProductionRoutingOpIntID") ) {
                final Object value = values.remove("ProductionRoutingOpIntID");
                if( (value == null) || (!value.equals(getProductionRoutingOpIntID())) ) {
                    setProductionRoutingOpIntID(((String) value));
                }
            }
            if( values.containsKey("BOOOperationPRTInternalID") ) {
                final Object value = values.remove("BOOOperationPRTInternalID");
                if( (value == null) || (!value.equals(getBOOOperationPRTInternalID())) ) {
                    setBOOOperationPRTInternalID(((String) value));
                }
            }
            if( values.containsKey("BOOOperationPRTIntVersCounter") ) {
                final Object value = values.remove("BOOOperationPRTIntVersCounter");
                if( (value == null) || (!value.equals(getBOOOperationPRTIntVersCounter())) ) {
                    setBOOOperationPRTIntVersCounter(((String) value));
                }
            }
            if( values.containsKey("DocumentType") ) {
                final Object value = values.remove("DocumentType");
                if( (value == null) || (!value.equals(getDocumentType())) ) {
                    setDocumentType(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecord") ) {
                final Object value = values.remove("DocumentInfoRecord");
                if( (value == null) || (!value.equals(getDocumentInfoRecord())) ) {
                    setDocumentInfoRecord(((String) value));
                }
            }
            if( values.containsKey("DocumentVersion") ) {
                final Object value = values.remove("DocumentVersion");
                if( (value == null) || (!value.equals(getDocumentVersion())) ) {
                    setDocumentVersion(((String) value));
                }
            }
            if( values.containsKey("DocumentPart") ) {
                final Object value = values.remove("DocumentPart");
                if( (value == null) || (!value.equals(getDocumentPart())) ) {
                    setDocumentPart(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolItemNumber") ) {
                final Object value = values.remove("ProdnRsceToolItemNumber");
                if( (value == null) || (!value.equals(getProdnRsceToolItemNumber())) ) {
                    setProdnRsceToolItemNumber(((String) value));
                }
            }
            if( values.containsKey("ProductionResourceType") ) {
                final Object value = values.remove("ProductionResourceType");
                if( (value == null) || (!value.equals(getProductionResourceType())) ) {
                    setProductionResourceType(((String) value));
                }
            }
            if( values.containsKey("ProductionResourceInternalID") ) {
                final Object value = values.remove("ProductionResourceInternalID");
                if( (value == null) || (!value.equals(getProductionResourceInternalID())) ) {
                    setProductionResourceInternalID(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolStandardTextCode") ) {
                final Object value = values.remove("ProdnRsceToolStandardTextCode");
                if( (value == null) || (!value.equals(getProdnRsceToolStandardTextCode())) ) {
                    setProdnRsceToolStandardTextCode(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolText") ) {
                final Object value = values.remove("ProdnRsceToolText");
                if( (value == null) || (!value.equals(getProdnRsceToolText())) ) {
                    setProdnRsceToolText(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolControlProfile") ) {
                final Object value = values.remove("ProdnRsceToolControlProfile");
                if( (value == null) || (!value.equals(getProdnRsceToolControlProfile())) ) {
                    setProdnRsceToolControlProfile(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolStandardWorkQty") ) {
                final Object value = values.remove("ProdnRsceToolStandardWorkQty");
                if( (value == null) || (!value.equals(getProdnRsceToolStandardWorkQty())) ) {
                    setProdnRsceToolStandardWorkQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProdnRsceToolStdWorkQtyUnit") ) {
                final Object value = values.remove("ProdnRsceToolStdWorkQtyUnit");
                if( (value == null) || (!value.equals(getProdnRsceToolStdWorkQtyUnit())) ) {
                    setProdnRsceToolStdWorkQtyUnit(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolTotQtyCalcFormula") ) {
                final Object value = values.remove("ProdnRsceToolTotQtyCalcFormula");
                if( (value == null) || (!value.equals(getProdnRsceToolTotQtyCalcFormula())) ) {
                    setProdnRsceToolTotQtyCalcFormula(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageQuantity") ) {
                final Object value = values.remove("ProdnRsceToolUsageQuantity");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageQuantity())) ) {
                    setProdnRsceToolUsageQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageQuantityUnit") ) {
                final Object value = values.remove("ProdnRsceToolUsageQuantityUnit");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageQuantityUnit())) ) {
                    setProdnRsceToolUsageQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageQtyCalcFmla") ) {
                final Object value = values.remove("ProdnRsceToolUsageQtyCalcFmla");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageQtyCalcFmla())) ) {
                    setProdnRsceToolUsageQtyCalcFmla(((String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> OperationDocumentPRTAssignmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new OperationDocumentPRTAssignmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OperationDocumentPRTAssignmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OperationDocumentPRTAssignmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService.DEFAULT_SERVICE_PATH);
    }

}
