/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.field.ProductionRoutingHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.link.ProductionRoutingHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.selectable.ProductionRoutingHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProductionRoutingHeaderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductionRoutingHeader extends VdmEntity<ProductionRoutingHeader>
{

    /**
     * Selector for all available fields of ProductionRoutingHeader.
     *
     */
    public final static ProductionRoutingHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "ProductionRoutingGroup" )
    @JsonProperty( "ProductionRoutingGroup" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingGroup" )
    private String productionRoutingGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingGroup</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> PRODUCTION_ROUTING_GROUP =
        new ProductionRoutingHeaderField<String>("ProductionRoutingGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRouting</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "ProductionRouting" )
    @JsonProperty( "ProductionRouting" )
    @Nullable
    @ODataField( odataName = "ProductionRouting" )
    private String productionRouting;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRouting</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> PRODUCTION_ROUTING =
        new ProductionRoutingHeaderField<String>("ProductionRouting");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingInternalVers</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "ProductionRoutingInternalVers" )
    @JsonProperty( "ProductionRoutingInternalVers" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingInternalVers" )
    private String productionRoutingInternalVers;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingInternalVers</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> PRODUCTION_ROUTING_INTERNAL_VERS =
        new ProductionRoutingHeaderField<String>("ProductionRoutingInternalVers");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Indicator: Delete completely in reorganization run
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<Boolean> IS_MARKED_FOR_DELETION =
        new ProductionRoutingHeaderField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsDesc</b>
     * </p>
     *
     * @return Routing Description
     */
    @SerializedName( "BillOfOperationsDesc" )
    @JsonProperty( "BillOfOperationsDesc" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsDesc" )
    private String billOfOperationsDesc;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsDesc</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> BILL_OF_OPERATIONS_DESC =
        new ProductionRoutingHeaderField<String>("BillOfOperationsDesc");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> PLANT = new ProductionRoutingHeaderField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUsage</b>
     * </p>
     *
     * @return Task List Usage
     */
    @SerializedName( "BillOfOperationsUsage" )
    @JsonProperty( "BillOfOperationsUsage" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsUsage" )
    private String billOfOperationsUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsUsage</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> BILL_OF_OPERATIONS_USAGE =
        new ProductionRoutingHeaderField<String>("BillOfOperationsUsage");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsStatus</b>
     * </p>
     *
     * @return Status
     */
    @SerializedName( "BillOfOperationsStatus" )
    @JsonProperty( "BillOfOperationsStatus" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsStatus" )
    private String billOfOperationsStatus;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsStatus</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> BILL_OF_OPERATIONS_STATUS =
        new ProductionRoutingHeaderField<String>("BillOfOperationsStatus");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePlannerGroup</b>
     * </p>
     *
     * @return Responsible Planner Group or Department
     */
    @SerializedName( "ResponsiblePlannerGroup" )
    @JsonProperty( "ResponsiblePlannerGroup" )
    @Nullable
    @ODataField( odataName = "ResponsiblePlannerGroup" )
    private String responsiblePlannerGroup;
    /**
     * Use with available fluent helpers to apply the <b>ResponsiblePlannerGroup</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> RESPONSIBLE_PLANNER_GROUP =
        new ProductionRoutingHeaderField<String>("ResponsiblePlannerGroup");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @return Minimum Lot Size
     */
    @SerializedName( "MinimumLotSizeQuantity" )
    @JsonProperty( "MinimumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumLotSizeQuantity" )
    private BigDecimal minimumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<BigDecimal> MINIMUM_LOT_SIZE_QUANTITY =
        new ProductionRoutingHeaderField<BigDecimal>("MinimumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @return Maximum Lot Size
     */
    @SerializedName( "MaximumLotSizeQuantity" )
    @JsonProperty( "MaximumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumLotSizeQuantity" )
    private BigDecimal maximumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<BigDecimal> MAXIMUM_LOT_SIZE_QUANTITY =
        new ProductionRoutingHeaderField<BigDecimal>("MaximumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUnit</b>
     * </p>
     *
     * @return Task List Unit of Measure
     */
    @SerializedName( "BillOfOperationsUnit" )
    @JsonProperty( "BillOfOperationsUnit" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsUnit" )
    private String billOfOperationsUnit;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsUnit</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> BILL_OF_OPERATIONS_UNIT =
        new ProductionRoutingHeaderField<String>("BillOfOperationsUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<LocalDateTime> CREATION_DATE =
        new ProductionRoutingHeaderField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> CREATED_BY_USER =
        new ProductionRoutingHeaderField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<LocalDateTime> LAST_CHANGE_DATE =
        new ProductionRoutingHeaderField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> LAST_CHANGED_BY_USER =
        new ProductionRoutingHeaderField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<LocalDateTime> VALIDITY_START_DATE =
        new ProductionRoutingHeaderField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<LocalDateTime> VALIDITY_END_DATE =
        new ProductionRoutingHeaderField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> CHANGE_NUMBER =
        new ProductionRoutingHeaderField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<ZonedDateTime> CHANGED_DATE_TIME =
        new ProductionRoutingHeaderField<ZonedDateTime>("ChangedDateTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "PlainLongText" )
    @JsonProperty( "PlainLongText" )
    @Nullable
    @ODataField( odataName = "PlainLongText" )
    private String plainLongText;
    /**
     * Use with available fluent helpers to apply the <b>PlainLongText</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> PLAIN_LONG_TEXT =
        new ProductionRoutingHeaderField<String>("PlainLongText");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "BillOfOperationsLongText" )
    @JsonProperty( "BillOfOperationsLongText" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsLongText" )
    private String billOfOperationsLongText;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsLongText</b> field to query operations.
     *
     */
    public final static ProductionRoutingHeaderField<String> BILL_OF_OPERATIONS_LONG_TEXT =
        new ProductionRoutingHeaderField<String>("BillOfOperationsLongText");
    /**
     * Navigation property <b>to_MatlAssgmt</b> for <b>ProductionRoutingHeader</b> to multiple
     * <b>ProductionRoutingMatlAssgmt</b>.
     *
     */
    @SerializedName( "to_MatlAssgmt" )
    @JsonProperty( "to_MatlAssgmt" )
    @ODataField( odataName = "to_MatlAssgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductionRoutingMatlAssgmt> toMatlAssgmt;
    /**
     * Navigation property <b>to_Sequence</b> for <b>ProductionRoutingHeader</b> to multiple
     * <b>ProductionRoutingSequence</b>.
     *
     */
    @SerializedName( "to_Sequence" )
    @JsonProperty( "to_Sequence" )
    @ODataField( odataName = "to_Sequence" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductionRoutingSequence> toSequence;
    /**
     * Use with available fluent helpers to apply the <b>to_MatlAssgmt</b> navigation property to query operations.
     *
     */
    public final static ProductionRoutingHeaderLink<ProductionRoutingMatlAssgmt> TO_MATL_ASSGMT =
        new ProductionRoutingHeaderLink<ProductionRoutingMatlAssgmt>("to_MatlAssgmt");
    /**
     * Use with available fluent helpers to apply the <b>to_Sequence</b> navigation property to query operations.
     *
     */
    public final static ProductionRoutingHeaderLink<ProductionRoutingSequence> TO_SEQUENCE =
        new ProductionRoutingHeaderLink<ProductionRoutingSequence>("to_Sequence");

    @Nonnull
    @Override
    public Class<ProductionRoutingHeader> getType()
    {
        return ProductionRoutingHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingGroup</b>
     * </p>
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     */
    public void setProductionRoutingGroup( @Nullable final String productionRoutingGroup )
    {
        rememberChangedField("ProductionRoutingGroup", this.productionRoutingGroup);
        this.productionRoutingGroup = productionRoutingGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRouting</b>
     * </p>
     *
     * @param productionRouting
     *            Group Counter
     */
    public void setProductionRouting( @Nullable final String productionRouting )
    {
        rememberChangedField("ProductionRouting", this.productionRouting);
        this.productionRouting = productionRouting;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingInternalVers</b>
     * </p>
     *
     * @param productionRoutingInternalVers
     *            Internal counter
     */
    public void setProductionRoutingInternalVers( @Nullable final String productionRoutingInternalVers )
    {
        rememberChangedField("ProductionRoutingInternalVers", this.productionRoutingInternalVers);
        this.productionRoutingInternalVers = productionRoutingInternalVers;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Indicator: Delete completely in reorganization run
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsDesc</b>
     * </p>
     *
     * @param billOfOperationsDesc
     *            Routing Description
     */
    public void setBillOfOperationsDesc( @Nullable final String billOfOperationsDesc )
    {
        rememberChangedField("BillOfOperationsDesc", this.billOfOperationsDesc);
        this.billOfOperationsDesc = billOfOperationsDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUsage</b>
     * </p>
     *
     * @param billOfOperationsUsage
     *            Task List Usage
     */
    public void setBillOfOperationsUsage( @Nullable final String billOfOperationsUsage )
    {
        rememberChangedField("BillOfOperationsUsage", this.billOfOperationsUsage);
        this.billOfOperationsUsage = billOfOperationsUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsStatus</b>
     * </p>
     *
     * @param billOfOperationsStatus
     *            Status
     */
    public void setBillOfOperationsStatus( @Nullable final String billOfOperationsStatus )
    {
        rememberChangedField("BillOfOperationsStatus", this.billOfOperationsStatus);
        this.billOfOperationsStatus = billOfOperationsStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePlannerGroup</b>
     * </p>
     *
     * @param responsiblePlannerGroup
     *            Responsible Planner Group or Department
     */
    public void setResponsiblePlannerGroup( @Nullable final String responsiblePlannerGroup )
    {
        rememberChangedField("ResponsiblePlannerGroup", this.responsiblePlannerGroup);
        this.responsiblePlannerGroup = responsiblePlannerGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @param minimumLotSizeQuantity
     *            Minimum Lot Size
     */
    public void setMinimumLotSizeQuantity( @Nullable final BigDecimal minimumLotSizeQuantity )
    {
        rememberChangedField("MinimumLotSizeQuantity", this.minimumLotSizeQuantity);
        this.minimumLotSizeQuantity = minimumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @param maximumLotSizeQuantity
     *            Maximum Lot Size
     */
    public void setMaximumLotSizeQuantity( @Nullable final BigDecimal maximumLotSizeQuantity )
    {
        rememberChangedField("MaximumLotSizeQuantity", this.maximumLotSizeQuantity);
        this.maximumLotSizeQuantity = maximumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUnit</b>
     * </p>
     *
     * @param billOfOperationsUnit
     *            Task List Unit of Measure
     */
    public void setBillOfOperationsUnit( @Nullable final String billOfOperationsUnit )
    {
        rememberChangedField("BillOfOperationsUnit", this.billOfOperationsUnit);
        this.billOfOperationsUnit = billOfOperationsUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     *
     * @param plainLongText
     *            Long Text
     */
    public void setPlainLongText( @Nullable final String plainLongText )
    {
        rememberChangedField("PlainLongText", this.plainLongText);
        this.plainLongText = plainLongText;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsLongText</b>
     * </p>
     *
     * @param billOfOperationsLongText
     *            Long Text
     */
    public void setBillOfOperationsLongText( @Nullable final String billOfOperationsLongText )
    {
        rememberChangedField("BillOfOperationsLongText", this.billOfOperationsLongText);
        this.billOfOperationsLongText = billOfOperationsLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProductionRoutingHeader";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductionRoutingGroup", getProductionRoutingGroup());
        result.put("ProductionRouting", getProductionRouting());
        result.put("ProductionRoutingInternalVers", getProductionRoutingInternalVers());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProductionRoutingGroup", getProductionRoutingGroup());
        values.put("ProductionRouting", getProductionRouting());
        values.put("ProductionRoutingInternalVers", getProductionRoutingInternalVers());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("BillOfOperationsDesc", getBillOfOperationsDesc());
        values.put("Plant", getPlant());
        values.put("BillOfOperationsUsage", getBillOfOperationsUsage());
        values.put("BillOfOperationsStatus", getBillOfOperationsStatus());
        values.put("ResponsiblePlannerGroup", getResponsiblePlannerGroup());
        values.put("MinimumLotSizeQuantity", getMinimumLotSizeQuantity());
        values.put("MaximumLotSizeQuantity", getMaximumLotSizeQuantity());
        values.put("BillOfOperationsUnit", getBillOfOperationsUnit());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ChangedDateTime", getChangedDateTime());
        values.put("PlainLongText", getPlainLongText());
        values.put("BillOfOperationsLongText", getBillOfOperationsLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductionRoutingGroup") ) {
                final Object value = values.remove("ProductionRoutingGroup");
                if( (value == null) || (!value.equals(getProductionRoutingGroup())) ) {
                    setProductionRoutingGroup(((String) value));
                }
            }
            if( values.containsKey("ProductionRouting") ) {
                final Object value = values.remove("ProductionRouting");
                if( (value == null) || (!value.equals(getProductionRouting())) ) {
                    setProductionRouting(((String) value));
                }
            }
            if( values.containsKey("ProductionRoutingInternalVers") ) {
                final Object value = values.remove("ProductionRoutingInternalVers");
                if( (value == null) || (!value.equals(getProductionRoutingInternalVers())) ) {
                    setProductionRoutingInternalVers(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("BillOfOperationsDesc") ) {
                final Object value = values.remove("BillOfOperationsDesc");
                if( (value == null) || (!value.equals(getBillOfOperationsDesc())) ) {
                    setBillOfOperationsDesc(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsUsage") ) {
                final Object value = values.remove("BillOfOperationsUsage");
                if( (value == null) || (!value.equals(getBillOfOperationsUsage())) ) {
                    setBillOfOperationsUsage(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsStatus") ) {
                final Object value = values.remove("BillOfOperationsStatus");
                if( (value == null) || (!value.equals(getBillOfOperationsStatus())) ) {
                    setBillOfOperationsStatus(((String) value));
                }
            }
            if( values.containsKey("ResponsiblePlannerGroup") ) {
                final Object value = values.remove("ResponsiblePlannerGroup");
                if( (value == null) || (!value.equals(getResponsiblePlannerGroup())) ) {
                    setResponsiblePlannerGroup(((String) value));
                }
            }
            if( values.containsKey("MinimumLotSizeQuantity") ) {
                final Object value = values.remove("MinimumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMinimumLotSizeQuantity())) ) {
                    setMinimumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumLotSizeQuantity") ) {
                final Object value = values.remove("MaximumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMaximumLotSizeQuantity())) ) {
                    setMaximumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillOfOperationsUnit") ) {
                final Object value = values.remove("BillOfOperationsUnit");
                if( (value == null) || (!value.equals(getBillOfOperationsUnit())) ) {
                    setBillOfOperationsUnit(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PlainLongText") ) {
                final Object value = values.remove("PlainLongText");
                if( (value == null) || (!value.equals(getPlainLongText())) ) {
                    setPlainLongText(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsLongText") ) {
                final Object value = values.remove("BillOfOperationsLongText");
                if( (value == null) || (!value.equals(getBillOfOperationsLongText())) ) {
                    setBillOfOperationsLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MatlAssgmt") ) {
                final Object value = (values).remove("to_MatlAssgmt");
                if( value instanceof Iterable ) {
                    if( toMatlAssgmt == null ) {
                        toMatlAssgmt = Lists.newArrayList();
                    } else {
                        toMatlAssgmt = Lists.newArrayList(toMatlAssgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductionRoutingMatlAssgmt entity;
                        if( toMatlAssgmt.size() > i ) {
                            entity = toMatlAssgmt.get(i);
                        } else {
                            entity = new ProductionRoutingMatlAssgmt();
                            toMatlAssgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Sequence") ) {
                final Object value = (values).remove("to_Sequence");
                if( value instanceof Iterable ) {
                    if( toSequence == null ) {
                        toSequence = Lists.newArrayList();
                    } else {
                        toSequence = Lists.newArrayList(toSequence);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductionRoutingSequence entity;
                        if( toSequence.size() > i ) {
                            entity = toSequence.get(i);
                        } else {
                            entity = new ProductionRoutingSequence();
                            toSequence.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductionRoutingHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductionRoutingHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductionRoutingHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductionRoutingHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMatlAssgmt != null ) {
            (values).put("to_MatlAssgmt", toMatlAssgmt);
        }
        if( toSequence != null ) {
            (values).put("to_Sequence", toSequence);
        }
        return values;
    }

    /**
     * Fetches the <b>ProductionRoutingMatlAssgmt</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_MatlAssgmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductionRoutingMatlAssgmt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductionRoutingMatlAssgmt> fetchMatlAssgmt()
    {
        return fetchFieldAsList("to_MatlAssgmt", ProductionRoutingMatlAssgmt.class);
    }

    /**
     * Retrieval of associated <b>ProductionRoutingMatlAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MatlAssgmt</b>.
     * <p>
     * If the navigation property <b>to_MatlAssgmt</b> of a queried <b>ProductionRoutingHeader</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductionRoutingMatlAssgmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductionRoutingMatlAssgmt> getMatlAssgmtOrFetch()
    {
        if( toMatlAssgmt == null ) {
            toMatlAssgmt = fetchMatlAssgmt();
        }
        return toMatlAssgmt;
    }

    /**
     * Retrieval of associated <b>ProductionRoutingMatlAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MatlAssgmt</b>.
     * <p>
     * If the navigation property for an entity <b>ProductionRoutingHeader</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MatlAssgmt</b> is already loaded, the result will
     *         contain the <b>ProductionRoutingMatlAssgmt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductionRoutingMatlAssgmt>> getMatlAssgmtIfPresent()
    {
        return Option.of(toMatlAssgmt);
    }

    /**
     * Overwrites the list of associated <b>ProductionRoutingMatlAssgmt</b> entities for the loaded navigation property
     * <b>to_MatlAssgmt</b>.
     * <p>
     * If the navigation property <b>to_MatlAssgmt</b> of a queried <b>ProductionRoutingHeader</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductionRoutingMatlAssgmt</b> entities.
     */
    public void setMatlAssgmt( @Nonnull final List<ProductionRoutingMatlAssgmt> value )
    {
        if( toMatlAssgmt == null ) {
            toMatlAssgmt = Lists.newArrayList();
        }
        toMatlAssgmt.clear();
        toMatlAssgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductionRoutingMatlAssgmt</b> entities. This corresponds to the
     * OData navigation property <b>to_MatlAssgmt</b>.
     * <p>
     * If the navigation property <b>to_MatlAssgmt</b> of a queried <b>ProductionRoutingHeader</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductionRoutingMatlAssgmt</b> entities.
     */
    public void addMatlAssgmt( ProductionRoutingMatlAssgmt... entity )
    {
        if( toMatlAssgmt == null ) {
            toMatlAssgmt = Lists.newArrayList();
        }
        toMatlAssgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProductionRoutingSequence</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Sequence</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductionRoutingSequence</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductionRoutingSequence> fetchSequence()
    {
        return fetchFieldAsList("to_Sequence", ProductionRoutingSequence.class);
    }

    /**
     * Retrieval of associated <b>ProductionRoutingSequence</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Sequence</b>.
     * <p>
     * If the navigation property <b>to_Sequence</b> of a queried <b>ProductionRoutingHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductionRoutingSequence</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductionRoutingSequence> getSequenceOrFetch()
    {
        if( toSequence == null ) {
            toSequence = fetchSequence();
        }
        return toSequence;
    }

    /**
     * Retrieval of associated <b>ProductionRoutingSequence</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Sequence</b>.
     * <p>
     * If the navigation property for an entity <b>ProductionRoutingHeader</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Sequence</b> is already loaded, the result will contain
     *         the <b>ProductionRoutingSequence</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductionRoutingSequence>> getSequenceIfPresent()
    {
        return Option.of(toSequence);
    }

    /**
     * Overwrites the list of associated <b>ProductionRoutingSequence</b> entities for the loaded navigation property
     * <b>to_Sequence</b>.
     * <p>
     * If the navigation property <b>to_Sequence</b> of a queried <b>ProductionRoutingHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductionRoutingSequence</b> entities.
     */
    public void setSequence( @Nonnull final List<ProductionRoutingSequence> value )
    {
        if( toSequence == null ) {
            toSequence = Lists.newArrayList();
        }
        toSequence.clear();
        toSequence.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductionRoutingSequence</b> entities. This corresponds to the OData
     * navigation property <b>to_Sequence</b>.
     * <p>
     * If the navigation property <b>to_Sequence</b> of a queried <b>ProductionRoutingHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductionRoutingSequence</b> entities.
     */
    public void addSequence( ProductionRoutingSequence... entity )
    {
        if( toSequence == null ) {
            toSequence = Lists.newArrayList();
        }
        toSequence.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProductionRoutingHeader instances.
     *
     */
    public final static class ProductionRoutingHeaderBuilder
    {

        private List<ProductionRoutingMatlAssgmt> toMatlAssgmt = Lists.newArrayList();
        private List<ProductionRoutingSequence> toSequence = Lists.newArrayList();

        private ProductionRoutingHeader.ProductionRoutingHeaderBuilder toMatlAssgmt(
            final List<ProductionRoutingMatlAssgmt> value )
        {
            toMatlAssgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MatlAssgmt</b> for <b>ProductionRoutingHeader</b> to multiple
         * <b>ProductionRoutingMatlAssgmt</b>.
         *
         * @param value
         *            The ProductionRoutingMatlAssgmts to build this ProductionRoutingHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductionRoutingHeader.ProductionRoutingHeaderBuilder matlAssgmt( ProductionRoutingMatlAssgmt... value )
        {
            return toMatlAssgmt(Lists.newArrayList(value));
        }

        private ProductionRoutingHeader.ProductionRoutingHeaderBuilder toSequence(
            final List<ProductionRoutingSequence> value )
        {
            toSequence.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Sequence</b> for <b>ProductionRoutingHeader</b> to multiple
         * <b>ProductionRoutingSequence</b>.
         *
         * @param value
         *            The ProductionRoutingSequences to build this ProductionRoutingHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductionRoutingHeader.ProductionRoutingHeaderBuilder sequence( ProductionRoutingSequence... value )
        {
            return toSequence(Lists.newArrayList(value));
        }

    }

}
