/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.selectable.ProductionRoutingMatlAssgmtSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingMatlAssgmt
 * ProductionRoutingMatlAssgmt} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ProductionRoutingMatlAssgmtByKeyFluentHelper
    extends
    FluentHelperByKey<ProductionRoutingMatlAssgmtByKeyFluentHelper, ProductionRoutingMatlAssgmt, ProductionRoutingMatlAssgmtSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingMatlAssgmt
     * ProductionRoutingMatlAssgmt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProductionRoutingMatlAssgmt}
     * @param productionRoutingMatlAssgmt
     *            Counter for Additional Criteria
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProductionRoutingMatlAssgmt}
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param productionRtgMatlAssgmtIntVers
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public ProductionRoutingMatlAssgmtByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String product,
        final String plant,
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingMatlAssgmt,
        final String productionRtgMatlAssgmtIntVers )
    {
        super(servicePath, entityCollection);
        this.key.put("Product", product);
        this.key.put("Plant", plant);
        this.key.put("ProductionRoutingGroup", productionRoutingGroup);
        this.key.put("ProductionRouting", productionRouting);
        this.key.put("ProductionRoutingMatlAssgmt", productionRoutingMatlAssgmt);
        this.key.put("ProductionRtgMatlAssgmtIntVers", productionRtgMatlAssgmtIntVers);
    }

    @Override
    @Nonnull
    protected Class<ProductionRoutingMatlAssgmt> getEntityClass()
    {
        return ProductionRoutingMatlAssgmt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
