/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.field.ProductionRoutingOpCompAllocField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.selectable.ProductionRoutingOpCompAllocSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Component Allocation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProductionRoutingOpCompAllocType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductionRoutingOpCompAlloc extends VdmEntity<ProductionRoutingOpCompAlloc>
{

    /**
     * Selector for all available fields of ProductionRoutingOpCompAlloc.
     *
     */
    public final static ProductionRoutingOpCompAllocSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "ProductionRoutingGroup" )
    @JsonProperty( "ProductionRoutingGroup" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingGroup" )
    private String productionRoutingGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingGroup</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> PRODUCTION_ROUTING_GROUP =
        new ProductionRoutingOpCompAllocField<String>("ProductionRoutingGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRouting</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "ProductionRouting" )
    @JsonProperty( "ProductionRouting" )
    @Nullable
    @ODataField( odataName = "ProductionRouting" )
    private String productionRouting;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRouting</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> PRODUCTION_ROUTING =
        new ProductionRoutingOpCompAllocField<String>("ProductionRouting");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingSequence</b>
     * </p>
     *
     * @return Sequence
     */
    @Key
    @SerializedName( "ProductionRoutingSequence" )
    @JsonProperty( "ProductionRoutingSequence" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingSequence" )
    private String productionRoutingSequence;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingSequence</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> PRODUCTION_ROUTING_SEQUENCE =
        new ProductionRoutingOpCompAllocField<String>("ProductionRoutingSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingOpIntID</b>
     * </p>
     *
     * @return Task list node number for operation
     */
    @Key
    @SerializedName( "ProductionRoutingOpIntID" )
    @JsonProperty( "ProductionRoutingOpIntID" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingOpIntID" )
    private String productionRoutingOpIntID;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingOpIntID</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> PRODUCTION_ROUTING_OP_INT_ID =
        new ProductionRoutingOpCompAllocField<String>("ProductionRoutingOpIntID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRtgOpBOMItemInternalID</b>
     * </p>
     *
     * @return No. for material comp. allocation to task list
     */
    @Key
    @SerializedName( "ProdnRtgOpBOMItemInternalID" )
    @JsonProperty( "ProdnRtgOpBOMItemInternalID" )
    @Nullable
    @ODataField( odataName = "ProdnRtgOpBOMItemInternalID" )
    private String prodnRtgOpBOMItemInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRtgOpBOMItemInternalID</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> PRODN_RTG_OP_BOM_ITEM_INTERNAL_ID =
        new ProductionRoutingOpCompAllocField<String>("ProdnRtgOpBOMItemInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRtgOpBOMItemIntVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "ProdnRtgOpBOMItemIntVersion" )
    @JsonProperty( "ProdnRtgOpBOMItemIntVersion" )
    @Nullable
    @ODataField( odataName = "ProdnRtgOpBOMItemIntVersion" )
    private String prodnRtgOpBOMItemIntVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRtgOpBOMItemIntVersion</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> PRODN_RTG_OP_BOM_ITEM_INT_VERSION =
        new ProductionRoutingOpCompAllocField<String>("ProdnRtgOpBOMItemIntVersion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return BOM category
     */
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> BILL_OF_MATERIAL_CATEGORY =
        new ProductionRoutingOpCompAllocField<String>("BillOfMaterialCategory");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @return Bill Of Material
     */
    @SerializedName( "BillOfMaterial" )
    @JsonProperty( "BillOfMaterial" )
    @Nullable
    @ODataField( odataName = "BillOfMaterial" )
    private String billOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterial</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> BILL_OF_MATERIAL =
        new ProductionRoutingOpCompAllocField<String>("BillOfMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @return Alternative BOM
     */
    @SerializedName( "BillOfMaterialVariant" )
    @JsonProperty( "BillOfMaterialVariant" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariant" )
    private String billOfMaterialVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariant</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> BILL_OF_MATERIAL_VARIANT =
        new ProductionRoutingOpCompAllocField<String>("BillOfMaterialVariant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     * </p>
     *
     * @return Node Number
     */
    @SerializedName( "BillOfMaterialItemNodeNumber" )
    @JsonProperty( "BillOfMaterialItemNodeNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNodeNumber" )
    private String billOfMaterialItemNodeNumber;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemNodeNumber</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> BILL_OF_MATERIAL_ITEM_NODE_NUMBER =
        new ProductionRoutingOpCompAllocField<String>("BillOfMaterialItemNodeNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @return Indicator: Backflush
     */
    @SerializedName( "MatlCompIsMarkedForBackflush" )
    @JsonProperty( "MatlCompIsMarkedForBackflush" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MatlCompIsMarkedForBackflush" )
    private Boolean matlCompIsMarkedForBackflush;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompIsMarkedForBackflush</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<Boolean> MATL_COMP_IS_MARKED_FOR_BACKFLUSH =
        new ProductionRoutingOpCompAllocField<Boolean>("MatlCompIsMarkedForBackflush");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<LocalDateTime> CREATION_DATE =
        new ProductionRoutingOpCompAllocField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> CREATED_BY_USER =
        new ProductionRoutingOpCompAllocField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Change Date Without Document Update
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<LocalDateTime> LAST_CHANGE_DATE =
        new ProductionRoutingOpCompAllocField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<LocalDateTime> VALIDITY_START_DATE =
        new ProductionRoutingOpCompAllocField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<LocalDateTime> VALIDITY_END_DATE =
        new ProductionRoutingOpCompAllocField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> CHANGE_NUMBER =
        new ProductionRoutingOpCompAllocField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<String> LAST_CHANGED_BY_USER =
        new ProductionRoutingOpCompAllocField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static ProductionRoutingOpCompAllocField<ZonedDateTime> CHANGED_DATE_TIME =
        new ProductionRoutingOpCompAllocField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<ProductionRoutingOpCompAlloc> getType()
    {
        return ProductionRoutingOpCompAlloc.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingGroup</b>
     * </p>
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     */
    public void setProductionRoutingGroup( @Nullable final String productionRoutingGroup )
    {
        rememberChangedField("ProductionRoutingGroup", this.productionRoutingGroup);
        this.productionRoutingGroup = productionRoutingGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRouting</b>
     * </p>
     *
     * @param productionRouting
     *            Group Counter
     */
    public void setProductionRouting( @Nullable final String productionRouting )
    {
        rememberChangedField("ProductionRouting", this.productionRouting);
        this.productionRouting = productionRouting;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingSequence</b>
     * </p>
     *
     * @param productionRoutingSequence
     *            Sequence
     */
    public void setProductionRoutingSequence( @Nullable final String productionRoutingSequence )
    {
        rememberChangedField("ProductionRoutingSequence", this.productionRoutingSequence);
        this.productionRoutingSequence = productionRoutingSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingOpIntID</b>
     * </p>
     *
     * @param productionRoutingOpIntID
     *            Task list node number for operation
     */
    public void setProductionRoutingOpIntID( @Nullable final String productionRoutingOpIntID )
    {
        rememberChangedField("ProductionRoutingOpIntID", this.productionRoutingOpIntID);
        this.productionRoutingOpIntID = productionRoutingOpIntID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRtgOpBOMItemInternalID</b>
     * </p>
     *
     * @param prodnRtgOpBOMItemInternalID
     *            No. for material comp. allocation to task list
     */
    public void setProdnRtgOpBOMItemInternalID( @Nullable final String prodnRtgOpBOMItemInternalID )
    {
        rememberChangedField("ProdnRtgOpBOMItemInternalID", this.prodnRtgOpBOMItemInternalID);
        this.prodnRtgOpBOMItemInternalID = prodnRtgOpBOMItemInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRtgOpBOMItemIntVersion</b>
     * </p>
     *
     * @param prodnRtgOpBOMItemIntVersion
     *            Internal counter
     */
    public void setProdnRtgOpBOMItemIntVersion( @Nullable final String prodnRtgOpBOMItemIntVersion )
    {
        rememberChangedField("ProdnRtgOpBOMItemIntVersion", this.prodnRtgOpBOMItemIntVersion);
        this.prodnRtgOpBOMItemIntVersion = prodnRtgOpBOMItemIntVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            BOM category
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @param billOfMaterial
     *            Bill Of Material
     */
    public void setBillOfMaterial( @Nullable final String billOfMaterial )
    {
        rememberChangedField("BillOfMaterial", this.billOfMaterial);
        this.billOfMaterial = billOfMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @param billOfMaterialVariant
     *            Alternative BOM
     */
    public void setBillOfMaterialVariant( @Nullable final String billOfMaterialVariant )
    {
        rememberChangedField("BillOfMaterialVariant", this.billOfMaterialVariant);
        this.billOfMaterialVariant = billOfMaterialVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNodeNumber
     *            Node Number
     */
    public void setBillOfMaterialItemNodeNumber( @Nullable final String billOfMaterialItemNodeNumber )
    {
        rememberChangedField("BillOfMaterialItemNodeNumber", this.billOfMaterialItemNodeNumber);
        this.billOfMaterialItemNodeNumber = billOfMaterialItemNodeNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @param matlCompIsMarkedForBackflush
     *            Indicator: Backflush
     */
    public void setMatlCompIsMarkedForBackflush( @Nullable final Boolean matlCompIsMarkedForBackflush )
    {
        rememberChangedField("MatlCompIsMarkedForBackflush", this.matlCompIsMarkedForBackflush);
        this.matlCompIsMarkedForBackflush = matlCompIsMarkedForBackflush;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Change Date Without Document Update
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProductionRoutingOpCompAlloc";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductionRoutingGroup", getProductionRoutingGroup());
        result.put("ProductionRouting", getProductionRouting());
        result.put("ProductionRoutingSequence", getProductionRoutingSequence());
        result.put("ProductionRoutingOpIntID", getProductionRoutingOpIntID());
        result.put("ProdnRtgOpBOMItemInternalID", getProdnRtgOpBOMItemInternalID());
        result.put("ProdnRtgOpBOMItemIntVersion", getProdnRtgOpBOMItemIntVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProductionRoutingGroup", getProductionRoutingGroup());
        values.put("ProductionRouting", getProductionRouting());
        values.put("ProductionRoutingSequence", getProductionRoutingSequence());
        values.put("ProductionRoutingOpIntID", getProductionRoutingOpIntID());
        values.put("ProdnRtgOpBOMItemInternalID", getProdnRtgOpBOMItemInternalID());
        values.put("ProdnRtgOpBOMItemIntVersion", getProdnRtgOpBOMItemIntVersion());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("BillOfMaterial", getBillOfMaterial());
        values.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        values.put("BillOfMaterialItemNodeNumber", getBillOfMaterialItemNodeNumber());
        values.put("MatlCompIsMarkedForBackflush", getMatlCompIsMarkedForBackflush());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductionRoutingGroup") ) {
                final Object value = values.remove("ProductionRoutingGroup");
                if( (value == null) || (!value.equals(getProductionRoutingGroup())) ) {
                    setProductionRoutingGroup(((String) value));
                }
            }
            if( values.containsKey("ProductionRouting") ) {
                final Object value = values.remove("ProductionRouting");
                if( (value == null) || (!value.equals(getProductionRouting())) ) {
                    setProductionRouting(((String) value));
                }
            }
            if( values.containsKey("ProductionRoutingSequence") ) {
                final Object value = values.remove("ProductionRoutingSequence");
                if( (value == null) || (!value.equals(getProductionRoutingSequence())) ) {
                    setProductionRoutingSequence(((String) value));
                }
            }
            if( values.containsKey("ProductionRoutingOpIntID") ) {
                final Object value = values.remove("ProductionRoutingOpIntID");
                if( (value == null) || (!value.equals(getProductionRoutingOpIntID())) ) {
                    setProductionRoutingOpIntID(((String) value));
                }
            }
            if( values.containsKey("ProdnRtgOpBOMItemInternalID") ) {
                final Object value = values.remove("ProdnRtgOpBOMItemInternalID");
                if( (value == null) || (!value.equals(getProdnRtgOpBOMItemInternalID())) ) {
                    setProdnRtgOpBOMItemInternalID(((String) value));
                }
            }
            if( values.containsKey("ProdnRtgOpBOMItemIntVersion") ) {
                final Object value = values.remove("ProdnRtgOpBOMItemIntVersion");
                if( (value == null) || (!value.equals(getProdnRtgOpBOMItemIntVersion())) ) {
                    setProdnRtgOpBOMItemIntVersion(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterial") ) {
                final Object value = values.remove("BillOfMaterial");
                if( (value == null) || (!value.equals(getBillOfMaterial())) ) {
                    setBillOfMaterial(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariant") ) {
                final Object value = values.remove("BillOfMaterialVariant");
                if( (value == null) || (!value.equals(getBillOfMaterialVariant())) ) {
                    setBillOfMaterialVariant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNodeNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNodeNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNodeNumber())) ) {
                    setBillOfMaterialItemNodeNumber(((String) value));
                }
            }
            if( values.containsKey("MatlCompIsMarkedForBackflush") ) {
                final Object value = values.remove("MatlCompIsMarkedForBackflush");
                if( (value == null) || (!value.equals(getMatlCompIsMarkedForBackflush())) ) {
                    setMatlCompIsMarkedForBackflush(((Boolean) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProductionRoutingOpCompAllocField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ProductionRoutingOpCompAllocField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductionRoutingOpCompAllocField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductionRoutingOpCompAllocField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService.DEFAULT_SERVICE_PATH);
    }

}
