/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.selectable.ProductionRoutingOpCompAllocSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
 * ProductionRoutingOpCompAlloc} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ProductionRoutingOpCompAllocByKeyFluentHelper
    extends
    FluentHelperByKey<ProductionRoutingOpCompAllocByKeyFluentHelper, ProductionRoutingOpCompAlloc, ProductionRoutingOpCompAllocSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     * ProductionRoutingOpCompAlloc} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProductionRoutingOpCompAlloc}
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productionRoutingOpIntID
     *            Task list node number for operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProductionRoutingOpCompAlloc}
     * @param prodnRtgOpBOMItemIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param prodnRtgOpBOMItemInternalID
     *            No. for material comp. allocation to task list
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public ProductionRoutingOpCompAllocByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String prodnRtgOpBOMItemInternalID,
        final String prodnRtgOpBOMItemIntVersion )
    {
        super(servicePath, entityCollection);
        this.key.put("ProductionRoutingGroup", productionRoutingGroup);
        this.key.put("ProductionRouting", productionRouting);
        this.key.put("ProductionRoutingSequence", productionRoutingSequence);
        this.key.put("ProductionRoutingOpIntID", productionRoutingOpIntID);
        this.key.put("ProdnRtgOpBOMItemInternalID", prodnRtgOpBOMItemInternalID);
        this.key.put("ProdnRtgOpBOMItemIntVersion", prodnRtgOpBOMItemIntVersion);
    }

    @Override
    @Nonnull
    protected Class<ProductionRoutingOpCompAlloc> getEntityClass()
    {
        return ProductionRoutingOpCompAlloc.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
