/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.selectable.ProductionRoutingOperationSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
 * ProductionRoutingOperation} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ProductionRoutingOperationByKeyFluentHelper
    extends
    FluentHelperByKey<ProductionRoutingOperationByKeyFluentHelper, ProductionRoutingOperation, ProductionRoutingOperationSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     * ProductionRoutingOperation} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProductionRoutingOperation}
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productionRoutingOpIntID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingOpIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProductionRoutingOperation}
     * @param productionRoutingSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public ProductionRoutingOperationByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String productionRoutingOpIntVersion )
    {
        super(servicePath, entityCollection);
        this.key.put("ProductionRoutingGroup", productionRoutingGroup);
        this.key.put("ProductionRouting", productionRouting);
        this.key.put("ProductionRoutingSequence", productionRoutingSequence);
        this.key.put("ProductionRoutingOpIntID", productionRoutingOpIntID);
        this.key.put("ProductionRoutingOpIntVersion", productionRoutingOpIntVersion);
    }

    @Override
    @Nonnull
    protected Class<ProductionRoutingOperation> getEntityClass()
    {
        return ProductionRoutingOperation.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
