/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.field.ProductionRoutingSequenceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.link.ProductionRoutingSequenceLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.selectable.ProductionRoutingSequenceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sequence
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProductionRoutingSequenceType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductionRoutingSequence extends VdmEntity<ProductionRoutingSequence>
{

    /**
     * Selector for all available fields of ProductionRoutingSequence.
     *
     */
    public final static ProductionRoutingSequenceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "ProductionRoutingGroup" )
    @JsonProperty( "ProductionRoutingGroup" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingGroup" )
    private String productionRoutingGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingGroup</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> PRODUCTION_ROUTING_GROUP =
        new ProductionRoutingSequenceField<String>("ProductionRoutingGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRouting</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "ProductionRouting" )
    @JsonProperty( "ProductionRouting" )
    @Nullable
    @ODataField( odataName = "ProductionRouting" )
    private String productionRouting;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRouting</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> PRODUCTION_ROUTING =
        new ProductionRoutingSequenceField<String>("ProductionRouting");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingSequence</b>
     * </p>
     *
     * @return Sequence
     */
    @Key
    @SerializedName( "ProductionRoutingSequence" )
    @JsonProperty( "ProductionRoutingSequence" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingSequence" )
    private String productionRoutingSequence;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingSequence</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> PRODUCTION_ROUTING_SEQUENCE =
        new ProductionRoutingSequenceField<String>("ProductionRoutingSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingSqncIntVers</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "ProductionRoutingSqncIntVers" )
    @JsonProperty( "ProductionRoutingSqncIntVers" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingSqncIntVers" )
    private String productionRoutingSqncIntVers;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingSqncIntVers</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> PRODUCTION_ROUTING_SQNC_INT_VERS =
        new ProductionRoutingSequenceField<String>("ProductionRoutingSqncIntVers");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> CHANGE_NUMBER =
        new ProductionRoutingSequenceField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<LocalDateTime> VALIDITY_START_DATE =
        new ProductionRoutingSequenceField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<LocalDateTime> VALIDITY_END_DATE =
        new ProductionRoutingSequenceField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SequenceCategory</b>
     * </p>
     *
     * @return Sequence Category
     */
    @SerializedName( "SequenceCategory" )
    @JsonProperty( "SequenceCategory" )
    @Nullable
    @ODataField( odataName = "SequenceCategory" )
    private String sequenceCategory;
    /**
     * Use with available fluent helpers to apply the <b>SequenceCategory</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> SEQUENCE_CATEGORY =
        new ProductionRoutingSequenceField<String>("SequenceCategory");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsRefSequence</b>
     * </p>
     *
     * @return Reference Sequence
     */
    @SerializedName( "BillOfOperationsRefSequence" )
    @JsonProperty( "BillOfOperationsRefSequence" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsRefSequence" )
    private String billOfOperationsRefSequence;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsRefSequence</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> BILL_OF_OPERATIONS_REF_SEQUENCE =
        new ProductionRoutingSequenceField<String>("BillOfOperationsRefSequence");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOSqncBranchOpInternalID</b>
     * </p>
     *
     * @return Reference node for start of a sequence
     */
    @SerializedName( "BOOSqncBranchOpInternalID" )
    @JsonProperty( "BOOSqncBranchOpInternalID" )
    @Nullable
    @ODataField( odataName = "BOOSqncBranchOpInternalID" )
    private String bOOSqncBranchOpInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BOOSqncBranchOpInternalID</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> BOO_SQNC_BRANCH_OP_INTERNAL_ID =
        new ProductionRoutingSequenceField<String>("BOOSqncBranchOpInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOSqncReturnOpInternalID</b>
     * </p>
     *
     * @return Finish reference node of a sequence
     */
    @SerializedName( "BOOSqncReturnOpInternalID" )
    @JsonProperty( "BOOSqncReturnOpInternalID" )
    @Nullable
    @ODataField( odataName = "BOOSqncReturnOpInternalID" )
    private String bOOSqncReturnOpInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BOOSqncReturnOpInternalID</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> BOO_SQNC_RETURN_OP_INTERNAL_ID =
        new ProductionRoutingSequenceField<String>("BOOSqncReturnOpInternalID");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @return Minimum Lot Size
     */
    @SerializedName( "MinimumLotSizeQuantity" )
    @JsonProperty( "MinimumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumLotSizeQuantity" )
    private BigDecimal minimumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<BigDecimal> MINIMUM_LOT_SIZE_QUANTITY =
        new ProductionRoutingSequenceField<BigDecimal>("MinimumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @return Maximum Lot Size
     */
    @SerializedName( "MaximumLotSizeQuantity" )
    @JsonProperty( "MaximumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumLotSizeQuantity" )
    private BigDecimal maximumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<BigDecimal> MAXIMUM_LOT_SIZE_QUANTITY =
        new ProductionRoutingSequenceField<BigDecimal>("MaximumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUnit</b>
     * </p>
     *
     * @return Task List Unit of Measure
     */
    @SerializedName( "BillOfOperationsUnit" )
    @JsonProperty( "BillOfOperationsUnit" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsUnit" )
    private String billOfOperationsUnit;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsUnit</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> BILL_OF_OPERATIONS_UNIT =
        new ProductionRoutingSequenceField<String>("BillOfOperationsUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SequenceText</b>
     * </p>
     *
     * @return Sequence Description
     */
    @SerializedName( "SequenceText" )
    @JsonProperty( "SequenceText" )
    @Nullable
    @ODataField( odataName = "SequenceText" )
    private String sequenceText;
    /**
     * Use with available fluent helpers to apply the <b>SequenceText</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> SEQUENCE_TEXT =
        new ProductionRoutingSequenceField<String>("SequenceText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<LocalDateTime> CREATION_DATE =
        new ProductionRoutingSequenceField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> CREATED_BY_USER =
        new ProductionRoutingSequenceField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<LocalDateTime> LAST_CHANGE_DATE =
        new ProductionRoutingSequenceField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<String> LAST_CHANGED_BY_USER =
        new ProductionRoutingSequenceField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static ProductionRoutingSequenceField<ZonedDateTime> CHANGED_DATE_TIME =
        new ProductionRoutingSequenceField<ZonedDateTime>("ChangedDateTime");
    /**
     * Navigation property <b>to_Operation</b> for <b>ProductionRoutingSequence</b> to multiple
     * <b>ProductionRoutingOperation</b>.
     *
     */
    @SerializedName( "to_Operation" )
    @JsonProperty( "to_Operation" )
    @ODataField( odataName = "to_Operation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductionRoutingOperation> toOperation;
    /**
     * Use with available fluent helpers to apply the <b>to_Operation</b> navigation property to query operations.
     *
     */
    public final static ProductionRoutingSequenceLink<ProductionRoutingOperation> TO_OPERATION =
        new ProductionRoutingSequenceLink<ProductionRoutingOperation>("to_Operation");

    @Nonnull
    @Override
    public Class<ProductionRoutingSequence> getType()
    {
        return ProductionRoutingSequence.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingGroup</b>
     * </p>
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     */
    public void setProductionRoutingGroup( @Nullable final String productionRoutingGroup )
    {
        rememberChangedField("ProductionRoutingGroup", this.productionRoutingGroup);
        this.productionRoutingGroup = productionRoutingGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRouting</b>
     * </p>
     *
     * @param productionRouting
     *            Group Counter
     */
    public void setProductionRouting( @Nullable final String productionRouting )
    {
        rememberChangedField("ProductionRouting", this.productionRouting);
        this.productionRouting = productionRouting;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingSequence</b>
     * </p>
     *
     * @param productionRoutingSequence
     *            Sequence
     */
    public void setProductionRoutingSequence( @Nullable final String productionRoutingSequence )
    {
        rememberChangedField("ProductionRoutingSequence", this.productionRoutingSequence);
        this.productionRoutingSequence = productionRoutingSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingSqncIntVers</b>
     * </p>
     *
     * @param productionRoutingSqncIntVers
     *            Internal counter
     */
    public void setProductionRoutingSqncIntVers( @Nullable final String productionRoutingSqncIntVers )
    {
        rememberChangedField("ProductionRoutingSqncIntVers", this.productionRoutingSqncIntVers);
        this.productionRoutingSqncIntVers = productionRoutingSqncIntVers;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SequenceCategory</b>
     * </p>
     *
     * @param sequenceCategory
     *            Sequence Category
     */
    public void setSequenceCategory( @Nullable final String sequenceCategory )
    {
        rememberChangedField("SequenceCategory", this.sequenceCategory);
        this.sequenceCategory = sequenceCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsRefSequence</b>
     * </p>
     *
     * @param billOfOperationsRefSequence
     *            Reference Sequence
     */
    public void setBillOfOperationsRefSequence( @Nullable final String billOfOperationsRefSequence )
    {
        rememberChangedField("BillOfOperationsRefSequence", this.billOfOperationsRefSequence);
        this.billOfOperationsRefSequence = billOfOperationsRefSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOSqncBranchOpInternalID</b>
     * </p>
     *
     * @param bOOSqncBranchOpInternalID
     *            Reference node for start of a sequence
     */
    public void setBOOSqncBranchOpInternalID( @Nullable final String bOOSqncBranchOpInternalID )
    {
        rememberChangedField("BOOSqncBranchOpInternalID", this.bOOSqncBranchOpInternalID);
        this.bOOSqncBranchOpInternalID = bOOSqncBranchOpInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOSqncReturnOpInternalID</b>
     * </p>
     *
     * @param bOOSqncReturnOpInternalID
     *            Finish reference node of a sequence
     */
    public void setBOOSqncReturnOpInternalID( @Nullable final String bOOSqncReturnOpInternalID )
    {
        rememberChangedField("BOOSqncReturnOpInternalID", this.bOOSqncReturnOpInternalID);
        this.bOOSqncReturnOpInternalID = bOOSqncReturnOpInternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @param minimumLotSizeQuantity
     *            Minimum Lot Size
     */
    public void setMinimumLotSizeQuantity( @Nullable final BigDecimal minimumLotSizeQuantity )
    {
        rememberChangedField("MinimumLotSizeQuantity", this.minimumLotSizeQuantity);
        this.minimumLotSizeQuantity = minimumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @param maximumLotSizeQuantity
     *            Maximum Lot Size
     */
    public void setMaximumLotSizeQuantity( @Nullable final BigDecimal maximumLotSizeQuantity )
    {
        rememberChangedField("MaximumLotSizeQuantity", this.maximumLotSizeQuantity);
        this.maximumLotSizeQuantity = maximumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUnit</b>
     * </p>
     *
     * @param billOfOperationsUnit
     *            Task List Unit of Measure
     */
    public void setBillOfOperationsUnit( @Nullable final String billOfOperationsUnit )
    {
        rememberChangedField("BillOfOperationsUnit", this.billOfOperationsUnit);
        this.billOfOperationsUnit = billOfOperationsUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SequenceText</b>
     * </p>
     *
     * @param sequenceText
     *            Sequence Description
     */
    public void setSequenceText( @Nullable final String sequenceText )
    {
        rememberChangedField("SequenceText", this.sequenceText);
        this.sequenceText = sequenceText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProductionRoutingSequence";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductionRoutingGroup", getProductionRoutingGroup());
        result.put("ProductionRouting", getProductionRouting());
        result.put("ProductionRoutingSequence", getProductionRoutingSequence());
        result.put("ProductionRoutingSqncIntVers", getProductionRoutingSqncIntVers());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProductionRoutingGroup", getProductionRoutingGroup());
        values.put("ProductionRouting", getProductionRouting());
        values.put("ProductionRoutingSequence", getProductionRoutingSequence());
        values.put("ProductionRoutingSqncIntVers", getProductionRoutingSqncIntVers());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("SequenceCategory", getSequenceCategory());
        values.put("BillOfOperationsRefSequence", getBillOfOperationsRefSequence());
        values.put("BOOSqncBranchOpInternalID", getBOOSqncBranchOpInternalID());
        values.put("BOOSqncReturnOpInternalID", getBOOSqncReturnOpInternalID());
        values.put("MinimumLotSizeQuantity", getMinimumLotSizeQuantity());
        values.put("MaximumLotSizeQuantity", getMaximumLotSizeQuantity());
        values.put("BillOfOperationsUnit", getBillOfOperationsUnit());
        values.put("SequenceText", getSequenceText());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductionRoutingGroup") ) {
                final Object value = values.remove("ProductionRoutingGroup");
                if( (value == null) || (!value.equals(getProductionRoutingGroup())) ) {
                    setProductionRoutingGroup(((String) value));
                }
            }
            if( values.containsKey("ProductionRouting") ) {
                final Object value = values.remove("ProductionRouting");
                if( (value == null) || (!value.equals(getProductionRouting())) ) {
                    setProductionRouting(((String) value));
                }
            }
            if( values.containsKey("ProductionRoutingSequence") ) {
                final Object value = values.remove("ProductionRoutingSequence");
                if( (value == null) || (!value.equals(getProductionRoutingSequence())) ) {
                    setProductionRoutingSequence(((String) value));
                }
            }
            if( values.containsKey("ProductionRoutingSqncIntVers") ) {
                final Object value = values.remove("ProductionRoutingSqncIntVers");
                if( (value == null) || (!value.equals(getProductionRoutingSqncIntVers())) ) {
                    setProductionRoutingSqncIntVers(((String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SequenceCategory") ) {
                final Object value = values.remove("SequenceCategory");
                if( (value == null) || (!value.equals(getSequenceCategory())) ) {
                    setSequenceCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsRefSequence") ) {
                final Object value = values.remove("BillOfOperationsRefSequence");
                if( (value == null) || (!value.equals(getBillOfOperationsRefSequence())) ) {
                    setBillOfOperationsRefSequence(((String) value));
                }
            }
            if( values.containsKey("BOOSqncBranchOpInternalID") ) {
                final Object value = values.remove("BOOSqncBranchOpInternalID");
                if( (value == null) || (!value.equals(getBOOSqncBranchOpInternalID())) ) {
                    setBOOSqncBranchOpInternalID(((String) value));
                }
            }
            if( values.containsKey("BOOSqncReturnOpInternalID") ) {
                final Object value = values.remove("BOOSqncReturnOpInternalID");
                if( (value == null) || (!value.equals(getBOOSqncReturnOpInternalID())) ) {
                    setBOOSqncReturnOpInternalID(((String) value));
                }
            }
            if( values.containsKey("MinimumLotSizeQuantity") ) {
                final Object value = values.remove("MinimumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMinimumLotSizeQuantity())) ) {
                    setMinimumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumLotSizeQuantity") ) {
                final Object value = values.remove("MaximumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMaximumLotSizeQuantity())) ) {
                    setMaximumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillOfOperationsUnit") ) {
                final Object value = values.remove("BillOfOperationsUnit");
                if( (value == null) || (!value.equals(getBillOfOperationsUnit())) ) {
                    setBillOfOperationsUnit(((String) value));
                }
            }
            if( values.containsKey("SequenceText") ) {
                final Object value = values.remove("SequenceText");
                if( (value == null) || (!value.equals(getSequenceText())) ) {
                    setSequenceText(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Operation") ) {
                final Object value = (values).remove("to_Operation");
                if( value instanceof Iterable ) {
                    if( toOperation == null ) {
                        toOperation = Lists.newArrayList();
                    } else {
                        toOperation = Lists.newArrayList(toOperation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductionRoutingOperation entity;
                        if( toOperation.size() > i ) {
                            entity = toOperation.get(i);
                        } else {
                            entity = new ProductionRoutingOperation();
                            toOperation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductionRoutingSequenceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductionRoutingSequenceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductionRoutingSequenceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductionRoutingSequenceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toOperation != null ) {
            (values).put("to_Operation", toOperation);
        }
        return values;
    }

    /**
     * Fetches the <b>ProductionRoutingOperation</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Operation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductionRoutingOperation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductionRoutingOperation> fetchOperation()
    {
        return fetchFieldAsList("to_Operation", ProductionRoutingOperation.class);
    }

    /**
     * Retrieval of associated <b>ProductionRoutingOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Operation</b>.
     * <p>
     * If the navigation property <b>to_Operation</b> of a queried <b>ProductionRoutingSequence</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductionRoutingOperation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductionRoutingOperation> getOperationOrFetch()
    {
        if( toOperation == null ) {
            toOperation = fetchOperation();
        }
        return toOperation;
    }

    /**
     * Retrieval of associated <b>ProductionRoutingOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Operation</b>.
     * <p>
     * If the navigation property for an entity <b>ProductionRoutingSequence</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Operation</b> is already loaded, the result will contain
     *         the <b>ProductionRoutingOperation</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductionRoutingOperation>> getOperationIfPresent()
    {
        return Option.of(toOperation);
    }

    /**
     * Overwrites the list of associated <b>ProductionRoutingOperation</b> entities for the loaded navigation property
     * <b>to_Operation</b>.
     * <p>
     * If the navigation property <b>to_Operation</b> of a queried <b>ProductionRoutingSequence</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductionRoutingOperation</b> entities.
     */
    public void setOperation( @Nonnull final List<ProductionRoutingOperation> value )
    {
        if( toOperation == null ) {
            toOperation = Lists.newArrayList();
        }
        toOperation.clear();
        toOperation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductionRoutingOperation</b> entities. This corresponds to the OData
     * navigation property <b>to_Operation</b>.
     * <p>
     * If the navigation property <b>to_Operation</b> of a queried <b>ProductionRoutingSequence</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductionRoutingOperation</b> entities.
     */
    public void addOperation( ProductionRoutingOperation... entity )
    {
        if( toOperation == null ) {
            toOperation = Lists.newArrayList();
        }
        toOperation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProductionRoutingSequence instances.
     *
     */
    public final static class ProductionRoutingSequenceBuilder
    {

        private List<ProductionRoutingOperation> toOperation = Lists.newArrayList();

        private ProductionRoutingSequence.ProductionRoutingSequenceBuilder toOperation(
            final List<ProductionRoutingOperation> value )
        {
            toOperation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Operation</b> for <b>ProductionRoutingSequence</b> to multiple
         * <b>ProductionRoutingOperation</b>.
         *
         * @param value
         *            The ProductionRoutingOperations to build this ProductionRoutingSequence with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductionRoutingSequence.ProductionRoutingSequenceBuilder operation(
            ProductionRoutingOperation... value )
        {
            return toOperation(Lists.newArrayList(value));
        }

    }

}
