/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.field.ProductionRoutingSubOperationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.selectable.ProductionRoutingSubOperationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Sub Operation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProductionRoutingSubOperationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductionRoutingSubOperation extends VdmEntity<ProductionRoutingSubOperation>
{

    /**
     * Selector for all available fields of ProductionRoutingSubOperation.
     *
     */
    public final static ProductionRoutingSubOperationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "ProductionRoutingGroup" )
    @JsonProperty( "ProductionRoutingGroup" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingGroup" )
    private String productionRoutingGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingGroup</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PRODUCTION_ROUTING_GROUP =
        new ProductionRoutingSubOperationField<String>("ProductionRoutingGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRouting</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "ProductionRouting" )
    @JsonProperty( "ProductionRouting" )
    @Nullable
    @ODataField( odataName = "ProductionRouting" )
    private String productionRouting;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRouting</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PRODUCTION_ROUTING =
        new ProductionRoutingSubOperationField<String>("ProductionRouting");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingOpIntID</b>
     * </p>
     *
     * @return Number of the Task List Node
     */
    @Key
    @SerializedName( "ProductionRoutingOpIntID" )
    @JsonProperty( "ProductionRoutingOpIntID" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingOpIntID" )
    private String productionRoutingOpIntID;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingOpIntID</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PRODUCTION_ROUTING_OP_INT_ID =
        new ProductionRoutingSubOperationField<String>("ProductionRoutingOpIntID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingSequence</b>
     * </p>
     *
     * @return Sequence
     */
    @Key
    @SerializedName( "ProductionRoutingSequence" )
    @JsonProperty( "ProductionRoutingSequence" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingSequence" )
    private String productionRoutingSequence;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingSequence</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PRODUCTION_ROUTING_SEQUENCE =
        new ProductionRoutingSubOperationField<String>("ProductionRoutingSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingOpIntVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "ProductionRoutingOpIntVersion" )
    @JsonProperty( "ProductionRoutingOpIntVersion" )
    @Nullable
    @ODataField( odataName = "ProductionRoutingOpIntVersion" )
    private String productionRoutingOpIntVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProductionRoutingOpIntVersion</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PRODUCTION_ROUTING_OP_INT_VERSION =
        new ProductionRoutingSubOperationField<String>("ProductionRoutingOpIntVersion");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorOperationInternalID</b>
     * </p>
     *
     * @return Node Number of the Superior Operation
     */
    @SerializedName( "SuperiorOperationInternalID" )
    @JsonProperty( "SuperiorOperationInternalID" )
    @Nullable
    @ODataField( odataName = "SuperiorOperationInternalID" )
    private String superiorOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>SuperiorOperationInternalID</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> SUPERIOR_OPERATION_INTERNAL_ID =
        new ProductionRoutingSubOperationField<String>("SuperiorOperationInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @return Operation / Phase Number
     */
    @SerializedName( "Operation" )
    @JsonProperty( "Operation" )
    @Nullable
    @ODataField( odataName = "Operation" )
    private String operation;
    /**
     * Use with available fluent helpers to apply the <b>Operation</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> OPERATION =
        new ProductionRoutingSubOperationField<String>("Operation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     *
     * @return Operation Short Text
     */
    @SerializedName( "OperationText" )
    @JsonProperty( "OperationText" )
    @Nullable
    @ODataField( odataName = "OperationText" )
    private String operationText;
    /**
     * Use with available fluent helpers to apply the <b>OperationText</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> OPERATION_TEXT =
        new ProductionRoutingSubOperationField<String>("OperationText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LongTextLanguageCode</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "LongTextLanguageCode" )
    @JsonProperty( "LongTextLanguageCode" )
    @Nullable
    @ODataField( odataName = "LongTextLanguageCode" )
    private String longTextLanguageCode;
    /**
     * Use with available fluent helpers to apply the <b>LongTextLanguageCode</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> LONG_TEXT_LANGUAGE_CODE =
        new ProductionRoutingSubOperationField<String>("LongTextLanguageCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> WORK_CENTER_TYPE_CODE =
        new ProductionRoutingSubOperationField<String>("WorkCenterTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID
     */
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> WORK_CENTER_INTERNAL_ID =
        new ProductionRoutingSubOperationField<String>("WorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PLANT =
        new ProductionRoutingSubOperationField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @return Control Key
     */
    @SerializedName( "OperationControlProfile" )
    @JsonProperty( "OperationControlProfile" )
    @Nullable
    @ODataField( odataName = "OperationControlProfile" )
    private String operationControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>OperationControlProfile</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> OPERATION_CONTROL_PROFILE =
        new ProductionRoutingSubOperationField<String>("OperationControlProfile");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>OperationStandardTextCode</b>
     * </p>
     *
     * @return Standard Text Key
     */
    @SerializedName( "OperationStandardTextCode" )
    @JsonProperty( "OperationStandardTextCode" )
    @Nullable
    @ODataField( odataName = "OperationStandardTextCode" )
    private String operationStandardTextCode;
    /**
     * Use with available fluent helpers to apply the <b>OperationStandardTextCode</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> OPERATION_STANDARD_TEXT_CODE =
        new ProductionRoutingSubOperationField<String>("OperationStandardTextCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationReferenceQuantity</b>
     * </p>
     *
     * @return Base Quantity
     */
    @SerializedName( "OperationReferenceQuantity" )
    @JsonProperty( "OperationReferenceQuantity" )
    @Nullable
    @ODataField( odataName = "OperationReferenceQuantity" )
    private BigDecimal operationReferenceQuantity;
    /**
     * Use with available fluent helpers to apply the <b>OperationReferenceQuantity</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> OPERATION_REFERENCE_QUANTITY =
        new ProductionRoutingSubOperationField<BigDecimal>("OperationReferenceQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @return Unit of Measure for Activity/Operation
     */
    @SerializedName( "OperationUnit" )
    @JsonProperty( "OperationUnit" )
    @Nullable
    @ODataField( odataName = "OperationUnit" )
    private String operationUnit;
    /**
     * Use with available fluent helpers to apply the <b>OperationUnit</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> OPERATION_UNIT =
        new ProductionRoutingSubOperationField<String>("OperationUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator for Converting Routing and Operation UoM
     */
    @SerializedName( "OpQtyToBaseQtyNmrtr" )
    @JsonProperty( "OpQtyToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "OpQtyToBaseQtyNmrtr" )
    private BigDecimal opQtyToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OpQtyToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> OP_QTY_TO_BASE_QTY_NMRTR =
        new ProductionRoutingSubOperationField<BigDecimal>("OpQtyToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator for Converting Routing and Operation UoM
     */
    @SerializedName( "OpQtyToBaseQtyDnmntr" )
    @JsonProperty( "OpQtyToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "OpQtyToBaseQtyDnmntr" )
    private BigDecimal opQtyToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OpQtyToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> OP_QTY_TO_BASE_QTY_DNMNTR =
        new ProductionRoutingSubOperationField<BigDecimal>("OpQtyToBaseQtyDnmntr");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantity1</b>
     * </p>
     *
     * @return Standard Work Quantity 1
     */
    @SerializedName( "StandardWorkQuantity1" )
    @JsonProperty( "StandardWorkQuantity1" )
    @Nullable
    @ODataField( odataName = "StandardWorkQuantity1" )
    private BigDecimal standardWorkQuantity1;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkQuantity1</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> STANDARD_WORK_QUANTITY1 =
        new ProductionRoutingSubOperationField<BigDecimal>("StandardWorkQuantity1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantityUnit1</b>
     * </p>
     *
     * @return Standard Work Quantity Unit 1
     */
    @SerializedName( "StandardWorkQuantityUnit1" )
    @JsonProperty( "StandardWorkQuantityUnit1" )
    @Nullable
    @ODataField( odataName = "StandardWorkQuantityUnit1" )
    private String standardWorkQuantityUnit1;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkQuantityUnit1</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> STANDARD_WORK_QUANTITY_UNIT1 =
        new ProductionRoutingSubOperationField<String>("StandardWorkQuantityUnit1");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType1</b>
     * </p>
     *
     * @return Cost Center Activity Type 1
     */
    @SerializedName( "CostCtrActivityType1" )
    @JsonProperty( "CostCtrActivityType1" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType1" )
    private String costCtrActivityType1;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType1</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> COST_CTR_ACTIVITY_TYPE1 =
        new ProductionRoutingSubOperationField<String>("CostCtrActivityType1");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantity2</b>
     * </p>
     *
     * @return Standard Work Quantity 2
     */
    @SerializedName( "StandardWorkQuantity2" )
    @JsonProperty( "StandardWorkQuantity2" )
    @Nullable
    @ODataField( odataName = "StandardWorkQuantity2" )
    private BigDecimal standardWorkQuantity2;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkQuantity2</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> STANDARD_WORK_QUANTITY2 =
        new ProductionRoutingSubOperationField<BigDecimal>("StandardWorkQuantity2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantityUnit2</b>
     * </p>
     *
     * @return Standard Work Quantity Unit 2
     */
    @SerializedName( "StandardWorkQuantityUnit2" )
    @JsonProperty( "StandardWorkQuantityUnit2" )
    @Nullable
    @ODataField( odataName = "StandardWorkQuantityUnit2" )
    private String standardWorkQuantityUnit2;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkQuantityUnit2</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> STANDARD_WORK_QUANTITY_UNIT2 =
        new ProductionRoutingSubOperationField<String>("StandardWorkQuantityUnit2");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType2</b>
     * </p>
     *
     * @return Cost Center Activity Type 2
     */
    @SerializedName( "CostCtrActivityType2" )
    @JsonProperty( "CostCtrActivityType2" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType2" )
    private String costCtrActivityType2;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType2</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> COST_CTR_ACTIVITY_TYPE2 =
        new ProductionRoutingSubOperationField<String>("CostCtrActivityType2");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantity3</b>
     * </p>
     *
     * @return Standard Work Quantity 3
     */
    @SerializedName( "StandardWorkQuantity3" )
    @JsonProperty( "StandardWorkQuantity3" )
    @Nullable
    @ODataField( odataName = "StandardWorkQuantity3" )
    private BigDecimal standardWorkQuantity3;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkQuantity3</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> STANDARD_WORK_QUANTITY3 =
        new ProductionRoutingSubOperationField<BigDecimal>("StandardWorkQuantity3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantityUnit3</b>
     * </p>
     *
     * @return Standard Work Quantity Unit 3
     */
    @SerializedName( "StandardWorkQuantityUnit3" )
    @JsonProperty( "StandardWorkQuantityUnit3" )
    @Nullable
    @ODataField( odataName = "StandardWorkQuantityUnit3" )
    private String standardWorkQuantityUnit3;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkQuantityUnit3</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> STANDARD_WORK_QUANTITY_UNIT3 =
        new ProductionRoutingSubOperationField<String>("StandardWorkQuantityUnit3");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType3</b>
     * </p>
     *
     * @return Cost Center Activity Type 3
     */
    @SerializedName( "CostCtrActivityType3" )
    @JsonProperty( "CostCtrActivityType3" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType3" )
    private String costCtrActivityType3;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType3</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> COST_CTR_ACTIVITY_TYPE3 =
        new ProductionRoutingSubOperationField<String>("CostCtrActivityType3");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantity4</b>
     * </p>
     *
     * @return Standard Work Quantity 4
     */
    @SerializedName( "StandardWorkQuantity4" )
    @JsonProperty( "StandardWorkQuantity4" )
    @Nullable
    @ODataField( odataName = "StandardWorkQuantity4" )
    private BigDecimal standardWorkQuantity4;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkQuantity4</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> STANDARD_WORK_QUANTITY4 =
        new ProductionRoutingSubOperationField<BigDecimal>("StandardWorkQuantity4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantityUnit4</b>
     * </p>
     *
     * @return Standard Work Quantity Unit 4
     */
    @SerializedName( "StandardWorkQuantityUnit4" )
    @JsonProperty( "StandardWorkQuantityUnit4" )
    @Nullable
    @ODataField( odataName = "StandardWorkQuantityUnit4" )
    private String standardWorkQuantityUnit4;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkQuantityUnit4</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> STANDARD_WORK_QUANTITY_UNIT4 =
        new ProductionRoutingSubOperationField<String>("StandardWorkQuantityUnit4");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType4</b>
     * </p>
     *
     * @return Cost Center Activity Type 4
     */
    @SerializedName( "CostCtrActivityType4" )
    @JsonProperty( "CostCtrActivityType4" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType4" )
    private String costCtrActivityType4;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType4</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> COST_CTR_ACTIVITY_TYPE4 =
        new ProductionRoutingSubOperationField<String>("CostCtrActivityType4");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantity5</b>
     * </p>
     *
     * @return Standard Work Quantity 5
     */
    @SerializedName( "StandardWorkQuantity5" )
    @JsonProperty( "StandardWorkQuantity5" )
    @Nullable
    @ODataField( odataName = "StandardWorkQuantity5" )
    private BigDecimal standardWorkQuantity5;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkQuantity5</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> STANDARD_WORK_QUANTITY5 =
        new ProductionRoutingSubOperationField<BigDecimal>("StandardWorkQuantity5");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantityUnit5</b>
     * </p>
     *
     * @return Standard Work Quantity Unit 5
     */
    @SerializedName( "StandardWorkQuantityUnit5" )
    @JsonProperty( "StandardWorkQuantityUnit5" )
    @Nullable
    @ODataField( odataName = "StandardWorkQuantityUnit5" )
    private String standardWorkQuantityUnit5;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkQuantityUnit5</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> STANDARD_WORK_QUANTITY_UNIT5 =
        new ProductionRoutingSubOperationField<String>("StandardWorkQuantityUnit5");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType5</b>
     * </p>
     *
     * @return Cost Center Activity Type 5
     */
    @SerializedName( "CostCtrActivityType5" )
    @JsonProperty( "CostCtrActivityType5" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType5" )
    private String costCtrActivityType5;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType5</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> COST_CTR_ACTIVITY_TYPE5 =
        new ProductionRoutingSubOperationField<String>("CostCtrActivityType5");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantity6</b>
     * </p>
     *
     * @return Standard Work Quantity 6
     */
    @SerializedName( "StandardWorkQuantity6" )
    @JsonProperty( "StandardWorkQuantity6" )
    @Nullable
    @ODataField( odataName = "StandardWorkQuantity6" )
    private BigDecimal standardWorkQuantity6;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkQuantity6</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> STANDARD_WORK_QUANTITY6 =
        new ProductionRoutingSubOperationField<BigDecimal>("StandardWorkQuantity6");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantityUnit6</b>
     * </p>
     *
     * @return Standard Work Quantity Unit 6
     */
    @SerializedName( "StandardWorkQuantityUnit6" )
    @JsonProperty( "StandardWorkQuantityUnit6" )
    @Nullable
    @ODataField( odataName = "StandardWorkQuantityUnit6" )
    private String standardWorkQuantityUnit6;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkQuantityUnit6</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> STANDARD_WORK_QUANTITY_UNIT6 =
        new ProductionRoutingSubOperationField<String>("StandardWorkQuantityUnit6");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType6</b>
     * </p>
     *
     * @return Cost Center Activity Type 6
     */
    @SerializedName( "CostCtrActivityType6" )
    @JsonProperty( "CostCtrActivityType6" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType6" )
    private String costCtrActivityType6;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType6</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> COST_CTR_ACTIVITY_TYPE6 =
        new ProductionRoutingSubOperationField<String>("CostCtrActivityType6");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfTimeTickets</b>
     * </p>
     *
     * @return Number of Time Tickets
     */
    @SerializedName( "NumberOfTimeTickets" )
    @JsonProperty( "NumberOfTimeTickets" )
    @Nullable
    @ODataField( odataName = "NumberOfTimeTickets" )
    private BigDecimal numberOfTimeTickets;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfTimeTickets</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> NUMBER_OF_TIME_TICKETS =
        new ProductionRoutingSubOperationField<BigDecimal>("NumberOfTimeTickets");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfConfirmationSlips</b>
     * </p>
     *
     * @return Number of Confirmation Slips
     */
    @SerializedName( "NumberOfConfirmationSlips" )
    @JsonProperty( "NumberOfConfirmationSlips" )
    @Nullable
    @ODataField( odataName = "NumberOfConfirmationSlips" )
    private String numberOfConfirmationSlips;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfConfirmationSlips</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> NUMBER_OF_CONFIRMATION_SLIPS =
        new ProductionRoutingSubOperationField<String>("NumberOfConfirmationSlips");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationCostingRelevancyType</b>
     * </p>
     *
     * @return Operation Costing Relevancy Type
     */
    @SerializedName( "OperationCostingRelevancyType" )
    @JsonProperty( "OperationCostingRelevancyType" )
    @Nullable
    @ODataField( odataName = "OperationCostingRelevancyType" )
    private String operationCostingRelevancyType;
    /**
     * Use with available fluent helpers to apply the <b>OperationCostingRelevancyType</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> OPERATION_COSTING_RELEVANCY_TYPE =
        new ProductionRoutingSubOperationField<String>("OperationCostingRelevancyType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @return Business Process
     */
    @SerializedName( "BusinessProcess" )
    @JsonProperty( "BusinessProcess" )
    @Nullable
    @ODataField( odataName = "BusinessProcess" )
    private String businessProcess;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcess</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> BUSINESS_PROCESS =
        new ProductionRoutingSubOperationField<String>("BusinessProcess");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<LocalDateTime> CREATION_DATE =
        new ProductionRoutingSubOperationField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> CREATED_BY_USER =
        new ProductionRoutingSubOperationField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<LocalDateTime> LAST_CHANGE_DATE =
        new ProductionRoutingSubOperationField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> LAST_CHANGED_BY_USER =
        new ProductionRoutingSubOperationField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<LocalDateTime> VALIDITY_START_DATE =
        new ProductionRoutingSubOperationField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<LocalDateTime> VALIDITY_END_DATE =
        new ProductionRoutingSubOperationField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> CHANGE_NUMBER =
        new ProductionRoutingSubOperationField<String>("ChangeNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OpIsExtlyProcdWithSubcontrg</b>
     * </p>
     *
     * @return Indicator: External Processing Operation with Subcontracting
     */
    @SerializedName( "OpIsExtlyProcdWithSubcontrg" )
    @JsonProperty( "OpIsExtlyProcdWithSubcontrg" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "OpIsExtlyProcdWithSubcontrg" )
    private Boolean opIsExtlyProcdWithSubcontrg;
    /**
     * Use with available fluent helpers to apply the <b>OpIsExtlyProcdWithSubcontrg</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<Boolean> OP_IS_EXTLY_PROCD_WITH_SUBCONTRG =
        new ProductionRoutingSubOperationField<Boolean>("OpIsExtlyProcdWithSubcontrg");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotType</b>
     * </p>
     *
     * @return Inspection Type
     */
    @SerializedName( "InspectionLotType" )
    @JsonProperty( "InspectionLotType" )
    @Nullable
    @ODataField( odataName = "InspectionLotType" )
    private String inspectionLotType;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotType</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> INSPECTION_LOT_TYPE =
        new ProductionRoutingSubOperationField<String>("InspectionLotType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @return Number of purchasing info record
     */
    @SerializedName( "PurchasingInfoRecord" )
    @JsonProperty( "PurchasingInfoRecord" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecord" )
    private String purchasingInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecord</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PURCHASING_INFO_RECORD =
        new ProductionRoutingSubOperationField<String>("PurchasingInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PURCHASING_ORGANIZATION =
        new ProductionRoutingSubOperationField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @SerializedName( "PurchaseContract" )
    @JsonProperty( "PurchaseContract" )
    @Nullable
    @ODataField( odataName = "PurchaseContract" )
    private String purchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContract</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PURCHASE_CONTRACT =
        new ProductionRoutingSubOperationField<String>("PurchaseContract");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @SerializedName( "PurchaseContractItem" )
    @JsonProperty( "PurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItem" )
    private String purchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItem</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PURCHASE_CONTRACT_ITEM =
        new ProductionRoutingSubOperationField<String>("PurchaseContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecdAddlGrpgName</b>
     * </p>
     *
     * @return Sort Term for Non-Stock Info Records
     */
    @SerializedName( "PurchasingInfoRecdAddlGrpgName" )
    @JsonProperty( "PurchasingInfoRecdAddlGrpgName" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecdAddlGrpgName" )
    private String purchasingInfoRecdAddlGrpgName;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecdAddlGrpgName</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PURCHASING_INFO_RECD_ADDL_GRPG_NAME =
        new ProductionRoutingSubOperationField<String>("PurchasingInfoRecdAddlGrpgName");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDuration</b>
     * </p>
     *
     * @return Planned Delivery Time in Days
     */
    @SerializedName( "PlannedDeliveryDuration" )
    @JsonProperty( "PlannedDeliveryDuration" )
    @Nullable
    @ODataField( odataName = "PlannedDeliveryDuration" )
    private BigDecimal plannedDeliveryDuration;
    /**
     * Use with available fluent helpers to apply the <b>PlannedDeliveryDuration</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> PLANNED_DELIVERY_DURATION =
        new ProductionRoutingSubOperationField<BigDecimal>("PlannedDeliveryDuration");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> MATERIAL_GROUP =
        new ProductionRoutingSubOperationField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group for External Processing Activity
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PURCHASING_GROUP =
        new ProductionRoutingSubOperationField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> SUPPLIER =
        new ProductionRoutingSubOperationField<String>("Supplier");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfOperationPriceUnits</b>
     * </p>
     *
     * @return Price unit
     */
    @SerializedName( "NumberOfOperationPriceUnits" )
    @JsonProperty( "NumberOfOperationPriceUnits" )
    @Nullable
    @ODataField( odataName = "NumberOfOperationPriceUnits" )
    private BigDecimal numberOfOperationPriceUnits;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfOperationPriceUnits</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> NUMBER_OF_OPERATION_PRICE_UNITS =
        new ProductionRoutingSubOperationField<BigDecimal>("NumberOfOperationPriceUnits");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostElement</b>
     * </p>
     *
     * @return Cost Element
     */
    @SerializedName( "CostElement" )
    @JsonProperty( "CostElement" )
    @Nullable
    @ODataField( odataName = "CostElement" )
    private String costElement;
    /**
     * Use with available fluent helpers to apply the <b>CostElement</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> COST_ELEMENT =
        new ProductionRoutingSubOperationField<String>("CostElement");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingPrice</b>
     * </p>
     *
     * @return Net Price in Purchasing Info Record
     */
    @SerializedName( "OpExternalProcessingPrice" )
    @JsonProperty( "OpExternalProcessingPrice" )
    @Nullable
    @ODataField( odataName = "OpExternalProcessingPrice" )
    private BigDecimal opExternalProcessingPrice;
    /**
     * Use with available fluent helpers to apply the <b>OpExternalProcessingPrice</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> OP_EXTERNAL_PROCESSING_PRICE =
        new ProductionRoutingSubOperationField<BigDecimal>("OpExternalProcessingPrice");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "OpExternalProcessingCurrency" )
    @JsonProperty( "OpExternalProcessingCurrency" )
    @Nullable
    @ODataField( odataName = "OpExternalProcessingCurrency" )
    private String opExternalProcessingCurrency;
    /**
     * Use with available fluent helpers to apply the <b>OpExternalProcessingCurrency</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> OP_EXTERNAL_PROCESSING_CURRENCY =
        new ProductionRoutingSubOperationField<String>("OpExternalProcessingCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OperationSetupType</b>
     * </p>
     *
     * @return Setup Type Key
     */
    @SerializedName( "OperationSetupType" )
    @JsonProperty( "OperationSetupType" )
    @Nullable
    @ODataField( odataName = "OperationSetupType" )
    private String operationSetupType;
    /**
     * Use with available fluent helpers to apply the <b>OperationSetupType</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> OPERATION_SETUP_TYPE =
        new ProductionRoutingSubOperationField<String>("OperationSetupType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationSetupGroupCategory</b>
     * </p>
     *
     * @return Setup group category
     */
    @SerializedName( "OperationSetupGroupCategory" )
    @JsonProperty( "OperationSetupGroupCategory" )
    @Nullable
    @ODataField( odataName = "OperationSetupGroupCategory" )
    private String operationSetupGroupCategory;
    /**
     * Use with available fluent helpers to apply the <b>OperationSetupGroupCategory</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> OPERATION_SETUP_GROUP_CATEGORY =
        new ProductionRoutingSubOperationField<String>("OperationSetupGroupCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationSetupGroup</b>
     * </p>
     *
     * @return Setup group key
     */
    @SerializedName( "OperationSetupGroup" )
    @JsonProperty( "OperationSetupGroup" )
    @Nullable
    @ODataField( odataName = "OperationSetupGroup" )
    private String operationSetupGroup;
    /**
     * Use with available fluent helpers to apply the <b>OperationSetupGroup</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> OPERATION_SETUP_GROUP =
        new ProductionRoutingSubOperationField<String>("OperationSetupGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryCode</b>
     * </p>
     *
     * @return Capacity Category
     */
    @SerializedName( "CapacityCategoryCode" )
    @JsonProperty( "CapacityCategoryCode" )
    @Nullable
    @ODataField( odataName = "CapacityCategoryCode" )
    private String capacityCategoryCode;
    /**
     * Use with available fluent helpers to apply the <b>CapacityCategoryCode</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> CAPACITY_CATEGORY_CODE =
        new ProductionRoutingSubOperationField<String>("CapacityCategoryCode");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationScrapPercent</b>
     * </p>
     *
     * @return Scrap factor
     */
    @SerializedName( "OperationScrapPercent" )
    @JsonProperty( "OperationScrapPercent" )
    @Nullable
    @ODataField( odataName = "OperationScrapPercent" )
    private BigDecimal operationScrapPercent;
    /**
     * Use with available fluent helpers to apply the <b>OperationScrapPercent</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<BigDecimal> OPERATION_SCRAP_PERCENT =
        new ProductionRoutingSubOperationField<BigDecimal>("OperationScrapPercent");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<ZonedDateTime> CHANGED_DATE_TIME =
        new ProductionRoutingSubOperationField<ZonedDateTime>("ChangedDateTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "PlainLongText" )
    @JsonProperty( "PlainLongText" )
    @Nullable
    @ODataField( odataName = "PlainLongText" )
    private String plainLongText;
    /**
     * Use with available fluent helpers to apply the <b>PlainLongText</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> PLAIN_LONG_TEXT =
        new ProductionRoutingSubOperationField<String>("PlainLongText");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "BillOfOperationsLongText" )
    @JsonProperty( "BillOfOperationsLongText" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsLongText" )
    private String billOfOperationsLongText;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsLongText</b> field to query operations.
     *
     */
    public final static ProductionRoutingSubOperationField<String> BILL_OF_OPERATIONS_LONG_TEXT =
        new ProductionRoutingSubOperationField<String>("BillOfOperationsLongText");

    @Nonnull
    @Override
    public Class<ProductionRoutingSubOperation> getType()
    {
        return ProductionRoutingSubOperation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingGroup</b>
     * </p>
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     */
    public void setProductionRoutingGroup( @Nullable final String productionRoutingGroup )
    {
        rememberChangedField("ProductionRoutingGroup", this.productionRoutingGroup);
        this.productionRoutingGroup = productionRoutingGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRouting</b>
     * </p>
     *
     * @param productionRouting
     *            Group Counter
     */
    public void setProductionRouting( @Nullable final String productionRouting )
    {
        rememberChangedField("ProductionRouting", this.productionRouting);
        this.productionRouting = productionRouting;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingOpIntID</b>
     * </p>
     *
     * @param productionRoutingOpIntID
     *            Number of the Task List Node
     */
    public void setProductionRoutingOpIntID( @Nullable final String productionRoutingOpIntID )
    {
        rememberChangedField("ProductionRoutingOpIntID", this.productionRoutingOpIntID);
        this.productionRoutingOpIntID = productionRoutingOpIntID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingSequence</b>
     * </p>
     *
     * @param productionRoutingSequence
     *            Sequence
     */
    public void setProductionRoutingSequence( @Nullable final String productionRoutingSequence )
    {
        rememberChangedField("ProductionRoutingSequence", this.productionRoutingSequence);
        this.productionRoutingSequence = productionRoutingSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionRoutingOpIntVersion</b>
     * </p>
     *
     * @param productionRoutingOpIntVersion
     *            Internal counter
     */
    public void setProductionRoutingOpIntVersion( @Nullable final String productionRoutingOpIntVersion )
    {
        rememberChangedField("ProductionRoutingOpIntVersion", this.productionRoutingOpIntVersion);
        this.productionRoutingOpIntVersion = productionRoutingOpIntVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorOperationInternalID</b>
     * </p>
     *
     * @param superiorOperationInternalID
     *            Node Number of the Superior Operation
     */
    public void setSuperiorOperationInternalID( @Nullable final String superiorOperationInternalID )
    {
        rememberChangedField("SuperiorOperationInternalID", this.superiorOperationInternalID);
        this.superiorOperationInternalID = superiorOperationInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @param operation
     *            Operation / Phase Number
     */
    public void setOperation( @Nullable final String operation )
    {
        rememberChangedField("Operation", this.operation);
        this.operation = operation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     *
     * @param operationText
     *            Operation Short Text
     */
    public void setOperationText( @Nullable final String operationText )
    {
        rememberChangedField("OperationText", this.operationText);
        this.operationText = operationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LongTextLanguageCode</b>
     * </p>
     *
     * @param longTextLanguageCode
     *            Language Key
     */
    public void setLongTextLanguageCode( @Nullable final String longTextLanguageCode )
    {
        rememberChangedField("LongTextLanguageCode", this.longTextLanguageCode);
        this.longTextLanguageCode = longTextLanguageCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @param operationControlProfile
     *            Control Key
     */
    public void setOperationControlProfile( @Nullable final String operationControlProfile )
    {
        rememberChangedField("OperationControlProfile", this.operationControlProfile);
        this.operationControlProfile = operationControlProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>OperationStandardTextCode</b>
     * </p>
     *
     * @param operationStandardTextCode
     *            Standard Text Key
     */
    public void setOperationStandardTextCode( @Nullable final String operationStandardTextCode )
    {
        rememberChangedField("OperationStandardTextCode", this.operationStandardTextCode);
        this.operationStandardTextCode = operationStandardTextCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationReferenceQuantity</b>
     * </p>
     *
     * @param operationReferenceQuantity
     *            Base Quantity
     */
    public void setOperationReferenceQuantity( @Nullable final BigDecimal operationReferenceQuantity )
    {
        rememberChangedField("OperationReferenceQuantity", this.operationReferenceQuantity);
        this.operationReferenceQuantity = operationReferenceQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @param operationUnit
     *            Unit of Measure for Activity/Operation
     */
    public void setOperationUnit( @Nullable final String operationUnit )
    {
        rememberChangedField("OperationUnit", this.operationUnit);
        this.operationUnit = operationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @param opQtyToBaseQtyNmrtr
     *            Numerator for Converting Routing and Operation UoM
     */
    public void setOpQtyToBaseQtyNmrtr( @Nullable final BigDecimal opQtyToBaseQtyNmrtr )
    {
        rememberChangedField("OpQtyToBaseQtyNmrtr", this.opQtyToBaseQtyNmrtr);
        this.opQtyToBaseQtyNmrtr = opQtyToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @param opQtyToBaseQtyDnmntr
     *            Denominator for Converting Routing and Operation UoM
     */
    public void setOpQtyToBaseQtyDnmntr( @Nullable final BigDecimal opQtyToBaseQtyDnmntr )
    {
        rememberChangedField("OpQtyToBaseQtyDnmntr", this.opQtyToBaseQtyDnmntr);
        this.opQtyToBaseQtyDnmntr = opQtyToBaseQtyDnmntr;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantity1</b>
     * </p>
     *
     * @param standardWorkQuantity1
     *            Standard Work Quantity 1
     */
    public void setStandardWorkQuantity1( @Nullable final BigDecimal standardWorkQuantity1 )
    {
        rememberChangedField("StandardWorkQuantity1", this.standardWorkQuantity1);
        this.standardWorkQuantity1 = standardWorkQuantity1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantityUnit1</b>
     * </p>
     *
     * @param standardWorkQuantityUnit1
     *            Standard Work Quantity Unit 1
     */
    public void setStandardWorkQuantityUnit1( @Nullable final String standardWorkQuantityUnit1 )
    {
        rememberChangedField("StandardWorkQuantityUnit1", this.standardWorkQuantityUnit1);
        this.standardWorkQuantityUnit1 = standardWorkQuantityUnit1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType1</b>
     * </p>
     *
     * @param costCtrActivityType1
     *            Cost Center Activity Type 1
     */
    public void setCostCtrActivityType1( @Nullable final String costCtrActivityType1 )
    {
        rememberChangedField("CostCtrActivityType1", this.costCtrActivityType1);
        this.costCtrActivityType1 = costCtrActivityType1;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantity2</b>
     * </p>
     *
     * @param standardWorkQuantity2
     *            Standard Work Quantity 2
     */
    public void setStandardWorkQuantity2( @Nullable final BigDecimal standardWorkQuantity2 )
    {
        rememberChangedField("StandardWorkQuantity2", this.standardWorkQuantity2);
        this.standardWorkQuantity2 = standardWorkQuantity2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantityUnit2</b>
     * </p>
     *
     * @param standardWorkQuantityUnit2
     *            Standard Work Quantity Unit 2
     */
    public void setStandardWorkQuantityUnit2( @Nullable final String standardWorkQuantityUnit2 )
    {
        rememberChangedField("StandardWorkQuantityUnit2", this.standardWorkQuantityUnit2);
        this.standardWorkQuantityUnit2 = standardWorkQuantityUnit2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType2</b>
     * </p>
     *
     * @param costCtrActivityType2
     *            Cost Center Activity Type 2
     */
    public void setCostCtrActivityType2( @Nullable final String costCtrActivityType2 )
    {
        rememberChangedField("CostCtrActivityType2", this.costCtrActivityType2);
        this.costCtrActivityType2 = costCtrActivityType2;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantity3</b>
     * </p>
     *
     * @param standardWorkQuantity3
     *            Standard Work Quantity 3
     */
    public void setStandardWorkQuantity3( @Nullable final BigDecimal standardWorkQuantity3 )
    {
        rememberChangedField("StandardWorkQuantity3", this.standardWorkQuantity3);
        this.standardWorkQuantity3 = standardWorkQuantity3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantityUnit3</b>
     * </p>
     *
     * @param standardWorkQuantityUnit3
     *            Standard Work Quantity Unit 3
     */
    public void setStandardWorkQuantityUnit3( @Nullable final String standardWorkQuantityUnit3 )
    {
        rememberChangedField("StandardWorkQuantityUnit3", this.standardWorkQuantityUnit3);
        this.standardWorkQuantityUnit3 = standardWorkQuantityUnit3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType3</b>
     * </p>
     *
     * @param costCtrActivityType3
     *            Cost Center Activity Type 3
     */
    public void setCostCtrActivityType3( @Nullable final String costCtrActivityType3 )
    {
        rememberChangedField("CostCtrActivityType3", this.costCtrActivityType3);
        this.costCtrActivityType3 = costCtrActivityType3;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantity4</b>
     * </p>
     *
     * @param standardWorkQuantity4
     *            Standard Work Quantity 4
     */
    public void setStandardWorkQuantity4( @Nullable final BigDecimal standardWorkQuantity4 )
    {
        rememberChangedField("StandardWorkQuantity4", this.standardWorkQuantity4);
        this.standardWorkQuantity4 = standardWorkQuantity4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantityUnit4</b>
     * </p>
     *
     * @param standardWorkQuantityUnit4
     *            Standard Work Quantity Unit 4
     */
    public void setStandardWorkQuantityUnit4( @Nullable final String standardWorkQuantityUnit4 )
    {
        rememberChangedField("StandardWorkQuantityUnit4", this.standardWorkQuantityUnit4);
        this.standardWorkQuantityUnit4 = standardWorkQuantityUnit4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType4</b>
     * </p>
     *
     * @param costCtrActivityType4
     *            Cost Center Activity Type 4
     */
    public void setCostCtrActivityType4( @Nullable final String costCtrActivityType4 )
    {
        rememberChangedField("CostCtrActivityType4", this.costCtrActivityType4);
        this.costCtrActivityType4 = costCtrActivityType4;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantity5</b>
     * </p>
     *
     * @param standardWorkQuantity5
     *            Standard Work Quantity 5
     */
    public void setStandardWorkQuantity5( @Nullable final BigDecimal standardWorkQuantity5 )
    {
        rememberChangedField("StandardWorkQuantity5", this.standardWorkQuantity5);
        this.standardWorkQuantity5 = standardWorkQuantity5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantityUnit5</b>
     * </p>
     *
     * @param standardWorkQuantityUnit5
     *            Standard Work Quantity Unit 5
     */
    public void setStandardWorkQuantityUnit5( @Nullable final String standardWorkQuantityUnit5 )
    {
        rememberChangedField("StandardWorkQuantityUnit5", this.standardWorkQuantityUnit5);
        this.standardWorkQuantityUnit5 = standardWorkQuantityUnit5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType5</b>
     * </p>
     *
     * @param costCtrActivityType5
     *            Cost Center Activity Type 5
     */
    public void setCostCtrActivityType5( @Nullable final String costCtrActivityType5 )
    {
        rememberChangedField("CostCtrActivityType5", this.costCtrActivityType5);
        this.costCtrActivityType5 = costCtrActivityType5;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantity6</b>
     * </p>
     *
     * @param standardWorkQuantity6
     *            Standard Work Quantity 6
     */
    public void setStandardWorkQuantity6( @Nullable final BigDecimal standardWorkQuantity6 )
    {
        rememberChangedField("StandardWorkQuantity6", this.standardWorkQuantity6);
        this.standardWorkQuantity6 = standardWorkQuantity6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkQuantityUnit6</b>
     * </p>
     *
     * @param standardWorkQuantityUnit6
     *            Standard Work Quantity Unit 6
     */
    public void setStandardWorkQuantityUnit6( @Nullable final String standardWorkQuantityUnit6 )
    {
        rememberChangedField("StandardWorkQuantityUnit6", this.standardWorkQuantityUnit6);
        this.standardWorkQuantityUnit6 = standardWorkQuantityUnit6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType6</b>
     * </p>
     *
     * @param costCtrActivityType6
     *            Cost Center Activity Type 6
     */
    public void setCostCtrActivityType6( @Nullable final String costCtrActivityType6 )
    {
        rememberChangedField("CostCtrActivityType6", this.costCtrActivityType6);
        this.costCtrActivityType6 = costCtrActivityType6;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfTimeTickets</b>
     * </p>
     *
     * @param numberOfTimeTickets
     *            Number of Time Tickets
     */
    public void setNumberOfTimeTickets( @Nullable final BigDecimal numberOfTimeTickets )
    {
        rememberChangedField("NumberOfTimeTickets", this.numberOfTimeTickets);
        this.numberOfTimeTickets = numberOfTimeTickets;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfConfirmationSlips</b>
     * </p>
     *
     * @param numberOfConfirmationSlips
     *            Number of Confirmation Slips
     */
    public void setNumberOfConfirmationSlips( @Nullable final String numberOfConfirmationSlips )
    {
        rememberChangedField("NumberOfConfirmationSlips", this.numberOfConfirmationSlips);
        this.numberOfConfirmationSlips = numberOfConfirmationSlips;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationCostingRelevancyType</b>
     * </p>
     *
     * @param operationCostingRelevancyType
     *            Operation Costing Relevancy Type
     */
    public void setOperationCostingRelevancyType( @Nullable final String operationCostingRelevancyType )
    {
        rememberChangedField("OperationCostingRelevancyType", this.operationCostingRelevancyType);
        this.operationCostingRelevancyType = operationCostingRelevancyType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @param businessProcess
     *            Business Process
     */
    public void setBusinessProcess( @Nullable final String businessProcess )
    {
        rememberChangedField("BusinessProcess", this.businessProcess);
        this.businessProcess = businessProcess;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OpIsExtlyProcdWithSubcontrg</b>
     * </p>
     *
     * @param opIsExtlyProcdWithSubcontrg
     *            Indicator: External Processing Operation with Subcontracting
     */
    public void setOpIsExtlyProcdWithSubcontrg( @Nullable final Boolean opIsExtlyProcdWithSubcontrg )
    {
        rememberChangedField("OpIsExtlyProcdWithSubcontrg", this.opIsExtlyProcdWithSubcontrg);
        this.opIsExtlyProcdWithSubcontrg = opIsExtlyProcdWithSubcontrg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotType</b>
     * </p>
     *
     * @param inspectionLotType
     *            Inspection Type
     */
    public void setInspectionLotType( @Nullable final String inspectionLotType )
    {
        rememberChangedField("InspectionLotType", this.inspectionLotType);
        this.inspectionLotType = inspectionLotType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setPurchasingInfoRecord( @Nullable final String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @param purchaseContract
     *            Purchasing Document Number
     */
    public void setPurchaseContract( @Nullable final String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseContractItem( @Nullable final String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecdAddlGrpgName</b>
     * </p>
     *
     * @param purchasingInfoRecdAddlGrpgName
     *            Sort Term for Non-Stock Info Records
     */
    public void setPurchasingInfoRecdAddlGrpgName( @Nullable final String purchasingInfoRecdAddlGrpgName )
    {
        rememberChangedField("PurchasingInfoRecdAddlGrpgName", this.purchasingInfoRecdAddlGrpgName);
        this.purchasingInfoRecdAddlGrpgName = purchasingInfoRecdAddlGrpgName;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDuration</b>
     * </p>
     *
     * @param plannedDeliveryDuration
     *            Planned Delivery Time in Days
     */
    public void setPlannedDeliveryDuration( @Nullable final BigDecimal plannedDeliveryDuration )
    {
        rememberChangedField("PlannedDeliveryDuration", this.plannedDeliveryDuration);
        this.plannedDeliveryDuration = plannedDeliveryDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group for External Processing Activity
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfOperationPriceUnits</b>
     * </p>
     *
     * @param numberOfOperationPriceUnits
     *            Price unit
     */
    public void setNumberOfOperationPriceUnits( @Nullable final BigDecimal numberOfOperationPriceUnits )
    {
        rememberChangedField("NumberOfOperationPriceUnits", this.numberOfOperationPriceUnits);
        this.numberOfOperationPriceUnits = numberOfOperationPriceUnits;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostElement</b>
     * </p>
     *
     * @param costElement
     *            Cost Element
     */
    public void setCostElement( @Nullable final String costElement )
    {
        rememberChangedField("CostElement", this.costElement);
        this.costElement = costElement;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingPrice</b>
     * </p>
     *
     * @param opExternalProcessingPrice
     *            Net Price in Purchasing Info Record
     */
    public void setOpExternalProcessingPrice( @Nullable final BigDecimal opExternalProcessingPrice )
    {
        rememberChangedField("OpExternalProcessingPrice", this.opExternalProcessingPrice);
        this.opExternalProcessingPrice = opExternalProcessingPrice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingCurrency</b>
     * </p>
     *
     * @param opExternalProcessingCurrency
     *            Currency Key
     */
    public void setOpExternalProcessingCurrency( @Nullable final String opExternalProcessingCurrency )
    {
        rememberChangedField("OpExternalProcessingCurrency", this.opExternalProcessingCurrency);
        this.opExternalProcessingCurrency = opExternalProcessingCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OperationSetupType</b>
     * </p>
     *
     * @param operationSetupType
     *            Setup Type Key
     */
    public void setOperationSetupType( @Nullable final String operationSetupType )
    {
        rememberChangedField("OperationSetupType", this.operationSetupType);
        this.operationSetupType = operationSetupType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationSetupGroupCategory</b>
     * </p>
     *
     * @param operationSetupGroupCategory
     *            Setup group category
     */
    public void setOperationSetupGroupCategory( @Nullable final String operationSetupGroupCategory )
    {
        rememberChangedField("OperationSetupGroupCategory", this.operationSetupGroupCategory);
        this.operationSetupGroupCategory = operationSetupGroupCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationSetupGroup</b>
     * </p>
     *
     * @param operationSetupGroup
     *            Setup group key
     */
    public void setOperationSetupGroup( @Nullable final String operationSetupGroup )
    {
        rememberChangedField("OperationSetupGroup", this.operationSetupGroup);
        this.operationSetupGroup = operationSetupGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryCode</b>
     * </p>
     *
     * @param capacityCategoryCode
     *            Capacity Category
     */
    public void setCapacityCategoryCode( @Nullable final String capacityCategoryCode )
    {
        rememberChangedField("CapacityCategoryCode", this.capacityCategoryCode);
        this.capacityCategoryCode = capacityCategoryCode;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationScrapPercent</b>
     * </p>
     *
     * @param operationScrapPercent
     *            Scrap factor
     */
    public void setOperationScrapPercent( @Nullable final BigDecimal operationScrapPercent )
    {
        rememberChangedField("OperationScrapPercent", this.operationScrapPercent);
        this.operationScrapPercent = operationScrapPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     *
     * @param plainLongText
     *            Long Text
     */
    public void setPlainLongText( @Nullable final String plainLongText )
    {
        rememberChangedField("PlainLongText", this.plainLongText);
        this.plainLongText = plainLongText;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsLongText</b>
     * </p>
     *
     * @param billOfOperationsLongText
     *            Long Text
     */
    public void setBillOfOperationsLongText( @Nullable final String billOfOperationsLongText )
    {
        rememberChangedField("BillOfOperationsLongText", this.billOfOperationsLongText);
        this.billOfOperationsLongText = billOfOperationsLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProductionRoutingSubOperation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductionRoutingGroup", getProductionRoutingGroup());
        result.put("ProductionRouting", getProductionRouting());
        result.put("ProductionRoutingOpIntID", getProductionRoutingOpIntID());
        result.put("ProductionRoutingSequence", getProductionRoutingSequence());
        result.put("ProductionRoutingOpIntVersion", getProductionRoutingOpIntVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProductionRoutingGroup", getProductionRoutingGroup());
        values.put("ProductionRouting", getProductionRouting());
        values.put("ProductionRoutingOpIntID", getProductionRoutingOpIntID());
        values.put("ProductionRoutingSequence", getProductionRoutingSequence());
        values.put("ProductionRoutingOpIntVersion", getProductionRoutingOpIntVersion());
        values.put("SuperiorOperationInternalID", getSuperiorOperationInternalID());
        values.put("Operation", getOperation());
        values.put("OperationText", getOperationText());
        values.put("LongTextLanguageCode", getLongTextLanguageCode());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("Plant", getPlant());
        values.put("OperationControlProfile", getOperationControlProfile());
        values.put("OperationStandardTextCode", getOperationStandardTextCode());
        values.put("OperationReferenceQuantity", getOperationReferenceQuantity());
        values.put("OperationUnit", getOperationUnit());
        values.put("OpQtyToBaseQtyNmrtr", getOpQtyToBaseQtyNmrtr());
        values.put("OpQtyToBaseQtyDnmntr", getOpQtyToBaseQtyDnmntr());
        values.put("StandardWorkQuantity1", getStandardWorkQuantity1());
        values.put("StandardWorkQuantityUnit1", getStandardWorkQuantityUnit1());
        values.put("CostCtrActivityType1", getCostCtrActivityType1());
        values.put("StandardWorkQuantity2", getStandardWorkQuantity2());
        values.put("StandardWorkQuantityUnit2", getStandardWorkQuantityUnit2());
        values.put("CostCtrActivityType2", getCostCtrActivityType2());
        values.put("StandardWorkQuantity3", getStandardWorkQuantity3());
        values.put("StandardWorkQuantityUnit3", getStandardWorkQuantityUnit3());
        values.put("CostCtrActivityType3", getCostCtrActivityType3());
        values.put("StandardWorkQuantity4", getStandardWorkQuantity4());
        values.put("StandardWorkQuantityUnit4", getStandardWorkQuantityUnit4());
        values.put("CostCtrActivityType4", getCostCtrActivityType4());
        values.put("StandardWorkQuantity5", getStandardWorkQuantity5());
        values.put("StandardWorkQuantityUnit5", getStandardWorkQuantityUnit5());
        values.put("CostCtrActivityType5", getCostCtrActivityType5());
        values.put("StandardWorkQuantity6", getStandardWorkQuantity6());
        values.put("StandardWorkQuantityUnit6", getStandardWorkQuantityUnit6());
        values.put("CostCtrActivityType6", getCostCtrActivityType6());
        values.put("NumberOfTimeTickets", getNumberOfTimeTickets());
        values.put("NumberOfConfirmationSlips", getNumberOfConfirmationSlips());
        values.put("OperationCostingRelevancyType", getOperationCostingRelevancyType());
        values.put("BusinessProcess", getBusinessProcess());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("OpIsExtlyProcdWithSubcontrg", getOpIsExtlyProcdWithSubcontrg());
        values.put("InspectionLotType", getInspectionLotType());
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchaseContract", getPurchaseContract());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("PurchasingInfoRecdAddlGrpgName", getPurchasingInfoRecdAddlGrpgName());
        values.put("PlannedDeliveryDuration", getPlannedDeliveryDuration());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("Supplier", getSupplier());
        values.put("NumberOfOperationPriceUnits", getNumberOfOperationPriceUnits());
        values.put("CostElement", getCostElement());
        values.put("OpExternalProcessingPrice", getOpExternalProcessingPrice());
        values.put("OpExternalProcessingCurrency", getOpExternalProcessingCurrency());
        values.put("OperationSetupType", getOperationSetupType());
        values.put("OperationSetupGroupCategory", getOperationSetupGroupCategory());
        values.put("OperationSetupGroup", getOperationSetupGroup());
        values.put("CapacityCategoryCode", getCapacityCategoryCode());
        values.put("OperationScrapPercent", getOperationScrapPercent());
        values.put("ChangedDateTime", getChangedDateTime());
        values.put("PlainLongText", getPlainLongText());
        values.put("BillOfOperationsLongText", getBillOfOperationsLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductionRoutingGroup") ) {
                final Object value = values.remove("ProductionRoutingGroup");
                if( (value == null) || (!value.equals(getProductionRoutingGroup())) ) {
                    setProductionRoutingGroup(((String) value));
                }
            }
            if( values.containsKey("ProductionRouting") ) {
                final Object value = values.remove("ProductionRouting");
                if( (value == null) || (!value.equals(getProductionRouting())) ) {
                    setProductionRouting(((String) value));
                }
            }
            if( values.containsKey("ProductionRoutingOpIntID") ) {
                final Object value = values.remove("ProductionRoutingOpIntID");
                if( (value == null) || (!value.equals(getProductionRoutingOpIntID())) ) {
                    setProductionRoutingOpIntID(((String) value));
                }
            }
            if( values.containsKey("ProductionRoutingSequence") ) {
                final Object value = values.remove("ProductionRoutingSequence");
                if( (value == null) || (!value.equals(getProductionRoutingSequence())) ) {
                    setProductionRoutingSequence(((String) value));
                }
            }
            if( values.containsKey("ProductionRoutingOpIntVersion") ) {
                final Object value = values.remove("ProductionRoutingOpIntVersion");
                if( (value == null) || (!value.equals(getProductionRoutingOpIntVersion())) ) {
                    setProductionRoutingOpIntVersion(((String) value));
                }
            }
            if( values.containsKey("SuperiorOperationInternalID") ) {
                final Object value = values.remove("SuperiorOperationInternalID");
                if( (value == null) || (!value.equals(getSuperiorOperationInternalID())) ) {
                    setSuperiorOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("Operation") ) {
                final Object value = values.remove("Operation");
                if( (value == null) || (!value.equals(getOperation())) ) {
                    setOperation(((String) value));
                }
            }
            if( values.containsKey("OperationText") ) {
                final Object value = values.remove("OperationText");
                if( (value == null) || (!value.equals(getOperationText())) ) {
                    setOperationText(((String) value));
                }
            }
            if( values.containsKey("LongTextLanguageCode") ) {
                final Object value = values.remove("LongTextLanguageCode");
                if( (value == null) || (!value.equals(getLongTextLanguageCode())) ) {
                    setLongTextLanguageCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("OperationControlProfile") ) {
                final Object value = values.remove("OperationControlProfile");
                if( (value == null) || (!value.equals(getOperationControlProfile())) ) {
                    setOperationControlProfile(((String) value));
                }
            }
            if( values.containsKey("OperationStandardTextCode") ) {
                final Object value = values.remove("OperationStandardTextCode");
                if( (value == null) || (!value.equals(getOperationStandardTextCode())) ) {
                    setOperationStandardTextCode(((String) value));
                }
            }
            if( values.containsKey("OperationReferenceQuantity") ) {
                final Object value = values.remove("OperationReferenceQuantity");
                if( (value == null) || (!value.equals(getOperationReferenceQuantity())) ) {
                    setOperationReferenceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OperationUnit") ) {
                final Object value = values.remove("OperationUnit");
                if( (value == null) || (!value.equals(getOperationUnit())) ) {
                    setOperationUnit(((String) value));
                }
            }
            if( values.containsKey("OpQtyToBaseQtyNmrtr") ) {
                final Object value = values.remove("OpQtyToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getOpQtyToBaseQtyNmrtr())) ) {
                    setOpQtyToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpQtyToBaseQtyDnmntr") ) {
                final Object value = values.remove("OpQtyToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getOpQtyToBaseQtyDnmntr())) ) {
                    setOpQtyToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("StandardWorkQuantity1") ) {
                final Object value = values.remove("StandardWorkQuantity1");
                if( (value == null) || (!value.equals(getStandardWorkQuantity1())) ) {
                    setStandardWorkQuantity1(((BigDecimal) value));
                }
            }
            if( values.containsKey("StandardWorkQuantityUnit1") ) {
                final Object value = values.remove("StandardWorkQuantityUnit1");
                if( (value == null) || (!value.equals(getStandardWorkQuantityUnit1())) ) {
                    setStandardWorkQuantityUnit1(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType1") ) {
                final Object value = values.remove("CostCtrActivityType1");
                if( (value == null) || (!value.equals(getCostCtrActivityType1())) ) {
                    setCostCtrActivityType1(((String) value));
                }
            }
            if( values.containsKey("StandardWorkQuantity2") ) {
                final Object value = values.remove("StandardWorkQuantity2");
                if( (value == null) || (!value.equals(getStandardWorkQuantity2())) ) {
                    setStandardWorkQuantity2(((BigDecimal) value));
                }
            }
            if( values.containsKey("StandardWorkQuantityUnit2") ) {
                final Object value = values.remove("StandardWorkQuantityUnit2");
                if( (value == null) || (!value.equals(getStandardWorkQuantityUnit2())) ) {
                    setStandardWorkQuantityUnit2(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType2") ) {
                final Object value = values.remove("CostCtrActivityType2");
                if( (value == null) || (!value.equals(getCostCtrActivityType2())) ) {
                    setCostCtrActivityType2(((String) value));
                }
            }
            if( values.containsKey("StandardWorkQuantity3") ) {
                final Object value = values.remove("StandardWorkQuantity3");
                if( (value == null) || (!value.equals(getStandardWorkQuantity3())) ) {
                    setStandardWorkQuantity3(((BigDecimal) value));
                }
            }
            if( values.containsKey("StandardWorkQuantityUnit3") ) {
                final Object value = values.remove("StandardWorkQuantityUnit3");
                if( (value == null) || (!value.equals(getStandardWorkQuantityUnit3())) ) {
                    setStandardWorkQuantityUnit3(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType3") ) {
                final Object value = values.remove("CostCtrActivityType3");
                if( (value == null) || (!value.equals(getCostCtrActivityType3())) ) {
                    setCostCtrActivityType3(((String) value));
                }
            }
            if( values.containsKey("StandardWorkQuantity4") ) {
                final Object value = values.remove("StandardWorkQuantity4");
                if( (value == null) || (!value.equals(getStandardWorkQuantity4())) ) {
                    setStandardWorkQuantity4(((BigDecimal) value));
                }
            }
            if( values.containsKey("StandardWorkQuantityUnit4") ) {
                final Object value = values.remove("StandardWorkQuantityUnit4");
                if( (value == null) || (!value.equals(getStandardWorkQuantityUnit4())) ) {
                    setStandardWorkQuantityUnit4(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType4") ) {
                final Object value = values.remove("CostCtrActivityType4");
                if( (value == null) || (!value.equals(getCostCtrActivityType4())) ) {
                    setCostCtrActivityType4(((String) value));
                }
            }
            if( values.containsKey("StandardWorkQuantity5") ) {
                final Object value = values.remove("StandardWorkQuantity5");
                if( (value == null) || (!value.equals(getStandardWorkQuantity5())) ) {
                    setStandardWorkQuantity5(((BigDecimal) value));
                }
            }
            if( values.containsKey("StandardWorkQuantityUnit5") ) {
                final Object value = values.remove("StandardWorkQuantityUnit5");
                if( (value == null) || (!value.equals(getStandardWorkQuantityUnit5())) ) {
                    setStandardWorkQuantityUnit5(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType5") ) {
                final Object value = values.remove("CostCtrActivityType5");
                if( (value == null) || (!value.equals(getCostCtrActivityType5())) ) {
                    setCostCtrActivityType5(((String) value));
                }
            }
            if( values.containsKey("StandardWorkQuantity6") ) {
                final Object value = values.remove("StandardWorkQuantity6");
                if( (value == null) || (!value.equals(getStandardWorkQuantity6())) ) {
                    setStandardWorkQuantity6(((BigDecimal) value));
                }
            }
            if( values.containsKey("StandardWorkQuantityUnit6") ) {
                final Object value = values.remove("StandardWorkQuantityUnit6");
                if( (value == null) || (!value.equals(getStandardWorkQuantityUnit6())) ) {
                    setStandardWorkQuantityUnit6(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType6") ) {
                final Object value = values.remove("CostCtrActivityType6");
                if( (value == null) || (!value.equals(getCostCtrActivityType6())) ) {
                    setCostCtrActivityType6(((String) value));
                }
            }
            if( values.containsKey("NumberOfTimeTickets") ) {
                final Object value = values.remove("NumberOfTimeTickets");
                if( (value == null) || (!value.equals(getNumberOfTimeTickets())) ) {
                    setNumberOfTimeTickets(((BigDecimal) value));
                }
            }
            if( values.containsKey("NumberOfConfirmationSlips") ) {
                final Object value = values.remove("NumberOfConfirmationSlips");
                if( (value == null) || (!value.equals(getNumberOfConfirmationSlips())) ) {
                    setNumberOfConfirmationSlips(((String) value));
                }
            }
            if( values.containsKey("OperationCostingRelevancyType") ) {
                final Object value = values.remove("OperationCostingRelevancyType");
                if( (value == null) || (!value.equals(getOperationCostingRelevancyType())) ) {
                    setOperationCostingRelevancyType(((String) value));
                }
            }
            if( values.containsKey("BusinessProcess") ) {
                final Object value = values.remove("BusinessProcess");
                if( (value == null) || (!value.equals(getBusinessProcess())) ) {
                    setBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("OpIsExtlyProcdWithSubcontrg") ) {
                final Object value = values.remove("OpIsExtlyProcdWithSubcontrg");
                if( (value == null) || (!value.equals(getOpIsExtlyProcdWithSubcontrg())) ) {
                    setOpIsExtlyProcdWithSubcontrg(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionLotType") ) {
                final Object value = values.remove("InspectionLotType");
                if( (value == null) || (!value.equals(getInspectionLotType())) ) {
                    setInspectionLotType(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecdAddlGrpgName") ) {
                final Object value = values.remove("PurchasingInfoRecdAddlGrpgName");
                if( (value == null) || (!value.equals(getPurchasingInfoRecdAddlGrpgName())) ) {
                    setPurchasingInfoRecdAddlGrpgName(((String) value));
                }
            }
            if( values.containsKey("PlannedDeliveryDuration") ) {
                final Object value = values.remove("PlannedDeliveryDuration");
                if( (value == null) || (!value.equals(getPlannedDeliveryDuration())) ) {
                    setPlannedDeliveryDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("NumberOfOperationPriceUnits") ) {
                final Object value = values.remove("NumberOfOperationPriceUnits");
                if( (value == null) || (!value.equals(getNumberOfOperationPriceUnits())) ) {
                    setNumberOfOperationPriceUnits(((BigDecimal) value));
                }
            }
            if( values.containsKey("CostElement") ) {
                final Object value = values.remove("CostElement");
                if( (value == null) || (!value.equals(getCostElement())) ) {
                    setCostElement(((String) value));
                }
            }
            if( values.containsKey("OpExternalProcessingPrice") ) {
                final Object value = values.remove("OpExternalProcessingPrice");
                if( (value == null) || (!value.equals(getOpExternalProcessingPrice())) ) {
                    setOpExternalProcessingPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpExternalProcessingCurrency") ) {
                final Object value = values.remove("OpExternalProcessingCurrency");
                if( (value == null) || (!value.equals(getOpExternalProcessingCurrency())) ) {
                    setOpExternalProcessingCurrency(((String) value));
                }
            }
            if( values.containsKey("OperationSetupType") ) {
                final Object value = values.remove("OperationSetupType");
                if( (value == null) || (!value.equals(getOperationSetupType())) ) {
                    setOperationSetupType(((String) value));
                }
            }
            if( values.containsKey("OperationSetupGroupCategory") ) {
                final Object value = values.remove("OperationSetupGroupCategory");
                if( (value == null) || (!value.equals(getOperationSetupGroupCategory())) ) {
                    setOperationSetupGroupCategory(((String) value));
                }
            }
            if( values.containsKey("OperationSetupGroup") ) {
                final Object value = values.remove("OperationSetupGroup");
                if( (value == null) || (!value.equals(getOperationSetupGroup())) ) {
                    setOperationSetupGroup(((String) value));
                }
            }
            if( values.containsKey("CapacityCategoryCode") ) {
                final Object value = values.remove("CapacityCategoryCode");
                if( (value == null) || (!value.equals(getCapacityCategoryCode())) ) {
                    setCapacityCategoryCode(((String) value));
                }
            }
            if( values.containsKey("OperationScrapPercent") ) {
                final Object value = values.remove("OperationScrapPercent");
                if( (value == null) || (!value.equals(getOperationScrapPercent())) ) {
                    setOperationScrapPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PlainLongText") ) {
                final Object value = values.remove("PlainLongText");
                if( (value == null) || (!value.equals(getPlainLongText())) ) {
                    setPlainLongText(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsLongText") ) {
                final Object value = values.remove("BillOfOperationsLongText");
                if( (value == null) || (!value.equals(getBillOfOperationsLongText())) ) {
                    setBillOfOperationsLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProductionRoutingSubOperationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ProductionRoutingSubOperationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductionRoutingSubOperationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductionRoutingSubOperationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService.DEFAULT_SERVICE_PATH);
    }

}
