/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProductionRoutingServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService ProductionRoutingService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProductionRoutingServiceBatch
    extends
    BatchFluentHelperBasic<ProductionRoutingServiceBatch, ProductionRoutingServiceBatchChangeSet>
    implements
    ProductionRoutingServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProductionRoutingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductionRoutingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProductionRoutingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductionRoutingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProductionRoutingServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductionRoutingServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProductionRoutingServiceBatchChangeSet(this, service);
    }

}
