/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation;

/**
 * Implementation of the {@link ProductionRoutingServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService ProductionRoutingService}.
 *
 */
public class DefaultProductionRoutingServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProductionRoutingServiceBatch, ProductionRoutingServiceBatchChangeSet>
    implements
    ProductionRoutingServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService service;

    @SuppressWarnings( "deprecation" )
    DefaultProductionRoutingServiceBatchChangeSet(
        @Nonnull final DefaultProductionRoutingServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProductionRoutingServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductionRoutingServiceBatchChangeSet createProductionRoutingHeader(
        @Nonnull final ProductionRoutingHeader productionRoutingHeader )
    {
        return addRequestCreate(service::createProductionRoutingHeader, productionRoutingHeader);
    }

    @Nonnull
    @Override
    public ProductionRoutingServiceBatchChangeSet updateProductionRoutingHeader(
        @Nonnull final ProductionRoutingHeader productionRoutingHeader )
    {
        return addRequestUpdate(service::updateProductionRoutingHeader, productionRoutingHeader);
    }

    @Nonnull
    @Override
    public ProductionRoutingServiceBatchChangeSet createProductionRoutingOpCompAlloc(
        @Nonnull final ProductionRoutingOpCompAlloc productionRoutingOpCompAlloc )
    {
        return addRequestCreate(service::createProductionRoutingOpCompAlloc, productionRoutingOpCompAlloc);
    }

    @Nonnull
    @Override
    public ProductionRoutingServiceBatchChangeSet updateProductionRoutingOpCompAlloc(
        @Nonnull final ProductionRoutingOpCompAlloc productionRoutingOpCompAlloc )
    {
        return addRequestUpdate(service::updateProductionRoutingOpCompAlloc, productionRoutingOpCompAlloc);
    }

    @Nonnull
    @Override
    public ProductionRoutingServiceBatchChangeSet createProductionRoutingOperation(
        @Nonnull final ProductionRoutingOperation productionRoutingOperation )
    {
        return addRequestCreate(service::createProductionRoutingOperation, productionRoutingOperation);
    }

    @Nonnull
    @Override
    public ProductionRoutingServiceBatchChangeSet updateProductionRoutingOperation(
        @Nonnull final ProductionRoutingOperation productionRoutingOperation )
    {
        return addRequestUpdate(service::updateProductionRoutingOperation, productionRoutingOperation);
    }

    @Nonnull
    @Override
    public ProductionRoutingServiceBatchChangeSet createProductionRoutingSequence(
        @Nonnull final ProductionRoutingSequence productionRoutingSequence )
    {
        return addRequestCreate(service::createProductionRoutingSequence, productionRoutingSequence);
    }

    @Nonnull
    @Override
    public ProductionRoutingServiceBatchChangeSet updateProductionRoutingSequence(
        @Nonnull final ProductionRoutingSequence productionRoutingSequence )
    {
        return addRequestUpdate(service::updateProductionRoutingSequence, productionRoutingSequence);
    }

    @Nonnull
    @Override
    public ProductionRoutingServiceBatchChangeSet createProductionRoutingSubOperation(
        @Nonnull final ProductionRoutingSubOperation productionRoutingSubOperation )
    {
        return addRequestCreate(service::createProductionRoutingSubOperation, productionRoutingSubOperation);
    }

    @Nonnull
    @Override
    public ProductionRoutingServiceBatchChangeSet updateProductionRoutingSubOperation(
        @Nonnull final ProductionRoutingSubOperation productionRoutingSubOperation )
    {
        return addRequestUpdate(service::updateProductionRoutingSubOperation, productionRoutingSubOperation);
    }

}
