/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionRoutingService ProductionRoutingService}.
 *
 */
public interface ProductionRoutingServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ProductionRoutingServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ProductionRoutingServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     * ProductionRoutingHeader} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     *            ProductionRoutingHeader} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionRoutingServiceBatchChangeSet
        createProductionRoutingHeader( @Nonnull final ProductionRoutingHeader productionRoutingHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     * ProductionRoutingHeader} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     *            ProductionRoutingHeader} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionRoutingServiceBatchChangeSet
        updateProductionRoutingHeader( @Nonnull final ProductionRoutingHeader productionRoutingHeader );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     * ProductionRoutingOpCompAlloc} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingOpCompAlloc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     *            ProductionRoutingOpCompAlloc} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionRoutingServiceBatchChangeSet
        createProductionRoutingOpCompAlloc( @Nonnull final ProductionRoutingOpCompAlloc productionRoutingOpCompAlloc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     * ProductionRoutingOpCompAlloc} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingOpCompAlloc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     *            ProductionRoutingOpCompAlloc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionRoutingServiceBatchChangeSet
        updateProductionRoutingOpCompAlloc( @Nonnull final ProductionRoutingOpCompAlloc productionRoutingOpCompAlloc );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     * ProductionRoutingOperation} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     *            ProductionRoutingOperation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionRoutingServiceBatchChangeSet
        createProductionRoutingOperation( @Nonnull final ProductionRoutingOperation productionRoutingOperation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     * ProductionRoutingOperation} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     *            ProductionRoutingOperation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionRoutingServiceBatchChangeSet
        updateProductionRoutingOperation( @Nonnull final ProductionRoutingOperation productionRoutingOperation );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     * ProductionRoutingSequence} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingSequence
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     *            ProductionRoutingSequence} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionRoutingServiceBatchChangeSet
        createProductionRoutingSequence( @Nonnull final ProductionRoutingSequence productionRoutingSequence );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     * ProductionRoutingSequence} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingSequence
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     *            ProductionRoutingSequence} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionRoutingServiceBatchChangeSet
        updateProductionRoutingSequence( @Nonnull final ProductionRoutingSequence productionRoutingSequence );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     * ProductionRoutingSubOperation} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingSubOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     *            ProductionRoutingSubOperation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionRoutingServiceBatchChangeSet createProductionRoutingSubOperation(
        @Nonnull final ProductionRoutingSubOperation productionRoutingSubOperation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     * ProductionRoutingSubOperation} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingSubOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     *            ProductionRoutingSubOperation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionRoutingServiceBatchChangeSet updateProductionRoutingSubOperation(
        @Nonnull final ProductionRoutingSubOperation productionRoutingSubOperation );

}
