/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.selectable.ProductionRoutingOperationSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
 * ProductionRoutingOperation} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ProductionRoutingOperationLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ProductionRoutingOperationLink<ObjectT>, ProductionRoutingOperation, ObjectT>
    implements
    ProductionRoutingOperationSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ProductionRoutingOperationLink( final String fieldName )
    {
        super(fieldName);
    }

    private ProductionRoutingOperationLink(
        final EntityLink<ProductionRoutingOperationLink<ObjectT>, ProductionRoutingOperation, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ProductionRoutingOperationLink<ObjectT> translateLinkType(
        final EntityLink<ProductionRoutingOperationLink<ObjectT>, ProductionRoutingOperation, ObjectT> link )
    {
        return new ProductionRoutingOperationLink<ObjectT>(link);
    }

}
