/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment
 * OperationEquipmentPRTAssignment}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.field.OperationEquipmentPRTAssignmentField
 * OperationEquipmentPRTAssignmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.link.OperationEquipmentPRTAssignmentLink
 * OperationEquipmentPRTAssignmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODUCTION_ROUTING_GROUP
 * PRODUCTION_ROUTING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODUCTION_ROUTING
 * PRODUCTION_ROUTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODUCTION_ROUTING_SEQUENCE
 * PRODUCTION_ROUTING_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODUCTION_ROUTING_OP_INT_ID
 * PRODUCTION_ROUTING_OP_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#BOO_OPERATION_PRT_INTERNAL_ID
 * BOO_OPERATION_PRT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#BOO_OPERATION_PRT_INT_VERS_COUNTER
 * BOO_OPERATION_PRT_INT_VERS_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODN_RSCE_TOOL_ITEM_NUMBER
 * PRODN_RSCE_TOOL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODUCTION_RESOURCE_TYPE
 * PRODUCTION_RESOURCE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODUCTION_RESOURCE_INTERNAL_ID
 * PRODUCTION_RESOURCE_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODN_RSCE_TOOL_STANDARD_TEXT_CODE
 * PRODN_RSCE_TOOL_STANDARD_TEXT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODN_RSCE_TOOL_TEXT
 * PRODN_RSCE_TOOL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODN_RSCE_TOOL_CONTROL_PROFILE
 * PRODN_RSCE_TOOL_CONTROL_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODN_RSCE_TOOL_STANDARD_WORK_QTY
 * PRODN_RSCE_TOOL_STANDARD_WORK_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT
 * PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODN_RSCE_TOOL_TOT_QTY_CALC_FORMULA
 * PRODN_RSCE_TOOL_TOT_QTY_CALC_FORMULA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODN_RSCE_TOOL_USAGE_QUANTITY
 * PRODN_RSCE_TOOL_USAGE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT
 * PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#PRODN_RSCE_TOOL_USAGE_QTY_CALC_FMLA
 * PRODN_RSCE_TOOL_USAGE_QTY_CALC_FMLA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface OperationEquipmentPRTAssignmentSelectable extends EntitySelectable<OperationEquipmentPRTAssignment>
{

}
