/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment
 * OperationMaterialPRTAssignment}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.field.OperationMaterialPRTAssignmentField
 * OperationMaterialPRTAssignmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.link.OperationMaterialPRTAssignmentLink
 * OperationMaterialPRTAssignmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODUCTION_ROUTING_GROUP
 * PRODUCTION_ROUTING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODUCTION_ROUTING
 * PRODUCTION_ROUTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODUCTION_ROUTING_SEQUENCE
 * PRODUCTION_ROUTING_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODUCTION_ROUTING_OP_INT_ID
 * PRODUCTION_ROUTING_OP_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#BOO_OPERATION_PRT_INTERNAL_ID
 * BOO_OPERATION_PRT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#BOO_OPERATION_PRT_INT_VERS_COUNTER
 * BOO_OPERATION_PRT_INT_VERS_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODN_RSCE_TOOL_ITEM_NUMBER
 * PRODN_RSCE_TOOL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODUCTION_RESOURCE_TYPE
 * PRODUCTION_RESOURCE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODUCTION_RESOURCE_INTERNAL_ID
 * PRODUCTION_RESOURCE_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODN_RSCE_TOOL_STANDARD_TEXT_CODE
 * PRODN_RSCE_TOOL_STANDARD_TEXT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODN_RSCE_TOOL_TEXT
 * PRODN_RSCE_TOOL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODN_RSCE_TOOL_CONTROL_PROFILE
 * PRODN_RSCE_TOOL_CONTROL_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODN_RSCE_TOOL_STANDARD_WORK_QTY
 * PRODN_RSCE_TOOL_STANDARD_WORK_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT
 * PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODN_RSCE_TOOL_TOT_QTY_CALC_FORMULA
 * PRODN_RSCE_TOOL_TOT_QTY_CALC_FORMULA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODN_RSCE_TOOL_USAGE_QUANTITY
 * PRODN_RSCE_TOOL_USAGE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT
 * PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#PRODN_RSCE_TOOL_USAGE_QTY_CALC_FMLA
 * PRODN_RSCE_TOOL_USAGE_QTY_CALC_FMLA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface OperationMaterialPRTAssignmentSelectable extends EntitySelectable<OperationMaterialPRTAssignment>
{

}
