/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
 * ProductionRoutingHeader}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.field.ProductionRoutingHeaderField
 * ProductionRoutingHeaderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.link.ProductionRoutingHeaderLink
 * ProductionRoutingHeaderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#PRODUCTION_ROUTING_GROUP
 * PRODUCTION_ROUTING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#PRODUCTION_ROUTING
 * PRODUCTION_ROUTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#PRODUCTION_ROUTING_INTERNAL_VERS
 * PRODUCTION_ROUTING_INTERNAL_VERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#BILL_OF_OPERATIONS_DESC
 * BILL_OF_OPERATIONS_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#BILL_OF_OPERATIONS_USAGE
 * BILL_OF_OPERATIONS_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#BILL_OF_OPERATIONS_STATUS
 * BILL_OF_OPERATIONS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#RESPONSIBLE_PLANNER_GROUP
 * RESPONSIBLE_PLANNER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#MINIMUM_LOT_SIZE_QUANTITY
 * MINIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#MAXIMUM_LOT_SIZE_QUANTITY
 * MAXIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#BILL_OF_OPERATIONS_UNIT
 * BILL_OF_OPERATIONS_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#PLAIN_LONG_TEXT
 * PLAIN_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#BILL_OF_OPERATIONS_LONG_TEXT
 * BILL_OF_OPERATIONS_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#TO_MATL_ASSGMT
 * TO_MATL_ASSGMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader#TO_SEQUENCE
 * TO_SEQUENCE}</li>
 * </ul>
 *
 */
public interface ProductionRoutingHeaderSelectable extends EntitySelectable<ProductionRoutingHeader>
{

}
