/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.field.ProductionSupplyAreaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.link.ProductionSupplyAreaLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.link.ProductionSupplyAreaOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.selectable.ProductionSupplyAreaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Production Supply Areas
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductionSupplyAreaType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductionSupplyArea extends VdmEntity<ProductionSupplyArea>
{

    /**
     * Selector for all available fields of ProductionSupplyArea.
     *
     */
    public final static ProductionSupplyAreaSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<Boolean> DELETE_MC =
        new ProductionSupplyAreaField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<Boolean> UPDATE_MC =
        new ProductionSupplyAreaField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ProductionSupplyAreaAddress_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ProductionSupplyAreaAddress_oc" )
    @JsonProperty( "to_ProductionSupplyAreaAddress_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ProductionSupplyAreaAddress_oc" )
    private Boolean productionSupplyAreaAddress_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ProductionSupplyAreaAddress_oc</b> field to query
     * operations.
     *
     */
    public final static ProductionSupplyAreaField<Boolean> PRODUCTION_SUPPLY_AREA_ADDRESS_OC =
        new ProductionSupplyAreaField<Boolean>("to_ProductionSupplyAreaAddress_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ProductionSupplyAreaText_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ProductionSupplyAreaText_oc" )
    @JsonProperty( "to_ProductionSupplyAreaText_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ProductionSupplyAreaText_oc" )
    private Boolean productionSupplyAreaText_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ProductionSupplyAreaText_oc</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<Boolean> PRODUCTION_SUPPLY_AREA_TEXT_OC =
        new ProductionSupplyAreaField<Boolean>("to_ProductionSupplyAreaText_oc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @return Production Supply Area
     */
    @Key
    @SerializedName( "ProductionSupplyArea" )
    @JsonProperty( "ProductionSupplyArea" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyArea" )
    private String productionSupplyArea;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupplyArea</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<String> PRODUCTION_SUPPLY_AREA =
        new ProductionSupplyAreaField<String>("ProductionSupplyArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<String> PLANT = new ProductionSupplyAreaField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<String> STORAGE_LOCATION =
        new ProductionSupplyAreaField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyAreaRespPerson</b>
     * </p>
     *
     * @return Person responsible for one or more supply areas
     */
    @SerializedName( "ProductionSupplyAreaRespPerson" )
    @JsonProperty( "ProductionSupplyAreaRespPerson" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyAreaRespPerson" )
    private String productionSupplyAreaRespPerson;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupplyAreaRespPerson</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<String> PRODUCTION_SUPPLY_AREA_RESP_PERSON =
        new ProductionSupplyAreaField<String>("ProductionSupplyAreaRespPerson");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<String> UNLOADING_POINT_NAME =
        new ProductionSupplyAreaField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @return Factory calendar key
     */
    @SerializedName( "FactoryCalendar" )
    @JsonProperty( "FactoryCalendar" )
    @Nullable
    @ODataField( odataName = "FactoryCalendar" )
    private String factoryCalendar;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendar</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<String> FACTORY_CALENDAR =
        new ProductionSupplyAreaField<String>("FactoryCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShiftGrouping</b>
     * </p>
     *
     * @return Grouping for Shift Definition and Sequences (Consumer)
     */
    @SerializedName( "ShiftGrouping" )
    @JsonProperty( "ShiftGrouping" )
    @Nullable
    @ODataField( odataName = "ShiftGrouping" )
    private String shiftGrouping;
    /**
     * Use with available fluent helpers to apply the <b>ShiftGrouping</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<String> SHIFT_GROUPING =
        new ProductionSupplyAreaField<String>("ShiftGrouping");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftSequence</b>
     * </p>
     *
     * @return Key for Shift Sequence (Consumer)
     */
    @SerializedName( "ShiftSequence" )
    @JsonProperty( "ShiftSequence" )
    @Nullable
    @ODataField( odataName = "ShiftSequence" )
    private String shiftSequence;
    /**
     * Use with available fluent helpers to apply the <b>ShiftSequence</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<String> SHIFT_SEQUENCE =
        new ProductionSupplyAreaField<String>("ShiftSequence");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PullIntervalInWorkdays</b>
     * </p>
     *
     * @return Pull Interval in Workdays
     */
    @SerializedName( "PullIntervalInWorkdays" )
    @JsonProperty( "PullIntervalInWorkdays" )
    @Nullable
    @ODataField( odataName = "PullIntervalInWorkdays" )
    private BigDecimal pullIntervalInWorkdays;
    /**
     * Use with available fluent helpers to apply the <b>PullIntervalInWorkdays</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<BigDecimal> PULL_INTERVAL_IN_WORKDAYS =
        new ProductionSupplyAreaField<BigDecimal>("PullIntervalInWorkdays");
    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PullIntervalInMinutes</b>
     * </p>
     *
     * @return Pull Interval in Minutes
     */
    @SerializedName( "PullIntervalInMinutes" )
    @JsonProperty( "PullIntervalInMinutes" )
    @Nullable
    @ODataField( odataName = "PullIntervalInMinutes" )
    private BigDecimal pullIntervalInMinutes;
    /**
     * Use with available fluent helpers to apply the <b>PullIntervalInMinutes</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<BigDecimal> PULL_INTERVAL_IN_MINUTES =
        new ProductionSupplyAreaField<BigDecimal>("PullIntervalInMinutes");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingWarehouseStagingArea</b>
     * </p>
     *
     * @return (Automotive) Unloading Point
     */
    @SerializedName( "UnloadingWarehouseStagingArea" )
    @JsonProperty( "UnloadingWarehouseStagingArea" )
    @Nullable
    @ODataField( odataName = "UnloadingWarehouseStagingArea" )
    private String unloadingWarehouseStagingArea;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingWarehouseStagingArea</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<String> UNLOADING_WAREHOUSE_STAGING_AREA =
        new ProductionSupplyAreaField<String>("UnloadingWarehouseStagingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyAreaAddressID</b>
     * </p>
     *
     * @return Address for Supply Area
     */
    @SerializedName( "ProductionSupplyAreaAddressID" )
    @JsonProperty( "ProductionSupplyAreaAddressID" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyAreaAddressID" )
    private String productionSupplyAreaAddressID;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupplyAreaAddressID</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<String> PRODUCTION_SUPPLY_AREA_ADDRESS_ID =
        new ProductionSupplyAreaField<String>("ProductionSupplyAreaAddressID");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Timestamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ProductionSupplyAreaField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>AutomotiveLoadingPoint</b>
     * </p>
     *
     * @return Loading Point
     */
    @SerializedName( "AutomotiveLoadingPoint" )
    @JsonProperty( "AutomotiveLoadingPoint" )
    @Nullable
    @ODataField( odataName = "AutomotiveLoadingPoint" )
    private String automotiveLoadingPoint;
    /**
     * Use with available fluent helpers to apply the <b>AutomotiveLoadingPoint</b> field to query operations.
     *
     */
    public final static ProductionSupplyAreaField<String> AUTOMOTIVE_LOADING_POINT =
        new ProductionSupplyAreaField<String>("AutomotiveLoadingPoint");
    /**
     * Navigation property <b>to_ProductionSupplyAreaAddress</b> for <b>ProductionSupplyArea</b> to single
     * <b>ProductionSupplyAreaAddress</b>.
     *
     */
    @SerializedName( "to_ProductionSupplyAreaAddress" )
    @JsonProperty( "to_ProductionSupplyAreaAddress" )
    @ODataField( odataName = "to_ProductionSupplyAreaAddress" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProductionSupplyAreaAddress toProductionSupplyAreaAddress;
    /**
     * Navigation property <b>to_ProductionSupplyAreaText</b> for <b>ProductionSupplyArea</b> to multiple
     * <b>ProductionSupplyAreaText</b>.
     *
     */
    @SerializedName( "to_ProductionSupplyAreaText" )
    @JsonProperty( "to_ProductionSupplyAreaText" )
    @ODataField( odataName = "to_ProductionSupplyAreaText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductionSupplyAreaText> toProductionSupplyAreaText;
    /**
     * Use with available fluent helpers to apply the <b>to_ProductionSupplyAreaAddress</b> navigation property to query
     * operations.
     *
     */
    public final static ProductionSupplyAreaOneToOneLink<ProductionSupplyAreaAddress> TO_PRODUCTION_SUPPLY_AREA_ADDRESS =
        new ProductionSupplyAreaOneToOneLink<ProductionSupplyAreaAddress>("to_ProductionSupplyAreaAddress");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductionSupplyAreaText</b> navigation property to query
     * operations.
     *
     */
    public final static ProductionSupplyAreaLink<ProductionSupplyAreaText> TO_PRODUCTION_SUPPLY_AREA_TEXT =
        new ProductionSupplyAreaLink<ProductionSupplyAreaText>("to_ProductionSupplyAreaText");

    @Nonnull
    @Override
    public Class<ProductionSupplyArea> getType()
    {
        return ProductionSupplyArea.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ProductionSupplyAreaAddress_oc</b>
     * </p>
     *
     * @param productionSupplyAreaAddress_oc
     *            Dynamic CbA-Control
     */
    public void setProductionSupplyAreaAddress_oc( @Nullable final Boolean productionSupplyAreaAddress_oc )
    {
        rememberChangedField("to_ProductionSupplyAreaAddress_oc", this.productionSupplyAreaAddress_oc);
        this.productionSupplyAreaAddress_oc = productionSupplyAreaAddress_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ProductionSupplyAreaText_oc</b>
     * </p>
     *
     * @param productionSupplyAreaText_oc
     *            Dynamic CbA-Control
     */
    public void setProductionSupplyAreaText_oc( @Nullable final Boolean productionSupplyAreaText_oc )
    {
        rememberChangedField("to_ProductionSupplyAreaText_oc", this.productionSupplyAreaText_oc);
        this.productionSupplyAreaText_oc = productionSupplyAreaText_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *            Production Supply Area
     */
    public void setProductionSupplyArea( @Nullable final String productionSupplyArea )
    {
        rememberChangedField("ProductionSupplyArea", this.productionSupplyArea);
        this.productionSupplyArea = productionSupplyArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyAreaRespPerson</b>
     * </p>
     *
     * @param productionSupplyAreaRespPerson
     *            Person responsible for one or more supply areas
     */
    public void setProductionSupplyAreaRespPerson( @Nullable final String productionSupplyAreaRespPerson )
    {
        rememberChangedField("ProductionSupplyAreaRespPerson", this.productionSupplyAreaRespPerson);
        this.productionSupplyAreaRespPerson = productionSupplyAreaRespPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @param factoryCalendar
     *            Factory calendar key
     */
    public void setFactoryCalendar( @Nullable final String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShiftGrouping</b>
     * </p>
     *
     * @param shiftGrouping
     *            Grouping for Shift Definition and Sequences (Consumer)
     */
    public void setShiftGrouping( @Nullable final String shiftGrouping )
    {
        rememberChangedField("ShiftGrouping", this.shiftGrouping);
        this.shiftGrouping = shiftGrouping;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftSequence</b>
     * </p>
     *
     * @param shiftSequence
     *            Key for Shift Sequence (Consumer)
     */
    public void setShiftSequence( @Nullable final String shiftSequence )
    {
        rememberChangedField("ShiftSequence", this.shiftSequence);
        this.shiftSequence = shiftSequence;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PullIntervalInWorkdays</b>
     * </p>
     *
     * @param pullIntervalInWorkdays
     *            Pull Interval in Workdays
     */
    public void setPullIntervalInWorkdays( @Nullable final BigDecimal pullIntervalInWorkdays )
    {
        rememberChangedField("PullIntervalInWorkdays", this.pullIntervalInWorkdays);
        this.pullIntervalInWorkdays = pullIntervalInWorkdays;
    }

    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PullIntervalInMinutes</b>
     * </p>
     *
     * @param pullIntervalInMinutes
     *            Pull Interval in Minutes
     */
    public void setPullIntervalInMinutes( @Nullable final BigDecimal pullIntervalInMinutes )
    {
        rememberChangedField("PullIntervalInMinutes", this.pullIntervalInMinutes);
        this.pullIntervalInMinutes = pullIntervalInMinutes;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingWarehouseStagingArea</b>
     * </p>
     *
     * @param unloadingWarehouseStagingArea
     *            (Automotive) Unloading Point
     */
    public void setUnloadingWarehouseStagingArea( @Nullable final String unloadingWarehouseStagingArea )
    {
        rememberChangedField("UnloadingWarehouseStagingArea", this.unloadingWarehouseStagingArea);
        this.unloadingWarehouseStagingArea = unloadingWarehouseStagingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyAreaAddressID</b>
     * </p>
     *
     * @param productionSupplyAreaAddressID
     *            Address for Supply Area
     */
    public void setProductionSupplyAreaAddressID( @Nullable final String productionSupplyAreaAddressID )
    {
        rememberChangedField("ProductionSupplyAreaAddressID", this.productionSupplyAreaAddressID);
        this.productionSupplyAreaAddressID = productionSupplyAreaAddressID;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Timestamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>AutomotiveLoadingPoint</b>
     * </p>
     *
     * @param automotiveLoadingPoint
     *            Loading Point
     */
    public void setAutomotiveLoadingPoint( @Nullable final String automotiveLoadingPoint )
    {
        rememberChangedField("AutomotiveLoadingPoint", this.automotiveLoadingPoint);
        this.automotiveLoadingPoint = automotiveLoadingPoint;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductionSupplyArea";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductionSupplyArea", getProductionSupplyArea());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("to_ProductionSupplyAreaAddress_oc", getProductionSupplyAreaAddress_oc());
        values.put("to_ProductionSupplyAreaText_oc", getProductionSupplyAreaText_oc());
        values.put("ProductionSupplyArea", getProductionSupplyArea());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("ProductionSupplyAreaRespPerson", getProductionSupplyAreaRespPerson());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("ShiftGrouping", getShiftGrouping());
        values.put("ShiftSequence", getShiftSequence());
        values.put("PullIntervalInWorkdays", getPullIntervalInWorkdays());
        values.put("PullIntervalInMinutes", getPullIntervalInMinutes());
        values.put("UnloadingWarehouseStagingArea", getUnloadingWarehouseStagingArea());
        values.put("ProductionSupplyAreaAddressID", getProductionSupplyAreaAddressID());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("AutomotiveLoadingPoint", getAutomotiveLoadingPoint());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ProductionSupplyAreaAddress_oc") ) {
                final Object value = values.remove("to_ProductionSupplyAreaAddress_oc");
                if( (value == null) || (!value.equals(getProductionSupplyAreaAddress_oc())) ) {
                    setProductionSupplyAreaAddress_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ProductionSupplyAreaText_oc") ) {
                final Object value = values.remove("to_ProductionSupplyAreaText_oc");
                if( (value == null) || (!value.equals(getProductionSupplyAreaText_oc())) ) {
                    setProductionSupplyAreaText_oc(((Boolean) value));
                }
            }
            if( values.containsKey("ProductionSupplyArea") ) {
                final Object value = values.remove("ProductionSupplyArea");
                if( (value == null) || (!value.equals(getProductionSupplyArea())) ) {
                    setProductionSupplyArea(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("ProductionSupplyAreaRespPerson") ) {
                final Object value = values.remove("ProductionSupplyAreaRespPerson");
                if( (value == null) || (!value.equals(getProductionSupplyAreaRespPerson())) ) {
                    setProductionSupplyAreaRespPerson(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((String) value));
                }
            }
            if( values.containsKey("ShiftGrouping") ) {
                final Object value = values.remove("ShiftGrouping");
                if( (value == null) || (!value.equals(getShiftGrouping())) ) {
                    setShiftGrouping(((String) value));
                }
            }
            if( values.containsKey("ShiftSequence") ) {
                final Object value = values.remove("ShiftSequence");
                if( (value == null) || (!value.equals(getShiftSequence())) ) {
                    setShiftSequence(((String) value));
                }
            }
            if( values.containsKey("PullIntervalInWorkdays") ) {
                final Object value = values.remove("PullIntervalInWorkdays");
                if( (value == null) || (!value.equals(getPullIntervalInWorkdays())) ) {
                    setPullIntervalInWorkdays(((BigDecimal) value));
                }
            }
            if( values.containsKey("PullIntervalInMinutes") ) {
                final Object value = values.remove("PullIntervalInMinutes");
                if( (value == null) || (!value.equals(getPullIntervalInMinutes())) ) {
                    setPullIntervalInMinutes(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnloadingWarehouseStagingArea") ) {
                final Object value = values.remove("UnloadingWarehouseStagingArea");
                if( (value == null) || (!value.equals(getUnloadingWarehouseStagingArea())) ) {
                    setUnloadingWarehouseStagingArea(((String) value));
                }
            }
            if( values.containsKey("ProductionSupplyAreaAddressID") ) {
                final Object value = values.remove("ProductionSupplyAreaAddressID");
                if( (value == null) || (!value.equals(getProductionSupplyAreaAddressID())) ) {
                    setProductionSupplyAreaAddressID(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("AutomotiveLoadingPoint") ) {
                final Object value = values.remove("AutomotiveLoadingPoint");
                if( (value == null) || (!value.equals(getAutomotiveLoadingPoint())) ) {
                    setAutomotiveLoadingPoint(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProductionSupplyAreaAddress") ) {
                final Object value = (values).remove("to_ProductionSupplyAreaAddress");
                if( value instanceof Map ) {
                    if( toProductionSupplyAreaAddress == null ) {
                        toProductionSupplyAreaAddress = new ProductionSupplyAreaAddress();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProductionSupplyAreaAddress.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ProductionSupplyAreaText") ) {
                final Object value = (values).remove("to_ProductionSupplyAreaText");
                if( value instanceof Iterable ) {
                    if( toProductionSupplyAreaText == null ) {
                        toProductionSupplyAreaText = Lists.newArrayList();
                    } else {
                        toProductionSupplyAreaText = Lists.newArrayList(toProductionSupplyAreaText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductionSupplyAreaText entity;
                        if( toProductionSupplyAreaText.size() > i ) {
                            entity = toProductionSupplyAreaText.get(i);
                        } else {
                            entity = new ProductionSupplyAreaText();
                            toProductionSupplyAreaText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductionSupplyAreaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductionSupplyAreaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductionSupplyAreaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductionSupplyAreaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionSupplyAreaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProductionSupplyAreaAddress != null ) {
            (values).put("to_ProductionSupplyAreaAddress", toProductionSupplyAreaAddress);
        }
        if( toProductionSupplyAreaText != null ) {
            (values).put("to_ProductionSupplyAreaText", toProductionSupplyAreaText);
        }
        return values;
    }

    /**
     * Fetches the <b>ProductionSupplyAreaAddress</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ProductionSupplyAreaAddress</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProductionSupplyAreaAddress</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProductionSupplyAreaAddress fetchProductionSupplyAreaAddress()
    {
        return fetchFieldAsSingle("to_ProductionSupplyAreaAddress", ProductionSupplyAreaAddress.class);
    }

    /**
     * Retrieval of associated <b>ProductionSupplyAreaAddress</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ProductionSupplyAreaAddress</b>.
     * <p>
     * If the navigation property <b>to_ProductionSupplyAreaAddress</b> of a queried <b>ProductionSupplyArea</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductionSupplyAreaAddress</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProductionSupplyAreaAddress getProductionSupplyAreaAddressOrFetch()
    {
        if( toProductionSupplyAreaAddress == null ) {
            toProductionSupplyAreaAddress = fetchProductionSupplyAreaAddress();
        }
        return toProductionSupplyAreaAddress;
    }

    /**
     * Retrieval of associated <b>ProductionSupplyAreaAddress</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ProductionSupplyAreaAddress</b>.
     * <p>
     * If the navigation property for an entity <b>ProductionSupplyArea</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductionSupplyAreaAddress</b> is already loaded, the
     *         result will contain the <b>ProductionSupplyAreaAddress</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProductionSupplyAreaAddress> getProductionSupplyAreaAddressIfPresent()
    {
        return Option.of(toProductionSupplyAreaAddress);
    }

    /**
     * Overwrites the associated <b>ProductionSupplyAreaAddress</b> entity for the loaded navigation property
     * <b>to_ProductionSupplyAreaAddress</b>.
     *
     * @param value
     *            New <b>ProductionSupplyAreaAddress</b> entity.
     */
    public void setProductionSupplyAreaAddress( final ProductionSupplyAreaAddress value )
    {
        toProductionSupplyAreaAddress = value;
    }

    /**
     * Fetches the <b>ProductionSupplyAreaText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ProductionSupplyAreaText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductionSupplyAreaText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductionSupplyAreaText> fetchProductionSupplyAreaText()
    {
        return fetchFieldAsList("to_ProductionSupplyAreaText", ProductionSupplyAreaText.class);
    }

    /**
     * Retrieval of associated <b>ProductionSupplyAreaText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductionSupplyAreaText</b>.
     * <p>
     * If the navigation property <b>to_ProductionSupplyAreaText</b> of a queried <b>ProductionSupplyArea</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductionSupplyAreaText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductionSupplyAreaText> getProductionSupplyAreaTextOrFetch()
    {
        if( toProductionSupplyAreaText == null ) {
            toProductionSupplyAreaText = fetchProductionSupplyAreaText();
        }
        return toProductionSupplyAreaText;
    }

    /**
     * Retrieval of associated <b>ProductionSupplyAreaText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductionSupplyAreaText</b>.
     * <p>
     * If the navigation property for an entity <b>ProductionSupplyArea</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductionSupplyAreaText</b> is already loaded, the
     *         result will contain the <b>ProductionSupplyAreaText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductionSupplyAreaText>> getProductionSupplyAreaTextIfPresent()
    {
        return Option.of(toProductionSupplyAreaText);
    }

    /**
     * Overwrites the list of associated <b>ProductionSupplyAreaText</b> entities for the loaded navigation property
     * <b>to_ProductionSupplyAreaText</b>.
     * <p>
     * If the navigation property <b>to_ProductionSupplyAreaText</b> of a queried <b>ProductionSupplyArea</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductionSupplyAreaText</b> entities.
     */
    public void setProductionSupplyAreaText( @Nonnull final List<ProductionSupplyAreaText> value )
    {
        if( toProductionSupplyAreaText == null ) {
            toProductionSupplyAreaText = Lists.newArrayList();
        }
        toProductionSupplyAreaText.clear();
        toProductionSupplyAreaText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductionSupplyAreaText</b> entities. This corresponds to the OData
     * navigation property <b>to_ProductionSupplyAreaText</b>.
     * <p>
     * If the navigation property <b>to_ProductionSupplyAreaText</b> of a queried <b>ProductionSupplyArea</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductionSupplyAreaText</b> entities.
     */
    public void addProductionSupplyAreaText( ProductionSupplyAreaText... entity )
    {
        if( toProductionSupplyAreaText == null ) {
            toProductionSupplyAreaText = Lists.newArrayList();
        }
        toProductionSupplyAreaText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProductionSupplyArea instances.
     *
     */
    public final static class ProductionSupplyAreaBuilder
    {

        private ProductionSupplyAreaAddress toProductionSupplyAreaAddress;
        private List<ProductionSupplyAreaText> toProductionSupplyAreaText = Lists.newArrayList();

        private ProductionSupplyArea.ProductionSupplyAreaBuilder toProductionSupplyAreaAddress(
            final ProductionSupplyAreaAddress value )
        {
            toProductionSupplyAreaAddress = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProductionSupplyAreaAddress</b> for <b>ProductionSupplyArea</b> to single
         * <b>ProductionSupplyAreaAddress</b>.
         *
         * @param value
         *            The ProductionSupplyAreaAddress to build this ProductionSupplyArea with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductionSupplyArea.ProductionSupplyAreaBuilder productionSupplyAreaAddress(
            final ProductionSupplyAreaAddress value )
        {
            return toProductionSupplyAreaAddress(value);
        }

        private ProductionSupplyArea.ProductionSupplyAreaBuilder toProductionSupplyAreaText(
            final List<ProductionSupplyAreaText> value )
        {
            toProductionSupplyAreaText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProductionSupplyAreaText</b> for <b>ProductionSupplyArea</b> to multiple
         * <b>ProductionSupplyAreaText</b>.
         *
         * @param value
         *            The ProductionSupplyAreaTexts to build this ProductionSupplyArea with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductionSupplyArea.ProductionSupplyAreaBuilder productionSupplyAreaText(
            ProductionSupplyAreaText... value )
        {
            return toProductionSupplyAreaText(Lists.newArrayList(value));
        }

    }

}
